/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xtext.builder.trace.DebugLocationData;
import org.eclipse.xtext.builder.trace.DebugTraceRegion;
import org.eclipse.xtext.builder.trace.TraceFactory;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;

public class TraceResourceFactory
extends ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        ResourceImpl result = new ResourceImpl(uri){

            protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
                TraceRegionSerializer serializer = new TraceRegionSerializer();
                DebugTraceRegion result = (DebugTraceRegion)serializer.doReadFrom(inputStream, (TraceRegionSerializer.Strategy)new Strategy());
                this.getContents().add((Object)result);
            }

            protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
                TraceRegionSerializer serializer = new TraceRegionSerializer();
                serializer.doWriteTo((TraceRegionSerializer.Strategy)new Strategy(), (Object)((DebugTraceRegion)this.getContents().get(0)), outputStream);
            }
        };
        return result;
    }

    protected class Strategy
    implements TraceRegionSerializer.Strategy<DebugTraceRegion, DebugLocationData> {
        protected Strategy() {
        }

        public DebugLocationData createLocation(int offset, int length, int lineNumber, int endLineNumber, SourceRelativeURI path) {
            DebugLocationData result = TraceFactory.eINSTANCE.createDebugLocationData();
            result.setOffset(offset);
            result.setLength(length);
            result.setLineNumber(lineNumber);
            result.setEndLineNumber(endLineNumber);
            result.setPath(path != null ? path.getURI() : null);
            return result;
        }

        public DebugTraceRegion createRegion(int offset, int length, int lineNumber, int endLineNumber, boolean isUseForDebugging, List<DebugLocationData> associations, DebugTraceRegion parent) {
            DebugTraceRegion result = TraceFactory.eINSTANCE.createDebugTraceRegion();
            result.setMyOffset(offset);
            result.setMyLength(length);
            result.setMyLineNumber(lineNumber);
            result.setMyEndLineNumber(endLineNumber);
            result.setUseForDebugging(isUseForDebugging);
            result.getAssociations().addAll(associations);
            if (parent != null) {
                parent.getNestedRegions().add((Object)result);
            }
            return result;
        }

        public void writeRegion(DebugTraceRegion region, TraceRegionSerializer.Callback<DebugTraceRegion, DebugLocationData> callback) throws IOException {
            callback.doWriteRegion(region.getMyOffset(), region.getMyLength(), region.getMyLineNumber(), region.getMyEndLineNumber(), region.isUseForDebugging(), region.getAssociations(), region.getNestedRegions());
        }

        public void writeLocation(DebugLocationData location, TraceRegionSerializer.Callback<DebugTraceRegion, DebugLocationData> callback) throws IOException {
            callback.doWriteLocation(location.getOffset(), location.getLength(), location.getLineNumber(), location.getEndLineNumber(), location.getPath() != null ? new SourceRelativeURI(location.getPath()) : null);
        }
    }
}

