/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.validation.IDependencyIndex;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.IPerformanceMonitor;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.MutableWorkspaceSettings;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ContentTypeWrapper;
import org.eclipse.wst.validation.internal.DependencyIndex;
import org.eclipse.wst.validation.internal.DisabledResourceManager;
import org.eclipse.wst.validation.internal.DisabledValidatorManager;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.PerformanceMonitor;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.ValPrefManagerGlobal;
import org.eclipse.wst.validation.internal.ValPrefManagerProject;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationRunner;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.eclipse.wst.validation.internal.model.ProjectPreferences;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationFramework {
    private volatile IDependencyIndex _dependencyIndex;
    private IPerformanceMonitor _performanceMonitor;
    private Set<IProject> _suspendedProjects;
    private boolean _suspendAllValidation;

    public static ValidationFramework getDefault() {
        return Singleton.vf;
    }

    private ValidationFramework() {
    }

    public void addValidationBuilder(IProject project) {
        ValidatorManager.addProjectBuildValidationSupport(project);
    }

    public void clearMessages(IResource resource, String validatorId) throws CoreException {
        Validator v = this.getValidator(validatorId, null);
        if (v != null) {
            MarkerManager.getDefault().clearMarker(resource, v);
        }
    }

    public void disableValidation(IResource resource) {
        assert (resource != null);
        DisabledResourceManager.getDefault().disableValidation(resource);
    }

    public void enableValidation(IResource resource) {
        DisabledResourceManager.getDefault().enableValidation(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDependencyIndex getDependencyIndex() {
        if (this._dependencyIndex == null) {
            ValidationFramework validationFramework = this;
            synchronized (validationFramework) {
                if (this._dependencyIndex == null) {
                    this._dependencyIndex = new DependencyIndex();
                }
            }
        }
        return this._dependencyIndex;
    }

    public synchronized IPerformanceMonitor getPerformanceMonitor() {
        if (this._performanceMonitor == null) {
            boolean traceTimes = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/timings");
            String traceFile = Platform.getDebugOption((String)"org.eclipse.wst.validation/timings/tracefile");
            boolean useDoubles = Misc.debugOptionAsBoolean("org.eclipse.wst.validation/timings/useDoubles");
            this._performanceMonitor = PerformanceMonitor.create(traceTimes, traceFile, useDoubles);
        }
        return this._performanceMonitor;
    }

    public IEclipsePreferences getPreferenceStore() {
        return new InstanceScope().getNode("org.eclipse.wst.validation");
    }

    public IReporter getReporter(IProject project, IProgressMonitor monitor) {
        return new WorkbenchReporter(project, monitor);
    }

    public Validator[] getValidatorsFor(IResource resource, boolean isManual, boolean isBuild) {
        IProject project = resource.getProject();
        LinkedList<Validator> list = new LinkedList<Validator>();
        ContentTypeWrapper ctw = new ContentTypeWrapper();
        Validator[] validatorArray = ValManager.getDefault().getValidators(project);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator val = validatorArray[n2];
            if (val.shouldValidate(resource, isManual, isBuild, ctw)) {
                list.add(val);
            }
            ++n2;
        }
        Validator[] result = new Validator[list.size()];
        list.toArray(result);
        return result;
    }

    public Set<Validator> getDisabledValidatorsFor(IResource resource) {
        return DisabledValidatorManager.getDefault().getDisabledValidatorsFor(resource);
    }

    public Validator getValidator(String id) {
        return ValManager.getDefault().getValidatorWithId(id, null);
    }

    public Validator getValidator(String id, IProject project) {
        return ValManager.getDefault().getValidatorWithId(id, project);
    }

    public Validator[] getValidators() {
        return ValManager.getDefault().getValidatorsCopy();
    }

    public MutableProjectSettings getProjectSettings(IProject project) {
        ProjectPreferences pp = ValManager.getDefault().getProjectPreferences(project);
        Validator[] vals = pp.getValidators();
        IMutableValidator[] vms = new ValidatorMutable[vals.length];
        int i = 0;
        while (i < vals.length) {
            vms[i] = new ValidatorMutable(vals[i]);
            ++i;
        }
        MutableProjectSettings mps = new MutableProjectSettings(project, vms);
        mps.setOverride(pp.getOverride());
        mps.setSuspend(pp.getSuspend());
        return mps;
    }

    public MutableWorkspaceSettings getWorkspaceSettings() throws InvocationTargetException {
        ValManager vm = ValManager.getDefault();
        GlobalPreferences gp = vm.getGlobalPreferences();
        Validator[] vals = vm.getValidators();
        IMutableValidator[] vms = new ValidatorMutable[vals.length];
        int i = 0;
        while (i < vals.length) {
            vms[i] = new ValidatorMutable(vals[i]);
            ++i;
        }
        MutableWorkspaceSettings mws = new MutableWorkspaceSettings(vms, gp.asValues());
        return mws;
    }

    public void applyChanges(MutableProjectSettings settings, boolean persist) {
        ValPrefManagerProject vpm = new ValPrefManagerProject(settings.getProject());
        vpm.savePreferences(settings, persist);
    }

    public void applyChanges(MutableWorkspaceSettings settings, boolean persist) {
        ValManager vm = ValManager.getDefault();
        GlobalPreferencesValues gpv = settings.getGlobalPreferencesValues();
        vm.replace(gpv);
        IMutableValidator[] mvs = settings.getValidators();
        ValidatorMutable[] vals = new ValidatorMutable[mvs.length];
        int i = 0;
        while (i < mvs.length) {
            vals[i] = (ValidatorMutable)mvs[i];
            ++i;
        }
        ValPrefManagerGlobal.getDefault().savePreferences(vm.getGlobalPreferences(), vals, persist);
        ValPrefManagerGlobal.saveV1Preferences(vals, persist);
    }

    public Validator[] getValidatorsConfiguredForProject(IProject project) throws ProjectUnavailableError {
        Validator[] orig = ValManager.getDefault().getValidatorsConfiguredForProject(project, ValManager.UseProjectPreferences.Normal);
        Validator[] copy = new Validator[orig.length];
        int i = 0;
        while (i < orig.length) {
            copy[i] = orig[i].copy();
            ++i;
        }
        return copy;
    }

    public Validator[] getValidatorsFor(IResource resource) {
        LinkedList<Validator> list = new LinkedList<Validator>();
        Validator[] validatorArray = this.getValidatorsFor(resource, false, false);
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v.isBuildValidation() || v.isManualValidation()) {
                list.add(v);
            }
            ++n2;
        }
        Validator[] vals = new Validator[list.size()];
        return list.toArray(vals);
    }

    public boolean hasValidators(IResource resource, boolean isManual, boolean isBuild) {
        return ValManager.getDefault().hasValidators(resource, isManual, isBuild);
    }

    public boolean isLoaded(Validator validator) {
        return validator.isLoaded();
    }

    public void join(IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, monitor);
        Job.getJobManager().join(ValidationBuilder.FAMILY_VALIDATION_JOB, monitor);
    }

    public void joinValidationOnly(IProgressMonitor monitor) throws InterruptedException, OperationCanceledException {
        Job.getJobManager().join(ValidationBuilder.FAMILY_VALIDATION_JOB, monitor);
    }

    public void cancel() {
        Job.getJobManager().cancel(ValidationBuilder.FAMILY_VALIDATION_JOB);
    }

    public void suspendValidation(IProject project, boolean suspend) {
        if (project == null) {
            return;
        }
        if (suspend) {
            this.getSuspendedProjects().add(project);
        } else {
            this.getSuspendedProjects().remove(project);
        }
    }

    private synchronized Set<IProject> getSuspendedProjects() {
        if (this._suspendedProjects == null) {
            this._suspendedProjects = Collections.synchronizedSet(new HashSet(20));
        }
        return this._suspendedProjects;
    }

    public void saveValidators(Validator[] validators) throws InvocationTargetException {
        ValPrefManagerGlobal gp = ValPrefManagerGlobal.getDefault();
        gp.saveAsPrefs(validators);
        GlobalConfiguration gc = ConfigurationManager.getManager().getGlobalConfiguration();
        LinkedList<ValidatorMetaData> manual = new LinkedList<ValidatorMetaData>();
        LinkedList<ValidatorMetaData> build = new LinkedList<ValidatorMetaData>();
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            Validator.V1 v1 = v.asV1Validator();
            if (v1 != null) {
                if (v1.isManualValidation()) {
                    manual.add(v1.getVmd());
                }
                if (v1.isBuildValidation()) {
                    build.add(v1.getVmd());
                }
            }
            ++n2;
        }
        ValidatorMetaData[] array = new ValidatorMetaData[manual.size()];
        gc.setEnabledManualValidators(manual.toArray(array));
        array = new ValidatorMetaData[build.size()];
        gc.setEnabledBuildValidators(build.toArray(array));
        gc.passivate();
        gc.store();
    }

    public void suspendAllValidation(boolean suspend) {
        this._suspendAllValidation = suspend;
    }

    public boolean isSuspended() {
        return this._suspendAllValidation;
    }

    public boolean isSuspended(IProject project) {
        if (this._suspendAllValidation) {
            return true;
        }
        if (project == null) {
            return false;
        }
        return this.getSuspendedProjects().contains(project);
    }

    public boolean isProjectSuspended(IProject project) {
        if (project == null) {
            return false;
        }
        return this.getSuspendedProjects().contains(project);
    }

    public ValidationResults validate(IProject[] projects, boolean isManual, boolean isBuild, IProgressMonitor monitor) throws CoreException {
        ValType type = ValType.Build;
        if (isManual) {
            type = ValType.Manual;
        }
        ValOperation vo = ValidationRunner.validate(this.createMap(projects), type, monitor, true);
        return vo.getResults();
    }

    public ValidationResults validate(IFile file, IProgressMonitor monitor) throws CoreException {
        ValOperation vo = ValidationRunner.validate(file, ValType.Manual, monitor, true);
        return vo.getResults();
    }

    private Map<IProject, Set<IResource>> createMap(IProject[] projects) throws CoreException {
        HashMap<IProject, Set<IResource>> map = new HashMap<IProject, Set<IResource>>(1000);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            HashSet<IResource> set = new HashSet<IResource>(1000);
            ResourceAdder ra = new ResourceAdder(set);
            p.accept((IResourceVisitor)ra);
            map.put(p, set);
            ++n2;
        }
        return map;
    }

    /* synthetic */ ValidationFramework(ValidationFramework validationFramework) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResourceAdder
    implements IResourceVisitor {
        private Set<IResource> _set;

        public ResourceAdder(Set<IResource> set) {
            this._set = set;
        }

        public boolean visit(IResource resource) throws CoreException {
            int type = resource.getType();
            if (type == 1 || type == 2) {
                this._set.add(resource);
            }
            return true;
        }
    }

    private static class Singleton {
        static ValidationFramework vf = new ValidationFramework(null);

        private Singleton() {
        }
    }
}

