/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.securestorage;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.equinox.security.ui.storage.PasswordProvider;
import org.eclipse.reddeer.eclipse.equinox.security.ui.storage.StoragePreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.requirement.AbstractRequirement;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;

public class SecureStorageRequirement
extends AbstractRequirement<DisableSecureStorage> {
    public void fulfill() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        StoragePreferencePage page = new StoragePreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        page.selectPasswordsTab();
        for (PasswordProvider provider : page.getMasterPasswordProviders()) {
            provider.disable();
        }
        dialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitWhile((WaitCondition)new ShellIsAvailable(dialog.getShell()));
    }

    public void cleanUp() {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DisableSecureStorage {
    }
}

