/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.views.log;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.text.LabeledText;

public class LogMessage {
    private TreeItem treeItem;
    private int severity;

    public LogMessage(TreeItem treeItem, int severity) {
        this.treeItem = treeItem;
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.treeItem.getCell(0);
    }

    public String getPlugin() {
        return this.treeItem.getCell(1);
    }

    public String getDate() {
        return this.treeItem.getCell(2);
    }

    public String getStackTrace() {
        this.treeItem.select();
        new ContextMenuItem(new String[]{"Event Details"}).select();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Event Details"));
        String stackTrace = new LabeledText("Exception Stack Trace:").getText();
        new PushButton("OK").click();
        return stackTrace;
    }

    public String getSessionData() {
        this.treeItem.select();
        new ContextMenuItem(new String[]{"Event Details"}).select();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Event Details"));
        String sessionData = new LabeledText("Session Data:").getText();
        new PushButton("OK").click();
        return sessionData;
    }

    public List<LogMessage> getSubLogMessages() {
        ArrayList<LogMessage> lm = new ArrayList<LogMessage>();
        for (TreeItem i : this.treeItem.getItems()) {
            LogMessage l = new LogMessage(i, this.severity);
            lm.add(l);
        }
        return lm;
    }

    public String toString() {
        return "LogMessage [getSeverity()=" + this.getSeverity() + ", getMessage()=" + this.getMessage() + ", getPlugin()=" + this.getPlugin() + ", getDate()=" + this.getDate() + ", getStackTrace()=" + this.getStackTrace() + ", getSessionData()=" + this.getSessionData() + ", getSubLogMessages()=" + this.getSubLogMessages() + "]";
    }
}

