/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core;

import org.eclipse.rcptt.tesla.core.TeslaFeatures;

public class TeslaLimits {
    private static final String TIMER_EXECS_WAIT = "timer.execs.wait";
    private static final String TIMER_EXECS_SKIP = "timer.execs.skip.after";
    private static final String TIMER_EXECS_TOTAL_WAIT = "timer.execs.total.wait";
    private static final String TIMER_EXECS_TOTAL_WAIT_STEP = "timer.execs.total.wait.step";
    private static final String TIMER_EXECS_WAIT_NULLIFY = "timer.execs.wait.nullify";
    private static final String JOB_DEBUGJOB_TIMEOUT = "job.debugjob.timeout";
    private static final String JOB_STEPMODE_STEP_TIME = "job.sleeping.step.time";
    private static final String JOB_STEPMODE_TIMEOUT = "job.sleeping.step.timeout";
    private static final String JOB_STEPMODE_ENABLE_TIMEOUT = "job.treat.as.sleeping.timeout";
    private static final String JOB_NULIFY_IF_NOT_RESCHEDULED = "job.nulify.reschedule.max.value";
    private static final String CONTEXTS_WAITFORJOBS_TIMEOUT = "contexts.waitforjobs.timeout";
    private static final String UIJOB_JOB_TIMEOUT = "uijob.hang.timeout";
    private static final String AUTOBUILD_JOB_TIMEOUT = "autobuild.job.hang.timeout";
    private static final String CONTEXT_RUNNABLE_TIMEOUT = "context.runnable.timeout";
    private static final String UIJOB_WAIT_FOR_DELAYED_TIMEOUT_TYPO = "uijob.scheldule.delayed.maxtime";
    private static final String UIJOB_WAIT_FOR_DELAYED_TIMEOUT = "uijob.schedule.delayed.maxtime";
    private static final String TIMEOUTS = "Runtime Limits";
    public static final String AUT_STARTUP_TIMEOUT = "uijob.aut.startup.timeout";
    public static final String JOB_LOGGING_TIMEOUT = "job.logging.timeout";
    public static final String JFACE_RECONCILER_TIMEOUT = "jface.reconciler.timeout";

    public static void init(TeslaFeatures o) {
        o.addReplace(UIJOB_WAIT_FOR_DELAYED_TIMEOUT_TYPO, UIJOB_WAIT_FOR_DELAYED_TIMEOUT);
        o.intOption(AUT_STARTUP_TIMEOUT, 600).category(TIMEOUTS).name("Time RCPTT wait for AUT application to startup (sec)").showIn("adv.options");
        o.intOption(CONTEXT_RUNNABLE_TIMEOUT, 180000).category(TIMEOUTS).name("Context operation runnable timeout (ms)").showIn("adv.options");
        o.intOption(UIJOB_JOB_TIMEOUT, 30000).category(TIMEOUTS).name("Job Hang Skip timeout (ms)").description("Timeout then RCPTT will deside to stop waiting for job").showIn("adv.options").order(1);
        o.intOption(JOB_LOGGING_TIMEOUT, 10).category(TIMEOUTS).name("Log waiting for job if exceed (sec)").description("Timeout then RCPTT will add information entry to Eclipse log").showIn("adv.options").order(1);
        o.intOption(AUTOBUILD_JOB_TIMEOUT, 180000).category(TIMEOUTS).name("AutoBuild Job Hang Skip timeout (ms)").description("Timeout then RCPTT will deside to stop waiting for autobuild job").showIn("adv.options").order(1);
        o.intOption(JOB_STEPMODE_ENABLE_TIMEOUT, 10000).category(TIMEOUTS).name("Enable step mode for job after timeout (job in Thread.sleep, Object.wait)").description("If job executes more then (ms). And calling Thread.sleep() or Object.wait(). RCPTT will try to continue execution in step mode").showIn("adv.options").order(2);
        o.intOption(JOB_STEPMODE_STEP_TIME, 200).category(TIMEOUTS).name("Step mode: One Step every (ms)").description("If job executes more then (ms). And calling Thread.sleep() or Object.wait(). RCPTT will try to continue execution").showIn("adv.options").order(3);
        o.intOption(JOB_STEPMODE_TIMEOUT, 120000).category(TIMEOUTS).name("Step mode: Step mode timeout (ms)").description("Allow step mode only for specified time").showIn("adv.options").order(4);
        o.intOption(UIJOB_WAIT_FOR_DELAYED_TIMEOUT, 600).category(TIMEOUTS).name("Wait for delayed jobs with delay less then (ms)").showIn("adv.options").order(5);
        o.intOption(CONTEXTS_WAITFORJOBS_TIMEOUT, 60000).category(TIMEOUTS).name("Wait jobs completion after context apply (ms)").showIn("adv.options").order(6);
        o.intOption(JOB_NULIFY_IF_NOT_RESCHEDULED, 50).category(TIMEOUTS).name("Delayed jobs scheduled with delay 0, if not rescheduled more then (times)").showIn("adv.options").order(7);
        o.intOption(JOB_DEBUGJOB_TIMEOUT, 300000).category(TIMEOUTS).name("Timeout for background Debug plugin launch Job").showIn("adv.options").order(8);
        o.intOption(TIMER_EXECS_WAIT, 250).category(TIMEOUTS).name("Wait for timerExecs (ms) (0 is disabled state)\n(skip org.eclipse.swt, org.eclipse.get packages)").showIn("adv.options").order(9);
        o.intOption(TIMER_EXECS_SKIP, 5000).category(TIMEOUTS).name("Wait for timerExecs (ms) rescheduling for no more then time in ms").showIn("adv.options").order(9);
        o.intOption(TIMER_EXECS_WAIT_NULLIFY, 100).category(TIMEOUTS).name("Nullify timerExec if time is less then (ms)").showIn("adv.options").order(10);
        o.intOption(TIMER_EXECS_TOTAL_WAIT, 30000).category(TIMEOUTS).name("Wait for timerExecs (ms) no more timeout and then do a step mode\nwith step timeout").showIn("adv.options").order(9);
        o.intOption(TIMER_EXECS_TOTAL_WAIT_STEP, 2000).category(TIMEOUTS).name("Step timeout for Timer Exec total timeout").showIn("adv.options").order(9);
        o.intOption(JFACE_RECONCILER_TIMEOUT, 10000).category(TIMEOUTS).name("JFace Viewer Reconciling Timeout (ms)").showIn("adv.options").order(11);
    }

    public static int getTimerExecsWait() {
        return TeslaLimits.getIntValue(TIMER_EXECS_WAIT);
    }

    public static int getTimerExecsSkip() {
        return TeslaLimits.getIntValue(TIMER_EXECS_SKIP);
    }

    public static int getTimerExecsTotalWaitTime() {
        return TeslaLimits.getIntValue(TIMER_EXECS_TOTAL_WAIT);
    }

    public static int getTimerExecsTotalWaitTimeStep() {
        return TeslaLimits.getIntValue(TIMER_EXECS_TOTAL_WAIT_STEP);
    }

    public static int getTimerExecsWaitNullify() {
        return TeslaLimits.getIntValue(TIMER_EXECS_WAIT_NULLIFY);
    }

    public static int getJobNullifyRescheduleMaxValue() {
        return TeslaLimits.getIntValue(JOB_NULIFY_IF_NOT_RESCHEDULED);
    }

    public static int getJobTimeout() {
        return TeslaLimits.getIntValue(UIJOB_JOB_TIMEOUT);
    }

    public static int getAutoBuildJobTimeout() {
        return TeslaLimits.getIntValue(AUTOBUILD_JOB_TIMEOUT);
    }

    public static int getContextRunnableTimeout() {
        return TeslaLimits.getIntValue(CONTEXT_RUNNABLE_TIMEOUT);
    }

    public static int getJobWaitForDelayedTimeout() {
        return TeslaLimits.getIntValue(UIJOB_WAIT_FOR_DELAYED_TIMEOUT);
    }

    private static int getIntValue(String id) {
        return Integer.parseInt(TeslaFeatures.getInstance().getOption(id).getValue());
    }

    public static long getContextJoinTimeout() {
        return TeslaLimits.getIntValue(CONTEXTS_WAITFORJOBS_TIMEOUT);
    }

    public static int getStepModeEnableTimeout() {
        return TeslaLimits.getIntValue(JOB_STEPMODE_ENABLE_TIMEOUT);
    }

    public static int getStepModeStepTime() {
        return TeslaLimits.getIntValue(JOB_STEPMODE_STEP_TIME);
    }

    public static int getStepModeTimeout() {
        return TeslaLimits.getIntValue(JOB_STEPMODE_TIMEOUT);
    }

    public static long getDebugJobTimeout() {
        return TeslaLimits.getIntValue(JOB_DEBUGJOB_TIMEOUT);
    }

    public static int getAUTStartupTimeout() {
        return TeslaLimits.getIntValue(AUT_STARTUP_TIMEOUT) * 1000;
    }

    public static long getJobLoggingTimeout() {
        return TeslaLimits.getIntValue(JOB_LOGGING_TIMEOUT) * 1000;
    }

    public static long getReconcilerTimeout() {
        return TeslaLimits.getIntValue(JFACE_RECONCILER_TIMEOUT);
    }
}

