/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.runtime.evaluation;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.runtime.evaluation.AbstractTypedModelInstance;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.EReferenceAnalysis;
import org.eclipse.qvtd.runtime.evaluation.ModelsManager;

public class EClassAnalysis {
    protected final @NonNull AbstractTypedModelInstance typedModelInstance;
    @Nullable EClassAnalysis nextEClassAnalysis = null;
    protected final @NonNull EClass eClass;
    private final @NonNull EReferenceAnalysis @Nullable [] eReferenceAnalyses;
    private final @NonNull Connection @NonNull [] connections;

    public EClassAnalysis(@NonNull AbstractTypedModelInstance typedModelInstance, @NonNull EClass eClass, @Nullable EClassAnalysis nextEClassAnalysis) {
        this.typedModelInstance = typedModelInstance;
        this.eClass = eClass;
        this.nextEClassAnalysis = nextEClassAnalysis;
        ModelsManager modelsManager = typedModelInstance.getModelsManager();
        ArrayList<EReferenceAnalysis> eReferenceAnalyses = null;
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!(eStructuralFeature instanceof EReference)) continue;
            EReference eReference = (EReference)eStructuralFeature;
            boolean isContainment = eReference.isContainment();
            boolean isResolveProxies = eReference.isResolveProxies();
            int oppositePropertyIndex = modelsManager.getOppositePropertyIndex(eReference);
            if (!isContainment && !isResolveProxies && oppositePropertyIndex < 0) continue;
            if (eReferenceAnalyses == null) {
                eReferenceAnalyses = new ArrayList<EReferenceAnalysis>();
            }
            eReferenceAnalyses.add(new EReferenceAnalysis(this, eReference, oppositePropertyIndex));
        }
        this.eReferenceAnalyses = eReferenceAnalyses != null ? eReferenceAnalyses.toArray(new EReferenceAnalysis[eReferenceAnalyses.size()]) : null;
        Set<@NonNull Integer> allClassIndexes = typedModelInstance.getClassIndexes(eClass);
        this.connections = new Connection[allClassIndexes.size()];
        int connectionIndex = 0;
        for (Integer classIndex : allClassIndexes) {
            this.connections[connectionIndex++] = typedModelInstance.classIndex2connection[classIndex];
        }
    }

    public @NonNull EClass getEClass() {
        return this.eClass;
    }

    public ModelsManager getModelsManager() {
        return this.typedModelInstance.getModelsManager();
    }

    public @NonNull AbstractTypedModelInstance getTypedModelInstance() {
        return this.typedModelInstance;
    }

    public void propagate(@NonNull EObject eObject) {
        Connection[] connectionArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Connection connection = connectionArray[n2];
            connection.appendElement(eObject);
            ++n2;
        }
    }

    public void traverseChild(@NonNull EObject eObject) {
        Object[] objectArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Connection connection = objectArray[n2];
            connection.appendElement(eObject);
            ++n2;
        }
        if (this.eReferenceAnalyses != null) {
            objectArray = this.eReferenceAnalyses;
            n = this.eReferenceAnalyses.length;
            n2 = 0;
            while (n2 < n) {
                @NonNull Object eReferenceAnalysis = objectArray[n2];
                ((EReferenceAnalysis)eReferenceAnalysis).traverseFrom(eObject);
                ++n2;
            }
        }
    }

    public String toString() {
        return this.eClass.getName();
    }

    public void unpropagate(@NonNull EObject eObject) {
        assert (this.eClass == eObject.eClass());
        Object[] objectArray = this.connections;
        int n = this.connections.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull Connection connection = objectArray[n2];
            ((Connection.Incremental)connection).removeElement(eObject);
            ++n2;
        }
        if (this.eReferenceAnalyses != null) {
            objectArray = this.eReferenceAnalyses;
            n = this.eReferenceAnalyses.length;
            n2 = 0;
            while (n2 < n) {
                @NonNull Object eReferenceAnalysis = objectArray[n2];
                ((EReferenceAnalysis)eReferenceAnalysis).untraverseFrom(eObject);
                ++n2;
            }
        }
    }
}

