/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.builtin.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.php.internal.server.core.builtin.IPHPServerConfigurationWorkingCopy;
import org.eclipse.php.internal.server.core.builtin.PHPServer;
import org.eclipse.php.internal.server.core.builtin.PHPServerConfiguration;
import org.eclipse.php.internal.server.core.builtin.command.ModifyPortCommand;
import org.eclipse.php.internal.server.ui.builtin.Messages;
import org.eclipse.php.internal.server.ui.builtin.PHPServerUIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class ServerPortEditorSection
extends ServerEditorSection {
    protected PHPServerConfiguration fPHPServerConfiguration;
    protected boolean updating;
    protected Table ports;
    protected TableViewer viewer;
    protected PropertyChangeListener listener;

    protected void addChangeListener() {
        this.listener = event -> {
            if ("modifyPort".equals(event.getPropertyName())) {
                String id = (String)event.getOldValue();
                Integer value = (Integer)event.getNewValue();
                if (value < 1 || value > 65535) {
                    this.setErrorMessage(Messages.ServerPortEditorSection_port_range_validator);
                } else {
                    this.setErrorMessage(null);
                    this.changePortNumber(id, value);
                }
            }
        };
        this.fPHPServerConfiguration.addPropertyChangeListener(this.listener);
    }

    protected void changePortNumber(String id, int port) {
        TableItem[] items = this.ports.getItems();
        int size = items.length;
        int i = 0;
        while (i < size) {
            ServerPort sp = (ServerPort)items[i].getData();
            if (sp.getId().equals(id)) {
                items[i].setData((Object)new ServerPort(id, sp.getName(), port, sp.getProtocol()));
                items[i].setText(1, Integer.toString(port));
                return;
            }
            ++i;
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 458);
        section.setText(Messages.configurationEditorPortsSection);
        section.setDescription(Messages.configurationEditorPortsDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
        this.ports = toolkit.createTable(composite, 66304);
        this.ports.setHeaderVisible(true);
        this.ports.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        TableColumn col = new TableColumn(this.ports, 0);
        col.setText(Messages.configurationEditorPortNameColumn);
        ColumnWeightData colData = new ColumnWeightData(15, 150, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        col = new TableColumn(this.ports, 0);
        col.setText(Messages.configurationEditorPortValueColumn);
        colData = new ColumnWeightData(8, 80, true);
        tableLayout.addColumnData((ColumnLayoutData)colData);
        GridData data = new GridData(784);
        data.widthHint = 230;
        data.heightHint = 100;
        this.ports.setLayoutData((Object)data);
        this.ports.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(this.ports);
        this.viewer.setColumnProperties(new String[]{"name", "port"});
        this.initialize();
    }

    protected void setupPortEditors() {
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.ports);
        this.viewer.setCellEditors(cellEditorArray);
        ICellModifier cellModifier = new ICellModifier(){

            public Object getValue(Object element, String property) {
                ServerPort sp = (ServerPort)element;
                if (sp.getPort() < 0) {
                    return "-";
                }
                return Integer.toString(sp.getPort());
            }

            public boolean canModify(Object element, String property) {
                return "port".equals(property);
            }

            public void modify(Object element, String property, Object value) {
                try {
                    Item item = (Item)element;
                    ServerPort sp = (ServerPort)item.getData();
                    int port = Integer.parseInt((String)value);
                    ServerPortEditorSection.this.execute((IUndoableOperation)new ModifyPortCommand((IPHPServerConfigurationWorkingCopy)ServerPortEditorSection.this.fPHPServerConfiguration, sp.getId(), port));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.viewer.setCellModifier(cellModifier);
        String os = System.getProperty("os.name");
        if (os != null && os.toLowerCase().indexOf("win") >= 0) {
            this.ports.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        int n = ServerPortEditorSection.this.ports.getSelectionIndex();
                        ServerPortEditorSection.this.viewer.editElement(ServerPortEditorSection.this.ports.getItem(n).getData(), 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.fPHPServerConfiguration != null) {
            this.fPHPServerConfiguration.removePropertyChangeListener(this.listener);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        PHPServer ts = (PHPServer)this.server.loadAdapter(PHPServer.class, null);
        try {
            this.fPHPServerConfiguration = ts.getPHPServerConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addChangeListener();
        this.initialize();
    }

    protected void initialize() {
        if (this.ports == null) {
            return;
        }
        this.ports.removeAll();
        for (ServerPort port : this.fPHPServerConfiguration.getServerPorts()) {
            TableItem item = new TableItem(this.ports, 0);
            String portStr = "-";
            if (port.getPort() >= 0) {
                portStr = Integer.toString(port.getPort());
            }
            String[] s = new String[]{port.getName(), portStr};
            item.setText(s);
            item.setImage(PHPServerUIPlugin.getImage("IMG_PORT"));
            item.setData((Object)port);
        }
        if (this.readOnly) {
            this.viewer.setCellEditors(new CellEditor[2]);
            this.viewer.setCellModifier(null);
        } else {
            this.setupPortEditors();
        }
    }
}

