/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ImageFinder {
    private static final ImageDescriptor[] NO_IMAGE_DESCRIPTORS = new ImageDescriptor[0];

    public static URL getUrl(String value, Bundle definingBundle) {
        block3: {
            try {
                if (value != null) {
                    return new URL(value);
                }
            }
            catch (MalformedURLException e) {
                if (definingBundle == null) break block3;
                return FileLocator.find((Bundle)definingBundle, (IPath)new Path(value));
            }
        }
        return null;
    }

    public static List<URL> getUrls(String value, Bundle definingBundle, String separator) {
        if (value == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokens = new StringTokenizer(value, separator);
        ArrayList<URL> list = new ArrayList<URL>(10);
        while (tokens.hasMoreTokens()) {
            String segment = tokens.nextToken().trim();
            URL url = ImageFinder.getUrl(segment, definingBundle);
            if (url == null) continue;
            list.add(url);
        }
        return list;
    }

    public static ImageDescriptor getImage(String value, Bundle definingBundle) {
        URL url = ImageFinder.getUrl(value, definingBundle);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    public static ImageDescriptor[] getImages(String value, Bundle definingBundle) {
        List<URL> urls = ImageFinder.getUrls(value, definingBundle, ",");
        if (urls.isEmpty()) {
            return NO_IMAGE_DESCRIPTORS;
        }
        ImageDescriptor[] images = new ImageDescriptor[urls.size()];
        int i = 0;
        while (i < images.length) {
            images[i] = ImageDescriptor.createFromURL((URL)urls.get(i));
            ++i;
        }
        return images;
    }

    public static URL locate(Object container, String value) {
        block6: {
            try {
                if (value != null) {
                    return new URL(value);
                }
            }
            catch (MalformedURLException e) {
                Bundle bundle = null;
                if (container instanceof Bundle) {
                    bundle = (Bundle)container;
                } else if (container instanceof Class) {
                    bundle = FrameworkUtil.getBundle((Class)((Class)container));
                }
                if (bundle == null) break block6;
                return FileLocator.find((Bundle)bundle, (IPath)new Path(value));
            }
        }
        return null;
    }

    public static List<URL> locate(Object container, String value, String delimeter) {
        if (value == null) {
            return Collections.emptyList();
        }
        return Stream.of(value.split(delimeter)).map(v -> ImageFinder.locate(container, v)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Optional<ImageDescriptor> createImageDescriptor(Object container, String value) {
        URL locate = ImageFinder.locate(container, value);
        return locate == null ? Optional.empty() : Optional.of(ImageDescriptor.createFromURL((URL)locate));
    }

    public static List<ImageDescriptor> createImageDescriptors(Object container, String value, String delimeter) {
        return ImageFinder.locate(container, value, delimeter).stream().map(u -> ImageDescriptor.createFromURL((URL)u)).collect(Collectors.toList());
    }
}

