/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.migration;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;

public class SequenceReconciler_1_3_0
extends DiagramReconciler {
    public ICommand getReconcileCommand(Diagram diagram) {
        CompositeCommand cc = new CompositeCommand("Migrate diagram from 1.1.0 to 1.3.0");
        cc.add((IUndoableOperation)new ChangeVisualIDsCommand(diagram));
        cc.add((IUndoableOperation)new ChangeCombinedFragmentOrder(diagram));
        return cc;
    }

    public static String getNewVisualID(String oldVisualID) {
        switch (oldVisualID) {
            case "Gate": {
                return "Gate_Shape";
            }
        }
        return oldVisualID;
    }

    protected class ChangeCombinedFragmentOrder
    extends AbstractCommand {
        protected final Diagram diagram;

        public ChangeCombinedFragmentOrder(Diagram diagram) {
            super("Change order of combinedFragment the diagram's visual ids from 1.2.0 to 1.3.0");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            View interactionShape = null;
            View interactionCompartmentShape = null;
            if (this.diagram.getChildren().size() == 1) {
                interactionShape = (View)this.diagram.getChildren().get(0);
                if (interactionShape.getChildren().size() > 0) {
                    int i = 0;
                    while (i < interactionShape.getChildren().size()) {
                        View child = (View)interactionShape.getChildren().get(i);
                        if ("Interaction_SubfragmentCompartment".equals(child.getType())) {
                            interactionCompartmentShape = child;
                        }
                        ++i;
                    }
                }
                if (interactionCompartmentShape != null) {
                    ArrayList<View> combinedViews = new ArrayList<View>();
                    int i = 0;
                    while (i < interactionCompartmentShape.getChildren().size()) {
                        View child = (View)interactionCompartmentShape.getChildren().get(i);
                        if ("CombinedFragment_Shape".equals(child.getType())) {
                            combinedViews.add(child);
                        }
                        ++i;
                    }
                    for (View view : combinedViews) {
                        interactionCompartmentShape.getPersistedChildren().remove((Object)view);
                        interactionCompartmentShape.getPersistedChildren().add(0, (Object)view);
                    }
                }
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }

    protected class ChangeVisualIDsCommand
    extends AbstractCommand {
        protected final Diagram diagram;

        public ChangeVisualIDsCommand(Diagram diagram) {
            super("Change the diagram's visual ids from 1.2.0 to 1.3.0");
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TreeIterator allContentIterator = this.diagram.eAllContents();
            while (allContentIterator.hasNext()) {
                EObject eObject = (EObject)allContentIterator.next();
                if (!(eObject instanceof View)) continue;
                View view = (View)eObject;
                view.setType(SequenceReconciler_1_3_0.getNewVisualID(view.getType()));
            }
            return CommandResult.newOKCommandResult();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canRedo false");
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            throw new ExecutionException("Should not be called, canUndo false");
        }
    }
}

