/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;

public class TableSelectionWrapper {
    private final INattableModelManager manager;
    private SelectionLayer selectionLayer;
    private Map<Integer, Object> rowPositionAndAxis = new HashMap<Integer, Object>();
    private final Collection<Object> rowAxisElements = new HashSet<Object>();
    private Map<Integer, Object> columnPositionAndAxis = new HashMap<Integer, Object>();
    private final Collection<Object> columnAxisElements = new HashSet<Object>();
    private final Map<PositionCoordinate, CellReference> allSelectedCells = new LinkedHashMap<PositionCoordinate, CellReference>();
    private final Map<PositionCoordinate, CellReference> singleCellsCoordinatesAndUniqueReference = new HashMap<PositionCoordinate, CellReference>();
    private final Collection<Object> singleCellValues = new ArrayList<Object>();

    @Deprecated
    public TableSelectionWrapper(Collection<PositionCoordinate> selectionCells) {
        this(selectionCells, new HashMap<Integer, Object>(), new HashMap<Integer, Object>());
    }

    @Deprecated
    public TableSelectionWrapper(Collection<PositionCoordinate> selectionCells, Map<Integer, Object> fullySelectedRowObject, Map<Integer, Object> fullySelectedColumnObject) {
        this.fillAllSelectedCellsMap(selectionCells);
        this.rowPositionAndAxis = fullySelectedRowObject;
        this.columnPositionAndAxis = fullySelectedColumnObject;
        this.manager = null;
    }

    @Deprecated
    public TableSelectionWrapper(INattableModelManager manager, Collection<PositionCoordinate> selectionCells) {
        this(manager, selectionCells, new HashMap<Integer, Object>(), new HashMap<Integer, Object>());
    }

    @Deprecated
    public TableSelectionWrapper(INattableModelManager manager, Collection<PositionCoordinate> selectionCells, Map<Integer, Object> fullySelectedRowObject, Map<Integer, Object> fullySelectedColumnObject) {
        this.manager = manager;
        this.selectionLayer = null;
        this.fillAllSelectedCellsMap(selectionCells);
        this.rowPositionAndAxis = fullySelectedRowObject;
        this.columnPositionAndAxis = fullySelectedColumnObject;
    }

    public TableSelectionWrapper(INattableModelManager manager, SelectionLayer selectionLayer, Collection<PositionCoordinate> selectionCells) {
        this.manager = manager;
        this.selectionLayer = selectionLayer;
        this.fillAllSelectedCellsMap(selectionCells);
    }

    private void fillAllSelectedCellsMap(Collection<PositionCoordinate> selectedCells) {
        if (this.selectionLayer == null && this.manager != null) {
            this.selectionLayer = this.manager.getBodyLayerStack().getSelectionLayer();
        }
        if (this.selectionLayer == null) {
            return;
        }
        for (PositionCoordinate positionCoordinate : selectedCells) {
            ILayerCell cell = this.selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell == null) continue;
            int columnIndex = this.selectionLayer.getColumnIndexByPosition(positionCoordinate.getColumnPosition());
            int rowIndex = this.selectionLayer.getRowIndexByPosition(positionCoordinate.getRowPosition());
            Object columnElement = this.manager.getColumnElement(columnIndex);
            Object rowElement = this.manager.getRowElement(rowIndex);
            CellReference reference = new CellReference(columnElement, rowElement);
            this.allSelectedCells.put(positionCoordinate, reference);
        }
    }

    public void updatePositions() {
        this.updateRowPositions();
        this.updateColumnPositions();
        this.updateCellPositions();
    }

    private void updateRowPositions() {
        HashMap<Integer, Object> rows = new HashMap<Integer, Object>();
        for (Object current : this.rowPositionAndAxis.values()) {
            int index = this.manager.getRowElementsList().indexOf(current);
            if (index >= 0) {
                int position = this.selectionLayer.getRowPositionByIndex(index);
                rows.put(position, current);
                continue;
            }
            this.rowAxisElements.remove(AxisUtils.getRepresentedElement(current));
            this.rowAxisElements.remove(current);
        }
        this.rowPositionAndAxis = rows;
    }

    private void updateColumnPositions() {
        HashMap<Integer, Object> columns = new HashMap<Integer, Object>();
        for (Object current : this.columnPositionAndAxis.values()) {
            int index = this.manager.getColumnElementsList().indexOf(current);
            if (index >= 0) {
                int position = this.selectionLayer.getColumnPositionByIndex(index);
                columns.put(position, current);
                continue;
            }
            this.columnAxisElements.remove(AxisUtils.getRepresentedElement(current));
            this.columnAxisElements.remove(current);
        }
        this.columnPositionAndAxis = columns;
    }

    private void updateCellPositions() {
        ArrayList<PositionCoordinate> toRemove = new ArrayList<PositionCoordinate>();
        for (Map.Entry<PositionCoordinate, CellReference> current : this.allSelectedCells.entrySet()) {
            PositionCoordinate pos = current.getKey();
            CellReference ref = current.getValue();
            int columnIndex = this.manager.getColumnElementsList().indexOf(ref.getColumnAxis());
            int rowIndex = this.manager.getRowElementsList().indexOf(ref.getRowAxis());
            if (rowIndex >= 0 && columnIndex >= 0) {
                int columnPosition = this.selectionLayer.getColumnPositionByIndex(columnIndex);
                int rowPosition = this.selectionLayer.getRowPositionByIndex(rowIndex);
                if (columnPosition >= 0 && rowPosition >= 0) {
                    pos.setColumnPosition(columnPosition);
                    pos.setRowPosition(rowPosition);
                    continue;
                }
                toRemove.add(pos);
                continue;
            }
            toRemove.add(pos);
        }
        for (PositionCoordinate removeMe : toRemove) {
            this.singleCellsCoordinatesAndUniqueReference.remove(removeMe);
        }
    }

    public void buildSingleCellSelection() {
        for (PositionCoordinate positionCoordinate : this.allSelectedCells.keySet()) {
            ILayerCell cell = this.selectionLayer.getCellByPosition(positionCoordinate.getColumnPosition(), positionCoordinate.getRowPosition());
            if (cell == null || !this.isSingleSelectedCell(positionCoordinate)) continue;
            this.singleCellsCoordinatesAndUniqueReference.put(positionCoordinate, this.allSelectedCells.get(positionCoordinate));
            Object value = cell.getDataValue();
            if (value != null) {
                if (value instanceof Collection) {
                    for (Object current : (Collection)value) {
                        this.singleCellValues.add(current);
                    }
                    continue;
                }
                this.singleCellValues.add(value);
                continue;
            }
            this.singleCellValues.add(cell);
        }
    }

    public Collection<Object> getSelectedElements() {
        HashSet<Object> selection = new HashSet<Object>();
        selection.addAll(this.rowAxisElements);
        selection.addAll(this.columnAxisElements);
        selection.addAll(this.singleCellValues);
        return selection;
    }

    private boolean isSingleSelectedCell(PositionCoordinate cellLocation) {
        return !this.rowPositionAndAxis.containsKey(cellLocation.getRowPosition()) && !this.columnPositionAndAxis.containsKey(cellLocation.getColumnPosition());
    }

    public Set<PositionCoordinate> getSingleSelectedCells() {
        return this.singleCellsCoordinatesAndUniqueReference.keySet();
    }

    public Collection<PositionCoordinate> getSelectedCells() {
        return this.allSelectedCells.keySet();
    }

    public Map<Integer, Object> getFullySelectedRows() {
        return this.rowPositionAndAxis;
    }

    public void addSelectedRow(int rowPosition) {
        int rowIndex = this.selectionLayer.getRowIndexByPosition(rowPosition);
        Object el = this.manager.getRowElement(rowIndex);
        this.rowPositionAndAxis.put(rowPosition, el);
        Object realElement = AxisUtils.getRepresentedElement(el);
        if (realElement != null) {
            this.rowAxisElements.add(realElement);
        } else {
            this.rowAxisElements.add(el);
        }
    }

    public void removeSelectedRow(int rowPosition) {
        int rowIndex = this.selectionLayer.getRowIndexByPosition(rowPosition);
        Object el = this.manager.getRowElement(rowIndex);
        this.rowPositionAndAxis.remove(rowPosition);
        Object realElement = AxisUtils.getRepresentedElement(el);
        if (realElement != null) {
            this.rowAxisElements.remove(realElement);
        } else {
            this.rowAxisElements.remove(el);
        }
    }

    public void addSelectedColumn(int columnPosition) {
        int columnIndex = this.selectionLayer.getColumnIndexByPosition(columnPosition);
        Object el = this.manager.getColumnElement(columnIndex);
        this.columnPositionAndAxis.put(columnPosition, el);
        Object realElement = AxisUtils.getRepresentedElement(el);
        if (realElement != null) {
            this.columnAxisElements.add(realElement);
        } else {
            this.columnAxisElements.add(el);
        }
    }

    public void removeSelectedColumn(int columnPosition) {
        int rowIndex = this.selectionLayer.getRowIndexByPosition(columnPosition);
        Object el = this.manager.getColumnElement(rowIndex);
        this.columnPositionAndAxis.remove(columnPosition);
        Object realElement = AxisUtils.getRepresentedElement(el);
        if (realElement != null) {
            this.columnAxisElements.remove(realElement);
        } else {
            this.columnAxisElements.remove(el);
        }
    }

    public Map<Integer, Object> getFullySelectedColumns() {
        return this.columnPositionAndAxis;
    }

    public boolean isCellsOutsideOfAxis() {
        boolean result = false;
        Iterator<PositionCoordinate> selectedCells = this.allSelectedCells.keySet().iterator();
        while (!result && selectedCells.hasNext()) {
            PositionCoordinate selectedCell = selectedCells.next();
            boolean bl = result = !this.rowPositionAndAxis.containsKey(selectedCell.getRowPosition()) && !this.columnPositionAndAxis.containsKey(selectedCell.getColumnPosition());
        }
        return result;
    }

    public boolean isContinuousRows() {
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        for (int rowIndex : this.getFullySelectedRows().keySet()) {
            if (-1 == firstRowIndex || rowIndex < firstRowIndex) {
                firstRowIndex = rowIndex;
            }
            if (-1 != lastRowIndex && rowIndex <= lastRowIndex) continue;
            lastRowIndex = rowIndex;
        }
        return lastRowIndex - firstRowIndex + 1 == this.getFullySelectedRows().size();
    }

    public boolean isContinuousColumns() {
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        for (int rowIndex : this.getFullySelectedColumns().keySet()) {
            if (-1 == firstColumnIndex || rowIndex < firstColumnIndex) {
                firstColumnIndex = rowIndex;
            }
            if (-1 != lastColumnIndex && rowIndex <= lastColumnIndex) continue;
            lastColumnIndex = rowIndex;
        }
        return lastColumnIndex - firstColumnIndex + 1 == this.getFullySelectedColumns().size();
    }

    public boolean isContinuousCells() {
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        for (PositionCoordinate currentPosition : this.getSelectedCells()) {
            if (-1 == firstRowIndex || currentPosition.getRowPosition() < firstRowIndex) {
                firstRowIndex = currentPosition.getRowPosition();
            }
            if (-1 == firstColumnIndex || currentPosition.getColumnPosition() < firstColumnIndex) {
                firstColumnIndex = currentPosition.getColumnPosition();
            }
            if (-1 == lastRowIndex || currentPosition.getRowPosition() > lastRowIndex) {
                lastRowIndex = currentPosition.getRowPosition();
            }
            if (-1 != lastColumnIndex && currentPosition.getColumnPosition() <= lastColumnIndex) continue;
            lastColumnIndex = currentPosition.getColumnPosition();
        }
        return (lastColumnIndex - firstColumnIndex + 1) * (lastRowIndex - firstRowIndex + 1) == this.getSelectedCells().size();
    }

    public void clearWrappedSelection() {
        this.rowPositionAndAxis.clear();
        this.columnPositionAndAxis.clear();
        this.allSelectedCells.clear();
        this.rowAxisElements.clear();
        this.columnAxisElements.clear();
        this.singleCellValues.clear();
        this.singleCellsCoordinatesAndUniqueReference.clear();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TableSelectionWrapper)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        TableSelectionWrapper w2 = (TableSelectionWrapper)o;
        if (w2.getNatTableModelManager() != this.manager) {
            return false;
        }
        return w2.getNatTableModelManager() == this.manager && w2.getFullySelectedColumns().equals(this.columnPositionAndAxis) && w2.getFullySelectedRows().equals(this.rowPositionAndAxis) && w2.getSelectedCells().equals(this.allSelectedCells.keySet()) && w2.getSingleSelectedCells().equals(this.singleCellValues);
    }

    public INattableModelManager getNatTableModelManager() {
        return this.manager;
    }

    public void copyRowsSelection(TableSelectionWrapper sourceWrapper) {
        this.rowPositionAndAxis.putAll(sourceWrapper.rowPositionAndAxis);
        this.rowAxisElements.addAll(sourceWrapper.rowAxisElements);
    }

    public void copyColumnsSelection(TableSelectionWrapper sourceWrapper) {
        this.columnPositionAndAxis.putAll(sourceWrapper.columnPositionAndAxis);
        this.columnAxisElements.addAll(sourceWrapper.columnAxisElements);
    }

    private final class CellReference {
        private Object columnAxis;
        private Object rowAxis;

        public CellReference(Object columnAxis, Object rowAxis) {
            this.columnAxis = columnAxis;
            this.rowAxis = rowAxis;
        }

        public Object getColumnAxis() {
            return this.columnAxis;
        }

        public Object getRowAxis() {
            return this.rowAxis;
        }
    }
}

