/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.internal.operations;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitecturePlugin;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureCommandUtils;

public class ArchitectureContextOperations {
    public static boolean isExtension(ArchitectureContext self) {
        return self.eIsSet((EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS);
    }

    public static boolean ceationCommandClassExists(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (self.getCreationCommandClass() != null) {
            boolean exists = false;
            Object javaClass = ArchitectureCommandUtils.getCommandClass(self, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS);
            boolean bl = exists = javaClass != null;
            if (!exists) {
                if (diagnostics != null) {
                    String problem = ArchitectureCommandUtils.getCommandClassUnconstrained(self, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS) == null ? "_UI_creationCommandClassExists_diagnostic" : "_UI_creationCommandClassConforms_diagnostic";
                    String expectedInterface = ArchitectureCommandUtils.getCommandType((EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS).map(Class::getSimpleName).orElse(ArchitecturePlugin.INSTANCE.getString("_UI_genericRequiredInterface_name"));
                    Set<String> requiredBundleDependencies = ArchitectureCommandUtils.getRequiredCommandBundleDependencies(self);
                    String depsList = String.join((CharSequence)", ", requiredBundleDependencies);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 1, ArchitecturePlugin.INSTANCE.getString(problem, new Object[]{EObjectValidator.getObjectLabel((EObject)self, context), expectedInterface, requiredBundleDependencies.size(), depsList}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS}));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean conversionCommandClassExists(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (self.getConversionCommandClass() != null) {
            boolean exists = false;
            Object javaClass = ArchitectureCommandUtils.getCommandClass(self, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS);
            boolean bl = exists = javaClass != null;
            if (!exists) {
                if (diagnostics != null) {
                    String problem = ArchitectureCommandUtils.getCommandClassUnconstrained(self, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS) == null ? "_UI_conversionCommandClassExists_diagnostic" : "_UI_conversionCommandClassConforms_diagnostic";
                    String expectedInterface = ArchitectureCommandUtils.getCommandType((EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS).map(Class::getSimpleName).orElse(ArchitecturePlugin.INSTANCE.getString("_UI_genericRequiredInterface_name"));
                    Set<String> requiredBundleDependencies = ArchitectureCommandUtils.getRequiredCommandBundleDependencies(self);
                    String depsList = String.join((CharSequence)", ", requiredBundleDependencies);
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 2, ArchitecturePlugin.INSTANCE.getString(problem, new Object[]{EObjectValidator.getObjectLabel((EObject)self, context), expectedInterface, requiredBundleDependencies.size(), depsList}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS}));
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isConsistentWith(ArchitectureContext self, ArchitectureContext context) {
        return context != null && context.eClass() == self.eClass();
    }

    public static boolean contextExtensionsAreConsistent(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List inconsistent;
        List<Object> list = inconsistent = !self.isExtension() ? List.of() : self.allExtendedContexts().stream().filter(other -> !self.isConsistentWith((ArchitectureContext)other)).collect(Collectors.toList());
        if (!inconsistent.isEmpty()) {
            if (diagnostics != null) {
                String us = EObjectValidator.getObjectLabel((EObject)self, context);
                String them = inconsistent.stream().map(e -> EObjectValidator.getObjectLabel((EObject)e, (Map)context)).collect(Collectors.joining(", "));
                ArrayList<EReference> data = new ArrayList<EReference>(List.of(self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS));
                data.addAll(inconsistent);
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 3, ArchitecturePlugin.INSTANCE.getString("_UI_contextExtensionsAreConsistent_diagnostic", new Object[]{us, them}), data.toArray()));
            }
            return false;
        }
        return true;
    }

    public static boolean contextGeneralizationIsConsistent(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Optional inconsistent;
        Optional<Object> optional = inconsistent = self.getGeneralContext() == null ? Optional.empty() : self.allGeneralContexts().stream().filter(Predicate.not(self::isConsistentWith)).findAny();
        if (inconsistent.isPresent()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 4, ArchitecturePlugin.INSTANCE.getString("_UI_contextGeneralizationIsConsistent_diagnostic", new Object[]{EObjectValidator.getObjectLabel((EObject)self, context), EObjectValidator.getObjectLabel((EObject)((EObject)inconsistent.get()), context)}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__GENERAL_CONTEXT, inconsistent.get()}));
            }
            return false;
        }
        return true;
    }

    public static boolean creationCommandClassRequired(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!self.isExtension() && self.getCreationCommandClass() == null) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 5, ArchitecturePlugin.INSTANCE.getString("_UI_creationCommandClassRequired_diagnostic", new Object[]{EObjectValidator.getObjectLabel((EObject)self, context)}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS}));
            }
            return false;
        }
        return true;
    }

    public static EList<ArchitectureContext> allExtendedContexts(ArchitectureContext self) {
        LinkedHashSet<ArchitectureContext> result = new LinkedHashSet<ArchitectureContext>();
        ArrayDeque<ArchitectureContext> queue = new ArrayDeque<ArchitectureContext>((Collection<ArchitectureContext>)self.getExtendedContexts());
        ArchitectureContext extended = (ArchitectureContext)queue.poll();
        while (extended != null) {
            if (result.add(extended)) {
                queue.addAll((Collection<ArchitectureContext>)extended.getExtendedContexts());
            }
            extended = (ArchitectureContext)queue.poll();
        }
        return new BasicEList.FastCompare(result);
    }

    public static EList<ArchitectureContext> allGeneralContexts(ArchitectureContext self) {
        LinkedHashSet<ArchitectureContext> result = new LinkedHashSet<ArchitectureContext>();
        ArchitectureContext general = self.getGeneralContext();
        while (general != null) {
            if (!result.add(general)) break;
            general = general.getGeneralContext();
        }
        return new BasicEList.FastCompare(result);
    }

    public static boolean extensionCycle(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (self.allExtendedContexts().contains((Object)self)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 6, ArchitecturePlugin.INSTANCE.getString("_UI_extensionCycle_diagnostic", new Object[]{EObjectValidator.getObjectLabel((EObject)self, context)}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS}));
            }
            return false;
        }
        return true;
    }

    public static boolean generalizationCycle(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (self.allGeneralContexts().contains((Object)self)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 7, ArchitecturePlugin.INSTANCE.getString("_UI_generalizationCycle_diagnostic", new Object[]{EObjectValidator.getObjectLabel((EObject)self, context)}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__GENERAL_CONTEXT}));
            }
            return false;
        }
        return true;
    }

    public static boolean generalNotExtended(ArchitectureContext self, DiagnosticChain diagnostics, Map<Object, Object> context) {
        HashSet<ArchitectureContext> allGenerals = new HashSet<ArchitectureContext>((Collection<ArchitectureContext>)self.allGeneralContexts());
        if (allGenerals.removeAll((Collection<?>)self.allExtendedContexts())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 8, ArchitecturePlugin.INSTANCE.getString("_UI_generalNotExtended_diagnostic", new Object[]{EObjectValidator.getObjectLabel((EObject)self, context)}), new Object[]{self, ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__EXTENDED_CONTEXTS}));
            }
            return false;
        }
        return true;
    }
}

