/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnCategories;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.columnCategories.ChooseColumnsFromCategoriesCommand;
import org.eclipse.nebula.widgets.nattable.columnCategories.ColumnCategoriesModel;
import org.eclipse.nebula.widgets.nattable.columnCategories.IColumnCategoriesDialogListener;
import org.eclipse.nebula.widgets.nattable.columnCategories.gui.ColumnCategoriesDialog;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooserUtils;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class ChooseColumnsFromCategoriesCommandHandler
extends AbstractLayerCommandHandler<ChooseColumnsFromCategoriesCommand>
implements IColumnCategoriesDialogListener {
    private final ColumnHideShowLayer columnHideShowLayer;
    private final ColumnHeaderLayer columnHeaderLayer;
    private final DataLayer columnHeaderDataLayer;
    private final ColumnCategoriesModel model;
    private ColumnCategoriesDialog dialog;

    public ChooseColumnsFromCategoriesCommandHandler(ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, ColumnCategoriesModel model) {
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.model = model;
    }

    @Override
    protected boolean doCommand(ChooseColumnsFromCategoriesCommand command) {
        this.dialog = new ColumnCategoriesDialog(command.getShell(), this.model, ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer), ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer));
        this.dialog.addListener(this);
        this.dialog.open();
        return true;
    }

    @Override
    public Class<ChooseColumnsFromCategoriesCommand> getCommandClass() {
        return ChooseColumnsFromCategoriesCommand.class;
    }

    @Override
    public void itemsRemoved(List<Integer> removedColumnPositions) {
        ColumnChooserUtils.hideColumnPositions(removedColumnPositions, this.columnHideShowLayer);
        this.refreshDialog();
    }

    @Override
    public void itemsSelected(List<Integer> addedColumnIndexes) {
        ColumnChooserUtils.showColumnIndexes(addedColumnIndexes, this.columnHideShowLayer);
        this.refreshDialog();
    }

    @Override
    public void itemsMoved(SelectionLayer.MoveDirectionEnum direction, List<Integer> selectedPositions) {
        List<List<Integer>> fromPositions = PositionUtil.getGroupedByContiguous(selectedPositions);
        List<Integer> toPositions = this.getDestinationPositions(direction, fromPositions);
        int i = 0;
        while (i < fromPositions.size()) {
            boolean multipleColumnsMoved = fromPositions.get(i).size() > 1;
            ILayerCommand command = null;
            if (!multipleColumnsMoved) {
                int fromPosition = fromPositions.get(i).get(0);
                int toPosition = toPositions.get(i);
                command = new ColumnReorderCommand(this.columnHideShowLayer, fromPosition, toPosition);
            } else if (multipleColumnsMoved) {
                command = new MultiColumnReorderCommand(this.columnHideShowLayer, fromPositions.get(i), toPositions.get(i));
            }
            this.columnHideShowLayer.doCommand(command);
            ++i;
        }
        this.refreshDialog();
    }

    protected List<Integer> getDestinationPositions(SelectionLayer.MoveDirectionEnum direction, List<List<Integer>> selectedPositions) {
        ArrayList<Integer> destinationPositions = new ArrayList<Integer>();
        for (List<Integer> contiguousPositions : selectedPositions) {
            switch (direction) {
                case UP: {
                    destinationPositions.add(ObjectUtils.getFirstElement(contiguousPositions) - 1);
                    break;
                }
                case DOWN: {
                    destinationPositions.add(ObjectUtils.getLastElement(contiguousPositions) + 2);
                }
            }
        }
        return destinationPositions;
    }

    private void refreshDialog() {
        if (ObjectUtils.isNotNull((Object)this.dialog)) {
            this.dialog.refresh(ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer), ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer));
        }
    }
}

