/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredPackageDialog
extends ElementListSelectionDialog {
    private boolean isRuntimeOnly;
    private boolean isDevelopmentTimeVersion;

    public RegisteredPackageDialog(Shell parent) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
            }
        });
        this.setMultipleSelection(false);
        this.setMessage(EcoreEditorPlugin.INSTANCE.getString("_UI_SelectRegisteredPackageURI"));
        this.setFilter("*");
        this.setTitle(EcoreEditorPlugin.INSTANCE.getString("_UI_PackageSelection_label"));
    }

    public String getResultAsString() {
        Object[] result = this.getResult();
        if (result != null && result.length == 1) {
            Object nsURI = result[0];
            if (this.isDevelopmentTimeVersion() && !this.isRuntimeOnly) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
                String uri = "";
                Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                URI location = (URI)ePackageNsURItoGenModelLocationMap.get(nsURI);
                Resource resource = resourceSet.getResource(location, true);
                EcoreUtil.resolveAll((Resource)resource);
                block0: for (Resource r : resourceSet.getResources()) {
                    for (EPackage ePackage : this.getAllPackages(r)) {
                        if (!nsURI.equals(ePackage.getNsURI())) continue;
                        uri = r.getURI().toString();
                        continue block0;
                    }
                }
                return uri;
            }
            return nsURI.toString();
        }
        return null;
    }

    private Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    public boolean isDevelopmentTimeVersion() {
        return this.isDevelopmentTimeVersion;
    }

    private void updateElements() {
        if (this.isDevelopmentTimeVersion) {
            Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
            Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
            Arrays.sort(result);
            this.setListElements(result);
        } else {
            Object[] result = EPackage.Registry.INSTANCE.keySet().toArray(new Object[EPackage.Registry.INSTANCE.size()]);
            Arrays.sort(result);
            this.setListElements(result);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Composite buttonGroup = new Composite(result, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonGroup.setLayout((Layout)layout);
        final Button developmentTimeVersionButton = new Button(buttonGroup, 16);
        developmentTimeVersionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RegisteredPackageDialog.this.isDevelopmentTimeVersion = developmentTimeVersionButton.getSelection();
                RegisteredPackageDialog.this.updateElements();
            }
        });
        developmentTimeVersionButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_DevelopmentTimeVersion_label"));
        Button runtimeTimeVersionButton = new Button(buttonGroup, 16);
        runtimeTimeVersionButton.setText(EcoreEditorPlugin.INSTANCE.getString("_UI_RuntimeVersion_label"));
        runtimeTimeVersionButton.setSelection(true);
        this.updateElements();
        return result;
    }

    public void setRuntimeOnly(boolean value) {
        this.isRuntimeOnly = value;
    }

    public boolean isRuntimeOnly() {
        return this.isRuntimeOnly;
    }
}

