/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.project.registry;

import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.project.registry.Capability;

public class MavenCapability
extends Capability {
    private static final long serialVersionUID = 8930981127331238566L;
    public static final String NS_MAVEN_ARTIFACT = "maven-artifact";
    public static final String NS_MAVEN_ARTIFACT_IMPORT = "maven-artifact-import";
    public static final String NS_MAVEN_PARENT = "maven-parent";
    private final String version;

    private MavenCapability(String namespace, String id, String version) {
        super(namespace, id);
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return this.getVersionlessKey() + "/" + this.version;
    }

    public int hashCode() {
        int hash = this.getVersionlessKey().hashCode();
        hash = hash * 17 + this.version.hashCode();
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        MavenCapability mavenCapability;
        if (this == obj) {
            return true;
        }
        Object object = obj;
        return object instanceof MavenCapability && (mavenCapability = (MavenCapability)object) == (MavenCapability)object && this.getVersionlessKey().equals(other.getVersionlessKey()) && this.version.equals(other.version);
    }

    public static MavenCapability createMavenArtifact(ArtifactKey key) {
        return new MavenCapability(NS_MAVEN_ARTIFACT, MavenCapability.getId(key), key.version());
    }

    public static MavenCapability createMavenArtifactImport(ArtifactKey key) {
        return new MavenCapability(NS_MAVEN_ARTIFACT_IMPORT, MavenCapability.getId(key), key.version());
    }

    public static MavenCapability createMavenParent(ArtifactKey key) {
        return new MavenCapability(NS_MAVEN_PARENT, MavenCapability.getId(key), key.version());
    }

    static String getId(ArtifactKey key) {
        String classifier = key.classifier() != null ? ":" + key.classifier() : "";
        return String.valueOf(key.groupId()) + ":" + key.artifactId() + classifier;
    }
}

