/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.outline.SymbolsLabelProvider;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class LSPSymbolInWorkspaceDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = LSPSymbolInWorkspaceDialog.class.getName();
    private final List<@NonNull LanguageServer> languageServers;
    private final InternalSymbolsLabelProvider labelProvider;

    public LSPSymbolInWorkspaceDialog(Shell shell, List<@NonNull LanguageServer> languageServers) {
        super(shell);
        this.languageServers = languageServers;
        this.labelProvider = new InternalSymbolsLabelProvider(new BoldStylerProvider(shell.getFont()));
        this.setMessage(Messages.LSPSymbolInWorkspaceDialog_DialogLabel);
        this.setTitle(Messages.LSPSymbolInWorkspaceDialog_DialogTitle);
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        InternalItemsFilter itemsFilter = new InternalItemsFilter();
        this.labelProvider.setPattern(itemsFilter.getPattern());
        return itemsFilter;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        if (itemsFilter.getPattern().isEmpty()) {
            return;
        }
        for (LanguageServer server : this.languageServers) {
            if (monitor.isCanceled()) {
                return;
            }
            WorkspaceSymbolParams params = new WorkspaceSymbolParams(itemsFilter.getPattern());
            try {
                List items = (List)((CompletableFuture)server.getWorkspaceService().symbol(params).thenApplyAsync(LSPSymbolInWorkspaceDialog::eitherToWorkspaceSymbols)).get(1L, TimeUnit.SECONDS);
                if (items == null) continue;
                for (Object item : items) {
                    if (item == null) continue;
                    contentProvider.add(item, itemsFilter);
                }
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                LanguageServerPlugin.logWarning("Could not get workspace symbols due to timeout after 1 seconds in `workspace/symbol`", e);
            }
        }
    }

    public String getElementName(Object item) {
        return ((WorkspaceSymbol)item).getName();
    }

    protected Comparator<WorkspaceSymbol> getItemsComparator() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = LanguageServerPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = LanguageServerPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    private static List<WorkspaceSymbol> toWorkspaceSymbols(List<? extends SymbolInformation> source) {
        return source == null ? List.of() : source.stream().map(LSPSymbolInWorkspaceDialog::toWorkspaceSymbol).collect(Collectors.toList());
    }

    private static WorkspaceSymbol toWorkspaceSymbol(SymbolInformation symbolinformation) {
        if (symbolinformation == null) {
            return null;
        }
        WorkspaceSymbol res = new WorkspaceSymbol();
        res.setName(symbolinformation.getName());
        res.setLocation(Either.forLeft((Object)symbolinformation.getLocation()));
        res.setKind(symbolinformation.getKind());
        res.setContainerName(symbolinformation.getContainerName());
        res.setTags(symbolinformation.getDeprecated() != false ? List.of(SymbolTag.Deprecated) : List.of());
        return res;
    }

    static List<? extends WorkspaceSymbol> eitherToWorkspaceSymbols(Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>> source) {
        return (List)source.map(LSPSymbolInWorkspaceDialog::toWorkspaceSymbols, Function.identity());
    }

    private class InternalItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private InternalItemsFilter() {
            super((FilteredItemsSelectionDialog)LSPSymbolInWorkspaceDialog.this);
        }

        /*
         * WARNING - void declaration
         */
        public boolean matchItem(Object item) {
            void info;
            void var3_2;
            WorkspaceSymbol workspaceSymbol;
            Object object = item;
            return object instanceof WorkspaceSymbol && (workspaceSymbol = (WorkspaceSymbol)object) == (WorkspaceSymbol)var3_2 && info.getName().toLowerCase().indexOf(this.getPattern().toLowerCase()) != -1;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }
    }

    private static class InternalSymbolsLabelProvider
    extends SymbolsLabelProvider {
        private String pattern;
        private final BoldStylerProvider stylerProvider;

        public InternalSymbolsLabelProvider(BoldStylerProvider stylerProvider) {
            super(true, InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.showKind", false));
            this.stylerProvider = stylerProvider;
        }

        @Override
        public StyledString getStyledText(Object element) {
            StyledString styledString = super.getStyledText(element);
            int index = styledString.getString().toLowerCase().indexOf(this.pattern);
            if (index != -1) {
                styledString.setStyle(index, this.pattern.length(), this.stylerProvider.getBoldStyler());
            }
            return styledString;
        }

        @Override
        protected int getMaxSeverity(@NonNull IResource resource, @NonNull IDocument doc, @NonNull Range range) throws CoreException, BadLocationException {
            int maxSeverity = -1;
            IMarker[] iMarkerArray = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                int offset = marker.getAttribute("charStart", -1);
                if (offset != -1) {
                    maxSeverity = Math.max(maxSeverity, marker.getAttribute("severity", -1));
                }
                ++n2;
            }
            return maxSeverity;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

