/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.dialogs.TypedViewerFilter;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class SourceFileSelectionDialog
extends SelectionStatusDialog {
    TreeViewer fViewer;
    private final ITreeContentProvider fContentProvider = new CElementContentProvider();
    private final ILabelProvider fLabelProvider = new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT);
    IStatus fCurrStatus = new StatusInfo();
    IStatus fFolderNameStatus = new StatusInfo();
    IStatus fFileNameStatus = new StatusInfo();
    ICElement fInput;
    private int fWidth = 60;
    private int fHeight = 18;
    StringDialogField fFolderNameDialogField;
    StringDialogField fFileNameDialogField;
    private IWorkspaceRoot fWorkspaceRoot;
    private final FieldsAdapter fFieldsAdapter = new FieldsAdapter();
    private ICElement fCurrentFolder = null;
    private String fCurrentFileString = null;
    String fInitialFolderName = null;
    String fInitialFileName = null;
    static final Class<?>[] FILTER_TYPES = new Class[]{ICModel.class, ICProject.class, ICContainer.class, ITranslationUnit.class};

    public SourceFileSelectionDialog(Shell parent) {
        super(parent);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fInput = CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot);
        this.fFolderNameDialogField = new StringDialogField();
        this.fFolderNameDialogField.setDialogFieldListener(this.fFieldsAdapter);
        this.fFolderNameDialogField.setLabelText(NewClassWizardMessages.SourceFileSelectionDialog_folderName_label);
        this.fFileNameDialogField = new StringDialogField();
        this.fFileNameDialogField.setDialogFieldListener(this.fFieldsAdapter);
        this.fFileNameDialogField.setLabelText(NewClassWizardMessages.SourceFileSelectionDialog_fileName_label);
        this.setResult(new ArrayList(0));
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    public void setInput(ICElement input) {
        this.fInput = input;
    }

    protected void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fFolderNameStatus, this.fFileNameStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        super.updateStatus(status);
    }

    protected void updateStatus(IStatus[] status) {
        this.updateStatus(StatusUtil.getMostSevere(status));
    }

    /*
     * Enabled aggressive block sorting
     */
    IStatus folderNameChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrentFolder = null;
        String str = this.fFolderNameDialogField.getText();
        if (str.length() == 0) {
            status.setError(NewClassWizardMessages.SourceFileSelectionDialog_error_EnterFolderName);
            return status;
        }
        Path path = new Path(str);
        IResource res = this.fWorkspaceRoot.findMember((IPath)path);
        if (res != null && res.exists()) {
            int resType = res.getType();
            if (resType != 4 && resType != 2) {
                status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_NotAFolder, (Object)str));
                return status;
            }
            IProject proj = res.getProject();
            if (!proj.isOpen()) {
                status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_NotAFolder, (Object)str));
                return status;
            }
            ICElement e = CoreModel.getDefault().create(res.getFullPath());
            this.fCurrentFolder = CModelUtil.getSourceFolder(e);
            if (this.fCurrentFolder == null) {
                status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_NotASourceFolder, (Object)str));
                return status;
            }
            if (CoreModel.hasCCNature((IProject)proj)) return status;
            if (CoreModel.hasCNature((IProject)proj)) return status;
            if (resType == 4) {
                status.setError(NewClassWizardMessages.SourceFileSelectionDialog_warning_NotACProject);
                return status;
            }
            status.setWarning(NewClassWizardMessages.SourceFileSelectionDialog_warning_NotInACProject);
            return status;
        }
        status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_FolderDoesNotExist, (Object)str));
        return status;
    }

    IStatus fileNameChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrentFileString = null;
        ICElement existingFile = null;
        String str = this.fFileNameDialogField.getText();
        if (str.length() == 0) {
            status.setError(NewClassWizardMessages.SourceFileSelectionDialog_error_EnterFileName);
            return status;
        }
        if (this.fCurrentFolder != null) {
            Path path;
            IPath folderPath = this.fCurrentFolder.getPath();
            IResource res = this.fWorkspaceRoot.findMember(folderPath.append((IPath)(path = new Path(str))));
            if (res == null) {
                res = this.fWorkspaceRoot.findMember((IPath)path);
            }
            if (res != null && res.exists()) {
                int resType = res.getType();
                if (resType == 1) {
                    IProject proj = res.getProject();
                    if (!proj.isOpen()) {
                        status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_NotAFile, (Object)str));
                        return status;
                    }
                    ICElement e = CoreModel.getDefault().create(res.getFullPath());
                    if (e instanceof ITranslationUnit) {
                        existingFile = e;
                    }
                    if (existingFile == null) {
                        status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_NotASourceFile, (Object)str));
                        return status;
                    }
                    if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                        status.setWarning(NewClassWizardMessages.SourceFileSelectionDialog_warning_NotInACProject);
                    }
                } else {
                    status.setError(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_error_NotAFile, (Object)str));
                    return status;
                }
            }
        }
        if (existingFile != null) {
            status.setWarning(NLS.bind((String)NewClassWizardMessages.SourceFileSelectionDialog_warning_SourceFileExists, (Object)str));
        }
        this.fCurrentFileString = str;
        return status;
    }

    public int open() {
        super.open();
        return this.getReturnCode();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
    }

    public void create() {
        BusyIndicator.showWhile(null, () -> {
            this.superCreate();
            this.fViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
            this.setPathFields(this.fInitialFolderName, this.fInitialFileName);
            this.fFileNameDialogField.setFocus();
            this.doStatusUpdate();
        });
    }

    void superCreate() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int nColumns = 4;
        this.fFolderNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fFolderNameDialogField.getTextControl(null), this.getMaxFieldWidth());
        TreeViewer treeViewer = this.createTreeViewer(composite);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        data.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        this.fFileNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace(composite);
        LayoutUtil.setWidthHint((Control)this.fFileNameDialogField.getTextControl(null), this.getMaxFieldWidth());
        return composite;
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(60);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        int style = 2052;
        this.fViewer = new TreeViewer(new Tree(parent, style));
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.fFieldsAdapter);
        this.fViewer.setComparator((ViewerComparator)new CElementSorter());
        this.fViewer.addFilter((ViewerFilter)new Filter());
        Tree tree = this.fViewer.getTree();
        tree.addSelectionListener((SelectionListener)this.fFieldsAdapter);
        this.fViewer.addDoubleClickListener((IDoubleClickListener)this.fFieldsAdapter);
        this.fViewer.setInput((Object)this.fInput.getCModel());
        return this.fViewer;
    }

    protected TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        if (this.getReturnCode() == 1) {
            this.setResult(null);
        }
    }

    public String getFolderName() {
        if (this.fCurrentFolder != null) {
            return this.fCurrentFolder.getPath().toString();
        }
        return null;
    }

    public String getFileName() {
        return this.fCurrentFileString;
    }

    public IPath getFilePath() {
        IPath path = null;
        if (this.fCurrentFolder != null) {
            path = this.fCurrentFolder.getPath();
            if (this.fCurrentFileString != null) {
                path = path.append(this.fCurrentFileString);
            }
        } else if (this.fCurrentFileString != null) {
            path = new Path(this.fCurrentFileString);
        }
        return path;
    }

    void setPathFields(String folderName, String fileName) {
        this.fFolderNameDialogField.setTextWithoutUpdate(folderName != null ? folderName : "");
        this.fFileNameDialogField.setTextWithoutUpdate(fileName != null ? fileName : "");
        this.fFolderNameStatus = this.folderNameChanged();
        this.fFileNameStatus = this.fileNameChanged();
    }

    public void setInitialSelection(String folderName, String fileName) {
        Path initialFolderPath;
        IPath folderPath;
        this.fInitialFileName = fileName != null && fileName.length() > 0 ? fileName : null;
        this.fInitialFolderName = null;
        if (folderName != null && folderName.length() > 0 && (folderPath = PathUtil.getValidEnclosingFolder((IPath)(initialFolderPath = new Path(folderName)))) != null) {
            this.fInitialFolderName = folderPath.toString();
            if (this.fInput != null) {
                ICElement[] foundElem = new ICElement[3];
                try {
                    this.fInput.accept(elem -> {
                        IPath path = elem.getPath();
                        if (path.isPrefixOf(folderPath)) {
                            if (foundElem[0] == null || path.segmentCount() > foundElem[0].getPath().segmentCount()) {
                                iCElementArray[0] = elem;
                            }
                            if (path.equals((Object)folderPath)) {
                                iCElementArray[1] = elem;
                                if (this.fInitialFileName == null) {
                                    return false;
                                }
                            } else if (this.fInitialFileName != null && elem.getElementName().equals(this.fInitialFileName)) {
                                iCElementArray[2] = elem;
                                return false;
                            }
                            return true;
                        }
                        return false;
                    });
                    ICElement selectedElement = foundElem[2];
                    if (selectedElement == null) {
                        selectedElement = foundElem[1];
                    }
                    if (selectedElement == null) {
                        selectedElement = foundElem[0];
                    }
                    if (selectedElement != null) {
                        this.setInitialSelections(new Object[]{selectedElement});
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    private final class FieldsAdapter
    extends SelectionAdapter
    implements ISelectionChangedListener,
    IDoubleClickListener,
    IDialogFieldListener {
        private FieldsAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            SourceFileSelectionDialog.this.doStatusUpdate();
            if (SourceFileSelectionDialog.this.fCurrStatus.isOK()) {
                SourceFileSelectionDialog.this.buttonPressed(0);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object obj;
            SourceFileSelectionDialog.this.setResult(((IStructuredSelection)event.getSelection()).toList());
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof ICElement) {
                ICElement elem = (ICElement)obj;
                IPath path = elem.getPath();
                String fileName = SourceFileSelectionDialog.this.fFileNameDialogField.getText();
                String folderName = SourceFileSelectionDialog.this.fFolderNameDialogField.getText();
                if (elem instanceof ICContainer || elem instanceof ICProject) {
                    folderName = path.toString();
                } else {
                    folderName = path.removeLastSegments(1).toString();
                    fileName = path.lastSegment();
                }
                SourceFileSelectionDialog.this.setPathFields(folderName, fileName);
            }
            SourceFileSelectionDialog.this.doStatusUpdate();
        }

        public void doubleClick(DoubleClickEvent event) {
            SourceFileSelectionDialog.this.doStatusUpdate();
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object item = ((IStructuredSelection)selection).getFirstElement();
                if (SourceFileSelectionDialog.this.fCurrStatus.getSeverity() != 4 && item instanceof ITranslationUnit) {
                    SourceFileSelectionDialog.this.setResult(((IStructuredSelection)selection).toList());
                    SourceFileSelectionDialog.this.close();
                    return;
                }
                if (SourceFileSelectionDialog.this.fViewer.getExpandedState(item)) {
                    SourceFileSelectionDialog.this.fViewer.collapseToLevel(item, 1);
                } else {
                    SourceFileSelectionDialog.this.fViewer.expandToLevel(item, 1);
                }
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == SourceFileSelectionDialog.this.fFolderNameDialogField) {
                SourceFileSelectionDialog.this.fFolderNameStatus = SourceFileSelectionDialog.this.folderNameChanged();
                SourceFileSelectionDialog.this.fFileNameStatus = SourceFileSelectionDialog.this.fileNameChanged();
            } else if (field == SourceFileSelectionDialog.this.fFileNameDialogField) {
                SourceFileSelectionDialog.this.fFileNameStatus = SourceFileSelectionDialog.this.fileNameChanged();
            }
            SourceFileSelectionDialog.this.doStatusUpdate();
        }
    }

    private final class Filter
    extends TypedViewerFilter {
        private Filter() {
            super(FILTER_TYPES);
        }

        @Override
        public boolean select(Viewer viewer, Object parent, Object obj) {
            if (obj instanceof ICElement) {
                ICElement elem = (ICElement)obj;
                if (!(SourceFileSelectionDialog.this.fInput instanceof ICModel)) {
                    return elem.getCProject().equals(SourceFileSelectionDialog.this.fInput.getCProject());
                }
                return true;
            }
            return super.select(viewer, parent, obj);
        }
    }
}

