/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.refactoring.rename.HeaderFileReferenceAdjuster;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameParticipantHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class HeaderFileRenameParticipant
extends RenameParticipant
implements ISharableParticipant {
    private Map<IResource, RenameArguments> renamedResources;
    private Change change;

    protected boolean initialize(Object element) {
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return this.renamedResources != null;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IResource && arguments instanceof RenameArguments) {
            if (this.renamedResources == null) {
                this.renamedResources = new HashMap<IResource, RenameArguments>();
            }
            this.renamedResources.put((IResource)element, (RenameArguments)arguments);
        }
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        try {
            if (this.renamedResources == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)Status.OK_STATUS);
                return refactoringStatus;
            }
            try {
                final HashMap<IFile, IFile> movedFiles = new HashMap<IFile, IFile>();
                HashMap<IContainer, IContainer> renamedContainers = new HashMap<IContainer, IContainer>();
                for (Map.Entry<IResource, RenameArguments> entry : this.renamedResources.entrySet()) {
                    IResource renamedResource = entry.getKey();
                    RenameArguments args = entry.getValue();
                    if (!args.getUpdateReferences() || renamedResource.isLinked()) continue;
                    String newName = args.getNewName();
                    if (renamedResource instanceof IContainer) {
                        IContainer container = (IContainer)renamedResource;
                        final IPath oldPath = container.getFullPath();
                        final IPath newPath = oldPath.removeLastSegments(1).append(newName);
                        final IWorkspaceRoot workspaceRoot = container.getWorkspace().getRoot();
                        IFolder newContainer = container.getType() == 2 ? workspaceRoot.getFolder(newPath) : workspaceRoot.getProject(newName);
                        renamedContainers.put(container, (IContainer)newContainer);
                        container.accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy proxy) throws CoreException {
                                if (proxy.isLinked()) {
                                    return false;
                                }
                                if (proxy.getType() == 1) {
                                    IFile file = (IFile)proxy.requestResource();
                                    IPath path = HeaderFileRenameParticipant.replacePrefix(file.getFullPath(), oldPath.segmentCount(), newPath);
                                    movedFiles.put(file, workspaceRoot.getFile(path));
                                    return false;
                                }
                                return true;
                            }
                        }, 0);
                        continue;
                    }
                    if (!(renamedResource instanceof IFile)) continue;
                    IFile file = (IFile)renamedResource;
                    movedFiles.put(file, file.getParent().getFile((IPath)new Path(newName)));
                }
                HeaderFileReferenceAdjuster includeAdjuster = new HeaderFileReferenceAdjuster(movedFiles, renamedContainers, this.getProcessor());
                this.change = includeAdjuster.createChange(context, pm);
            }
            catch (CoreException e) {
                RefactoringStatus refactoringStatus = RefactoringStatus.create((IStatus)e.getStatus());
                return refactoringStatus;
            }
        }
        finally {
            pm.done();
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.change = RenameParticipantHelper.postprocessParticipantChange(this.change, (RefactoringParticipant)this);
        pm.done();
        return this.change;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.done();
        return null;
    }

    public String getName() {
        return RenameMessages.HeaderFileRenameParticipant_name;
    }

    private static IPath replacePrefix(IPath path, int prefixLength, IPath newPrefix) {
        return newPrefix.append(path.removeFirstSegments(prefixLength));
    }
}

