/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.preferences.CodeTemplateBlock;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.text.templates.TemplatePersistenceData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CodeTemplatePreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.eclipse.cdt.ui.preferences.CodeTemplatePreferencePage";
    public static final String PROP_ID = "org.eclipse.cdt.ui.propertyPages.CodeTemplatePreferencePage";
    public static final String DATA_SELECT_TEMPLATE = "CodeTemplatePreferencePage.select_template";
    private CodeTemplateBlock fCodeTemplateConfigurationBlock;

    public CodeTemplatePreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(PreferencesMessages.CodeTemplatesPreferencePage_title);
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.fCodeTemplateConfigurationBlock = new CodeTemplateBlock(this.getNewStatusChangedListener(), this.getProject(), container);
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.code_templates_preference_context");
    }

    @Override
    protected Control createPreferenceContent(Composite composite) {
        return this.fCodeTemplateConfigurationBlock.createContents(composite);
    }

    @Override
    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
    }

    public boolean performOk() {
        if (this.fCodeTemplateConfigurationBlock != null) {
            return this.fCodeTemplateConfigurationBlock.performOk(this.useProjectSettings());
        }
        return true;
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.performDefaults();
        }
    }

    public void dispose() {
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.dispose();
        }
        super.dispose();
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public boolean performCancel() {
        if (this.fCodeTemplateConfigurationBlock != null) {
            this.fCodeTemplateConfigurationBlock.performCancel();
        }
        return super.performCancel();
    }

    @Override
    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.fCodeTemplateConfigurationBlock.hasProjectSpecificOptions(project);
    }

    @Override
    protected String getPreferencePageId() {
        return PREF_ID;
    }

    @Override
    protected String getPropertyPageId() {
        return null;
    }

    @Override
    public void applyData(Object data) {
        Object id;
        if (data instanceof Map && (id = ((Map)data).get(DATA_SELECT_TEMPLATE)) instanceof String) {
            TemplatePersistenceData[] templates;
            TemplatePersistenceData[] templatePersistenceDataArray = templates = this.fCodeTemplateConfigurationBlock.fTemplateStore.getTemplateData();
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                TemplatePersistenceData template = templatePersistenceDataArray[n2];
                if (id.equals(template.getId()) || id.equals(template.getTemplate().getName())) {
                    this.fCodeTemplateConfigurationBlock.postSetSelection(template);
                    break;
                }
                ++n2;
            }
        }
        super.applyData(data);
    }
}

