/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableManagerToolChain;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuiltinSpecsDetector;
import org.eclipse.osgi.util.NLS;

public abstract class ToolchainBuiltinSpecsDetector
extends AbstractBuiltinSpecsDetector {
    private static final String EMPTY_QUOTED_STRING = "\"\"";
    private Map<String, ITool> toolMap = new HashMap<String, ITool>();

    public abstract String getToolchainId();

    protected Optional<ITool> languageTool(String languageId) {
        ITool tool;
        if (languageId == null) {
            return Optional.empty();
        }
        if (this.currentCfgDescription == null && (tool = this.toolMap.get(languageId)) != null) {
            return Optional.of(tool);
        }
        String toolchainId = null;
        IToolChain toolchain = null;
        ITool tool2 = null;
        if (this.currentCfgDescription != null) {
            IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(this.currentCfgDescription);
            toolchain = cfg != null ? cfg.getToolChain() : null;
            String string = toolchainId = toolchain != null ? toolchain.getId() : null;
        }
        if (toolchain == null) {
            toolchainId = this.getToolchainId();
            toolchain = ManagedBuildManager.getExtensionToolChain(toolchainId);
        }
        while (toolchain != null) {
            tool2 = this.getTool(languageId, toolchain);
            if (tool2 != null) break;
            toolchain = toolchain.getSuperClass();
        }
        if (this.currentCfgDescription == null && tool2 != null) {
            this.toolMap.put(languageId, tool2);
        }
        if (tool2 == null) {
            ManagedBuilderCorePlugin.error("Unable to find tool in toolchain=" + toolchainId + " for language=" + languageId);
        }
        return Optional.ofNullable(tool2);
    }

    private ITool getTool(String languageId, IToolChain toolchain) {
        ITool[] tools;
        ITool[] iToolArray = tools = toolchain.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            IInputType[] inputTypes;
            ITool tool = iToolArray[n2];
            IInputType[] iInputTypeArray = inputTypes = tool.getInputTypes();
            int n3 = inputTypes.length;
            int n4 = 0;
            while (n4 < n3) {
                IInputType inType = iInputTypeArray[n4];
                String lang = inType.getLanguageId(tool);
                if (languageId.equals(lang)) {
                    return tool;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected String getCompilerCommand(String languageId) {
        Optional found = this.languageTool(languageId).flatMap(t -> Optional.of(t.getToolCommand()));
        if (!found.isPresent()) {
            ManagedBuilderCorePlugin.error(NLS.bind((String)"Unable to find compiler command in toolchain={0}", (Object)this.getToolchainId()));
            return "";
        }
        return (String)found.get();
    }

    @Override
    protected String getSpecFileExtension(String languageId) {
        Optional<List> optionalExtensions = this.languageTool(languageId).flatMap(t -> Optional.of(t.getAllInputExtensions()));
        List extensions = optionalExtensions.map(stringArray -> Arrays.asList(stringArray)).orElseGet(() -> Collections.emptyList());
        Optional<String> extension = this.selectBestSpecFileExtension(extensions);
        if (!extension.isPresent()) {
            ManagedBuilderCorePlugin.error(NLS.bind((String)"Unable to find file extension for language {0}", (Object)languageId));
            return null;
        }
        return extension.get();
    }

    protected String getToolOptions(String languageId, Predicate<IOption> predicate) {
        IOption[] options;
        Optional found = this.languageTool(languageId).flatMap(t -> Optional.of(t.getOptions()));
        if (!found.isPresent()) {
            return "";
        }
        StringBuilder flags = new StringBuilder();
        IOption[] iOptionArray = options = (IOption[])found.get();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            if (predicate.test(option)) {
                try {
                    String optionValue = null;
                    switch (option.getBasicValueType()) {
                        case 0: {
                            if (option.getBooleanValue()) {
                                optionValue = option.getCommand();
                                break;
                            }
                            optionValue = option.getCommandFalse();
                            break;
                        }
                        case 1: {
                            optionValue = option.getEnumCommand(option.getSelectedEnum());
                            break;
                        }
                        case 2: {
                            optionValue = String.valueOf(option.getCommand()) + option.getStringValue();
                            break;
                        }
                        case 3: {
                            String[] values = option.getBasicStringListValue();
                            if (values == null) break;
                            optionValue = "";
                            String cmd = option.getCommand();
                            String[] stringArray = values;
                            int n3 = values.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String value = stringArray[n4];
                                if (!value.isEmpty() && !value.equals(EMPTY_QUOTED_STRING)) {
                                    optionValue = String.valueOf(optionValue) + cmd + value + ' ';
                                }
                                ++n4;
                            }
                            break;
                        }
                        case 12: {
                            optionValue = option.getCommand(option.getStringValue());
                        }
                    }
                    if (optionValue != null) {
                        flags.append(' ').append(optionValue.trim());
                    }
                }
                catch (BuildException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            }
            ++n2;
        }
        return flags.toString().trim();
    }

    @Override
    protected String getToolOptions(String languageId) {
        return this.getToolOptions(languageId, IOption::isForScannerDiscovery);
    }

    @Override
    protected String getAllToolOptions(String languageId) {
        return this.getToolOptions(languageId, Predicate.not(IOption::isExcludedFromScannerDiscovery));
    }

    @Override
    protected List<IEnvironmentVariable> getEnvironmentVariables() {
        if (this.envMngr == null && this.currentCfgDescription == null) {
            IToolChain toolchain = ManagedBuildManager.getExtensionToolChain(this.getToolchainId());
            this.envMngr = new EnvironmentVariableManagerToolChain(toolchain);
        }
        List<IEnvironmentVariable> vars = super.getEnvironmentVariables();
        return vars;
    }
}

