/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public interface IToolChain
extends IAdaptable {
    public static final String ATTR_OS = "os";
    public static final String ATTR_ARCH = "arch";
    public static final String ATTR_PACKAGE = "package";

    public IToolChainProvider getProvider();

    public String getId();

    @Deprecated
    public String getVersion();

    public String getName();

    default public String getBuildConfigNameFragment() {
        String os = this.getProperty(ATTR_OS);
        String arch = this.getProperty(ATTR_ARCH);
        if (os != null) {
            return String.valueOf(os) + '.' + arch;
        }
        if (arch != null) {
            return arch;
        }
        return "";
    }

    default public String getTypeId() {
        return this.getProvider().getId();
    }

    public String getProperty(String var1);

    public void setProperty(String var1, String var2);

    public IEnvironmentVariable[] getVariables();

    public IEnvironmentVariable getVariable(String var1);

    public String[] getErrorParserIds();

    public List<String> getBinaryParserIds();

    default public IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, List<String> command, IExtendedScannerInfo baseScannerInfo, IResource resource, URI buildDirectoryURI) {
        return null;
    }

    @Deprecated
    default public IExtendedScannerInfo getScannerInfo(IBuildConfiguration buildConfig, Path command, String[] args, IExtendedScannerInfo baseScannerInfo, IResource resource, URI buildDirectoryURI) {
        ArrayList<String> commandStrings = new ArrayList<String>(args.length + 1);
        commandStrings.add(command.toString());
        commandStrings.addAll(Arrays.asList(args));
        return this.getScannerInfo(buildConfig, commandStrings, baseScannerInfo, resource, buildDirectoryURI);
    }

    default public IExtendedScannerInfo getDefaultScannerInfo(IBuildConfiguration buildConfig, IExtendedScannerInfo baseScannerInfo, ILanguage language, URI buildDirectoryURI) {
        return null;
    }

    public Path getCommandPath(Path var1);

    public String[] getCompileCommands();

    default public String[] getCompileCommands(ILanguage language) {
        return new String[0];
    }

    default public IResource[] getResourcesFromCommand(List<String> command, URI buildDirectoryURI) {
        return new IResource[0];
    }

    @Deprecated
    default public IResource[] getResourcesFromCommand(String[] command, URI buildDirectoryURI) {
        return this.getResourcesFromCommand(Arrays.asList(command), buildDirectoryURI);
    }

    default public List<String> stripCommand(List<String> command, IResource[] resources) {
        return command;
    }

    default public boolean matches(Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            String tcValue = this.getProperty(property.getKey());
            if (tcValue == null || property.getValue().equals(tcValue)) continue;
            return false;
        }
        return true;
    }
}

