/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.uiforms.handler;

import java.lang.reflect.Field;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.internal.forms.widgets.FormTextModel;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;

public class FormTextHandler
extends ControlHandler {
    private static FormTextHandler instance;

    public static FormTextHandler getInstance() {
        if (instance == null) {
            instance = new FormTextHandler();
        }
        return instance;
    }

    public void click(FormText widget) {
        this.click(widget, 0);
    }

    public void click(final FormText widget, final int hyperlinkSegmentIndex) {
        final FormTextModel model = this.getModel(widget);
        if (hyperlinkSegmentIndex > model.getHyperlinkCount()) {
            throw new CoreLayerException("FormText with text \"" + this.getText(widget) + "\" has only " + model.getHyperlinkCount() + " hyperlink segments.");
        }
        Display.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IHyperlinkSegment hyperlink = model.getHyperlink(hyperlinkSegmentIndex);
                model.selectLink(hyperlink);
                FormTextHandler.this.notifyWidget(1, widget);
            }
        });
    }

    public String getText(FormText widget) {
        FormTextModel model = this.getModel(widget);
        return model.getAccessibleText().trim();
    }

    private void notifyWidget(int eventType, FormText widget) {
        Event event = this.createEvent(widget);
        this.notifyWidget(eventType, event, (Widget)widget);
    }

    private Event createEvent(FormText widget) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = widget;
        event.display = Display.getDisplay();
        event.type = 1;
        event.character = (char)13;
        return event;
    }

    private FormTextModel getModel(FormText widget) {
        FormTextModel model;
        Field field;
        try {
            field = widget.getClass().getDeclaredField("model");
        }
        catch (SecurityException e1) {
            throw new SecurityException(e1);
        }
        catch (NoSuchFieldException e1) {
            throw new SecurityException(e1);
        }
        field.setAccessible(true);
        try {
            model = (FormTextModel)field.get(widget);
        }
        catch (IllegalArgumentException e1) {
            throw new SecurityException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new SecurityException(e1);
        }
        return model;
    }
}

