/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox.java;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.JavaBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.ModuleHandle;
import org.eclipse.m2m.internal.qvt.oml.blackbox.java.StandaloneBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.ResolverUtils;
import org.eclipse.m2m.qvt.oml.blackbox.java.Module;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiBlackboxProvider
extends JavaBlackboxProvider {
    public static final String URI_BLACKBOX_OSGI_QUERY = "osgi";
    private final Map<Bundle, Map<String, BlackboxUnitDescriptor>> importedDescriptors = new HashMap<Bundle, Map<String, BlackboxUnitDescriptor>>();
    private final Map<Bundle, Map<String, BlackboxUnitDescriptor>> annotatedDescriptors = new HashMap<Bundle, Map<String, BlackboxUnitDescriptor>>();

    @Override
    public BlackboxUnitDescriptor getUnitDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        BlackboxUnitDescriptor standaloneDescriptor = StandaloneBlackboxProvider.INSTANCE.getUnitDescriptor(qualifiedName, resolutionContext);
        if (standaloneDescriptor != null) {
            return standaloneDescriptor;
        }
        Bundle bundle = OSGiBlackboxProvider.getBundle(resolutionContext);
        if (bundle != null) {
            Map<String, BlackboxUnitDescriptor> descriptors = this.importedDescriptors.get(bundle);
            if (descriptors == null) {
                descriptors = new HashMap<String, BlackboxUnitDescriptor>();
                this.importedDescriptors.put(bundle, descriptors);
            }
            if (descriptors.containsKey(qualifiedName)) {
                return descriptors.get(qualifiedName);
            }
            BlackboxUnitDescriptor result = this.loadDescriptor(bundle, qualifiedName, false);
            if (result != null) {
                descriptors.put(qualifiedName, result);
            }
            return result;
        }
        return null;
    }

    @Override
    public Collection<? extends BlackboxUnitDescriptor> getUnitDescriptors(ResolutionContext resolutionContext) {
        Collection<JavaBlackboxProvider.JavaUnitDescriptor> standaloneDescriptors = StandaloneBlackboxProvider.INSTANCE.getUnitDescriptors(resolutionContext);
        Bundle bundle = OSGiBlackboxProvider.getBundle(resolutionContext);
        if (bundle != null) {
            HashMap<String, BlackboxUnitDescriptor> descriptors = new HashMap<String, BlackboxUnitDescriptor>(resolutionContext.getImports().isEmpty() ? this.getAnnotatedDescriptors(bundle) : this.getImportedDescriptors(bundle));
            for (BlackboxUnitDescriptor blackboxUnitDescriptor : standaloneDescriptors) {
                descriptors.put(blackboxUnitDescriptor.getQualifiedName(), blackboxUnitDescriptor);
            }
            return descriptors.values();
        }
        return standaloneDescriptors;
    }

    private static Bundle getBundle(ResolutionContext resolutionContext) {
        URI contextUri = OSGiBlackboxProvider.reconvert(resolutionContext.getURI());
        if (contextUri.isPlatformPlugin() && contextUri.segmentCount() > 1) {
            return Platform.getBundle((String)contextUri.segment(1));
        }
        return null;
    }

    private Map<String, BlackboxUnitDescriptor> getImportedDescriptors(Bundle bundle) {
        Map<String, BlackboxUnitDescriptor> descriptors = this.importedDescriptors.get(bundle);
        if (descriptors == null) {
            return Collections.emptyMap();
        }
        return descriptors;
    }

    private static IPath[] getBundleClassPath(Bundle bundle) {
        String header = (String)bundle.getHeaders().get("Bundle-ClassPath");
        try {
            ManifestElement[] headerElements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)header);
            if (headerElements == null || headerElements.length == 0) {
                return new IPath[]{Path.EMPTY};
            }
            Path[] classPath = new Path[headerElements.length];
            int i = 0;
            while (i < headerElements.length) {
                String value = headerElements[i].getValue();
                classPath[i] = value.equals(".") ? Path.EMPTY : new Path(value);
                ++i;
            }
            return classPath;
        }
        catch (BundleException e) {
            return new IPath[0];
        }
    }

    private IPath resolveAgainstBundleClassPath(IPath path, IPath[] classPath) {
        IPath[] iPathArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath entry = iPathArray[n2];
            if (entry.isPrefixOf(path)) {
                return path.makeRelativeTo(entry);
            }
            ++n2;
        }
        return null;
    }

    private Map<String, BlackboxUnitDescriptor> getAnnotatedDescriptors(Bundle bundle) {
        Map<String, BlackboxUnitDescriptor> descriptors = this.annotatedDescriptors.get(bundle);
        if (descriptors == null) {
            Collection classResources;
            descriptors = new HashMap<String, BlackboxUnitDescriptor>();
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring != null && (classResources = bundleWiring.listResources(Path.ROOT.toString(), "*.class", 1)) != null) {
                IPath[] classPath = OSGiBlackboxProvider.getBundleClassPath(bundle);
                for (String classResource : classResources) {
                    String qualifiedName;
                    BlackboxUnitDescriptor descriptor;
                    IPath path;
                    if (classResource.contains("$") || (path = this.resolveAgainstBundleClassPath((IPath)new Path(classResource), classPath)) == null || (descriptor = this.loadDescriptor(bundle, qualifiedName = ResolverUtils.toQualifiedName(path.removeFileExtension()), true)) == null) continue;
                    descriptors.put(qualifiedName, descriptor);
                }
            }
            this.annotatedDescriptors.put(bundle, descriptors);
        }
        return descriptors;
    }

    private BlackboxUnitDescriptor loadDescriptor(final Bundle bundle, String qualifiedName, boolean isModuleAnnotationRequired) {
        try {
            Class cls = bundle.loadClass(qualifiedName);
            if (isModuleAnnotationRequired && !cls.isAnnotationPresent(Module.class)) {
            }
            return new OSGiUnitDescriptor(this, cls, bundle, qualifiedName){

                protected String getUnitQuery() {
                    return "osgi=" + bundle.getSymbolicName();
                }
            };
        }
        finally {
            return null;
        }
    }

    private static URI reconvert(URI uri) {
        String bundleSymbolicName;
        if (BlackboxUnitResolver.isBlackboxUnitURI(uri) && (bundleSymbolicName = ResolverUtils.getQueryValue(uri, URI_BLACKBOX_OSGI_QUERY)) != null) {
            return URI.createPlatformPluginURI((String)bundleSymbolicName, (boolean)true);
        }
        return uri;
    }

    @Override
    public void cleanup() {
        this.importedDescriptors.clear();
        this.annotatedDescriptors.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OSGiUnitDescriptor
    extends JavaBlackboxProvider.JavaUnitDescriptor {
        private Bundle bundle;

        OSGiUnitDescriptor(Class<?> cls, Bundle bundle, String unitQualifiedName) {
            super(unitQualifiedName);
            this.bundle = bundle;
            this.addModuleHandle(new OSGiModuleHandle(cls));
        }

        @Override
        public URI reconvertURI() {
            return OSGiBlackboxProvider.reconvert(this.getURI());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class OSGiModuleHandle
        extends ModuleHandle {
            private Class<?> cls;

            OSGiModuleHandle(Class<?> cls) {
                super(cls.getCanonicalName(), cls.getSimpleName());
                this.cls = cls;
            }

            @Override
            public Class<?> getModuleJavaClass() {
                return this.cls;
            }

            @Override
            public String toString() {
                return String.valueOf(super.toString()) + ", bundle: " + OSGiUnitDescriptor.this.bundle.getSymbolicName();
            }
        }
    }
}

