/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.command;

import org.eclipse.bpmn2.modeler.core.features.command.ICustomCommandFeature;
import org.eclipse.bpmn2.modeler.core.features.command.Messages;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.ICopyFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IPasteFeature;
import org.eclipse.graphiti.features.context.ICopyContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPasteContext;
import org.eclipse.graphiti.features.context.impl.CopyContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.PasteContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;

public class CustomKeyCommandFeature
extends AbstractCustomFeature
implements ICustomCommandFeature {
    private String name = Messages.CustomKeyCommandFeature_MoveOrDuplicate;

    public CustomKeyCommandFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean isAvailable(String hint) {
        if (hint != null) {
            if (hint.startsWith("move")) {
                this.name = Messages.CustomKeyCommandFeature_Move;
                return true;
            }
            if (hint.startsWith("duplicate")) {
                this.name = Messages.CustomKeyCommandFeature_Duplicate;
                return true;
            }
        }
        return false;
    }

    public boolean canExecute(ICustomContext context) {
        String command = (String)context.getProperty((Object)"command.hint");
        if (command != null) {
            if (command.startsWith("move")) {
                return this.canExecuteMove(context);
            }
            if (command.startsWith("duplicate")) {
                return this.canExecuteDuplicate(context);
            }
        }
        return false;
    }

    private boolean canExecuteMove(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes.length == 0) {
            return false;
        }
        PictogramElement[] pictogramElementArray = pes;
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            if (!(pe instanceof ContainerShape)) {
                return false;
            }
            ContainerShape cs = (ContainerShape)pe;
            MoveShapeContext moveContext = new MoveShapeContext((Shape)cs);
            moveContext.setSourceContainer(cs.getContainer());
            moveContext.setTargetContainer(cs.getContainer());
            IMoveShapeFeature f = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)moveContext);
            if (!f.canMoveShape((IMoveShapeContext)moveContext)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canExecuteDuplicate(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes.length == 0) {
            return false;
        }
        CopyContext copyContext = new CopyContext(pes);
        ICopyFeature copyFeature = this.getFeatureProvider().getCopyFeature((ICopyContext)copyContext);
        if (copyFeature == null || !copyFeature.canCopy((ICopyContext)copyContext)) {
            return false;
        }
        DiagramBehavior db = (DiagramBehavior)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior();
        Point p = db.getMouseLocation();
        p = db.calculateRealMouseLocation(p);
        org.eclipse.graphiti.mm.algorithms.styles.Point point = GraphicsUtil.createPoint(p.x, p.y);
        PasteContext pasteContext = new PasteContext(pes, point.getX(), point.getY());
        pasteContext.putProperty((Object)"copy.from.context", (Object)Boolean.TRUE);
        IPasteFeature pasteFeature = this.getFeatureProvider().getPasteFeature((IPasteContext)pasteContext);
        return pasteFeature != null && pasteFeature.canPaste((IPasteContext)pasteContext);
    }

    public void execute(ICustomContext context) {
        String command = (String)context.getProperty((Object)"command.hint");
        if (command.startsWith("move")) {
            this.executeMove(context);
        } else if (command.startsWith("duplicate")) {
            this.executeDuplicate(context);
        }
    }

    public String getDescription() {
        return super.getDescription();
    }

    public String getName() {
        return this.name;
    }

    private void executeMove(ICustomContext context) {
        PictogramElement[] pes;
        int dx = 0;
        int dy = 0;
        int mult = 1;
        String command = (String)context.getProperty((Object)"command.hint");
        if (command.endsWith("10")) {
            mult = 10;
            command = command.replace("10", "");
        }
        if ("moveup".equals(command)) {
            dy = -1;
        } else if ("movedown".equals(command)) {
            dy = 1;
        } else if ("moveleft".equals(command)) {
            dx = -1;
        } else if ("moveright".equals(command)) {
            dx = 1;
        }
        dx *= mult;
        dy *= mult;
        PictogramElement[] pictogramElementArray = pes = context.getPictogramElements();
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            ContainerShape cs = (ContainerShape)pe;
            MoveShapeContext moveContext = new MoveShapeContext((Shape)cs);
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)cs);
            EObject c = cs.eContainer();
            if (c instanceof ContainerShape) {
                ILocation lc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)((ContainerShape)c));
                loc.setX(loc.getX() - lc.getX());
                loc.setY(loc.getY() - lc.getY());
            }
            moveContext.setDeltaX(dx);
            moveContext.setDeltaY(dy);
            moveContext.setX(loc.getX() + dx);
            moveContext.setY(loc.getY() + dy);
            moveContext.setSourceContainer(cs.getContainer());
            moveContext.setTargetContainer(cs.getContainer());
            IMoveShapeFeature f = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)moveContext);
            f.moveShape((IMoveShapeContext)moveContext);
            ++n2;
        }
    }

    private void executeDuplicate(ICustomContext context) {
        CopyContext copyContext = new CopyContext(context.getPictogramElements());
        ICopyFeature copyFeature = this.getFeatureProvider().getCopyFeature((ICopyContext)copyContext);
        copyFeature.copy((ICopyContext)copyContext);
        DiagramBehavior db = (DiagramBehavior)this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior();
        Point p = db.getMouseLocation();
        p = db.calculateRealMouseLocation(p);
        org.eclipse.graphiti.mm.algorithms.styles.Point point = GraphicsUtil.createPoint(p.x, p.y);
        PasteContext pasteContext = new PasteContext(context.getPictogramElements(), point.getX(), point.getY());
        IPasteFeature pasteFeature = this.getFeatureProvider().getPasteFeature((IPasteContext)pasteContext);
        pasteFeature.paste((IPasteContext)pasteContext);
    }
}

