/**********************************************************************
 * Auto-generated by protocol-dts-generator.ts, do not edit manually. *
 **********************************************************************/

export namespace Protocol {

    export type integer = number

    export interface ProtocolApi {
        Console: ConsoleApi;

        Debugger: DebuggerApi;

        HeapProfiler: HeapProfilerApi;

        Profiler: ProfilerApi;

        Runtime: RuntimeApi;

        Schema: SchemaApi;

        Accessibility: AccessibilityApi;

        Animation: AnimationApi;

        ApplicationCache: ApplicationCacheApi;

        Audits: AuditsApi;

        Browser: BrowserApi;

        CSS: CSSApi;

        CacheStorage: CacheStorageApi;

        DOM: DOMApi;

        DOMDebugger: DOMDebuggerApi;

        DOMSnapshot: DOMSnapshotApi;

        DOMStorage: DOMStorageApi;

        Database: DatabaseApi;

        DeviceOrientation: DeviceOrientationApi;

        Emulation: EmulationApi;

        HeadlessExperimental: HeadlessExperimentalApi;

        IO: IOApi;

        IndexedDB: IndexedDBApi;

        Input: InputApi;

        Inspector: InspectorApi;

        LayerTree: LayerTreeApi;

        Log: LogApi;

        Memory: MemoryApi;

        Network: NetworkApi;

        Overlay: OverlayApi;

        Page: PageApi;

        Performance: PerformanceApi;

        Security: SecurityApi;

        ServiceWorker: ServiceWorkerApi;

        Storage: StorageApi;

        SystemInfo: SystemInfoApi;

        Target: TargetApi;

        Tethering: TetheringApi;

        Tracing: TracingApi;

        Testing: TestingApi;
    }

    /**
     * This domain is deprecated - use Runtime or Log instead.
     */
    export namespace Console {

        /**
         * Console message.
         */
        export interface ConsoleMessage {
            /**
             * Message source.
             */
            source: ('xml' | 'javascript' | 'network' | 'console-api' | 'storage' | 'appcache' | 'rendering' | 'security' | 'other' | 'deprecation' | 'worker');

            /**
             * Message severity.
             */
            level: ('log' | 'warning' | 'error' | 'debug' | 'info');

            /**
             * Message text.
             */
            text: string;

            /**
             * URL of the message origin.
             */
            url?: string;

            /**
             * Line number in the resource that generated this message (1-based).
             */
            line?: integer;

            /**
             * Column number in the resource that generated this message (1-based).
             */
            column?: integer;
        }

        export interface MessageAddedEvent {
            /**
             * Console message that has been added.
             */
            message: ConsoleMessage;
        }
    }

    export interface ConsoleApi {
        /**
         * Does nothing.
         */
        clearMessages(): Promise<void>;

        /**
         * Disables console domain, prevents further console messages from being reported to the client.
         */
        disable(): Promise<void>;

        /**
         * Enables console domain, sends the messages collected so far to the client by means of the
         * `messageAdded` notification.
         */
        enable(): Promise<void>;

        /**
         * Issued when new console message is added.
         */
        on(event: 'messageAdded', listener: (params: Console.MessageAddedEvent) => void): void;
    }

    /**
     * Debugger domain exposes JavaScript debugging capabilities. It allows setting and removing
     * breakpoints, stepping through execution, exploring stack traces, etc.
     */
    export namespace Debugger {

        /**
         * Breakpoint identifier.
         */
        export type BreakpointId = string;

        /**
         * Call frame identifier.
         */
        export type CallFrameId = string;

        /**
         * Location in the source code.
         */
        export interface Location {
            /**
             * Script identifier as reported in the `Debugger.scriptParsed`.
             */
            scriptId: Runtime.ScriptId;

            /**
             * Line number in the script (0-based).
             */
            lineNumber: integer;

            /**
             * Column number in the script (0-based).
             */
            columnNumber?: integer;
        }

        /**
         * Location in the source code.
         */
        export interface ScriptPosition {
            lineNumber: integer;

            columnNumber: integer;
        }

        /**
         * JavaScript call frame. Array of call frames form the call stack.
         */
        export interface CallFrame {
            /**
             * Call frame identifier. This identifier is only valid while the virtual machine is paused.
             */
            callFrameId: CallFrameId;

            /**
             * Name of the JavaScript function called on this call frame.
             */
            functionName: string;

            /**
             * Location in the source code.
             */
            functionLocation?: Location;

            /**
             * Location in the source code.
             */
            location: Location;

            /**
             * JavaScript script name or url.
             */
            url: string;

            /**
             * Scope chain for this call frame.
             */
            scopeChain: Scope[];

            /**
             * `this` object for this call frame.
             */
            this: Runtime.RemoteObject;

            /**
             * The value being returned, if the function is at return point.
             */
            returnValue?: Runtime.RemoteObject;
        }

        /**
         * Scope description.
         */
        export interface Scope {
            /**
             * Scope type.
             */
            type: ('global' | 'local' | 'with' | 'closure' | 'catch' | 'block' | 'script' | 'eval' | 'module');

            /**
             * Object representing the scope. For `global` and `with` scopes it represents the actual
             * object; for the rest of the scopes, it is artificial transient object enumerating scope
             * variables as its properties.
             */
            object: Runtime.RemoteObject;

            name?: string;

            /**
             * Location in the source code where scope starts
             */
            startLocation?: Location;

            /**
             * Location in the source code where scope ends
             */
            endLocation?: Location;
        }

        /**
         * Search match for resource.
         */
        export interface SearchMatch {
            /**
             * Line number in resource content.
             */
            lineNumber: number;

            /**
             * Line with match content.
             */
            lineContent: string;
        }

        export interface BreakLocation {
            /**
             * Script identifier as reported in the `Debugger.scriptParsed`.
             */
            scriptId: Runtime.ScriptId;

            /**
             * Line number in the script (0-based).
             */
            lineNumber: integer;

            /**
             * Column number in the script (0-based).
             */
            columnNumber?: integer;

            type?: ('debuggerStatement' | 'call' | 'return');
        }

        export interface ContinueToLocationRequest {
            /**
             * Location to continue to.
             */
            location: Location;

            targetCallFrames?: ('any' | 'current');
        }

        export interface EnableResponse {
            /**
             * Unique identifier of the debugger.
             */
            debuggerId: Runtime.UniqueDebuggerId;
        }

        export interface EvaluateOnCallFrameRequest {
            /**
             * Call frame identifier to evaluate on.
             */
            callFrameId: CallFrameId;

            /**
             * Expression to evaluate.
             */
            expression: string;

            /**
             * String object group name to put result into (allows rapid releasing resulting object handles
             * using `releaseObjectGroup`).
             */
            objectGroup?: string;

            /**
             * Specifies whether command line API should be available to the evaluated expression, defaults
             * to false.
             */
            includeCommandLineAPI?: boolean;

            /**
             * In silent mode exceptions thrown during evaluation are not reported and do not pause
             * execution. Overrides `setPauseOnException` state.
             */
            silent?: boolean;

            /**
             * Whether the result is expected to be a JSON object that should be sent by value.
             */
            returnByValue?: boolean;

            /**
             * Whether preview should be generated for the result.
             */
            generatePreview?: boolean;

            /**
             * Whether to throw an exception if side effect cannot be ruled out during evaluation.
             */
            throwOnSideEffect?: boolean;

            /**
             * Terminate execution after timing out (number of milliseconds).
             */
            timeout?: Runtime.TimeDelta;
        }

        export interface EvaluateOnCallFrameResponse {
            /**
             * Object wrapper for the evaluation result.
             */
            result: Runtime.RemoteObject;

            /**
             * Exception details.
             */
            exceptionDetails?: Runtime.ExceptionDetails;
        }

        export interface GetPossibleBreakpointsRequest {
            /**
             * Start of range to search possible breakpoint locations in.
             */
            start: Location;

            /**
             * End of range to search possible breakpoint locations in (excluding). When not specified, end
             * of scripts is used as end of range.
             */
            end?: Location;

            /**
             * Only consider locations which are in the same (non-nested) function as start.
             */
            restrictToFunction?: boolean;
        }

        export interface GetPossibleBreakpointsResponse {
            /**
             * List of the possible breakpoint locations.
             */
            locations: BreakLocation[];
        }

        export interface GetScriptSourceRequest {
            /**
             * Id of the script to get source for.
             */
            scriptId: Runtime.ScriptId;
        }

        export interface GetScriptSourceResponse {
            /**
             * Script source.
             */
            scriptSource: string;
        }

        export interface GetStackTraceRequest {
            stackTraceId: Runtime.StackTraceId;
        }

        export interface GetStackTraceResponse {
            stackTrace: Runtime.StackTrace;
        }

        export interface PauseOnAsyncCallRequest {
            /**
             * Debugger will pause when async call with given stack trace is started.
             */
            parentStackTraceId: Runtime.StackTraceId;
        }

        export interface RemoveBreakpointRequest {
            breakpointId: BreakpointId;
        }

        export interface RestartFrameRequest {
            /**
             * Call frame identifier to evaluate on.
             */
            callFrameId: CallFrameId;
        }

        export interface RestartFrameResponse {
            /**
             * New stack trace.
             */
            callFrames: CallFrame[];

            /**
             * Async stack trace, if any.
             */
            asyncStackTrace?: Runtime.StackTrace;

            /**
             * Async stack trace, if any.
             */
            asyncStackTraceId?: Runtime.StackTraceId;
        }

        export interface SearchInContentRequest {
            /**
             * Id of the script to search in.
             */
            scriptId: Runtime.ScriptId;

            /**
             * String to search for.
             */
            query: string;

            /**
             * If true, search is case sensitive.
             */
            caseSensitive?: boolean;

            /**
             * If true, treats string parameter as regex.
             */
            isRegex?: boolean;
        }

        export interface SearchInContentResponse {
            /**
             * List of search matches.
             */
            result: SearchMatch[];
        }

        export interface SetAsyncCallStackDepthRequest {
            /**
             * Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async
             * call stacks (default).
             */
            maxDepth: integer;
        }

        export interface SetBlackboxPatternsRequest {
            /**
             * Array of regexps that will be used to check script url for blackbox state.
             */
            patterns: string[];
        }

        export interface SetBlackboxedRangesRequest {
            /**
             * Id of the script.
             */
            scriptId: Runtime.ScriptId;

            positions: ScriptPosition[];
        }

        export interface SetBreakpointRequest {
            /**
             * Location to set breakpoint in.
             */
            location: Location;

            /**
             * Expression to use as a breakpoint condition. When specified, debugger will only stop on the
             * breakpoint if this expression evaluates to true.
             */
            condition?: string;
        }

        export interface SetBreakpointResponse {
            /**
             * Id of the created breakpoint for further reference.
             */
            breakpointId: BreakpointId;

            /**
             * Location this breakpoint resolved into.
             */
            actualLocation: Location;
        }

        export interface SetBreakpointByUrlRequest {
            /**
             * Line number to set breakpoint at.
             */
            lineNumber: integer;

            /**
             * URL of the resources to set breakpoint on.
             */
            url?: string;

            /**
             * Regex pattern for the URLs of the resources to set breakpoints on. Either `url` or
             * `urlRegex` must be specified.
             */
            urlRegex?: string;

            /**
             * Script hash of the resources to set breakpoint on.
             */
            scriptHash?: string;

            /**
             * Offset in the line to set breakpoint at.
             */
            columnNumber?: integer;

            /**
             * Expression to use as a breakpoint condition. When specified, debugger will only stop on the
             * breakpoint if this expression evaluates to true.
             */
            condition?: string;
        }

        export interface SetBreakpointByUrlResponse {
            /**
             * Id of the created breakpoint for further reference.
             */
            breakpointId: BreakpointId;

            /**
             * List of the locations this breakpoint resolved into upon addition.
             */
            locations: Location[];
        }

        export interface SetBreakpointOnFunctionCallRequest {
            /**
             * Function object id.
             */
            objectId: Runtime.RemoteObjectId;

            /**
             * Expression to use as a breakpoint condition. When specified, debugger will
             * stop on the breakpoint if this expression evaluates to true.
             */
            condition?: string;
        }

        export interface SetBreakpointOnFunctionCallResponse {
            /**
             * Id of the created breakpoint for further reference.
             */
            breakpointId: BreakpointId;
        }

        export interface SetBreakpointsActiveRequest {
            /**
             * New value for breakpoints active state.
             */
            active: boolean;
        }

        export interface SetPauseOnExceptionsRequest {
            /**
             * Pause on exceptions mode.
             */
            state: ('none' | 'uncaught' | 'all');
        }

        export interface SetReturnValueRequest {
            /**
             * New return value.
             */
            newValue: Runtime.CallArgument;
        }

        export interface SetScriptSourceRequest {
            /**
             * Id of the script to edit.
             */
            scriptId: Runtime.ScriptId;

            /**
             * New content of the script.
             */
            scriptSource: string;

            /**
             * If true the change will not actually be applied. Dry run may be used to get result
             * description without actually modifying the code.
             */
            dryRun?: boolean;
        }

        export interface SetScriptSourceResponse {
            /**
             * New stack trace in case editing has happened while VM was stopped.
             */
            callFrames?: CallFrame[];

            /**
             * Whether current call stack  was modified after applying the changes.
             */
            stackChanged?: boolean;

            /**
             * Async stack trace, if any.
             */
            asyncStackTrace?: Runtime.StackTrace;

            /**
             * Async stack trace, if any.
             */
            asyncStackTraceId?: Runtime.StackTraceId;

            /**
             * Exception details if any.
             */
            exceptionDetails?: Runtime.ExceptionDetails;
        }

        export interface SetSkipAllPausesRequest {
            /**
             * New value for skip pauses state.
             */
            skip: boolean;
        }

        export interface SetVariableValueRequest {
            /**
             * 0-based number of scope as was listed in scope chain. Only 'local', 'closure' and 'catch'
             * scope types are allowed. Other scopes could be manipulated manually.
             */
            scopeNumber: integer;

            /**
             * Variable name.
             */
            variableName: string;

            /**
             * New variable value.
             */
            newValue: Runtime.CallArgument;

            /**
             * Id of callframe that holds variable.
             */
            callFrameId: CallFrameId;
        }

        export interface StepIntoRequest {
            /**
             * Debugger will issue additional Debugger.paused notification if any async task is scheduled
             * before next pause.
             */
            breakOnAsyncCall?: boolean;
        }

        export interface BreakpointResolvedEvent {
            /**
             * Breakpoint unique identifier.
             */
            breakpointId: BreakpointId;

            /**
             * Actual breakpoint location.
             */
            location: Location;
        }

        export interface PausedEvent {
            /**
             * Call stack the virtual machine stopped on.
             */
            callFrames: CallFrame[];

            /**
             * Pause reason.
             */
            reason: ('XHR' | 'DOM' | 'EventListener' | 'exception' | 'assert' | 'debugCommand' | 'promiseRejection' | 'OOM' | 'other' | 'ambiguous');

            /**
             * Object containing break-specific auxiliary properties.
             */
            data?: any;

            /**
             * Hit breakpoints IDs
             */
            hitBreakpoints?: string[];

            /**
             * Async stack trace, if any.
             */
            asyncStackTrace?: Runtime.StackTrace;

            /**
             * Async stack trace, if any.
             */
            asyncStackTraceId?: Runtime.StackTraceId;

            /**
             * Just scheduled async call will have this stack trace as parent stack during async execution.
             * This field is available only after `Debugger.stepInto` call with `breakOnAsynCall` flag.
             */
            asyncCallStackTraceId?: Runtime.StackTraceId;
        }

        export interface ScriptFailedToParseEvent {
            /**
             * Identifier of the script parsed.
             */
            scriptId: Runtime.ScriptId;

            /**
             * URL or name of the script parsed (if any).
             */
            url: string;

            /**
             * Line offset of the script within the resource with given URL (for script tags).
             */
            startLine: integer;

            /**
             * Column offset of the script within the resource with given URL.
             */
            startColumn: integer;

            /**
             * Last line of the script.
             */
            endLine: integer;

            /**
             * Length of the last line of the script.
             */
            endColumn: integer;

            /**
             * Specifies script creation context.
             */
            executionContextId: Runtime.ExecutionContextId;

            /**
             * Content hash of the script.
             */
            hash: string;

            /**
             * Embedder-specific auxiliary data.
             */
            executionContextAuxData?: any;

            /**
             * URL of source map associated with script (if any).
             */
            sourceMapURL?: string;

            /**
             * True, if this script has sourceURL.
             */
            hasSourceURL?: boolean;

            /**
             * True, if this script is ES6 module.
             */
            isModule?: boolean;

            /**
             * This script length.
             */
            length?: integer;

            /**
             * JavaScript top stack frame of where the script parsed event was triggered if available.
             */
            stackTrace?: Runtime.StackTrace;
        }

        export interface ScriptParsedEvent {
            /**
             * Identifier of the script parsed.
             */
            scriptId: Runtime.ScriptId;

            /**
             * URL or name of the script parsed (if any).
             */
            url: string;

            /**
             * Line offset of the script within the resource with given URL (for script tags).
             */
            startLine: integer;

            /**
             * Column offset of the script within the resource with given URL.
             */
            startColumn: integer;

            /**
             * Last line of the script.
             */
            endLine: integer;

            /**
             * Length of the last line of the script.
             */
            endColumn: integer;

            /**
             * Specifies script creation context.
             */
            executionContextId: Runtime.ExecutionContextId;

            /**
             * Content hash of the script.
             */
            hash: string;

            /**
             * Embedder-specific auxiliary data.
             */
            executionContextAuxData?: any;

            /**
             * True, if this script is generated as a result of the live edit operation.
             */
            isLiveEdit?: boolean;

            /**
             * URL of source map associated with script (if any).
             */
            sourceMapURL?: string;

            /**
             * True, if this script has sourceURL.
             */
            hasSourceURL?: boolean;

            /**
             * True, if this script is ES6 module.
             */
            isModule?: boolean;

            /**
             * This script length.
             */
            length?: integer;

            /**
             * JavaScript top stack frame of where the script parsed event was triggered if available.
             */
            stackTrace?: Runtime.StackTrace;
        }
    }

    export interface DebuggerApi {
        /**
         * Continues execution until specific location is reached.
         */
        continueToLocation(params: Debugger.ContinueToLocationRequest): Promise<void>;

        /**
         * Disables debugger for given page.
         */
        disable(): Promise<void>;

        /**
         * Enables debugger for the given page. Clients should not assume that the debugging has been
         * enabled until the result for this command is received.
         */
        enable(): Promise<Debugger.EnableResponse>;

        /**
         * Evaluates expression on a given call frame.
         */
        evaluateOnCallFrame(params: Debugger.EvaluateOnCallFrameRequest): Promise<Debugger.EvaluateOnCallFrameResponse>;

        /**
         * Returns possible locations for breakpoint. scriptId in start and end range locations should be
         * the same.
         */
        getPossibleBreakpoints(params: Debugger.GetPossibleBreakpointsRequest): Promise<Debugger.GetPossibleBreakpointsResponse>;

        /**
         * Returns source for the script with given id.
         */
        getScriptSource(params: Debugger.GetScriptSourceRequest): Promise<Debugger.GetScriptSourceResponse>;

        /**
         * Returns stack trace with given `stackTraceId`.
         */
        getStackTrace(params: Debugger.GetStackTraceRequest): Promise<Debugger.GetStackTraceResponse>;

        /**
         * Stops on the next JavaScript statement.
         */
        pause(): Promise<void>;

        pauseOnAsyncCall(params: Debugger.PauseOnAsyncCallRequest): Promise<void>;

        /**
         * Removes JavaScript breakpoint.
         */
        removeBreakpoint(params: Debugger.RemoveBreakpointRequest): Promise<void>;

        /**
         * Restarts particular call frame from the beginning.
         */
        restartFrame(params: Debugger.RestartFrameRequest): Promise<Debugger.RestartFrameResponse>;

        /**
         * Resumes JavaScript execution.
         */
        resume(): Promise<void>;

        /**
         * This method is deprecated - use Debugger.stepInto with breakOnAsyncCall and
         * Debugger.pauseOnAsyncTask instead. Steps into next scheduled async task if any is scheduled
         * before next pause. Returns success when async task is actually scheduled, returns error if no
         * task were scheduled or another scheduleStepIntoAsync was called.
         */
        scheduleStepIntoAsync(): Promise<void>;

        /**
         * Searches for given string in script content.
         */
        searchInContent(params: Debugger.SearchInContentRequest): Promise<Debugger.SearchInContentResponse>;

        /**
         * Enables or disables async call stacks tracking.
         */
        setAsyncCallStackDepth(params: Debugger.SetAsyncCallStackDepthRequest): Promise<void>;

        /**
         * Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in
         * scripts with url matching one of the patterns. VM will try to leave blackboxed script by
         * performing 'step in' several times, finally resorting to 'step out' if unsuccessful.
         */
        setBlackboxPatterns(params: Debugger.SetBlackboxPatternsRequest): Promise<void>;

        /**
         * Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted
         * scripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.
         * Positions array contains positions where blackbox state is changed. First interval isn't
         * blackboxed. Array should be sorted.
         */
        setBlackboxedRanges(params: Debugger.SetBlackboxedRangesRequest): Promise<void>;

        /**
         * Sets JavaScript breakpoint at a given location.
         */
        setBreakpoint(params: Debugger.SetBreakpointRequest): Promise<Debugger.SetBreakpointResponse>;

        /**
         * Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this
         * command is issued, all existing parsed scripts will have breakpoints resolved and returned in
         * `locations` property. Further matching script parsing will result in subsequent
         * `breakpointResolved` events issued. This logical breakpoint will survive page reloads.
         */
        setBreakpointByUrl(params: Debugger.SetBreakpointByUrlRequest): Promise<Debugger.SetBreakpointByUrlResponse>;

        /**
         * Sets JavaScript breakpoint before each call to the given function.
         * If another function was created from the same source as a given one,
         * calling it will also trigger the breakpoint.
         */
        setBreakpointOnFunctionCall(params: Debugger.SetBreakpointOnFunctionCallRequest): Promise<Debugger.SetBreakpointOnFunctionCallResponse>;

        /**
         * Activates / deactivates all breakpoints on the page.
         */
        setBreakpointsActive(params: Debugger.SetBreakpointsActiveRequest): Promise<void>;

        /**
         * Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions or
         * no exceptions. Initial pause on exceptions state is `none`.
         */
        setPauseOnExceptions(params: Debugger.SetPauseOnExceptionsRequest): Promise<void>;

        /**
         * Changes return value in top frame. Available only at return break position.
         */
        setReturnValue(params: Debugger.SetReturnValueRequest): Promise<void>;

        /**
         * Edits JavaScript source live.
         */
        setScriptSource(params: Debugger.SetScriptSourceRequest): Promise<Debugger.SetScriptSourceResponse>;

        /**
         * Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc).
         */
        setSkipAllPauses(params: Debugger.SetSkipAllPausesRequest): Promise<void>;

        /**
         * Changes value of variable in a callframe. Object-based scopes are not supported and must be
         * mutated manually.
         */
        setVariableValue(params: Debugger.SetVariableValueRequest): Promise<void>;

        /**
         * Steps into the function call.
         */
        stepInto(params: Debugger.StepIntoRequest): Promise<void>;

        /**
         * Steps out of the function call.
         */
        stepOut(): Promise<void>;

        /**
         * Steps over the statement.
         */
        stepOver(): Promise<void>;

        /**
         * Fired when breakpoint is resolved to an actual script and location.
         */
        on(event: 'breakpointResolved', listener: (params: Debugger.BreakpointResolvedEvent) => void): void;

        /**
         * Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
         */
        on(event: 'paused', listener: (params: Debugger.PausedEvent) => void): void;

        /**
         * Fired when the virtual machine resumed execution.
         */
        on(event: 'resumed', listener: () => void): void;

        /**
         * Fired when virtual machine fails to parse the script.
         */
        on(event: 'scriptFailedToParse', listener: (params: Debugger.ScriptFailedToParseEvent) => void): void;

        /**
         * Fired when virtual machine parses script. This event is also fired for all known and uncollected
         * scripts upon enabling debugger.
         */
        on(event: 'scriptParsed', listener: (params: Debugger.ScriptParsedEvent) => void): void;
    }

    export namespace HeapProfiler {

        /**
         * Heap snapshot object id.
         */
        export type HeapSnapshotObjectId = string;

        /**
         * Sampling Heap Profile node. Holds callsite information, allocation statistics and child nodes.
         */
        export interface SamplingHeapProfileNode {
            /**
             * Function location.
             */
            callFrame: Runtime.CallFrame;

            /**
             * Allocations size in bytes for the node excluding children.
             */
            selfSize: number;

            /**
             * Child nodes.
             */
            children: SamplingHeapProfileNode[];
        }

        /**
         * Profile.
         */
        export interface SamplingHeapProfile {
            head: SamplingHeapProfileNode;
        }

        export interface AddInspectedHeapObjectRequest {
            /**
             * Heap snapshot object id to be accessible by means of $x command line API.
             */
            heapObjectId: HeapSnapshotObjectId;
        }

        export interface GetHeapObjectIdRequest {
            /**
             * Identifier of the object to get heap object id for.
             */
            objectId: Runtime.RemoteObjectId;
        }

        export interface GetHeapObjectIdResponse {
            /**
             * Id of the heap snapshot object corresponding to the passed remote object id.
             */
            heapSnapshotObjectId: HeapSnapshotObjectId;
        }

        export interface GetObjectByHeapObjectIdRequest {
            objectId: HeapSnapshotObjectId;

            /**
             * Symbolic group name that can be used to release multiple objects.
             */
            objectGroup?: string;
        }

        export interface GetObjectByHeapObjectIdResponse {
            /**
             * Evaluation result.
             */
            result: Runtime.RemoteObject;
        }

        export interface GetSamplingProfileResponse {
            /**
             * Return the sampling profile being collected.
             */
            profile: SamplingHeapProfile;
        }

        export interface StartSamplingRequest {
            /**
             * Average sample interval in bytes. Poisson distribution is used for the intervals. The
             * default value is 32768 bytes.
             */
            samplingInterval?: number;
        }

        export interface StartTrackingHeapObjectsRequest {
            trackAllocations?: boolean;
        }

        export interface StopSamplingResponse {
            /**
             * Recorded sampling heap profile.
             */
            profile: SamplingHeapProfile;
        }

        export interface StopTrackingHeapObjectsRequest {
            /**
             * If true 'reportHeapSnapshotProgress' events will be generated while snapshot is being taken
             * when the tracking is stopped.
             */
            reportProgress?: boolean;
        }

        export interface TakeHeapSnapshotRequest {
            /**
             * If true 'reportHeapSnapshotProgress' events will be generated while snapshot is being taken.
             */
            reportProgress?: boolean;
        }

        export interface AddHeapSnapshotChunkEvent {
            chunk: string;
        }

        export interface HeapStatsUpdateEvent {
            /**
             * An array of triplets. Each triplet describes a fragment. The first integer is the fragment
             * index, the second integer is a total count of objects for the fragment, the third integer is
             * a total size of the objects for the fragment.
             */
            statsUpdate: integer[];
        }

        export interface LastSeenObjectIdEvent {
            lastSeenObjectId: integer;

            timestamp: number;
        }

        export interface ReportHeapSnapshotProgressEvent {
            done: integer;

            total: integer;

            finished?: boolean;
        }
    }

    export interface HeapProfilerApi {
        /**
         * Enables console to refer to the node with given id via $x (see Command Line API for more details
         * $x functions).
         */
        addInspectedHeapObject(params: HeapProfiler.AddInspectedHeapObjectRequest): Promise<void>;

        collectGarbage(): Promise<void>;

        disable(): Promise<void>;

        enable(): Promise<void>;

        getHeapObjectId(params: HeapProfiler.GetHeapObjectIdRequest): Promise<HeapProfiler.GetHeapObjectIdResponse>;

        getObjectByHeapObjectId(params: HeapProfiler.GetObjectByHeapObjectIdRequest): Promise<HeapProfiler.GetObjectByHeapObjectIdResponse>;

        getSamplingProfile(): Promise<HeapProfiler.GetSamplingProfileResponse>;

        startSampling(params: HeapProfiler.StartSamplingRequest): Promise<void>;

        startTrackingHeapObjects(params: HeapProfiler.StartTrackingHeapObjectsRequest): Promise<void>;

        stopSampling(): Promise<HeapProfiler.StopSamplingResponse>;

        stopTrackingHeapObjects(params: HeapProfiler.StopTrackingHeapObjectsRequest): Promise<void>;

        takeHeapSnapshot(params: HeapProfiler.TakeHeapSnapshotRequest): Promise<void>;

        on(event: 'addHeapSnapshotChunk', listener: (params: HeapProfiler.AddHeapSnapshotChunkEvent) => void): void;

        /**
         * If heap objects tracking has been started then backend may send update for one or more fragments
         */
        on(event: 'heapStatsUpdate', listener: (params: HeapProfiler.HeapStatsUpdateEvent) => void): void;

        /**
         * If heap objects tracking has been started then backend regularly sends a current value for last
         * seen object id and corresponding timestamp. If the were changes in the heap since last event
         * then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
         */
        on(event: 'lastSeenObjectId', listener: (params: HeapProfiler.LastSeenObjectIdEvent) => void): void;

        on(event: 'reportHeapSnapshotProgress', listener: (params: HeapProfiler.ReportHeapSnapshotProgressEvent) => void): void;

        on(event: 'resetProfiles', listener: () => void): void;
    }

    export namespace Profiler {

        /**
         * Profile node. Holds callsite information, execution statistics and child nodes.
         */
        export interface ProfileNode {
            /**
             * Unique id of the node.
             */
            id: integer;

            /**
             * Function location.
             */
            callFrame: Runtime.CallFrame;

            /**
             * Number of samples where this node was on top of the call stack.
             */
            hitCount?: integer;

            /**
             * Child node ids.
             */
            children?: integer[];

            /**
             * The reason of being not optimized. The function may be deoptimized or marked as don't
             * optimize.
             */
            deoptReason?: string;

            /**
             * An array of source position ticks.
             */
            positionTicks?: PositionTickInfo[];
        }

        /**
         * Profile.
         */
        export interface Profile {
            /**
             * The list of profile nodes. First item is the root node.
             */
            nodes: ProfileNode[];

            /**
             * Profiling start timestamp in microseconds.
             */
            startTime: number;

            /**
             * Profiling end timestamp in microseconds.
             */
            endTime: number;

            /**
             * Ids of samples top nodes.
             */
            samples?: integer[];

            /**
             * Time intervals between adjacent samples in microseconds. The first delta is relative to the
             * profile startTime.
             */
            timeDeltas?: integer[];
        }

        /**
         * Specifies a number of samples attributed to a certain source position.
         */
        export interface PositionTickInfo {
            /**
             * Source line number (1-based).
             */
            line: integer;

            /**
             * Number of samples attributed to the source line.
             */
            ticks: integer;
        }

        /**
         * Coverage data for a source range.
         */
        export interface CoverageRange {
            /**
             * JavaScript script source offset for the range start.
             */
            startOffset: integer;

            /**
             * JavaScript script source offset for the range end.
             */
            endOffset: integer;

            /**
             * Collected execution count of the source range.
             */
            count: integer;
        }

        /**
         * Coverage data for a JavaScript function.
         */
        export interface FunctionCoverage {
            /**
             * JavaScript function name.
             */
            functionName: string;

            /**
             * Source ranges inside the function with coverage data.
             */
            ranges: CoverageRange[];

            /**
             * Whether coverage data for this function has block granularity.
             */
            isBlockCoverage: boolean;
        }

        /**
         * Coverage data for a JavaScript script.
         */
        export interface ScriptCoverage {
            /**
             * JavaScript script id.
             */
            scriptId: Runtime.ScriptId;

            /**
             * JavaScript script name or url.
             */
            url: string;

            /**
             * Functions contained in the script that has coverage data.
             */
            functions: FunctionCoverage[];
        }

        /**
         * Describes a type collected during runtime.
         */
        export interface TypeObject {
            /**
             * Name of a type collected with type profiling.
             */
            name: string;
        }

        /**
         * Source offset and types for a parameter or return value.
         */
        export interface TypeProfileEntry {
            /**
             * Source offset of the parameter or end of function for return values.
             */
            offset: integer;

            /**
             * The types for this parameter or return value.
             */
            types: TypeObject[];
        }

        /**
         * Type profile data collected during runtime for a JavaScript script.
         */
        export interface ScriptTypeProfile {
            /**
             * JavaScript script id.
             */
            scriptId: Runtime.ScriptId;

            /**
             * JavaScript script name or url.
             */
            url: string;

            /**
             * Type profile entries for parameters and return values of the functions in the script.
             */
            entries: TypeProfileEntry[];
        }

        export interface GetBestEffortCoverageResponse {
            /**
             * Coverage data for the current isolate.
             */
            result: ScriptCoverage[];
        }

        export interface SetSamplingIntervalRequest {
            /**
             * New sampling interval in microseconds.
             */
            interval: integer;
        }

        export interface StartPreciseCoverageRequest {
            /**
             * Collect accurate call counts beyond simple 'covered' or 'not covered'.
             */
            callCount?: boolean;

            /**
             * Collect block-based coverage.
             */
            detailed?: boolean;
        }

        export interface StopResponse {
            /**
             * Recorded profile.
             */
            profile: Profile;
        }

        export interface TakePreciseCoverageResponse {
            /**
             * Coverage data for the current isolate.
             */
            result: ScriptCoverage[];
        }

        export interface TakeTypeProfileResponse {
            /**
             * Type profile for all scripts since startTypeProfile() was turned on.
             */
            result: ScriptTypeProfile[];
        }

        export interface ConsoleProfileFinishedEvent {
            id: string;

            /**
             * Location of console.profileEnd().
             */
            location: Debugger.Location;

            profile: Profile;

            /**
             * Profile title passed as an argument to console.profile().
             */
            title?: string;
        }

        export interface ConsoleProfileStartedEvent {
            id: string;

            /**
             * Location of console.profile().
             */
            location: Debugger.Location;

            /**
             * Profile title passed as an argument to console.profile().
             */
            title?: string;
        }
    }

    export interface ProfilerApi {
        disable(): Promise<void>;

        enable(): Promise<void>;

        /**
         * Collect coverage data for the current isolate. The coverage data may be incomplete due to
         * garbage collection.
         */
        getBestEffortCoverage(): Promise<Profiler.GetBestEffortCoverageResponse>;

        /**
         * Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.
         */
        setSamplingInterval(params: Profiler.SetSamplingIntervalRequest): Promise<void>;

        start(): Promise<void>;

        /**
         * Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code
         * coverage may be incomplete. Enabling prevents running optimized code and resets execution
         * counters.
         */
        startPreciseCoverage(params: Profiler.StartPreciseCoverageRequest): Promise<void>;

        /**
         * Enable type profile.
         */
        startTypeProfile(): Promise<void>;

        stop(): Promise<Profiler.StopResponse>;

        /**
         * Disable precise code coverage. Disabling releases unnecessary execution count records and allows
         * executing optimized code.
         */
        stopPreciseCoverage(): Promise<void>;

        /**
         * Disable type profile. Disabling releases type profile data collected so far.
         */
        stopTypeProfile(): Promise<void>;

        /**
         * Collect coverage data for the current isolate, and resets execution counters. Precise code
         * coverage needs to have started.
         */
        takePreciseCoverage(): Promise<Profiler.TakePreciseCoverageResponse>;

        /**
         * Collect type profile.
         */
        takeTypeProfile(): Promise<Profiler.TakeTypeProfileResponse>;

        on(event: 'consoleProfileFinished', listener: (params: Profiler.ConsoleProfileFinishedEvent) => void): void;

        /**
         * Sent when new profile recording is started using console.profile() call.
         */
        on(event: 'consoleProfileStarted', listener: (params: Profiler.ConsoleProfileStartedEvent) => void): void;
    }

    /**
     * Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.
     * Evaluation results are returned as mirror object that expose object type, string representation
     * and unique identifier that can be used for further object reference. Original objects are
     * maintained in memory unless they are either explicitly released or are released along with the
     * other objects in their object group.
     */
    export namespace Runtime {

        /**
         * Unique script identifier.
         */
        export type ScriptId = string;

        /**
         * Unique object identifier.
         */
        export type RemoteObjectId = string;

        /**
         * Primitive value which cannot be JSON-stringified. Includes values `-0`, `NaN`, `Infinity`,
         * `-Infinity`, and bigint literals.
         */
        export type UnserializableValue = string;

        /**
         * Mirror object referencing original JavaScript object.
         */
        export interface RemoteObject {
            /**
             * Object type.
             */
            type: ('object' | 'function' | 'undefined' | 'string' | 'number' | 'boolean' | 'symbol' | 'bigint');

            /**
             * Object subtype hint. Specified for `object` type values only.
             */
            subtype?: ('array' | 'null' | 'node' | 'regexp' | 'date' | 'map' | 'set' | 'weakmap' | 'weakset' | 'iterator' | 'generator' | 'error' | 'proxy' | 'promise' | 'typedarray');

            /**
             * Object class (constructor) name. Specified for `object` type values only.
             */
            className?: string;

            /**
             * Remote object value in case of primitive values or JSON values (if it was requested).
             */
            value?: any;

            /**
             * Primitive value which can not be JSON-stringified does not have `value`, but gets this
             * property.
             */
            unserializableValue?: UnserializableValue;

            /**
             * String representation of the object.
             */
            description?: string;

            /**
             * Unique object identifier (for non-primitive values).
             */
            objectId?: RemoteObjectId;

            /**
             * Preview containing abbreviated property values. Specified for `object` type values only.
             */
            preview?: ObjectPreview;

            customPreview?: CustomPreview;
        }

        export interface CustomPreview {
            header: string;

            hasBody: boolean;

            formatterObjectId: RemoteObjectId;

            bindRemoteObjectFunctionId: RemoteObjectId;

            configObjectId?: RemoteObjectId;
        }

        /**
         * Object containing abbreviated remote object value.
         */
        export interface ObjectPreview {
            /**
             * Object type.
             */
            type: ('object' | 'function' | 'undefined' | 'string' | 'number' | 'boolean' | 'symbol' | 'bigint');

            /**
             * Object subtype hint. Specified for `object` type values only.
             */
            subtype?: ('array' | 'null' | 'node' | 'regexp' | 'date' | 'map' | 'set' | 'weakmap' | 'weakset' | 'iterator' | 'generator' | 'error');

            /**
             * String representation of the object.
             */
            description?: string;

            /**
             * True iff some of the properties or entries of the original object did not fit.
             */
            overflow: boolean;

            /**
             * List of the properties.
             */
            properties: PropertyPreview[];

            /**
             * List of the entries. Specified for `map` and `set` subtype values only.
             */
            entries?: EntryPreview[];
        }

        export interface PropertyPreview {
            /**
             * Property name.
             */
            name: string;

            /**
             * Object type. Accessor means that the property itself is an accessor property.
             */
            type: ('object' | 'function' | 'undefined' | 'string' | 'number' | 'boolean' | 'symbol' | 'accessor' | 'bigint');

            /**
             * User-friendly property value string.
             */
            value?: string;

            /**
             * Nested value preview.
             */
            valuePreview?: ObjectPreview;

            /**
             * Object subtype hint. Specified for `object` type values only.
             */
            subtype?: ('array' | 'null' | 'node' | 'regexp' | 'date' | 'map' | 'set' | 'weakmap' | 'weakset' | 'iterator' | 'generator' | 'error');
        }

        export interface EntryPreview {
            /**
             * Preview of the key. Specified for map-like collection entries.
             */
            key?: ObjectPreview;

            /**
             * Preview of the value.
             */
            value: ObjectPreview;
        }

        /**
         * Object property descriptor.
         */
        export interface PropertyDescriptor {
            /**
             * Property name or symbol description.
             */
            name: string;

            /**
             * The value associated with the property.
             */
            value?: RemoteObject;

            /**
             * True if the value associated with the property may be changed (data descriptors only).
             */
            writable?: boolean;

            /**
             * A function which serves as a getter for the property, or `undefined` if there is no getter
             * (accessor descriptors only).
             */
            get?: RemoteObject;

            /**
             * A function which serves as a setter for the property, or `undefined` if there is no setter
             * (accessor descriptors only).
             */
            set?: RemoteObject;

            /**
             * True if the type of this property descriptor may be changed and if the property may be
             * deleted from the corresponding object.
             */
            configurable: boolean;

            /**
             * True if this property shows up during enumeration of the properties on the corresponding
             * object.
             */
            enumerable: boolean;

            /**
             * True if the result was thrown during the evaluation.
             */
            wasThrown?: boolean;

            /**
             * True if the property is owned for the object.
             */
            isOwn?: boolean;

            /**
             * Property symbol object, if the property is of the `symbol` type.
             */
            symbol?: RemoteObject;
        }

        /**
         * Object internal property descriptor. This property isn't normally visible in JavaScript code.
         */
        export interface InternalPropertyDescriptor {
            /**
             * Conventional property name.
             */
            name: string;

            /**
             * The value associated with the property.
             */
            value?: RemoteObject;
        }

        /**
         * Represents function call argument. Either remote object id `objectId`, primitive `value`,
         * unserializable primitive value or neither of (for undefined) them should be specified.
         */
        export interface CallArgument {
            /**
             * Primitive value or serializable javascript object.
             */
            value?: any;

            /**
             * Primitive value which can not be JSON-stringified.
             */
            unserializableValue?: UnserializableValue;

            /**
             * Remote object handle.
             */
            objectId?: RemoteObjectId;
        }

        /**
         * Id of an execution context.
         */
        export type ExecutionContextId = integer;

        /**
         * Description of an isolated world.
         */
        export interface ExecutionContextDescription {
            /**
             * Unique id of the execution context. It can be used to specify in which execution context
             * script evaluation should be performed.
             */
            id: ExecutionContextId;

            /**
             * Execution context origin.
             */
            origin: string;

            /**
             * Human readable name describing given context.
             */
            name: string;

            /**
             * Embedder-specific auxiliary data.
             */
            auxData?: any;
        }

        /**
         * Detailed information about exception (or error) that was thrown during script compilation or
         * execution.
         */
        export interface ExceptionDetails {
            /**
             * Exception id.
             */
            exceptionId: integer;

            /**
             * Exception text, which should be used together with exception object when available.
             */
            text: string;

            /**
             * Line number of the exception location (0-based).
             */
            lineNumber: integer;

            /**
             * Column number of the exception location (0-based).
             */
            columnNumber: integer;

            /**
             * Script ID of the exception location.
             */
            scriptId?: ScriptId;

            /**
             * URL of the exception location, to be used when the script was not reported.
             */
            url?: string;

            /**
             * JavaScript stack trace if available.
             */
            stackTrace?: StackTrace;

            /**
             * Exception object if available.
             */
            exception?: RemoteObject;

            /**
             * Identifier of the context where exception happened.
             */
            executionContextId?: ExecutionContextId;
        }

        /**
         * Number of milliseconds since epoch.
         */
        export type Timestamp = number;

        /**
         * Number of milliseconds.
         */
        export type TimeDelta = number;

        /**
         * Stack entry for runtime errors and assertions.
         */
        export interface CallFrame {
            /**
             * JavaScript function name.
             */
            functionName: string;

            /**
             * JavaScript script id.
             */
            scriptId: ScriptId;

            /**
             * JavaScript script name or url.
             */
            url: string;

            /**
             * JavaScript script line number (0-based).
             */
            lineNumber: integer;

            /**
             * JavaScript script column number (0-based).
             */
            columnNumber: integer;
        }

        /**
         * Call frames for assertions or error messages.
         */
        export interface StackTrace {
            /**
             * String label of this stack trace. For async traces this may be a name of the function that
             * initiated the async call.
             */
            description?: string;

            /**
             * JavaScript function name.
             */
            callFrames: CallFrame[];

            /**
             * Asynchronous JavaScript stack trace that preceded this stack, if available.
             */
            parent?: StackTrace;

            /**
             * Asynchronous JavaScript stack trace that preceded this stack, if available.
             */
            parentId?: StackTraceId;
        }

        /**
         * Unique identifier of current debugger.
         */
        export type UniqueDebuggerId = string;

        /**
         * If `debuggerId` is set stack trace comes from another debugger and can be resolved there. This
         * allows to track cross-debugger calls. See `Runtime.StackTrace` and `Debugger.paused` for usages.
         */
        export interface StackTraceId {
            id: string;

            debuggerId?: UniqueDebuggerId;
        }

        export interface AwaitPromiseRequest {
            /**
             * Identifier of the promise.
             */
            promiseObjectId: RemoteObjectId;

            /**
             * Whether the result is expected to be a JSON object that should be sent by value.
             */
            returnByValue?: boolean;

            /**
             * Whether preview should be generated for the result.
             */
            generatePreview?: boolean;
        }

        export interface AwaitPromiseResponse {
            /**
             * Promise result. Will contain rejected value if promise was rejected.
             */
            result: RemoteObject;

            /**
             * Exception details if stack strace is available.
             */
            exceptionDetails?: ExceptionDetails;
        }

        export interface CallFunctionOnRequest {
            /**
             * Declaration of the function to call.
             */
            functionDeclaration: string;

            /**
             * Identifier of the object to call function on. Either objectId or executionContextId should
             * be specified.
             */
            objectId?: RemoteObjectId;

            /**
             * Call arguments. All call arguments must belong to the same JavaScript world as the target
             * object.
             */
            arguments?: CallArgument[];

            /**
             * In silent mode exceptions thrown during evaluation are not reported and do not pause
             * execution. Overrides `setPauseOnException` state.
             */
            silent?: boolean;

            /**
             * Whether the result is expected to be a JSON object which should be sent by value.
             */
            returnByValue?: boolean;

            /**
             * Whether preview should be generated for the result.
             */
            generatePreview?: boolean;

            /**
             * Whether execution should be treated as initiated by user in the UI.
             */
            userGesture?: boolean;

            /**
             * Whether execution should `await` for resulting value and return once awaited promise is
             * resolved.
             */
            awaitPromise?: boolean;

            /**
             * Specifies execution context which global object will be used to call function on. Either
             * executionContextId or objectId should be specified.
             */
            executionContextId?: ExecutionContextId;

            /**
             * Symbolic group name that can be used to release multiple objects. If objectGroup is not
             * specified and objectId is, objectGroup will be inherited from object.
             */
            objectGroup?: string;
        }

        export interface CallFunctionOnResponse {
            /**
             * Call result.
             */
            result: RemoteObject;

            /**
             * Exception details.
             */
            exceptionDetails?: ExceptionDetails;
        }

        export interface CompileScriptRequest {
            /**
             * Expression to compile.
             */
            expression: string;

            /**
             * Source url to be set for the script.
             */
            sourceURL: string;

            /**
             * Specifies whether the compiled script should be persisted.
             */
            persistScript: boolean;

            /**
             * Specifies in which execution context to perform script run. If the parameter is omitted the
             * evaluation will be performed in the context of the inspected page.
             */
            executionContextId?: ExecutionContextId;
        }

        export interface CompileScriptResponse {
            /**
             * Id of the script.
             */
            scriptId?: ScriptId;

            /**
             * Exception details.
             */
            exceptionDetails?: ExceptionDetails;
        }

        export interface EvaluateRequest {
            /**
             * Expression to evaluate.
             */
            expression: string;

            /**
             * Symbolic group name that can be used to release multiple objects.
             */
            objectGroup?: string;

            /**
             * Determines whether Command Line API should be available during the evaluation.
             */
            includeCommandLineAPI?: boolean;

            /**
             * In silent mode exceptions thrown during evaluation are not reported and do not pause
             * execution. Overrides `setPauseOnException` state.
             */
            silent?: boolean;

            /**
             * Specifies in which execution context to perform evaluation. If the parameter is omitted the
             * evaluation will be performed in the context of the inspected page.
             */
            contextId?: ExecutionContextId;

            /**
             * Whether the result is expected to be a JSON object that should be sent by value.
             */
            returnByValue?: boolean;

            /**
             * Whether preview should be generated for the result.
             */
            generatePreview?: boolean;

            /**
             * Whether execution should be treated as initiated by user in the UI.
             */
            userGesture?: boolean;

            /**
             * Whether execution should `await` for resulting value and return once awaited promise is
             * resolved.
             */
            awaitPromise?: boolean;

            /**
             * Whether to throw an exception if side effect cannot be ruled out during evaluation.
             */
            throwOnSideEffect?: boolean;

            /**
             * Terminate execution after timing out (number of milliseconds).
             */
            timeout?: TimeDelta;
        }

        export interface EvaluateResponse {
            /**
             * Evaluation result.
             */
            result: RemoteObject;

            /**
             * Exception details.
             */
            exceptionDetails?: ExceptionDetails;
        }

        export interface GetIsolateIdResponse {
            /**
             * The isolate id.
             */
            id: string;
        }

        export interface GetHeapUsageResponse {
            /**
             * Used heap size in bytes.
             */
            usedSize: number;

            /**
             * Allocated heap size in bytes.
             */
            totalSize: number;
        }

        export interface GetPropertiesRequest {
            /**
             * Identifier of the object to return properties for.
             */
            objectId: RemoteObjectId;

            /**
             * If true, returns properties belonging only to the element itself, not to its prototype
             * chain.
             */
            ownProperties?: boolean;

            /**
             * If true, returns accessor properties (with getter/setter) only; internal properties are not
             * returned either.
             */
            accessorPropertiesOnly?: boolean;

            /**
             * Whether preview should be generated for the results.
             */
            generatePreview?: boolean;
        }

        export interface GetPropertiesResponse {
            /**
             * Object properties.
             */
            result: PropertyDescriptor[];

            /**
             * Internal object properties (only of the element itself).
             */
            internalProperties?: InternalPropertyDescriptor[];

            /**
             * Exception details.
             */
            exceptionDetails?: ExceptionDetails;
        }

        export interface GlobalLexicalScopeNamesRequest {
            /**
             * Specifies in which execution context to lookup global scope variables.
             */
            executionContextId?: ExecutionContextId;
        }

        export interface GlobalLexicalScopeNamesResponse {
            names: string[];
        }

        export interface QueryObjectsRequest {
            /**
             * Identifier of the prototype to return objects for.
             */
            prototypeObjectId: RemoteObjectId;

            /**
             * Symbolic group name that can be used to release the results.
             */
            objectGroup?: string;
        }

        export interface QueryObjectsResponse {
            /**
             * Array with objects.
             */
            objects: RemoteObject;
        }

        export interface ReleaseObjectRequest {
            /**
             * Identifier of the object to release.
             */
            objectId: RemoteObjectId;
        }

        export interface ReleaseObjectGroupRequest {
            /**
             * Symbolic object group name.
             */
            objectGroup: string;
        }

        export interface RunScriptRequest {
            /**
             * Id of the script to run.
             */
            scriptId: ScriptId;

            /**
             * Specifies in which execution context to perform script run. If the parameter is omitted the
             * evaluation will be performed in the context of the inspected page.
             */
            executionContextId?: ExecutionContextId;

            /**
             * Symbolic group name that can be used to release multiple objects.
             */
            objectGroup?: string;

            /**
             * In silent mode exceptions thrown during evaluation are not reported and do not pause
             * execution. Overrides `setPauseOnException` state.
             */
            silent?: boolean;

            /**
             * Determines whether Command Line API should be available during the evaluation.
             */
            includeCommandLineAPI?: boolean;

            /**
             * Whether the result is expected to be a JSON object which should be sent by value.
             */
            returnByValue?: boolean;

            /**
             * Whether preview should be generated for the result.
             */
            generatePreview?: boolean;

            /**
             * Whether execution should `await` for resulting value and return once awaited promise is
             * resolved.
             */
            awaitPromise?: boolean;
        }

        export interface RunScriptResponse {
            /**
             * Run result.
             */
            result: RemoteObject;

            /**
             * Exception details.
             */
            exceptionDetails?: ExceptionDetails;
        }

        export interface SetAsyncCallStackDepthRequest {
            /**
             * Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async
             * call stacks (default).
             */
            maxDepth: integer;
        }

        export interface SetCustomObjectFormatterEnabledRequest {
            enabled: boolean;
        }

        export interface SetMaxCallStackSizeToCaptureRequest {
            size: integer;
        }

        export interface AddBindingRequest {
            name: string;

            executionContextId?: ExecutionContextId;
        }

        export interface RemoveBindingRequest {
            name: string;
        }

        export interface BindingCalledEvent {
            name: string;

            payload: string;

            /**
             * Identifier of the context where the call was made.
             */
            executionContextId: ExecutionContextId;
        }

        export interface ConsoleAPICalledEvent {
            /**
             * Type of the call.
             */
            type: ('log' | 'debug' | 'info' | 'error' | 'warning' | 'dir' | 'dirxml' | 'table' | 'trace' | 'clear' | 'startGroup' | 'startGroupCollapsed' | 'endGroup' | 'assert' | 'profile' | 'profileEnd' | 'count' | 'timeEnd');

            /**
             * Call arguments.
             */
            args: RemoteObject[];

            /**
             * Identifier of the context where the call was made.
             */
            executionContextId: ExecutionContextId;

            /**
             * Call timestamp.
             */
            timestamp: Timestamp;

            /**
             * Stack trace captured when the call was made.
             */
            stackTrace?: StackTrace;

            /**
             * Console context descriptor for calls on non-default console context (not console.*):
             * 'anonymous#unique-logger-id' for call on unnamed context, 'name#unique-logger-id' for call
             * on named context.
             */
            context?: string;
        }

        export interface ExceptionRevokedEvent {
            /**
             * Reason describing why exception was revoked.
             */
            reason: string;

            /**
             * The id of revoked exception, as reported in `exceptionThrown`.
             */
            exceptionId: integer;
        }

        export interface ExceptionThrownEvent {
            /**
             * Timestamp of the exception.
             */
            timestamp: Timestamp;

            exceptionDetails: ExceptionDetails;
        }

        export interface ExecutionContextCreatedEvent {
            /**
             * A newly created execution context.
             */
            context: ExecutionContextDescription;
        }

        export interface ExecutionContextDestroyedEvent {
            /**
             * Id of the destroyed context
             */
            executionContextId: ExecutionContextId;
        }

        export interface InspectRequestedEvent {
            object: RemoteObject;

            hints: any;
        }
    }

    export interface RuntimeApi {
        /**
         * Add handler to promise with given promise object id.
         */
        awaitPromise(params: Runtime.AwaitPromiseRequest): Promise<Runtime.AwaitPromiseResponse>;

        /**
         * Calls function with given declaration on the given object. Object group of the result is
         * inherited from the target object.
         */
        callFunctionOn(params: Runtime.CallFunctionOnRequest): Promise<Runtime.CallFunctionOnResponse>;

        /**
         * Compiles expression.
         */
        compileScript(params: Runtime.CompileScriptRequest): Promise<Runtime.CompileScriptResponse>;

        /**
         * Disables reporting of execution contexts creation.
         */
        disable(): Promise<void>;

        /**
         * Discards collected exceptions and console API calls.
         */
        discardConsoleEntries(): Promise<void>;

        /**
         * Enables reporting of execution contexts creation by means of `executionContextCreated` event.
         * When the reporting gets enabled the event will be sent immediately for each existing execution
         * context.
         */
        enable(): Promise<void>;

        /**
         * Evaluates expression on global object.
         */
        evaluate(params: Runtime.EvaluateRequest): Promise<Runtime.EvaluateResponse>;

        /**
         * Returns the isolate id.
         */
        getIsolateId(): Promise<Runtime.GetIsolateIdResponse>;

        /**
         * Returns the JavaScript heap usage.
         * It is the total usage of the corresponding isolate not scoped to a particular Runtime.
         */
        getHeapUsage(): Promise<Runtime.GetHeapUsageResponse>;

        /**
         * Returns properties of a given object. Object group of the result is inherited from the target
         * object.
         */
        getProperties(params: Runtime.GetPropertiesRequest): Promise<Runtime.GetPropertiesResponse>;

        /**
         * Returns all let, const and class variables from global scope.
         */
        globalLexicalScopeNames(params: Runtime.GlobalLexicalScopeNamesRequest): Promise<Runtime.GlobalLexicalScopeNamesResponse>;

        queryObjects(params: Runtime.QueryObjectsRequest): Promise<Runtime.QueryObjectsResponse>;

        /**
         * Releases remote object with given id.
         */
        releaseObject(params: Runtime.ReleaseObjectRequest): Promise<void>;

        /**
         * Releases all remote objects that belong to a given group.
         */
        releaseObjectGroup(params: Runtime.ReleaseObjectGroupRequest): Promise<void>;

        /**
         * Tells inspected instance to run if it was waiting for debugger to attach.
         */
        runIfWaitingForDebugger(): Promise<void>;

        /**
         * Runs script with given id in a given context.
         */
        runScript(params: Runtime.RunScriptRequest): Promise<Runtime.RunScriptResponse>;

        /**
         * Enables or disables async call stacks tracking.
         */
        setAsyncCallStackDepth(params: Runtime.SetAsyncCallStackDepthRequest): Promise<void>;

        setCustomObjectFormatterEnabled(params: Runtime.SetCustomObjectFormatterEnabledRequest): Promise<void>;

        setMaxCallStackSizeToCapture(params: Runtime.SetMaxCallStackSizeToCaptureRequest): Promise<void>;

        /**
         * Terminate current or next JavaScript execution.
         * Will cancel the termination when the outer-most script execution ends.
         */
        terminateExecution(): Promise<void>;

        /**
         * If executionContextId is empty, adds binding with the given name on the
         * global objects of all inspected contexts, including those created later,
         * bindings survive reloads.
         * If executionContextId is specified, adds binding only on global object of
         * given execution context.
         * Binding function takes exactly one argument, this argument should be string,
         * in case of any other input, function throws an exception.
         * Each binding function call produces Runtime.bindingCalled notification.
         */
        addBinding(params: Runtime.AddBindingRequest): Promise<void>;

        /**
         * This method does not remove binding function from global object but
         * unsubscribes current runtime agent from Runtime.bindingCalled notifications.
         */
        removeBinding(params: Runtime.RemoveBindingRequest): Promise<void>;

        /**
         * Notification is issued every time when binding is called.
         */
        on(event: 'bindingCalled', listener: (params: Runtime.BindingCalledEvent) => void): void;

        /**
         * Issued when console API was called.
         */
        on(event: 'consoleAPICalled', listener: (params: Runtime.ConsoleAPICalledEvent) => void): void;

        /**
         * Issued when unhandled exception was revoked.
         */
        on(event: 'exceptionRevoked', listener: (params: Runtime.ExceptionRevokedEvent) => void): void;

        /**
         * Issued when exception was thrown and unhandled.
         */
        on(event: 'exceptionThrown', listener: (params: Runtime.ExceptionThrownEvent) => void): void;

        /**
         * Issued when new execution context is created.
         */
        on(event: 'executionContextCreated', listener: (params: Runtime.ExecutionContextCreatedEvent) => void): void;

        /**
         * Issued when execution context is destroyed.
         */
        on(event: 'executionContextDestroyed', listener: (params: Runtime.ExecutionContextDestroyedEvent) => void): void;

        /**
         * Issued when all executionContexts were cleared in browser
         */
        on(event: 'executionContextsCleared', listener: () => void): void;

        /**
         * Issued when object should be inspected (for example, as a result of inspect() command line API
         * call).
         */
        on(event: 'inspectRequested', listener: (params: Runtime.InspectRequestedEvent) => void): void;
    }

    /**
     * This domain is deprecated.
     */
    export namespace Schema {

        /**
         * Description of the protocol domain.
         */
        export interface Domain {
            /**
             * Domain name.
             */
            name: string;

            /**
             * Domain version.
             */
            version: string;
        }

        export interface GetDomainsResponse {
            /**
             * List of supported domains.
             */
            domains: Domain[];
        }
    }

    export interface SchemaApi {
        /**
         * Returns supported domains.
         */
        getDomains(): Promise<Schema.GetDomainsResponse>;
    }

    export namespace Accessibility {

        /**
         * Unique accessibility node identifier.
         */
        export type AXNodeId = string;

        /**
         * Enum of possible property types.
         */
        export type AXValueType = ('boolean' | 'tristate' | 'booleanOrUndefined' | 'idref' | 'idrefList' | 'integer' | 'node' | 'nodeList' | 'number' | 'string' | 'computedString' | 'token' | 'tokenList' | 'domRelation' | 'role' | 'internalRole' | 'valueUndefined');

        /**
         * Enum of possible property sources.
         */
        export type AXValueSourceType = ('attribute' | 'implicit' | 'style' | 'contents' | 'placeholder' | 'relatedElement');

        /**
         * Enum of possible native property sources (as a subtype of a particular AXValueSourceType).
         */
        export type AXValueNativeSourceType = ('figcaption' | 'label' | 'labelfor' | 'labelwrapped' | 'legend' | 'tablecaption' | 'title' | 'other');

        /**
         * A single source for a computed AX property.
         */
        export interface AXValueSource {
            /**
             * What type of source this is.
             */
            type: AXValueSourceType;

            /**
             * The value of this property source.
             */
            value?: AXValue;

            /**
             * The name of the relevant attribute, if any.
             */
            attribute?: string;

            /**
             * The value of the relevant attribute, if any.
             */
            attributeValue?: AXValue;

            /**
             * Whether this source is superseded by a higher priority source.
             */
            superseded?: boolean;

            /**
             * The native markup source for this value, e.g. a <label> element.
             */
            nativeSource?: AXValueNativeSourceType;

            /**
             * The value, such as a node or node list, of the native source.
             */
            nativeSourceValue?: AXValue;

            /**
             * Whether the value for this property is invalid.
             */
            invalid?: boolean;

            /**
             * Reason for the value being invalid, if it is.
             */
            invalidReason?: string;
        }

        export interface AXRelatedNode {
            /**
             * The BackendNodeId of the related DOM node.
             */
            backendDOMNodeId: DOM.BackendNodeId;

            /**
             * The IDRef value provided, if any.
             */
            idref?: string;

            /**
             * The text alternative of this node in the current context.
             */
            text?: string;
        }

        export interface AXProperty {
            /**
             * The name of this property.
             */
            name: AXPropertyName;

            /**
             * The value of this property.
             */
            value: AXValue;
        }

        /**
         * A single computed AX property.
         */
        export interface AXValue {
            /**
             * The type of this value.
             */
            type: AXValueType;

            /**
             * The computed value of this property.
             */
            value?: any;

            /**
             * One or more related nodes, if applicable.
             */
            relatedNodes?: AXRelatedNode[];

            /**
             * The sources which contributed to the computation of this property.
             */
            sources?: AXValueSource[];
        }

        /**
         * Values of AXProperty name: from 'busy' to 'roledescription' - states which apply to every AX
         * node, from 'live' to 'root' - attributes which apply to nodes in live regions, from
         * 'autocomplete' to 'valuetext' - attributes which apply to widgets, from 'checked' to 'selected'
         * - states which apply to widgets, from 'activedescendant' to 'owns' - relationships between
         * elements other than parent/child/sibling.
         */
        export type AXPropertyName = ('busy' | 'disabled' | 'hidden' | 'hiddenRoot' | 'invalid' | 'keyshortcuts' | 'roledescription' | 'live' | 'atomic' | 'relevant' | 'root' | 'autocomplete' | 'hasPopup' | 'level' | 'multiselectable' | 'orientation' | 'multiline' | 'readonly' | 'required' | 'valuemin' | 'valuemax' | 'valuetext' | 'checked' | 'expanded' | 'modal' | 'pressed' | 'selected' | 'activedescendant' | 'controls' | 'describedby' | 'details' | 'errormessage' | 'flowto' | 'labelledby' | 'owns');

        /**
         * A node in the accessibility tree.
         */
        export interface AXNode {
            /**
             * Unique identifier for this node.
             */
            nodeId: AXNodeId;

            /**
             * Whether this node is ignored for accessibility
             */
            ignored: boolean;

            /**
             * Collection of reasons why this node is hidden.
             */
            ignoredReasons?: AXProperty[];

            /**
             * This `Node`'s role, whether explicit or implicit.
             */
            role?: AXValue;

            /**
             * The accessible name for this `Node`.
             */
            name?: AXValue;

            /**
             * The accessible description for this `Node`.
             */
            description?: AXValue;

            /**
             * The value for this `Node`.
             */
            value?: AXValue;

            /**
             * All other properties
             */
            properties?: AXProperty[];

            /**
             * IDs for each of this node's child nodes.
             */
            childIds?: AXNodeId[];

            /**
             * The backend ID for the associated DOM node, if any.
             */
            backendDOMNodeId?: DOM.BackendNodeId;
        }

        export interface GetPartialAXTreeRequest {
            /**
             * Identifier of the node to get the partial accessibility tree for.
             */
            nodeId?: DOM.NodeId;

            /**
             * Identifier of the backend node to get the partial accessibility tree for.
             */
            backendNodeId?: DOM.BackendNodeId;

            /**
             * JavaScript object id of the node wrapper to get the partial accessibility tree for.
             */
            objectId?: Runtime.RemoteObjectId;

            /**
             * Whether to fetch this nodes ancestors, siblings and children. Defaults to true.
             */
            fetchRelatives?: boolean;
        }

        export interface GetPartialAXTreeResponse {
            /**
             * The `Accessibility.AXNode` for this DOM node, if it exists, plus its ancestors, siblings and
             * children, if requested.
             */
            nodes: AXNode[];
        }
    }

    export interface AccessibilityApi {
        /**
         * Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.
         */
        getPartialAXTree(params: Accessibility.GetPartialAXTreeRequest): Promise<Accessibility.GetPartialAXTreeResponse>;
    }

    export namespace Animation {

        /**
         * Animation instance.
         */
        export interface Animation {
            /**
             * `Animation`'s id.
             */
            id: string;

            /**
             * `Animation`'s name.
             */
            name: string;

            /**
             * `Animation`'s internal paused state.
             */
            pausedState: boolean;

            /**
             * `Animation`'s play state.
             */
            playState: string;

            /**
             * `Animation`'s playback rate.
             */
            playbackRate: number;

            /**
             * `Animation`'s start time.
             */
            startTime: number;

            /**
             * `Animation`'s current time.
             */
            currentTime: number;

            /**
             * Animation type of `Animation`.
             */
            type: ('CSSTransition' | 'CSSAnimation' | 'WebAnimation');

            /**
             * `Animation`'s source animation node.
             */
            source?: AnimationEffect;

            /**
             * A unique ID for `Animation` representing the sources that triggered this CSS
             * animation/transition.
             */
            cssId?: string;
        }

        /**
         * AnimationEffect instance
         */
        export interface AnimationEffect {
            /**
             * `AnimationEffect`'s delay.
             */
            delay: number;

            /**
             * `AnimationEffect`'s end delay.
             */
            endDelay: number;

            /**
             * `AnimationEffect`'s iteration start.
             */
            iterationStart: number;

            /**
             * `AnimationEffect`'s iterations.
             */
            iterations: number;

            /**
             * `AnimationEffect`'s iteration duration.
             */
            duration: number;

            /**
             * `AnimationEffect`'s playback direction.
             */
            direction: string;

            /**
             * `AnimationEffect`'s fill mode.
             */
            fill: string;

            /**
             * `AnimationEffect`'s target node.
             */
            backendNodeId?: DOM.BackendNodeId;

            /**
             * `AnimationEffect`'s keyframes.
             */
            keyframesRule?: KeyframesRule;

            /**
             * `AnimationEffect`'s timing function.
             */
            easing: string;
        }

        /**
         * Keyframes Rule
         */
        export interface KeyframesRule {
            /**
             * CSS keyframed animation's name.
             */
            name?: string;

            /**
             * List of animation keyframes.
             */
            keyframes: KeyframeStyle[];
        }

        /**
         * Keyframe Style
         */
        export interface KeyframeStyle {
            /**
             * Keyframe's time offset.
             */
            offset: string;

            /**
             * `AnimationEffect`'s timing function.
             */
            easing: string;
        }

        export interface GetCurrentTimeRequest {
            /**
             * Id of animation.
             */
            id: string;
        }

        export interface GetCurrentTimeResponse {
            /**
             * Current time of the page.
             */
            currentTime: number;
        }

        export interface GetPlaybackRateResponse {
            /**
             * Playback rate for animations on page.
             */
            playbackRate: number;
        }

        export interface ReleaseAnimationsRequest {
            /**
             * List of animation ids to seek.
             */
            animations: string[];
        }

        export interface ResolveAnimationRequest {
            /**
             * Animation id.
             */
            animationId: string;
        }

        export interface ResolveAnimationResponse {
            /**
             * Corresponding remote object.
             */
            remoteObject: Runtime.RemoteObject;
        }

        export interface SeekAnimationsRequest {
            /**
             * List of animation ids to seek.
             */
            animations: string[];

            /**
             * Set the current time of each animation.
             */
            currentTime: number;
        }

        export interface SetPausedRequest {
            /**
             * Animations to set the pause state of.
             */
            animations: string[];

            /**
             * Paused state to set to.
             */
            paused: boolean;
        }

        export interface SetPlaybackRateRequest {
            /**
             * Playback rate for animations on page
             */
            playbackRate: number;
        }

        export interface SetTimingRequest {
            /**
             * Animation id.
             */
            animationId: string;

            /**
             * Duration of the animation.
             */
            duration: number;

            /**
             * Delay of the animation.
             */
            delay: number;
        }

        export interface AnimationCanceledEvent {
            /**
             * Id of the animation that was cancelled.
             */
            id: string;
        }

        export interface AnimationCreatedEvent {
            /**
             * Id of the animation that was created.
             */
            id: string;
        }

        export interface AnimationStartedEvent {
            /**
             * Animation that was started.
             */
            animation: Animation;
        }
    }

    export interface AnimationApi {
        /**
         * Disables animation domain notifications.
         */
        disable(): Promise<void>;

        /**
         * Enables animation domain notifications.
         */
        enable(): Promise<void>;

        /**
         * Returns the current time of the an animation.
         */
        getCurrentTime(params: Animation.GetCurrentTimeRequest): Promise<Animation.GetCurrentTimeResponse>;

        /**
         * Gets the playback rate of the document timeline.
         */
        getPlaybackRate(): Promise<Animation.GetPlaybackRateResponse>;

        /**
         * Releases a set of animations to no longer be manipulated.
         */
        releaseAnimations(params: Animation.ReleaseAnimationsRequest): Promise<void>;

        /**
         * Gets the remote object of the Animation.
         */
        resolveAnimation(params: Animation.ResolveAnimationRequest): Promise<Animation.ResolveAnimationResponse>;

        /**
         * Seek a set of animations to a particular time within each animation.
         */
        seekAnimations(params: Animation.SeekAnimationsRequest): Promise<void>;

        /**
         * Sets the paused state of a set of animations.
         */
        setPaused(params: Animation.SetPausedRequest): Promise<void>;

        /**
         * Sets the playback rate of the document timeline.
         */
        setPlaybackRate(params: Animation.SetPlaybackRateRequest): Promise<void>;

        /**
         * Sets the timing of an animation node.
         */
        setTiming(params: Animation.SetTimingRequest): Promise<void>;

        /**
         * Event for when an animation has been cancelled.
         */
        on(event: 'animationCanceled', listener: (params: Animation.AnimationCanceledEvent) => void): void;

        /**
         * Event for each animation that has been created.
         */
        on(event: 'animationCreated', listener: (params: Animation.AnimationCreatedEvent) => void): void;

        /**
         * Event for animation that has been started.
         */
        on(event: 'animationStarted', listener: (params: Animation.AnimationStartedEvent) => void): void;
    }

    export namespace ApplicationCache {

        /**
         * Detailed application cache resource information.
         */
        export interface ApplicationCacheResource {
            /**
             * Resource url.
             */
            url: string;

            /**
             * Resource size.
             */
            size: integer;

            /**
             * Resource type.
             */
            type: string;
        }

        /**
         * Detailed application cache information.
         */
        export interface ApplicationCache {
            /**
             * Manifest URL.
             */
            manifestURL: string;

            /**
             * Application cache size.
             */
            size: number;

            /**
             * Application cache creation time.
             */
            creationTime: number;

            /**
             * Application cache update time.
             */
            updateTime: number;

            /**
             * Application cache resources.
             */
            resources: ApplicationCacheResource[];
        }

        /**
         * Frame identifier - manifest URL pair.
         */
        export interface FrameWithManifest {
            /**
             * Frame identifier.
             */
            frameId: Page.FrameId;

            /**
             * Manifest URL.
             */
            manifestURL: string;

            /**
             * Application cache status.
             */
            status: integer;
        }

        export interface GetApplicationCacheForFrameRequest {
            /**
             * Identifier of the frame containing document whose application cache is retrieved.
             */
            frameId: Page.FrameId;
        }

        export interface GetApplicationCacheForFrameResponse {
            /**
             * Relevant application cache data for the document in given frame.
             */
            applicationCache: ApplicationCache;
        }

        export interface GetFramesWithManifestsResponse {
            /**
             * Array of frame identifiers with manifest urls for each frame containing a document
             * associated with some application cache.
             */
            frameIds: FrameWithManifest[];
        }

        export interface GetManifestForFrameRequest {
            /**
             * Identifier of the frame containing document whose manifest is retrieved.
             */
            frameId: Page.FrameId;
        }

        export interface GetManifestForFrameResponse {
            /**
             * Manifest URL for document in the given frame.
             */
            manifestURL: string;
        }

        export interface ApplicationCacheStatusUpdatedEvent {
            /**
             * Identifier of the frame containing document whose application cache updated status.
             */
            frameId: Page.FrameId;

            /**
             * Manifest URL.
             */
            manifestURL: string;

            /**
             * Updated application cache status.
             */
            status: integer;
        }

        export interface NetworkStateUpdatedEvent {
            isNowOnline: boolean;
        }
    }

    export interface ApplicationCacheApi {
        /**
         * Enables application cache domain notifications.
         */
        enable(): Promise<void>;

        /**
         * Returns relevant application cache data for the document in given frame.
         */
        getApplicationCacheForFrame(params: ApplicationCache.GetApplicationCacheForFrameRequest): Promise<ApplicationCache.GetApplicationCacheForFrameResponse>;

        /**
         * Returns array of frame identifiers with manifest urls for each frame containing a document
         * associated with some application cache.
         */
        getFramesWithManifests(): Promise<ApplicationCache.GetFramesWithManifestsResponse>;

        /**
         * Returns manifest URL for document in the given frame.
         */
        getManifestForFrame(params: ApplicationCache.GetManifestForFrameRequest): Promise<ApplicationCache.GetManifestForFrameResponse>;

        on(event: 'applicationCacheStatusUpdated', listener: (params: ApplicationCache.ApplicationCacheStatusUpdatedEvent) => void): void;

        on(event: 'networkStateUpdated', listener: (params: ApplicationCache.NetworkStateUpdatedEvent) => void): void;
    }

    /**
     * Audits domain allows investigation of page violations and possible improvements.
     */
    export namespace Audits {

        export interface GetEncodedResponseRequest {
            /**
             * Identifier of the network request to get content for.
             */
            requestId: Network.RequestId;

            /**
             * The encoding to use.
             */
            encoding: ('webp' | 'jpeg' | 'png');

            /**
             * The quality of the encoding (0-1). (defaults to 1)
             */
            quality?: number;

            /**
             * Whether to only return the size information (defaults to false).
             */
            sizeOnly?: boolean;
        }

        export interface GetEncodedResponseResponse {
            /**
             * The encoded body as a base64 string. Omitted if sizeOnly is true.
             */
            body?: string;

            /**
             * Size before re-encoding.
             */
            originalSize: integer;

            /**
             * Size after re-encoding.
             */
            encodedSize: integer;
        }
    }

    export interface AuditsApi {
        /**
         * Returns the response body and size if it were re-encoded with the specified settings. Only
         * applies to images.
         */
        getEncodedResponse(params: Audits.GetEncodedResponseRequest): Promise<Audits.GetEncodedResponseResponse>;
    }

    /**
     * The Browser domain defines methods and events for browser managing.
     */
    export namespace Browser {

        export type WindowID = integer;

        /**
         * The state of the browser window.
         */
        export type WindowState = ('normal' | 'minimized' | 'maximized' | 'fullscreen');

        /**
         * Browser window bounds information
         */
        export interface Bounds {
            /**
             * The offset from the left edge of the screen to the window in pixels.
             */
            left?: integer;

            /**
             * The offset from the top edge of the screen to the window in pixels.
             */
            top?: integer;

            /**
             * The window width in pixels.
             */
            width?: integer;

            /**
             * The window height in pixels.
             */
            height?: integer;

            /**
             * The window state. Default to normal.
             */
            windowState?: WindowState;
        }

        export type PermissionType = ('accessibilityEvents' | 'audioCapture' | 'backgroundSync' | 'clipboardRead' | 'clipboardWrite' | 'durableStorage' | 'flash' | 'geolocation' | 'midi' | 'midiSysex' | 'notifications' | 'paymentHandler' | 'protectedMediaIdentifier' | 'sensors' | 'videoCapture');

        /**
         * Chrome histogram bucket.
         */
        export interface Bucket {
            /**
             * Minimum value (inclusive).
             */
            low: integer;

            /**
             * Maximum value (exclusive).
             */
            high: integer;

            /**
             * Number of samples.
             */
            count: integer;
        }

        /**
         * Chrome histogram.
         */
        export interface Histogram {
            /**
             * Name.
             */
            name: string;

            /**
             * Sum of sample values.
             */
            sum: integer;

            /**
             * Total number of samples.
             */
            count: integer;

            /**
             * Buckets.
             */
            buckets: Bucket[];
        }

        export interface GrantPermissionsRequest {
            origin: string;

            permissions: PermissionType[];

            /**
             * BrowserContext to override permissions. When omitted, default browser context is used.
             */
            browserContextId?: Target.BrowserContextID;
        }

        export interface ResetPermissionsRequest {
            /**
             * BrowserContext to reset permissions. When omitted, default browser context is used.
             */
            browserContextId?: Target.BrowserContextID;
        }

        export interface GetVersionResponse {
            /**
             * Protocol version.
             */
            protocolVersion: string;

            /**
             * Product name.
             */
            product: string;

            /**
             * Product revision.
             */
            revision: string;

            /**
             * User-Agent.
             */
            userAgent: string;

            /**
             * V8 version.
             */
            jsVersion: string;
        }

        export interface GetBrowserCommandLineResponse {
            /**
             * Commandline parameters
             */
            arguments: string[];
        }

        export interface GetHistogramsRequest {
            /**
             * Requested substring in name. Only histograms which have query as a
             * substring in their name are extracted. An empty or absent query returns
             * all histograms.
             */
            query?: string;

            /**
             * If true, retrieve delta since last call.
             */
            delta?: boolean;
        }

        export interface GetHistogramsResponse {
            /**
             * Histograms.
             */
            histograms: Histogram[];
        }

        export interface GetHistogramRequest {
            /**
             * Requested histogram name.
             */
            name: string;

            /**
             * If true, retrieve delta since last call.
             */
            delta?: boolean;
        }

        export interface GetHistogramResponse {
            /**
             * Histogram.
             */
            histogram: Histogram;
        }

        export interface GetWindowBoundsRequest {
            /**
             * Browser window id.
             */
            windowId: WindowID;
        }

        export interface GetWindowBoundsResponse {
            /**
             * Bounds information of the window. When window state is 'minimized', the restored window
             * position and size are returned.
             */
            bounds: Bounds;
        }

        export interface GetWindowForTargetRequest {
            /**
             * Devtools agent host id.
             */
            targetId: Target.TargetID;
        }

        export interface GetWindowForTargetResponse {
            /**
             * Browser window id.
             */
            windowId: WindowID;

            /**
             * Bounds information of the window. When window state is 'minimized', the restored window
             * position and size are returned.
             */
            bounds: Bounds;
        }

        export interface SetWindowBoundsRequest {
            /**
             * Browser window id.
             */
            windowId: WindowID;

            /**
             * New window bounds. The 'minimized', 'maximized' and 'fullscreen' states cannot be combined
             * with 'left', 'top', 'width' or 'height'. Leaves unspecified fields unchanged.
             */
            bounds: Bounds;
        }
    }

    export interface BrowserApi {
        /**
         * Grant specific permissions to the given origin and reject all others.
         */
        grantPermissions(params: Browser.GrantPermissionsRequest): Promise<void>;

        /**
         * Reset all permission management for all origins.
         */
        resetPermissions(params: Browser.ResetPermissionsRequest): Promise<void>;

        /**
         * Close browser gracefully.
         */
        close(): Promise<void>;

        /**
         * Returns version information.
         */
        getVersion(): Promise<Browser.GetVersionResponse>;

        /**
         * Returns the command line switches for the browser process if, and only if
         * --enable-automation is on the commandline.
         */
        getBrowserCommandLine(): Promise<Browser.GetBrowserCommandLineResponse>;

        /**
         * Get Chrome histograms.
         */
        getHistograms(params: Browser.GetHistogramsRequest): Promise<Browser.GetHistogramsResponse>;

        /**
         * Get a Chrome histogram by name.
         */
        getHistogram(params: Browser.GetHistogramRequest): Promise<Browser.GetHistogramResponse>;

        /**
         * Get position and size of the browser window.
         */
        getWindowBounds(params: Browser.GetWindowBoundsRequest): Promise<Browser.GetWindowBoundsResponse>;

        /**
         * Get the browser window that contains the devtools target.
         */
        getWindowForTarget(params: Browser.GetWindowForTargetRequest): Promise<Browser.GetWindowForTargetResponse>;

        /**
         * Set position and/or size of the browser window.
         */
        setWindowBounds(params: Browser.SetWindowBoundsRequest): Promise<void>;
    }

    /**
     * This domain exposes CSS read/write operations. All CSS objects (stylesheets, rules, and styles)
     * have an associated `id` used in subsequent operations on the related object. Each object type has
     * a specific `id` structure, and those are not interchangeable between objects of different kinds.
     * CSS objects can be loaded using the `get*ForNode()` calls (which accept a DOM node id). A client
     * can also keep track of stylesheets via the `styleSheetAdded`/`styleSheetRemoved` events and
     * subsequently load the required stylesheet contents using the `getStyleSheet[Text]()` methods.
     */
    export namespace CSS {

        export type StyleSheetId = string;

        /**
         * Stylesheet type: "injected" for stylesheets injected via extension, "user-agent" for user-agent
         * stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via
         * inspector" rules), "regular" for regular stylesheets.
         */
        export type StyleSheetOrigin = ('injected' | 'user-agent' | 'inspector' | 'regular');

        /**
         * CSS rule collection for a single pseudo style.
         */
        export interface PseudoElementMatches {
            /**
             * Pseudo element type.
             */
            pseudoType: DOM.PseudoType;

            /**
             * Matches of CSS rules applicable to the pseudo style.
             */
            matches: RuleMatch[];
        }

        /**
         * Inherited CSS rule collection from ancestor node.
         */
        export interface InheritedStyleEntry {
            /**
             * The ancestor node's inline style, if any, in the style inheritance chain.
             */
            inlineStyle?: CSSStyle;

            /**
             * Matches of CSS rules matching the ancestor node in the style inheritance chain.
             */
            matchedCSSRules: RuleMatch[];
        }

        /**
         * Match data for a CSS rule.
         */
        export interface RuleMatch {
            /**
             * CSS rule in the match.
             */
            rule: CSSRule;

            /**
             * Matching selector indices in the rule's selectorList selectors (0-based).
             */
            matchingSelectors: integer[];
        }

        /**
         * Data for a simple selector (these are delimited by commas in a selector list).
         */
        export interface Value {
            /**
             * Value text.
             */
            text: string;

            /**
             * Value range in the underlying resource (if available).
             */
            range?: SourceRange;
        }

        /**
         * Selector list data.
         */
        export interface SelectorList {
            /**
             * Selectors in the list.
             */
            selectors: Value[];

            /**
             * Rule selector text.
             */
            text: string;
        }

        /**
         * CSS stylesheet metainformation.
         */
        export interface CSSStyleSheetHeader {
            /**
             * The stylesheet identifier.
             */
            styleSheetId: StyleSheetId;

            /**
             * Owner frame identifier.
             */
            frameId: Page.FrameId;

            /**
             * Stylesheet resource URL.
             */
            sourceURL: string;

            /**
             * URL of source map associated with the stylesheet (if any).
             */
            sourceMapURL?: string;

            /**
             * Stylesheet origin.
             */
            origin: StyleSheetOrigin;

            /**
             * Stylesheet title.
             */
            title: string;

            /**
             * The backend id for the owner node of the stylesheet.
             */
            ownerNode?: DOM.BackendNodeId;

            /**
             * Denotes whether the stylesheet is disabled.
             */
            disabled: boolean;

            /**
             * Whether the sourceURL field value comes from the sourceURL comment.
             */
            hasSourceURL?: boolean;

            /**
             * Whether this stylesheet is created for STYLE tag by parser. This flag is not set for
             * document.written STYLE tags.
             */
            isInline: boolean;

            /**
             * Line offset of the stylesheet within the resource (zero based).
             */
            startLine: number;

            /**
             * Column offset of the stylesheet within the resource (zero based).
             */
            startColumn: number;

            /**
             * Size of the content (in characters).
             */
            length: number;
        }

        /**
         * CSS rule representation.
         */
        export interface CSSRule {
            /**
             * The css style sheet identifier (absent for user agent stylesheet and user-specified
             * stylesheet rules) this rule came from.
             */
            styleSheetId?: StyleSheetId;

            /**
             * Rule selector data.
             */
            selectorList: SelectorList;

            /**
             * Parent stylesheet's origin.
             */
            origin: StyleSheetOrigin;

            /**
             * Associated style declaration.
             */
            style: CSSStyle;

            /**
             * Media list array (for rules involving media queries). The array enumerates media queries
             * starting with the innermost one, going outwards.
             */
            media?: CSSMedia[];
        }

        /**
         * CSS coverage information.
         */
        export interface RuleUsage {
            /**
             * The css style sheet identifier (absent for user agent stylesheet and user-specified
             * stylesheet rules) this rule came from.
             */
            styleSheetId: StyleSheetId;

            /**
             * Offset of the start of the rule (including selector) from the beginning of the stylesheet.
             */
            startOffset: number;

            /**
             * Offset of the end of the rule body from the beginning of the stylesheet.
             */
            endOffset: number;

            /**
             * Indicates whether the rule was actually used by some element in the page.
             */
            used: boolean;
        }

        /**
         * Text range within a resource. All numbers are zero-based.
         */
        export interface SourceRange {
            /**
             * Start line of range.
             */
            startLine: integer;

            /**
             * Start column of range (inclusive).
             */
            startColumn: integer;

            /**
             * End line of range
             */
            endLine: integer;

            /**
             * End column of range (exclusive).
             */
            endColumn: integer;
        }

        export interface ShorthandEntry {
            /**
             * Shorthand name.
             */
            name: string;

            /**
             * Shorthand value.
             */
            value: string;

            /**
             * Whether the property has "!important" annotation (implies `false` if absent).
             */
            important?: boolean;
        }

        export interface CSSComputedStyleProperty {
            /**
             * Computed style property name.
             */
            name: string;

            /**
             * Computed style property value.
             */
            value: string;
        }

        /**
         * CSS style representation.
         */
        export interface CSSStyle {
            /**
             * The css style sheet identifier (absent for user agent stylesheet and user-specified
             * stylesheet rules) this rule came from.
             */
            styleSheetId?: StyleSheetId;

            /**
             * CSS properties in the style.
             */
            cssProperties: CSSProperty[];

            /**
             * Computed values for all shorthands found in the style.
             */
            shorthandEntries: ShorthandEntry[];

            /**
             * Style declaration text (if available).
             */
            cssText?: string;

            /**
             * Style declaration range in the enclosing stylesheet (if available).
             */
            range?: SourceRange;
        }

        /**
         * CSS property declaration data.
         */
        export interface CSSProperty {
            /**
             * The property name.
             */
            name: string;

            /**
             * The property value.
             */
            value: string;

            /**
             * Whether the property has "!important" annotation (implies `false` if absent).
             */
            important?: boolean;

            /**
             * Whether the property is implicit (implies `false` if absent).
             */
            implicit?: boolean;

            /**
             * The full property text as specified in the style.
             */
            text?: string;

            /**
             * Whether the property is understood by the browser (implies `true` if absent).
             */
            parsedOk?: boolean;

            /**
             * Whether the property is disabled by the user (present for source-based properties only).
             */
            disabled?: boolean;

            /**
             * The entire property range in the enclosing style declaration (if available).
             */
            range?: SourceRange;
        }

        /**
         * CSS media rule descriptor.
         */
        export interface CSSMedia {
            /**
             * Media query text.
             */
            text: string;

            /**
             * Source of the media query: "mediaRule" if specified by a @media rule, "importRule" if
             * specified by an @import rule, "linkedSheet" if specified by a "media" attribute in a linked
             * stylesheet's LINK tag, "inlineSheet" if specified by a "media" attribute in an inline
             * stylesheet's STYLE tag.
             */
            source: ('mediaRule' | 'importRule' | 'linkedSheet' | 'inlineSheet');

            /**
             * URL of the document containing the media query description.
             */
            sourceURL?: string;

            /**
             * The associated rule (@media or @import) header range in the enclosing stylesheet (if
             * available).
             */
            range?: SourceRange;

            /**
             * Identifier of the stylesheet containing this object (if exists).
             */
            styleSheetId?: StyleSheetId;

            /**
             * Array of media queries.
             */
            mediaList?: MediaQuery[];
        }

        /**
         * Media query descriptor.
         */
        export interface MediaQuery {
            /**
             * Array of media query expressions.
             */
            expressions: MediaQueryExpression[];

            /**
             * Whether the media query condition is satisfied.
             */
            active: boolean;
        }

        /**
         * Media query expression descriptor.
         */
        export interface MediaQueryExpression {
            /**
             * Media query expression value.
             */
            value: number;

            /**
             * Media query expression units.
             */
            unit: string;

            /**
             * Media query expression feature.
             */
            feature: string;

            /**
             * The associated range of the value text in the enclosing stylesheet (if available).
             */
            valueRange?: SourceRange;

            /**
             * Computed length of media query expression (if applicable).
             */
            computedLength?: number;
        }

        /**
         * Information about amount of glyphs that were rendered with given font.
         */
        export interface PlatformFontUsage {
            /**
             * Font's family name reported by platform.
             */
            familyName: string;

            /**
             * Indicates if the font was downloaded or resolved locally.
             */
            isCustomFont: boolean;

            /**
             * Amount of glyphs that were rendered with this font.
             */
            glyphCount: number;
        }

        /**
         * Properties of a web font: https://www.w3.org/TR/2008/REC-CSS2-20080411/fonts.html#font-descriptions
         */
        export interface FontFace {
            /**
             * The font-family.
             */
            fontFamily: string;

            /**
             * The font-style.
             */
            fontStyle: string;

            /**
             * The font-variant.
             */
            fontVariant: string;

            /**
             * The font-weight.
             */
            fontWeight: string;

            /**
             * The font-stretch.
             */
            fontStretch: string;

            /**
             * The unicode-range.
             */
            unicodeRange: string;

            /**
             * The src.
             */
            src: string;

            /**
             * The resolved platform font family
             */
            platformFontFamily: string;
        }

        /**
         * CSS keyframes rule representation.
         */
        export interface CSSKeyframesRule {
            /**
             * Animation name.
             */
            animationName: Value;

            /**
             * List of keyframes.
             */
            keyframes: CSSKeyframeRule[];
        }

        /**
         * CSS keyframe rule representation.
         */
        export interface CSSKeyframeRule {
            /**
             * The css style sheet identifier (absent for user agent stylesheet and user-specified
             * stylesheet rules) this rule came from.
             */
            styleSheetId?: StyleSheetId;

            /**
             * Parent stylesheet's origin.
             */
            origin: StyleSheetOrigin;

            /**
             * Associated key text.
             */
            keyText: Value;

            /**
             * Associated style declaration.
             */
            style: CSSStyle;
        }

        /**
         * A descriptor of operation to mutate style declaration text.
         */
        export interface StyleDeclarationEdit {
            /**
             * The css style sheet identifier.
             */
            styleSheetId: StyleSheetId;

            /**
             * The range of the style text in the enclosing stylesheet.
             */
            range: SourceRange;

            /**
             * New style text.
             */
            text: string;
        }

        export interface AddRuleRequest {
            /**
             * The css style sheet identifier where a new rule should be inserted.
             */
            styleSheetId: StyleSheetId;

            /**
             * The text of a new rule.
             */
            ruleText: string;

            /**
             * Text position of a new rule in the target style sheet.
             */
            location: SourceRange;
        }

        export interface AddRuleResponse {
            /**
             * The newly created rule.
             */
            rule: CSSRule;
        }

        export interface CollectClassNamesRequest {
            styleSheetId: StyleSheetId;
        }

        export interface CollectClassNamesResponse {
            /**
             * Class name list.
             */
            classNames: string[];
        }

        export interface CreateStyleSheetRequest {
            /**
             * Identifier of the frame where "via-inspector" stylesheet should be created.
             */
            frameId: Page.FrameId;
        }

        export interface CreateStyleSheetResponse {
            /**
             * Identifier of the created "via-inspector" stylesheet.
             */
            styleSheetId: StyleSheetId;
        }

        export interface ForcePseudoStateRequest {
            /**
             * The element id for which to force the pseudo state.
             */
            nodeId: DOM.NodeId;

            /**
             * Element pseudo classes to force when computing the element's style.
             */
            forcedPseudoClasses: string[];
        }

        export interface GetBackgroundColorsRequest {
            /**
             * Id of the node to get background colors for.
             */
            nodeId: DOM.NodeId;
        }

        export interface GetBackgroundColorsResponse {
            /**
             * The range of background colors behind this element, if it contains any visible text. If no
             * visible text is present, this will be undefined. In the case of a flat background color,
             * this will consist of simply that color. In the case of a gradient, this will consist of each
             * of the color stops. For anything more complicated, this will be an empty array. Images will
             * be ignored (as if the image had failed to load).
             */
            backgroundColors?: string[];

            /**
             * The computed font size for this node, as a CSS computed value string (e.g. '12px').
             */
            computedFontSize?: string;

            /**
             * The computed font weight for this node, as a CSS computed value string (e.g. 'normal' or
             * '100').
             */
            computedFontWeight?: string;

            /**
             * The computed font size for the document body, as a computed CSS value string (e.g. '16px').
             */
            computedBodyFontSize?: string;
        }

        export interface GetComputedStyleForNodeRequest {
            nodeId: DOM.NodeId;
        }

        export interface GetComputedStyleForNodeResponse {
            /**
             * Computed style for the specified DOM node.
             */
            computedStyle: CSSComputedStyleProperty[];
        }

        export interface GetInlineStylesForNodeRequest {
            nodeId: DOM.NodeId;
        }

        export interface GetInlineStylesForNodeResponse {
            /**
             * Inline style for the specified DOM node.
             */
            inlineStyle?: CSSStyle;

            /**
             * Attribute-defined element style (e.g. resulting from "width=20 height=100%").
             */
            attributesStyle?: CSSStyle;
        }

        export interface GetMatchedStylesForNodeRequest {
            nodeId: DOM.NodeId;
        }

        export interface GetMatchedStylesForNodeResponse {
            /**
             * Inline style for the specified DOM node.
             */
            inlineStyle?: CSSStyle;

            /**
             * Attribute-defined element style (e.g. resulting from "width=20 height=100%").
             */
            attributesStyle?: CSSStyle;

            /**
             * CSS rules matching this node, from all applicable stylesheets.
             */
            matchedCSSRules?: RuleMatch[];

            /**
             * Pseudo style matches for this node.
             */
            pseudoElements?: PseudoElementMatches[];

            /**
             * A chain of inherited styles (from the immediate node parent up to the DOM tree root).
             */
            inherited?: InheritedStyleEntry[];

            /**
             * A list of CSS keyframed animations matching this node.
             */
            cssKeyframesRules?: CSSKeyframesRule[];
        }

        export interface GetMediaQueriesResponse {
            medias: CSSMedia[];
        }

        export interface GetPlatformFontsForNodeRequest {
            nodeId: DOM.NodeId;
        }

        export interface GetPlatformFontsForNodeResponse {
            /**
             * Usage statistics for every employed platform font.
             */
            fonts: PlatformFontUsage[];
        }

        export interface GetStyleSheetTextRequest {
            styleSheetId: StyleSheetId;
        }

        export interface GetStyleSheetTextResponse {
            /**
             * The stylesheet text.
             */
            text: string;
        }

        export interface SetEffectivePropertyValueForNodeRequest {
            /**
             * The element id for which to set property.
             */
            nodeId: DOM.NodeId;

            propertyName: string;

            value: string;
        }

        export interface SetKeyframeKeyRequest {
            styleSheetId: StyleSheetId;

            range: SourceRange;

            keyText: string;
        }

        export interface SetKeyframeKeyResponse {
            /**
             * The resulting key text after modification.
             */
            keyText: Value;
        }

        export interface SetMediaTextRequest {
            styleSheetId: StyleSheetId;

            range: SourceRange;

            text: string;
        }

        export interface SetMediaTextResponse {
            /**
             * The resulting CSS media rule after modification.
             */
            media: CSSMedia;
        }

        export interface SetRuleSelectorRequest {
            styleSheetId: StyleSheetId;

            range: SourceRange;

            selector: string;
        }

        export interface SetRuleSelectorResponse {
            /**
             * The resulting selector list after modification.
             */
            selectorList: SelectorList;
        }

        export interface SetStyleSheetTextRequest {
            styleSheetId: StyleSheetId;

            text: string;
        }

        export interface SetStyleSheetTextResponse {
            /**
             * URL of source map associated with script (if any).
             */
            sourceMapURL?: string;
        }

        export interface SetStyleTextsRequest {
            edits: StyleDeclarationEdit[];
        }

        export interface SetStyleTextsResponse {
            /**
             * The resulting styles after modification.
             */
            styles: CSSStyle[];
        }

        export interface StopRuleUsageTrackingResponse {
            ruleUsage: RuleUsage[];
        }

        export interface TakeCoverageDeltaResponse {
            coverage: RuleUsage[];
        }

        export interface FontsUpdatedEvent {
            /**
             * The web font that has loaded.
             */
            font?: FontFace;
        }

        export interface StyleSheetAddedEvent {
            /**
             * Added stylesheet metainfo.
             */
            header: CSSStyleSheetHeader;
        }

        export interface StyleSheetChangedEvent {
            styleSheetId: StyleSheetId;
        }

        export interface StyleSheetRemovedEvent {
            /**
             * Identifier of the removed stylesheet.
             */
            styleSheetId: StyleSheetId;
        }
    }

    export interface CSSApi {
        /**
         * Inserts a new rule with the given `ruleText` in a stylesheet with given `styleSheetId`, at the
         * position specified by `location`.
         */
        addRule(params: CSS.AddRuleRequest): Promise<CSS.AddRuleResponse>;

        /**
         * Returns all class names from specified stylesheet.
         */
        collectClassNames(params: CSS.CollectClassNamesRequest): Promise<CSS.CollectClassNamesResponse>;

        /**
         * Creates a new special "via-inspector" stylesheet in the frame with given `frameId`.
         */
        createStyleSheet(params: CSS.CreateStyleSheetRequest): Promise<CSS.CreateStyleSheetResponse>;

        /**
         * Disables the CSS agent for the given page.
         */
        disable(): Promise<void>;

        /**
         * Enables the CSS agent for the given page. Clients should not assume that the CSS agent has been
         * enabled until the result of this command is received.
         */
        enable(): Promise<void>;

        /**
         * Ensures that the given node will have specified pseudo-classes whenever its style is computed by
         * the browser.
         */
        forcePseudoState(params: CSS.ForcePseudoStateRequest): Promise<void>;

        getBackgroundColors(params: CSS.GetBackgroundColorsRequest): Promise<CSS.GetBackgroundColorsResponse>;

        /**
         * Returns the computed style for a DOM node identified by `nodeId`.
         */
        getComputedStyleForNode(params: CSS.GetComputedStyleForNodeRequest): Promise<CSS.GetComputedStyleForNodeResponse>;

        /**
         * Returns the styles defined inline (explicitly in the "style" attribute and implicitly, using DOM
         * attributes) for a DOM node identified by `nodeId`.
         */
        getInlineStylesForNode(params: CSS.GetInlineStylesForNodeRequest): Promise<CSS.GetInlineStylesForNodeResponse>;

        /**
         * Returns requested styles for a DOM node identified by `nodeId`.
         */
        getMatchedStylesForNode(params: CSS.GetMatchedStylesForNodeRequest): Promise<CSS.GetMatchedStylesForNodeResponse>;

        /**
         * Returns all media queries parsed by the rendering engine.
         */
        getMediaQueries(): Promise<CSS.GetMediaQueriesResponse>;

        /**
         * Requests information about platform fonts which we used to render child TextNodes in the given
         * node.
         */
        getPlatformFontsForNode(params: CSS.GetPlatformFontsForNodeRequest): Promise<CSS.GetPlatformFontsForNodeResponse>;

        /**
         * Returns the current textual content for a stylesheet.
         */
        getStyleSheetText(params: CSS.GetStyleSheetTextRequest): Promise<CSS.GetStyleSheetTextResponse>;

        /**
         * Find a rule with the given active property for the given node and set the new value for this
         * property
         */
        setEffectivePropertyValueForNode(params: CSS.SetEffectivePropertyValueForNodeRequest): Promise<void>;

        /**
         * Modifies the keyframe rule key text.
         */
        setKeyframeKey(params: CSS.SetKeyframeKeyRequest): Promise<CSS.SetKeyframeKeyResponse>;

        /**
         * Modifies the rule selector.
         */
        setMediaText(params: CSS.SetMediaTextRequest): Promise<CSS.SetMediaTextResponse>;

        /**
         * Modifies the rule selector.
         */
        setRuleSelector(params: CSS.SetRuleSelectorRequest): Promise<CSS.SetRuleSelectorResponse>;

        /**
         * Sets the new stylesheet text.
         */
        setStyleSheetText(params: CSS.SetStyleSheetTextRequest): Promise<CSS.SetStyleSheetTextResponse>;

        /**
         * Applies specified style edits one after another in the given order.
         */
        setStyleTexts(params: CSS.SetStyleTextsRequest): Promise<CSS.SetStyleTextsResponse>;

        /**
         * Enables the selector recording.
         */
        startRuleUsageTracking(): Promise<void>;

        /**
         * Stop tracking rule usage and return the list of rules that were used since last call to
         * `takeCoverageDelta` (or since start of coverage instrumentation)
         */
        stopRuleUsageTracking(): Promise<CSS.StopRuleUsageTrackingResponse>;

        /**
         * Obtain list of rules that became used since last call to this method (or since start of coverage
         * instrumentation)
         */
        takeCoverageDelta(): Promise<CSS.TakeCoverageDeltaResponse>;

        /**
         * Fires whenever a web font is updated.  A non-empty font parameter indicates a successfully loaded
         * web font
         */
        on(event: 'fontsUpdated', listener: (params: CSS.FontsUpdatedEvent) => void): void;

        /**
         * Fires whenever a MediaQuery result changes (for example, after a browser window has been
         * resized.) The current implementation considers only viewport-dependent media features.
         */
        on(event: 'mediaQueryResultChanged', listener: () => void): void;

        /**
         * Fired whenever an active document stylesheet is added.
         */
        on(event: 'styleSheetAdded', listener: (params: CSS.StyleSheetAddedEvent) => void): void;

        /**
         * Fired whenever a stylesheet is changed as a result of the client operation.
         */
        on(event: 'styleSheetChanged', listener: (params: CSS.StyleSheetChangedEvent) => void): void;

        /**
         * Fired whenever an active document stylesheet is removed.
         */
        on(event: 'styleSheetRemoved', listener: (params: CSS.StyleSheetRemovedEvent) => void): void;
    }

    export namespace CacheStorage {

        /**
         * Unique identifier of the Cache object.
         */
        export type CacheId = string;

        /**
         * Data entry.
         */
        export interface DataEntry {
            /**
             * Request URL.
             */
            requestURL: string;

            /**
             * Request method.
             */
            requestMethod: string;

            /**
             * Request headers
             */
            requestHeaders: Header[];

            /**
             * Number of seconds since epoch.
             */
            responseTime: number;

            /**
             * HTTP response status code.
             */
            responseStatus: integer;

            /**
             * HTTP response status text.
             */
            responseStatusText: string;

            /**
             * Response headers
             */
            responseHeaders: Header[];
        }

        /**
         * Cache identifier.
         */
        export interface Cache {
            /**
             * An opaque unique id of the cache.
             */
            cacheId: CacheId;

            /**
             * Security origin of the cache.
             */
            securityOrigin: string;

            /**
             * The name of the cache.
             */
            cacheName: string;
        }

        export interface Header {
            name: string;

            value: string;
        }

        /**
         * Cached response
         */
        export interface CachedResponse {
            /**
             * Entry content, base64-encoded.
             */
            body: string;
        }

        export interface DeleteCacheRequest {
            /**
             * Id of cache for deletion.
             */
            cacheId: CacheId;
        }

        export interface DeleteEntryRequest {
            /**
             * Id of cache where the entry will be deleted.
             */
            cacheId: CacheId;

            /**
             * URL spec of the request.
             */
            request: string;
        }

        export interface RequestCacheNamesRequest {
            /**
             * Security origin.
             */
            securityOrigin: string;
        }

        export interface RequestCacheNamesResponse {
            /**
             * Caches for the security origin.
             */
            caches: Cache[];
        }

        export interface RequestCachedResponseRequest {
            /**
             * Id of cache that contains the enty.
             */
            cacheId: CacheId;

            /**
             * URL spec of the request.
             */
            requestURL: string;
        }

        export interface RequestCachedResponseResponse {
            /**
             * Response read from the cache.
             */
            response: CachedResponse;
        }

        export interface RequestEntriesRequest {
            /**
             * ID of cache to get entries from.
             */
            cacheId: CacheId;

            /**
             * Number of records to skip.
             */
            skipCount: integer;

            /**
             * Number of records to fetch.
             */
            pageSize: integer;
        }

        export interface RequestEntriesResponse {
            /**
             * Array of object store data entries.
             */
            cacheDataEntries: DataEntry[];

            /**
             * If true, there are more entries to fetch in the given range.
             */
            hasMore: boolean;
        }
    }

    export interface CacheStorageApi {
        /**
         * Deletes a cache.
         */
        deleteCache(params: CacheStorage.DeleteCacheRequest): Promise<void>;

        /**
         * Deletes a cache entry.
         */
        deleteEntry(params: CacheStorage.DeleteEntryRequest): Promise<void>;

        /**
         * Requests cache names.
         */
        requestCacheNames(params: CacheStorage.RequestCacheNamesRequest): Promise<CacheStorage.RequestCacheNamesResponse>;

        /**
         * Fetches cache entry.
         */
        requestCachedResponse(params: CacheStorage.RequestCachedResponseRequest): Promise<CacheStorage.RequestCachedResponseResponse>;

        /**
         * Requests data from cache.
         */
        requestEntries(params: CacheStorage.RequestEntriesRequest): Promise<CacheStorage.RequestEntriesResponse>;
    }

    /**
     * This domain exposes DOM read/write operations. Each DOM Node is represented with its mirror object
     * that has an `id`. This `id` can be used to get additional information on the Node, resolve it into
     * the JavaScript object wrapper, etc. It is important that client receives DOM events only for the
     * nodes that are known to the client. Backend keeps track of the nodes that were sent to the client
     * and never sends the same node twice. It is client's responsibility to collect information about
     * the nodes that were sent to the client.<p>Note that `iframe` owner elements will return
     * corresponding document elements as their child nodes.</p>
     */
    export namespace DOM {

        /**
         * Unique DOM node identifier.
         */
        export type NodeId = integer;

        /**
         * Unique DOM node identifier used to reference a node that may not have been pushed to the
         * front-end.
         */
        export type BackendNodeId = integer;

        /**
         * Backend node with a friendly name.
         */
        export interface BackendNode {
            /**
             * `Node`'s nodeType.
             */
            nodeType: integer;

            /**
             * `Node`'s nodeName.
             */
            nodeName: string;

            backendNodeId: BackendNodeId;
        }

        /**
         * Pseudo element type.
         */
        export type PseudoType = ('first-line' | 'first-letter' | 'before' | 'after' | 'backdrop' | 'selection' | 'first-line-inherited' | 'scrollbar' | 'scrollbar-thumb' | 'scrollbar-button' | 'scrollbar-track' | 'scrollbar-track-piece' | 'scrollbar-corner' | 'resizer' | 'input-list-button');

        /**
         * Shadow root type.
         */
        export type ShadowRootType = ('user-agent' | 'open' | 'closed');

        /**
         * DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes.
         * DOMNode is a base node mirror type.
         */
        export interface Node {
            /**
             * Node identifier that is passed into the rest of the DOM messages as the `nodeId`. Backend
             * will only push node with given `id` once. It is aware of all requested nodes and will only
             * fire DOM events for nodes known to the client.
             */
            nodeId: NodeId;

            /**
             * The id of the parent node if any.
             */
            parentId?: NodeId;

            /**
             * The BackendNodeId for this node.
             */
            backendNodeId: BackendNodeId;

            /**
             * `Node`'s nodeType.
             */
            nodeType: integer;

            /**
             * `Node`'s nodeName.
             */
            nodeName: string;

            /**
             * `Node`'s localName.
             */
            localName: string;

            /**
             * `Node`'s nodeValue.
             */
            nodeValue: string;

            /**
             * Child count for `Container` nodes.
             */
            childNodeCount?: integer;

            /**
             * Child nodes of this node when requested with children.
             */
            children?: Node[];

            /**
             * Attributes of the `Element` node in the form of flat array `[name1, value1, name2, value2]`.
             */
            attributes?: string[];

            /**
             * Document URL that `Document` or `FrameOwner` node points to.
             */
            documentURL?: string;

            /**
             * Base URL that `Document` or `FrameOwner` node uses for URL completion.
             */
            baseURL?: string;

            /**
             * `DocumentType`'s publicId.
             */
            publicId?: string;

            /**
             * `DocumentType`'s systemId.
             */
            systemId?: string;

            /**
             * `DocumentType`'s internalSubset.
             */
            internalSubset?: string;

            /**
             * `Document`'s XML version in case of XML documents.
             */
            xmlVersion?: string;

            /**
             * `Attr`'s name.
             */
            name?: string;

            /**
             * `Attr`'s value.
             */
            value?: string;

            /**
             * Pseudo element type for this node.
             */
            pseudoType?: PseudoType;

            /**
             * Shadow root type.
             */
            shadowRootType?: ShadowRootType;

            /**
             * Frame ID for frame owner elements.
             */
            frameId?: Page.FrameId;

            /**
             * Content document for frame owner elements.
             */
            contentDocument?: Node;

            /**
             * Shadow root list for given element host.
             */
            shadowRoots?: Node[];

            /**
             * Content document fragment for template elements.
             */
            templateContent?: Node;

            /**
             * Pseudo elements associated with this node.
             */
            pseudoElements?: Node[];

            /**
             * Import document for the HTMLImport links.
             */
            importedDocument?: Node;

            /**
             * Distributed nodes for given insertion point.
             */
            distributedNodes?: BackendNode[];

            /**
             * Whether the node is SVG.
             */
            isSVG?: boolean;
        }

        /**
         * A structure holding an RGBA color.
         */
        export interface RGBA {
            /**
             * The red component, in the [0-255] range.
             */
            r: integer;

            /**
             * The green component, in the [0-255] range.
             */
            g: integer;

            /**
             * The blue component, in the [0-255] range.
             */
            b: integer;

            /**
             * The alpha component, in the [0-1] range (default: 1).
             */
            a?: number;
        }

        /**
         * An array of quad vertices, x immediately followed by y for each point, points clock-wise.
         */
        export type Quad = number[];

        /**
         * Box model.
         */
        export interface BoxModel {
            /**
             * Content box
             */
            content: Quad;

            /**
             * Padding box
             */
            padding: Quad;

            /**
             * Border box
             */
            border: Quad;

            /**
             * Margin box
             */
            margin: Quad;

            /**
             * Node width
             */
            width: integer;

            /**
             * Node height
             */
            height: integer;

            /**
             * Shape outside coordinates
             */
            shapeOutside?: ShapeOutsideInfo;
        }

        /**
         * CSS Shape Outside details.
         */
        export interface ShapeOutsideInfo {
            /**
             * Shape bounds
             */
            bounds: Quad;

            /**
             * Shape coordinate details
             */
            shape: any[];

            /**
             * Margin shape bounds
             */
            marginShape: any[];
        }

        /**
         * Rectangle.
         */
        export interface Rect {
            /**
             * X coordinate
             */
            x: number;

            /**
             * Y coordinate
             */
            y: number;

            /**
             * Rectangle width
             */
            width: number;

            /**
             * Rectangle height
             */
            height: number;
        }

        export interface CollectClassNamesFromSubtreeRequest {
            /**
             * Id of the node to collect class names.
             */
            nodeId: NodeId;
        }

        export interface CollectClassNamesFromSubtreeResponse {
            /**
             * Class name list.
             */
            classNames: string[];
        }

        export interface CopyToRequest {
            /**
             * Id of the node to copy.
             */
            nodeId: NodeId;

            /**
             * Id of the element to drop the copy into.
             */
            targetNodeId: NodeId;

            /**
             * Drop the copy before this node (if absent, the copy becomes the last child of
             * `targetNodeId`).
             */
            insertBeforeNodeId?: NodeId;
        }

        export interface CopyToResponse {
            /**
             * Id of the node clone.
             */
            nodeId: NodeId;
        }

        export interface DescribeNodeRequest {
            /**
             * Identifier of the node.
             */
            nodeId?: NodeId;

            /**
             * Identifier of the backend node.
             */
            backendNodeId?: BackendNodeId;

            /**
             * JavaScript object id of the node wrapper.
             */
            objectId?: Runtime.RemoteObjectId;

            /**
             * The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
             * entire subtree or provide an integer larger than 0.
             */
            depth?: integer;

            /**
             * Whether or not iframes and shadow roots should be traversed when returning the subtree
             * (default is false).
             */
            pierce?: boolean;
        }

        export interface DescribeNodeResponse {
            /**
             * Node description.
             */
            node: Node;
        }

        export interface DiscardSearchResultsRequest {
            /**
             * Unique search session identifier.
             */
            searchId: string;
        }

        export interface FocusRequest {
            /**
             * Identifier of the node.
             */
            nodeId?: NodeId;

            /**
             * Identifier of the backend node.
             */
            backendNodeId?: BackendNodeId;

            /**
             * JavaScript object id of the node wrapper.
             */
            objectId?: Runtime.RemoteObjectId;
        }

        export interface GetAttributesRequest {
            /**
             * Id of the node to retrieve attibutes for.
             */
            nodeId: NodeId;
        }

        export interface GetAttributesResponse {
            /**
             * An interleaved array of node attribute names and values.
             */
            attributes: string[];
        }

        export interface GetBoxModelRequest {
            /**
             * Identifier of the node.
             */
            nodeId?: NodeId;

            /**
             * Identifier of the backend node.
             */
            backendNodeId?: BackendNodeId;

            /**
             * JavaScript object id of the node wrapper.
             */
            objectId?: Runtime.RemoteObjectId;
        }

        export interface GetBoxModelResponse {
            /**
             * Box model for the node.
             */
            model: BoxModel;
        }

        export interface GetContentQuadsRequest {
            /**
             * Identifier of the node.
             */
            nodeId?: NodeId;

            /**
             * Identifier of the backend node.
             */
            backendNodeId?: BackendNodeId;

            /**
             * JavaScript object id of the node wrapper.
             */
            objectId?: Runtime.RemoteObjectId;
        }

        export interface GetContentQuadsResponse {
            /**
             * Quads that describe node layout relative to viewport.
             */
            quads: Quad[];
        }

        export interface GetDocumentRequest {
            /**
             * The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
             * entire subtree or provide an integer larger than 0.
             */
            depth?: integer;

            /**
             * Whether or not iframes and shadow roots should be traversed when returning the subtree
             * (default is false).
             */
            pierce?: boolean;
        }

        export interface GetDocumentResponse {
            /**
             * Resulting node.
             */
            root: Node;
        }

        export interface GetFlattenedDocumentRequest {
            /**
             * The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
             * entire subtree or provide an integer larger than 0.
             */
            depth?: integer;

            /**
             * Whether or not iframes and shadow roots should be traversed when returning the subtree
             * (default is false).
             */
            pierce?: boolean;
        }

        export interface GetFlattenedDocumentResponse {
            /**
             * Resulting node.
             */
            nodes: Node[];
        }

        export interface GetNodeForLocationRequest {
            /**
             * X coordinate.
             */
            x: integer;

            /**
             * Y coordinate.
             */
            y: integer;

            /**
             * False to skip to the nearest non-UA shadow root ancestor (default: false).
             */
            includeUserAgentShadowDOM?: boolean;
        }

        export interface GetNodeForLocationResponse {
            /**
             * Id of the node at given coordinates.
             */
            nodeId: NodeId;
        }

        export interface GetOuterHTMLRequest {
            /**
             * Identifier of the node.
             */
            nodeId?: NodeId;

            /**
             * Identifier of the backend node.
             */
            backendNodeId?: BackendNodeId;

            /**
             * JavaScript object id of the node wrapper.
             */
            objectId?: Runtime.RemoteObjectId;
        }

        export interface GetOuterHTMLResponse {
            /**
             * Outer HTML markup.
             */
            outerHTML: string;
        }

        export interface GetRelayoutBoundaryRequest {
            /**
             * Id of the node.
             */
            nodeId: NodeId;
        }

        export interface GetRelayoutBoundaryResponse {
            /**
             * Relayout boundary node id for the given node.
             */
            nodeId: NodeId;
        }

        export interface GetSearchResultsRequest {
            /**
             * Unique search session identifier.
             */
            searchId: string;

            /**
             * Start index of the search result to be returned.
             */
            fromIndex: integer;

            /**
             * End index of the search result to be returned.
             */
            toIndex: integer;
        }

        export interface GetSearchResultsResponse {
            /**
             * Ids of the search result nodes.
             */
            nodeIds: NodeId[];
        }

        export interface MoveToRequest {
            /**
             * Id of the node to move.
             */
            nodeId: NodeId;

            /**
             * Id of the element to drop the moved node into.
             */
            targetNodeId: NodeId;

            /**
             * Drop node before this one (if absent, the moved node becomes the last child of
             * `targetNodeId`).
             */
            insertBeforeNodeId?: NodeId;
        }

        export interface MoveToResponse {
            /**
             * New id of the moved node.
             */
            nodeId: NodeId;
        }

        export interface PerformSearchRequest {
            /**
             * Plain text or query selector or XPath search query.
             */
            query: string;

            /**
             * True to search in user agent shadow DOM.
             */
            includeUserAgentShadowDOM?: boolean;
        }

        export interface PerformSearchResponse {
            /**
             * Unique search session identifier.
             */
            searchId: string;

            /**
             * Number of search results.
             */
            resultCount: integer;
        }

        export interface PushNodeByPathToFrontendRequest {
            /**
             * Path to node in the proprietary format.
             */
            path: string;
        }

        export interface PushNodeByPathToFrontendResponse {
            /**
             * Id of the node for given path.
             */
            nodeId: NodeId;
        }

        export interface PushNodesByBackendIdsToFrontendRequest {
            /**
             * The array of backend node ids.
             */
            backendNodeIds: BackendNodeId[];
        }

        export interface PushNodesByBackendIdsToFrontendResponse {
            /**
             * The array of ids of pushed nodes that correspond to the backend ids specified in
             * backendNodeIds.
             */
            nodeIds: NodeId[];
        }

        export interface QuerySelectorRequest {
            /**
             * Id of the node to query upon.
             */
            nodeId: NodeId;

            /**
             * Selector string.
             */
            selector: string;
        }

        export interface QuerySelectorResponse {
            /**
             * Query selector result.
             */
            nodeId: NodeId;
        }

        export interface QuerySelectorAllRequest {
            /**
             * Id of the node to query upon.
             */
            nodeId: NodeId;

            /**
             * Selector string.
             */
            selector: string;
        }

        export interface QuerySelectorAllResponse {
            /**
             * Query selector result.
             */
            nodeIds: NodeId[];
        }

        export interface RemoveAttributeRequest {
            /**
             * Id of the element to remove attribute from.
             */
            nodeId: NodeId;

            /**
             * Name of the attribute to remove.
             */
            name: string;
        }

        export interface RemoveNodeRequest {
            /**
             * Id of the node to remove.
             */
            nodeId: NodeId;
        }

        export interface RequestChildNodesRequest {
            /**
             * Id of the node to get children for.
             */
            nodeId: NodeId;

            /**
             * The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the
             * entire subtree or provide an integer larger than 0.
             */
            depth?: integer;

            /**
             * Whether or not iframes and shadow roots should be traversed when returning the sub-tree
             * (default is false).
             */
            pierce?: boolean;
        }

        export interface RequestNodeRequest {
            /**
             * JavaScript object id to convert into node.
             */
            objectId: Runtime.RemoteObjectId;
        }

        export interface RequestNodeResponse {
            /**
             * Node id for given object.
             */
            nodeId: NodeId;
        }

        export interface ResolveNodeRequest {
            /**
             * Id of the node to resolve.
             */
            nodeId?: NodeId;

            /**
             * Backend identifier of the node to resolve.
             */
            backendNodeId?: DOM.BackendNodeId;

            /**
             * Symbolic group name that can be used to release multiple objects.
             */
            objectGroup?: string;
        }

        export interface ResolveNodeResponse {
            /**
             * JavaScript object wrapper for given node.
             */
            object: Runtime.RemoteObject;
        }

        export interface SetAttributeValueRequest {
            /**
             * Id of the element to set attribute for.
             */
            nodeId: NodeId;

            /**
             * Attribute name.
             */
            name: string;

            /**
             * Attribute value.
             */
            value: string;
        }

        export interface SetAttributesAsTextRequest {
            /**
             * Id of the element to set attributes for.
             */
            nodeId: NodeId;

            /**
             * Text with a number of attributes. Will parse this text using HTML parser.
             */
            text: string;

            /**
             * Attribute name to replace with new attributes derived from text in case text parsed
             * successfully.
             */
            name?: string;
        }

        export interface SetFileInputFilesRequest {
            /**
             * Array of file paths to set.
             */
            files: string[];

            /**
             * Identifier of the node.
             */
            nodeId?: NodeId;

            /**
             * Identifier of the backend node.
             */
            backendNodeId?: BackendNodeId;

            /**
             * JavaScript object id of the node wrapper.
             */
            objectId?: Runtime.RemoteObjectId;
        }

        export interface SetInspectedNodeRequest {
            /**
             * DOM node id to be accessible by means of $x command line API.
             */
            nodeId: NodeId;
        }

        export interface SetNodeNameRequest {
            /**
             * Id of the node to set name for.
             */
            nodeId: NodeId;

            /**
             * New node's name.
             */
            name: string;
        }

        export interface SetNodeNameResponse {
            /**
             * New node's id.
             */
            nodeId: NodeId;
        }

        export interface SetNodeValueRequest {
            /**
             * Id of the node to set value for.
             */
            nodeId: NodeId;

            /**
             * New node's value.
             */
            value: string;
        }

        export interface SetOuterHTMLRequest {
            /**
             * Id of the node to set markup for.
             */
            nodeId: NodeId;

            /**
             * Outer HTML markup to set.
             */
            outerHTML: string;
        }

        export interface GetFrameOwnerRequest {
            frameId: Page.FrameId;
        }

        export interface GetFrameOwnerResponse {
            nodeId: NodeId;
        }

        export interface AttributeModifiedEvent {
            /**
             * Id of the node that has changed.
             */
            nodeId: NodeId;

            /**
             * Attribute name.
             */
            name: string;

            /**
             * Attribute value.
             */
            value: string;
        }

        export interface AttributeRemovedEvent {
            /**
             * Id of the node that has changed.
             */
            nodeId: NodeId;

            /**
             * A ttribute name.
             */
            name: string;
        }

        export interface CharacterDataModifiedEvent {
            /**
             * Id of the node that has changed.
             */
            nodeId: NodeId;

            /**
             * New text value.
             */
            characterData: string;
        }

        export interface ChildNodeCountUpdatedEvent {
            /**
             * Id of the node that has changed.
             */
            nodeId: NodeId;

            /**
             * New node count.
             */
            childNodeCount: integer;
        }

        export interface ChildNodeInsertedEvent {
            /**
             * Id of the node that has changed.
             */
            parentNodeId: NodeId;

            /**
             * If of the previous siblint.
             */
            previousNodeId: NodeId;

            /**
             * Inserted node data.
             */
            node: Node;
        }

        export interface ChildNodeRemovedEvent {
            /**
             * Parent id.
             */
            parentNodeId: NodeId;

            /**
             * Id of the node that has been removed.
             */
            nodeId: NodeId;
        }

        export interface DistributedNodesUpdatedEvent {
            /**
             * Insertion point where distrubuted nodes were updated.
             */
            insertionPointId: NodeId;

            /**
             * Distributed nodes for given insertion point.
             */
            distributedNodes: BackendNode[];
        }

        export interface InlineStyleInvalidatedEvent {
            /**
             * Ids of the nodes for which the inline styles have been invalidated.
             */
            nodeIds: NodeId[];
        }

        export interface PseudoElementAddedEvent {
            /**
             * Pseudo element's parent element id.
             */
            parentId: NodeId;

            /**
             * The added pseudo element.
             */
            pseudoElement: Node;
        }

        export interface PseudoElementRemovedEvent {
            /**
             * Pseudo element's parent element id.
             */
            parentId: NodeId;

            /**
             * The removed pseudo element id.
             */
            pseudoElementId: NodeId;
        }

        export interface SetChildNodesEvent {
            /**
             * Parent node id to populate with children.
             */
            parentId: NodeId;

            /**
             * Child nodes array.
             */
            nodes: Node[];
        }

        export interface ShadowRootPoppedEvent {
            /**
             * Host element id.
             */
            hostId: NodeId;

            /**
             * Shadow root id.
             */
            rootId: NodeId;
        }

        export interface ShadowRootPushedEvent {
            /**
             * Host element id.
             */
            hostId: NodeId;

            /**
             * Shadow root.
             */
            root: Node;
        }
    }

    export interface DOMApi {
        /**
         * Collects class names for the node with given id and all of it's child nodes.
         */
        collectClassNamesFromSubtree(params: DOM.CollectClassNamesFromSubtreeRequest): Promise<DOM.CollectClassNamesFromSubtreeResponse>;

        /**
         * Creates a deep copy of the specified node and places it into the target container before the
         * given anchor.
         */
        copyTo(params: DOM.CopyToRequest): Promise<DOM.CopyToResponse>;

        /**
         * Describes node given its id, does not require domain to be enabled. Does not start tracking any
         * objects, can be used for automation.
         */
        describeNode(params: DOM.DescribeNodeRequest): Promise<DOM.DescribeNodeResponse>;

        /**
         * Disables DOM agent for the given page.
         */
        disable(): Promise<void>;

        /**
         * Discards search results from the session with the given id. `getSearchResults` should no longer
         * be called for that search.
         */
        discardSearchResults(params: DOM.DiscardSearchResultsRequest): Promise<void>;

        /**
         * Enables DOM agent for the given page.
         */
        enable(): Promise<void>;

        /**
         * Focuses the given element.
         */
        focus(params: DOM.FocusRequest): Promise<void>;

        /**
         * Returns attributes for the specified node.
         */
        getAttributes(params: DOM.GetAttributesRequest): Promise<DOM.GetAttributesResponse>;

        /**
         * Returns boxes for the given node.
         */
        getBoxModel(params: DOM.GetBoxModelRequest): Promise<DOM.GetBoxModelResponse>;

        /**
         * Returns quads that describe node position on the page. This method
         * might return multiple quads for inline nodes.
         */
        getContentQuads(params: DOM.GetContentQuadsRequest): Promise<DOM.GetContentQuadsResponse>;

        /**
         * Returns the root DOM node (and optionally the subtree) to the caller.
         */
        getDocument(params: DOM.GetDocumentRequest): Promise<DOM.GetDocumentResponse>;

        /**
         * Returns the root DOM node (and optionally the subtree) to the caller.
         */
        getFlattenedDocument(params: DOM.GetFlattenedDocumentRequest): Promise<DOM.GetFlattenedDocumentResponse>;

        /**
         * Returns node id at given location.
         */
        getNodeForLocation(params: DOM.GetNodeForLocationRequest): Promise<DOM.GetNodeForLocationResponse>;

        /**
         * Returns node's HTML markup.
         */
        getOuterHTML(params: DOM.GetOuterHTMLRequest): Promise<DOM.GetOuterHTMLResponse>;

        /**
         * Returns the id of the nearest ancestor that is a relayout boundary.
         */
        getRelayoutBoundary(params: DOM.GetRelayoutBoundaryRequest): Promise<DOM.GetRelayoutBoundaryResponse>;

        /**
         * Returns search results from given `fromIndex` to given `toIndex` from the search with the given
         * identifier.
         */
        getSearchResults(params: DOM.GetSearchResultsRequest): Promise<DOM.GetSearchResultsResponse>;

        /**
         * Hides any highlight.
         */
        hideHighlight(): Promise<void>;

        /**
         * Highlights DOM node.
         */
        highlightNode(): Promise<void>;

        /**
         * Highlights given rectangle.
         */
        highlightRect(): Promise<void>;

        /**
         * Marks last undoable state.
         */
        markUndoableState(): Promise<void>;

        /**
         * Moves node into the new container, places it before the given anchor.
         */
        moveTo(params: DOM.MoveToRequest): Promise<DOM.MoveToResponse>;

        /**
         * Searches for a given string in the DOM tree. Use `getSearchResults` to access search results or
         * `cancelSearch` to end this search session.
         */
        performSearch(params: DOM.PerformSearchRequest): Promise<DOM.PerformSearchResponse>;

        /**
         * Requests that the node is sent to the caller given its path. // FIXME, use XPath
         */
        pushNodeByPathToFrontend(params: DOM.PushNodeByPathToFrontendRequest): Promise<DOM.PushNodeByPathToFrontendResponse>;

        /**
         * Requests that a batch of nodes is sent to the caller given their backend node ids.
         */
        pushNodesByBackendIdsToFrontend(params: DOM.PushNodesByBackendIdsToFrontendRequest): Promise<DOM.PushNodesByBackendIdsToFrontendResponse>;

        /**
         * Executes `querySelector` on a given node.
         */
        querySelector(params: DOM.QuerySelectorRequest): Promise<DOM.QuerySelectorResponse>;

        /**
         * Executes `querySelectorAll` on a given node.
         */
        querySelectorAll(params: DOM.QuerySelectorAllRequest): Promise<DOM.QuerySelectorAllResponse>;

        /**
         * Re-does the last undone action.
         */
        redo(): Promise<void>;

        /**
         * Removes attribute with given name from an element with given id.
         */
        removeAttribute(params: DOM.RemoveAttributeRequest): Promise<void>;

        /**
         * Removes node with given id.
         */
        removeNode(params: DOM.RemoveNodeRequest): Promise<void>;

        /**
         * Requests that children of the node with given id are returned to the caller in form of
         * `setChildNodes` events where not only immediate children are retrieved, but all children down to
         * the specified depth.
         */
        requestChildNodes(params: DOM.RequestChildNodesRequest): Promise<void>;

        /**
         * Requests that the node is sent to the caller given the JavaScript node object reference. All
         * nodes that form the path from the node to the root are also sent to the client as a series of
         * `setChildNodes` notifications.
         */
        requestNode(params: DOM.RequestNodeRequest): Promise<DOM.RequestNodeResponse>;

        /**
         * Resolves the JavaScript node object for a given NodeId or BackendNodeId.
         */
        resolveNode(params: DOM.ResolveNodeRequest): Promise<DOM.ResolveNodeResponse>;

        /**
         * Sets attribute for an element with given id.
         */
        setAttributeValue(params: DOM.SetAttributeValueRequest): Promise<void>;

        /**
         * Sets attributes on element with given id. This method is useful when user edits some existing
         * attribute value and types in several attribute name/value pairs.
         */
        setAttributesAsText(params: DOM.SetAttributesAsTextRequest): Promise<void>;

        /**
         * Sets files for the given file input element.
         */
        setFileInputFiles(params: DOM.SetFileInputFilesRequest): Promise<void>;

        /**
         * Enables console to refer to the node with given id via $x (see Command Line API for more details
         * $x functions).
         */
        setInspectedNode(params: DOM.SetInspectedNodeRequest): Promise<void>;

        /**
         * Sets node name for a node with given id.
         */
        setNodeName(params: DOM.SetNodeNameRequest): Promise<DOM.SetNodeNameResponse>;

        /**
         * Sets node value for a node with given id.
         */
        setNodeValue(params: DOM.SetNodeValueRequest): Promise<void>;

        /**
         * Sets node HTML markup, returns new node id.
         */
        setOuterHTML(params: DOM.SetOuterHTMLRequest): Promise<void>;

        /**
         * Undoes the last performed action.
         */
        undo(): Promise<void>;

        /**
         * Returns iframe node that owns iframe with the given domain.
         */
        getFrameOwner(params: DOM.GetFrameOwnerRequest): Promise<DOM.GetFrameOwnerResponse>;

        /**
         * Fired when `Element`'s attribute is modified.
         */
        on(event: 'attributeModified', listener: (params: DOM.AttributeModifiedEvent) => void): void;

        /**
         * Fired when `Element`'s attribute is removed.
         */
        on(event: 'attributeRemoved', listener: (params: DOM.AttributeRemovedEvent) => void): void;

        /**
         * Mirrors `DOMCharacterDataModified` event.
         */
        on(event: 'characterDataModified', listener: (params: DOM.CharacterDataModifiedEvent) => void): void;

        /**
         * Fired when `Container`'s child node count has changed.
         */
        on(event: 'childNodeCountUpdated', listener: (params: DOM.ChildNodeCountUpdatedEvent) => void): void;

        /**
         * Mirrors `DOMNodeInserted` event.
         */
        on(event: 'childNodeInserted', listener: (params: DOM.ChildNodeInsertedEvent) => void): void;

        /**
         * Mirrors `DOMNodeRemoved` event.
         */
        on(event: 'childNodeRemoved', listener: (params: DOM.ChildNodeRemovedEvent) => void): void;

        /**
         * Called when distrubution is changed.
         */
        on(event: 'distributedNodesUpdated', listener: (params: DOM.DistributedNodesUpdatedEvent) => void): void;

        /**
         * Fired when `Document` has been totally updated. Node ids are no longer valid.
         */
        on(event: 'documentUpdated', listener: () => void): void;

        /**
         * Fired when `Element`'s inline style is modified via a CSS property modification.
         */
        on(event: 'inlineStyleInvalidated', listener: (params: DOM.InlineStyleInvalidatedEvent) => void): void;

        /**
         * Called when a pseudo element is added to an element.
         */
        on(event: 'pseudoElementAdded', listener: (params: DOM.PseudoElementAddedEvent) => void): void;

        /**
         * Called when a pseudo element is removed from an element.
         */
        on(event: 'pseudoElementRemoved', listener: (params: DOM.PseudoElementRemovedEvent) => void): void;

        /**
         * Fired when backend wants to provide client with the missing DOM structure. This happens upon
         * most of the calls requesting node ids.
         */
        on(event: 'setChildNodes', listener: (params: DOM.SetChildNodesEvent) => void): void;

        /**
         * Called when shadow root is popped from the element.
         */
        on(event: 'shadowRootPopped', listener: (params: DOM.ShadowRootPoppedEvent) => void): void;

        /**
         * Called when shadow root is pushed into the element.
         */
        on(event: 'shadowRootPushed', listener: (params: DOM.ShadowRootPushedEvent) => void): void;
    }

    /**
     * DOM debugging allows setting breakpoints on particular DOM operations and events. JavaScript
     * execution will stop on these operations as if there was a regular breakpoint set.
     */
    export namespace DOMDebugger {

        /**
         * DOM breakpoint type.
         */
        export type DOMBreakpointType = ('subtree-modified' | 'attribute-modified' | 'node-removed');

        /**
         * Object event listener.
         */
        export interface EventListener {
            /**
             * `EventListener`'s type.
             */
            type: string;

            /**
             * `EventListener`'s useCapture.
             */
            useCapture: boolean;

            /**
             * `EventListener`'s passive flag.
             */
            passive: boolean;

            /**
             * `EventListener`'s once flag.
             */
            once: boolean;

            /**
             * Script id of the handler code.
             */
            scriptId: Runtime.ScriptId;

            /**
             * Line number in the script (0-based).
             */
            lineNumber: integer;

            /**
             * Column number in the script (0-based).
             */
            columnNumber: integer;

            /**
             * Event handler function value.
             */
            handler?: Runtime.RemoteObject;

            /**
             * Event original handler function value.
             */
            originalHandler?: Runtime.RemoteObject;

            /**
             * Node the listener is added to (if any).
             */
            backendNodeId?: DOM.BackendNodeId;
        }

        export interface GetEventListenersRequest {
            /**
             * Identifier of the object to return listeners for.
             */
            objectId: Runtime.RemoteObjectId;

            /**
             * The maximum depth at which Node children should be retrieved, defaults to 1. Use -1 for the
             * entire subtree or provide an integer larger than 0.
             */
            depth?: integer;

            /**
             * Whether or not iframes and shadow roots should be traversed when returning the subtree
             * (default is false). Reports listeners for all contexts if pierce is enabled.
             */
            pierce?: boolean;
        }

        export interface GetEventListenersResponse {
            /**
             * Array of relevant listeners.
             */
            listeners: EventListener[];
        }

        export interface RemoveDOMBreakpointRequest {
            /**
             * Identifier of the node to remove breakpoint from.
             */
            nodeId: DOM.NodeId;

            /**
             * Type of the breakpoint to remove.
             */
            type: DOMBreakpointType;
        }

        export interface RemoveEventListenerBreakpointRequest {
            /**
             * Event name.
             */
            eventName: string;

            /**
             * EventTarget interface name.
             */
            targetName?: string;
        }

        export interface RemoveInstrumentationBreakpointRequest {
            /**
             * Instrumentation name to stop on.
             */
            eventName: string;
        }

        export interface RemoveXHRBreakpointRequest {
            /**
             * Resource URL substring.
             */
            url: string;
        }

        export interface SetDOMBreakpointRequest {
            /**
             * Identifier of the node to set breakpoint on.
             */
            nodeId: DOM.NodeId;

            /**
             * Type of the operation to stop upon.
             */
            type: DOMBreakpointType;
        }

        export interface SetEventListenerBreakpointRequest {
            /**
             * DOM Event name to stop on (any DOM event will do).
             */
            eventName: string;

            /**
             * EventTarget interface name to stop on. If equal to `"*"` or not provided, will stop on any
             * EventTarget.
             */
            targetName?: string;
        }

        export interface SetInstrumentationBreakpointRequest {
            /**
             * Instrumentation name to stop on.
             */
            eventName: string;
        }

        export interface SetXHRBreakpointRequest {
            /**
             * Resource URL substring. All XHRs having this substring in the URL will get stopped upon.
             */
            url: string;
        }
    }

    export interface DOMDebuggerApi {
        /**
         * Returns event listeners of the given object.
         */
        getEventListeners(params: DOMDebugger.GetEventListenersRequest): Promise<DOMDebugger.GetEventListenersResponse>;

        /**
         * Removes DOM breakpoint that was set using `setDOMBreakpoint`.
         */
        removeDOMBreakpoint(params: DOMDebugger.RemoveDOMBreakpointRequest): Promise<void>;

        /**
         * Removes breakpoint on particular DOM event.
         */
        removeEventListenerBreakpoint(params: DOMDebugger.RemoveEventListenerBreakpointRequest): Promise<void>;

        /**
         * Removes breakpoint on particular native event.
         */
        removeInstrumentationBreakpoint(params: DOMDebugger.RemoveInstrumentationBreakpointRequest): Promise<void>;

        /**
         * Removes breakpoint from XMLHttpRequest.
         */
        removeXHRBreakpoint(params: DOMDebugger.RemoveXHRBreakpointRequest): Promise<void>;

        /**
         * Sets breakpoint on particular operation with DOM.
         */
        setDOMBreakpoint(params: DOMDebugger.SetDOMBreakpointRequest): Promise<void>;

        /**
         * Sets breakpoint on particular DOM event.
         */
        setEventListenerBreakpoint(params: DOMDebugger.SetEventListenerBreakpointRequest): Promise<void>;

        /**
         * Sets breakpoint on particular native event.
         */
        setInstrumentationBreakpoint(params: DOMDebugger.SetInstrumentationBreakpointRequest): Promise<void>;

        /**
         * Sets breakpoint on XMLHttpRequest.
         */
        setXHRBreakpoint(params: DOMDebugger.SetXHRBreakpointRequest): Promise<void>;
    }

    /**
     * This domain facilitates obtaining document snapshots with DOM, layout, and style information.
     */
    export namespace DOMSnapshot {

        /**
         * A Node in the DOM tree.
         */
        export interface DOMNode {
            /**
             * `Node`'s nodeType.
             */
            nodeType: integer;

            /**
             * `Node`'s nodeName.
             */
            nodeName: string;

            /**
             * `Node`'s nodeValue.
             */
            nodeValue: string;

            /**
             * Only set for textarea elements, contains the text value.
             */
            textValue?: string;

            /**
             * Only set for input elements, contains the input's associated text value.
             */
            inputValue?: string;

            /**
             * Only set for radio and checkbox input elements, indicates if the element has been checked
             */
            inputChecked?: boolean;

            /**
             * Only set for option elements, indicates if the element has been selected
             */
            optionSelected?: boolean;

            /**
             * `Node`'s id, corresponds to DOM.Node.backendNodeId.
             */
            backendNodeId: DOM.BackendNodeId;

            /**
             * The indexes of the node's child nodes in the `domNodes` array returned by `getSnapshot`, if
             * any.
             */
            childNodeIndexes?: integer[];

            /**
             * Attributes of an `Element` node.
             */
            attributes?: NameValue[];

            /**
             * Indexes of pseudo elements associated with this node in the `domNodes` array returned by
             * `getSnapshot`, if any.
             */
            pseudoElementIndexes?: integer[];

            /**
             * The index of the node's related layout tree node in the `layoutTreeNodes` array returned by
             * `getSnapshot`, if any.
             */
            layoutNodeIndex?: integer;

            /**
             * Document URL that `Document` or `FrameOwner` node points to.
             */
            documentURL?: string;

            /**
             * Base URL that `Document` or `FrameOwner` node uses for URL completion.
             */
            baseURL?: string;

            /**
             * Only set for documents, contains the document's content language.
             */
            contentLanguage?: string;

            /**
             * Only set for documents, contains the document's character set encoding.
             */
            documentEncoding?: string;

            /**
             * `DocumentType` node's publicId.
             */
            publicId?: string;

            /**
             * `DocumentType` node's systemId.
             */
            systemId?: string;

            /**
             * Frame ID for frame owner elements and also for the document node.
             */
            frameId?: Page.FrameId;

            /**
             * The index of a frame owner element's content document in the `domNodes` array returned by
             * `getSnapshot`, if any.
             */
            contentDocumentIndex?: integer;

            /**
             * Type of a pseudo element node.
             */
            pseudoType?: DOM.PseudoType;

            /**
             * Shadow root type.
             */
            shadowRootType?: DOM.ShadowRootType;

            /**
             * Whether this DOM node responds to mouse clicks. This includes nodes that have had click
             * event listeners attached via JavaScript as well as anchor tags that naturally navigate when
             * clicked.
             */
            isClickable?: boolean;

            /**
             * Details of the node's event listeners, if any.
             */
            eventListeners?: DOMDebugger.EventListener[];

            /**
             * The selected url for nodes with a srcset attribute.
             */
            currentSourceURL?: string;

            /**
             * The url of the script (if any) that generates this node.
             */
            originURL?: string;
        }

        /**
         * Details of post layout rendered text positions. The exact layout should not be regarded as
         * stable and may change between versions.
         */
        export interface InlineTextBox {
            /**
             * The absolute position bounding box.
             */
            boundingBox: DOM.Rect;

            /**
             * The starting index in characters, for this post layout textbox substring. Characters that
             * would be represented as a surrogate pair in UTF-16 have length 2.
             */
            startCharacterIndex: integer;

            /**
             * The number of characters in this post layout textbox substring. Characters that would be
             * represented as a surrogate pair in UTF-16 have length 2.
             */
            numCharacters: integer;
        }

        /**
         * Details of an element in the DOM tree with a LayoutObject.
         */
        export interface LayoutTreeNode {
            /**
             * The index of the related DOM node in the `domNodes` array returned by `getSnapshot`.
             */
            domNodeIndex: integer;

            /**
             * The absolute position bounding box.
             */
            boundingBox: DOM.Rect;

            /**
             * Contents of the LayoutText, if any.
             */
            layoutText?: string;

            /**
             * The post-layout inline text nodes, if any.
             */
            inlineTextNodes?: InlineTextBox[];

            /**
             * Index into the `computedStyles` array returned by `getSnapshot`.
             */
            styleIndex?: integer;

            /**
             * Global paint order index, which is determined by the stacking order of the nodes. Nodes
             * that are painted together will have the same index. Only provided if includePaintOrder in
             * getSnapshot was true.
             */
            paintOrder?: integer;

            /**
             * Set to true to indicate the element begins a new stacking context.
             */
            isStackingContext?: boolean;
        }

        /**
         * A subset of the full ComputedStyle as defined by the request whitelist.
         */
        export interface ComputedStyle {
            /**
             * Name/value pairs of computed style properties.
             */
            properties: NameValue[];
        }

        /**
         * A name/value pair.
         */
        export interface NameValue {
            /**
             * Attribute/property name.
             */
            name: string;

            /**
             * Attribute/property value.
             */
            value: string;
        }

        /**
         * Index of the string in the strings table.
         */
        export type StringIndex = integer;

        /**
         * Index of the string in the strings table.
         */
        export type ArrayOfStrings = StringIndex[];

        /**
         * Data that is only present on rare nodes.
         */
        export interface RareStringData {
            index: integer[];

            value: StringIndex[];
        }

        export interface RareBooleanData {
            index: integer[];
        }

        export interface RareIntegerData {
            index: integer[];

            value: integer[];
        }

        export type Rectangle = number[];

        /**
         * Document snapshot.
         */
        export interface DocumentSnapshot {
            /**
             * Document URL that `Document` or `FrameOwner` node points to.
             */
            documentURL: StringIndex;

            /**
             * Base URL that `Document` or `FrameOwner` node uses for URL completion.
             */
            baseURL: StringIndex;

            /**
             * Contains the document's content language.
             */
            contentLanguage: StringIndex;

            /**
             * Contains the document's character set encoding.
             */
            encodingName: StringIndex;

            /**
             * `DocumentType` node's publicId.
             */
            publicId: StringIndex;

            /**
             * `DocumentType` node's systemId.
             */
            systemId: StringIndex;

            /**
             * Frame ID for frame owner elements and also for the document node.
             */
            frameId: StringIndex;

            /**
             * A table with dom nodes.
             */
            nodes: NodeTreeSnapshot;

            /**
             * The nodes in the layout tree.
             */
            layout: LayoutTreeSnapshot;

            /**
             * The post-layout inline text nodes.
             */
            textBoxes: TextBoxSnapshot;
        }

        /**
         * Table containing nodes.
         */
        export interface NodeTreeSnapshot {
            /**
             * Parent node index.
             */
            parentIndex?: integer[];

            /**
             * `Node`'s nodeType.
             */
            nodeType?: integer[];

            /**
             * `Node`'s nodeName.
             */
            nodeName?: StringIndex[];

            /**
             * `Node`'s nodeValue.
             */
            nodeValue?: StringIndex[];

            /**
             * `Node`'s id, corresponds to DOM.Node.backendNodeId.
             */
            backendNodeId?: DOM.BackendNodeId[];

            /**
             * Attributes of an `Element` node. Flatten name, value pairs.
             */
            attributes?: ArrayOfStrings[];

            /**
             * Only set for textarea elements, contains the text value.
             */
            textValue?: RareStringData;

            /**
             * Only set for input elements, contains the input's associated text value.
             */
            inputValue?: RareStringData;

            /**
             * Only set for radio and checkbox input elements, indicates if the element has been checked
             */
            inputChecked?: RareBooleanData;

            /**
             * Only set for option elements, indicates if the element has been selected
             */
            optionSelected?: RareBooleanData;

            /**
             * The index of the document in the list of the snapshot documents.
             */
            contentDocumentIndex?: RareIntegerData;

            /**
             * Type of a pseudo element node.
             */
            pseudoType?: RareStringData;

            /**
             * Whether this DOM node responds to mouse clicks. This includes nodes that have had click
             * event listeners attached via JavaScript as well as anchor tags that naturally navigate when
             * clicked.
             */
            isClickable?: RareBooleanData;

            /**
             * The selected url for nodes with a srcset attribute.
             */
            currentSourceURL?: RareStringData;

            /**
             * The url of the script (if any) that generates this node.
             */
            originURL?: RareStringData;
        }

        /**
         * Details of an element in the DOM tree with a LayoutObject.
         */
        export interface LayoutTreeSnapshot {
            /**
             * The index of the related DOM node in the `domNodes` array returned by `getSnapshot`.
             */
            nodeIndex: integer[];

            /**
             * Index into the `computedStyles` array returned by `captureSnapshot`.
             */
            styles: ArrayOfStrings[];

            /**
             * The absolute position bounding box.
             */
            bounds: Rectangle[];

            /**
             * Contents of the LayoutText, if any.
             */
            text: StringIndex[];

            /**
             * Stacking context information.
             */
            stackingContexts: RareBooleanData;
        }

        /**
         * Details of post layout rendered text positions. The exact layout should not be regarded as
         * stable and may change between versions.
         */
        export interface TextBoxSnapshot {
            /**
             * Intex of th elayout tree node that owns this box collection.
             */
            layoutIndex: integer[];

            /**
             * The absolute position bounding box.
             */
            bounds: Rectangle[];

            /**
             * The starting index in characters, for this post layout textbox substring. Characters that
             * would be represented as a surrogate pair in UTF-16 have length 2.
             */
            start: integer[];

            /**
             * The number of characters in this post layout textbox substring. Characters that would be
             * represented as a surrogate pair in UTF-16 have length 2.
             */
            length: integer[];
        }

        export interface GetSnapshotRequest {
            /**
             * Whitelist of computed styles to return.
             */
            computedStyleWhitelist: string[];

            /**
             * Whether or not to retrieve details of DOM listeners (default false).
             */
            includeEventListeners?: boolean;

            /**
             * Whether to determine and include the paint order index of LayoutTreeNodes (default false).
             */
            includePaintOrder?: boolean;

            /**
             * Whether to include UA shadow tree in the snapshot (default false).
             */
            includeUserAgentShadowTree?: boolean;
        }

        export interface GetSnapshotResponse {
            /**
             * The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document.
             */
            domNodes: DOMNode[];

            /**
             * The nodes in the layout tree.
             */
            layoutTreeNodes: LayoutTreeNode[];

            /**
             * Whitelisted ComputedStyle properties for each node in the layout tree.
             */
            computedStyles: ComputedStyle[];
        }

        export interface CaptureSnapshotRequest {
            /**
             * Whitelist of computed styles to return.
             */
            computedStyles: string[];
        }

        export interface CaptureSnapshotResponse {
            /**
             * The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document.
             */
            documents: DocumentSnapshot[];

            /**
             * Shared string table that all string properties refer to with indexes.
             */
            strings: string[];
        }
    }

    export interface DOMSnapshotApi {
        /**
         * Disables DOM snapshot agent for the given page.
         */
        disable(): Promise<void>;

        /**
         * Enables DOM snapshot agent for the given page.
         */
        enable(): Promise<void>;

        /**
         * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
         * template contents, and imported documents) in a flattened array, as well as layout and
         * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
         * flattened.
         */
        getSnapshot(params: DOMSnapshot.GetSnapshotRequest): Promise<DOMSnapshot.GetSnapshotResponse>;

        /**
         * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
         * template contents, and imported documents) in a flattened array, as well as layout and
         * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
         * flattened.
         */
        captureSnapshot(params: DOMSnapshot.CaptureSnapshotRequest): Promise<DOMSnapshot.CaptureSnapshotResponse>;
    }

    /**
     * Query and modify DOM storage.
     */
    export namespace DOMStorage {

        /**
         * DOM Storage identifier.
         */
        export interface StorageId {
            /**
             * Security origin for the storage.
             */
            securityOrigin: string;

            /**
             * Whether the storage is local storage (not session storage).
             */
            isLocalStorage: boolean;
        }

        /**
         * DOM Storage item.
         */
        export type Item = string[];

        export interface ClearRequest {
            storageId: StorageId;
        }

        export interface GetDOMStorageItemsRequest {
            storageId: StorageId;
        }

        export interface GetDOMStorageItemsResponse {
            entries: Item[];
        }

        export interface RemoveDOMStorageItemRequest {
            storageId: StorageId;

            key: string;
        }

        export interface SetDOMStorageItemRequest {
            storageId: StorageId;

            key: string;

            value: string;
        }

        export interface DomStorageItemAddedEvent {
            storageId: StorageId;

            key: string;

            newValue: string;
        }

        export interface DomStorageItemRemovedEvent {
            storageId: StorageId;

            key: string;
        }

        export interface DomStorageItemUpdatedEvent {
            storageId: StorageId;

            key: string;

            oldValue: string;

            newValue: string;
        }

        export interface DomStorageItemsClearedEvent {
            storageId: StorageId;
        }
    }

    export interface DOMStorageApi {
        clear(params: DOMStorage.ClearRequest): Promise<void>;

        /**
         * Disables storage tracking, prevents storage events from being sent to the client.
         */
        disable(): Promise<void>;

        /**
         * Enables storage tracking, storage events will now be delivered to the client.
         */
        enable(): Promise<void>;

        getDOMStorageItems(params: DOMStorage.GetDOMStorageItemsRequest): Promise<DOMStorage.GetDOMStorageItemsResponse>;

        removeDOMStorageItem(params: DOMStorage.RemoveDOMStorageItemRequest): Promise<void>;

        setDOMStorageItem(params: DOMStorage.SetDOMStorageItemRequest): Promise<void>;

        on(event: 'domStorageItemAdded', listener: (params: DOMStorage.DomStorageItemAddedEvent) => void): void;

        on(event: 'domStorageItemRemoved', listener: (params: DOMStorage.DomStorageItemRemovedEvent) => void): void;

        on(event: 'domStorageItemUpdated', listener: (params: DOMStorage.DomStorageItemUpdatedEvent) => void): void;

        on(event: 'domStorageItemsCleared', listener: (params: DOMStorage.DomStorageItemsClearedEvent) => void): void;
    }

    export namespace Database {

        /**
         * Unique identifier of Database object.
         */
        export type DatabaseId = string;

        /**
         * Database object.
         */
        export interface Database {
            /**
             * Database ID.
             */
            id: DatabaseId;

            /**
             * Database domain.
             */
            domain: string;

            /**
             * Database name.
             */
            name: string;

            /**
             * Database version.
             */
            version: string;
        }

        /**
         * Database error.
         */
        export interface Error {
            /**
             * Error message.
             */
            message: string;

            /**
             * Error code.
             */
            code: integer;
        }

        export interface ExecuteSQLRequest {
            databaseId: DatabaseId;

            query: string;
        }

        export interface ExecuteSQLResponse {
            columnNames?: string[];

            values?: any[];

            sqlError?: Error;
        }

        export interface GetDatabaseTableNamesRequest {
            databaseId: DatabaseId;
        }

        export interface GetDatabaseTableNamesResponse {
            tableNames: string[];
        }

        export interface AddDatabaseEvent {
            database: Database;
        }
    }

    export interface DatabaseApi {
        /**
         * Disables database tracking, prevents database events from being sent to the client.
         */
        disable(): Promise<void>;

        /**
         * Enables database tracking, database events will now be delivered to the client.
         */
        enable(): Promise<void>;

        executeSQL(params: Database.ExecuteSQLRequest): Promise<Database.ExecuteSQLResponse>;

        getDatabaseTableNames(params: Database.GetDatabaseTableNamesRequest): Promise<Database.GetDatabaseTableNamesResponse>;

        on(event: 'addDatabase', listener: (params: Database.AddDatabaseEvent) => void): void;
    }

    export namespace DeviceOrientation {

        export interface SetDeviceOrientationOverrideRequest {
            /**
             * Mock alpha
             */
            alpha: number;

            /**
             * Mock beta
             */
            beta: number;

            /**
             * Mock gamma
             */
            gamma: number;
        }
    }

    export interface DeviceOrientationApi {
        /**
         * Clears the overridden Device Orientation.
         */
        clearDeviceOrientationOverride(): Promise<void>;

        /**
         * Overrides the Device Orientation.
         */
        setDeviceOrientationOverride(params: DeviceOrientation.SetDeviceOrientationOverrideRequest): Promise<void>;
    }

    /**
     * This domain emulates different environments for the page.
     */
    export namespace Emulation {

        /**
         * Screen orientation.
         */
        export interface ScreenOrientation {
            /**
             * Orientation type.
             */
            type: ('portraitPrimary' | 'portraitSecondary' | 'landscapePrimary' | 'landscapeSecondary');

            /**
             * Orientation angle.
             */
            angle: integer;
        }

        /**
         * advance: If the scheduler runs out of immediate work, the virtual time base may fast forward to
         * allow the next delayed task (if any) to run; pause: The virtual time base may not advance;
         * pauseIfNetworkFetchesPending: The virtual time base may not advance if there are any pending
         * resource fetches.
         */
        export type VirtualTimePolicy = ('advance' | 'pause' | 'pauseIfNetworkFetchesPending');

        export interface CanEmulateResponse {
            /**
             * True if emulation is supported.
             */
            result: boolean;
        }

        export interface SetCPUThrottlingRateRequest {
            /**
             * Throttling rate as a slowdown factor (1 is no throttle, 2 is 2x slowdown, etc).
             */
            rate: number;
        }

        export interface SetDefaultBackgroundColorOverrideRequest {
            /**
             * RGBA of the default background color. If not specified, any existing override will be
             * cleared.
             */
            color?: DOM.RGBA;
        }

        export interface SetDeviceMetricsOverrideRequest {
            /**
             * Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.
             */
            width: integer;

            /**
             * Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.
             */
            height: integer;

            /**
             * Overriding device scale factor value. 0 disables the override.
             */
            deviceScaleFactor: number;

            /**
             * Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text
             * autosizing and more.
             */
            mobile: boolean;

            /**
             * Scale to apply to resulting view image.
             */
            scale?: number;

            /**
             * Overriding screen width value in pixels (minimum 0, maximum 10000000).
             */
            screenWidth?: integer;

            /**
             * Overriding screen height value in pixels (minimum 0, maximum 10000000).
             */
            screenHeight?: integer;

            /**
             * Overriding view X position on screen in pixels (minimum 0, maximum 10000000).
             */
            positionX?: integer;

            /**
             * Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).
             */
            positionY?: integer;

            /**
             * Do not set visible view size, rely upon explicit setVisibleSize call.
             */
            dontSetVisibleSize?: boolean;

            /**
             * Screen orientation override.
             */
            screenOrientation?: ScreenOrientation;

            /**
             * If set, the visible area of the page will be overridden to this viewport. This viewport
             * change is not observed by the page, e.g. viewport-relative elements do not change positions.
             */
            viewport?: Page.Viewport;
        }

        export interface SetScrollbarsHiddenRequest {
            /**
             * Whether scrollbars should be always hidden.
             */
            hidden: boolean;
        }

        export interface SetDocumentCookieDisabledRequest {
            /**
             * Whether document.coookie API should be disabled.
             */
            disabled: boolean;
        }

        export interface SetEmitTouchEventsForMouseRequest {
            /**
             * Whether touch emulation based on mouse input should be enabled.
             */
            enabled: boolean;

            /**
             * Touch/gesture events configuration. Default: current platform.
             */
            configuration?: ('mobile' | 'desktop');
        }

        export interface SetEmulatedMediaRequest {
            /**
             * Media type to emulate. Empty string disables the override.
             */
            media: string;
        }

        export interface SetGeolocationOverrideRequest {
            /**
             * Mock latitude
             */
            latitude?: number;

            /**
             * Mock longitude
             */
            longitude?: number;

            /**
             * Mock accuracy
             */
            accuracy?: number;
        }

        export interface SetNavigatorOverridesRequest {
            /**
             * The platform navigator.platform should return.
             */
            platform: string;
        }

        export interface SetPageScaleFactorRequest {
            /**
             * Page scale factor.
             */
            pageScaleFactor: number;
        }

        export interface SetScriptExecutionDisabledRequest {
            /**
             * Whether script execution should be disabled in the page.
             */
            value: boolean;
        }

        export interface SetTouchEmulationEnabledRequest {
            /**
             * Whether the touch event emulation should be enabled.
             */
            enabled: boolean;

            /**
             * Maximum touch points supported. Defaults to one.
             */
            maxTouchPoints?: integer;
        }

        export interface SetVirtualTimePolicyRequest {
            policy: VirtualTimePolicy;

            /**
             * If set, after this many virtual milliseconds have elapsed virtual time will be paused and a
             * virtualTimeBudgetExpired event is sent.
             */
            budget?: number;

            /**
             * If set this specifies the maximum number of tasks that can be run before virtual is forced
             * forwards to prevent deadlock.
             */
            maxVirtualTimeTaskStarvationCount?: integer;

            /**
             * If set the virtual time policy change should be deferred until any frame starts navigating.
             * Note any previous deferred policy change is superseded.
             */
            waitForNavigation?: boolean;

            /**
             * If set, base::Time::Now will be overriden to initially return this value.
             */
            initialVirtualTime?: Network.TimeSinceEpoch;
        }

        export interface SetVirtualTimePolicyResponse {
            /**
             * Absolute timestamp at which virtual time was first enabled (up time in milliseconds).
             */
            virtualTimeTicksBase: number;
        }

        export interface SetVisibleSizeRequest {
            /**
             * Frame width (DIP).
             */
            width: integer;

            /**
             * Frame height (DIP).
             */
            height: integer;
        }

        export interface SetUserAgentOverrideRequest {
            /**
             * User agent to use.
             */
            userAgent: string;

            /**
             * Browser langugage to emulate.
             */
            acceptLanguage?: string;

            /**
             * The platform navigator.platform should return.
             */
            platform?: string;
        }

        export interface VirtualTimeAdvancedEvent {
            /**
             * The amount of virtual time that has elapsed in milliseconds since virtual time was first
             * enabled.
             */
            virtualTimeElapsed: number;
        }

        export interface VirtualTimePausedEvent {
            /**
             * The amount of virtual time that has elapsed in milliseconds since virtual time was first
             * enabled.
             */
            virtualTimeElapsed: number;
        }
    }

    export interface EmulationApi {
        /**
         * Tells whether emulation is supported.
         */
        canEmulate(): Promise<Emulation.CanEmulateResponse>;

        /**
         * Clears the overriden device metrics.
         */
        clearDeviceMetricsOverride(): Promise<void>;

        /**
         * Clears the overriden Geolocation Position and Error.
         */
        clearGeolocationOverride(): Promise<void>;

        /**
         * Requests that page scale factor is reset to initial values.
         */
        resetPageScaleFactor(): Promise<void>;

        /**
         * Enables CPU throttling to emulate slow CPUs.
         */
        setCPUThrottlingRate(params: Emulation.SetCPUThrottlingRateRequest): Promise<void>;

        /**
         * Sets or clears an override of the default background color of the frame. This override is used
         * if the content does not specify one.
         */
        setDefaultBackgroundColorOverride(params: Emulation.SetDefaultBackgroundColorOverrideRequest): Promise<void>;

        /**
         * Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
         * window.innerWidth, window.innerHeight, and "device-width"/"device-height"-related CSS media
         * query results).
         */
        setDeviceMetricsOverride(params: Emulation.SetDeviceMetricsOverrideRequest): Promise<void>;

        setScrollbarsHidden(params: Emulation.SetScrollbarsHiddenRequest): Promise<void>;

        setDocumentCookieDisabled(params: Emulation.SetDocumentCookieDisabledRequest): Promise<void>;

        setEmitTouchEventsForMouse(params: Emulation.SetEmitTouchEventsForMouseRequest): Promise<void>;

        /**
         * Emulates the given media for CSS media queries.
         */
        setEmulatedMedia(params: Emulation.SetEmulatedMediaRequest): Promise<void>;

        /**
         * Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position
         * unavailable.
         */
        setGeolocationOverride(params: Emulation.SetGeolocationOverrideRequest): Promise<void>;

        /**
         * Overrides value returned by the javascript navigator object.
         */
        setNavigatorOverrides(params: Emulation.SetNavigatorOverridesRequest): Promise<void>;

        /**
         * Sets a specified page scale factor.
         */
        setPageScaleFactor(params: Emulation.SetPageScaleFactorRequest): Promise<void>;

        /**
         * Switches script execution in the page.
         */
        setScriptExecutionDisabled(params: Emulation.SetScriptExecutionDisabledRequest): Promise<void>;

        /**
         * Enables touch on platforms which do not support them.
         */
        setTouchEmulationEnabled(params: Emulation.SetTouchEmulationEnabledRequest): Promise<void>;

        /**
         * Turns on virtual time for all frames (replacing real-time with a synthetic time source) and sets
         * the current virtual time policy.  Note this supersedes any previous time budget.
         */
        setVirtualTimePolicy(params: Emulation.SetVirtualTimePolicyRequest): Promise<Emulation.SetVirtualTimePolicyResponse>;

        /**
         * Resizes the frame/viewport of the page. Note that this does not affect the frame's container
         * (e.g. browser window). Can be used to produce screenshots of the specified size. Not supported
         * on Android.
         */
        setVisibleSize(params: Emulation.SetVisibleSizeRequest): Promise<void>;

        /**
         * Allows overriding user agent with the given string.
         */
        setUserAgentOverride(params: Emulation.SetUserAgentOverrideRequest): Promise<void>;

        /**
         * Notification sent after the virtual time has advanced.
         */
        on(event: 'virtualTimeAdvanced', listener: (params: Emulation.VirtualTimeAdvancedEvent) => void): void;

        /**
         * Notification sent after the virtual time budget for the current VirtualTimePolicy has run out.
         */
        on(event: 'virtualTimeBudgetExpired', listener: () => void): void;

        /**
         * Notification sent after the virtual time has paused.
         */
        on(event: 'virtualTimePaused', listener: (params: Emulation.VirtualTimePausedEvent) => void): void;
    }

    /**
     * This domain provides experimental commands only supported in headless mode.
     */
    export namespace HeadlessExperimental {

        /**
         * Encoding options for a screenshot.
         */
        export interface ScreenshotParams {
            /**
             * Image compression format (defaults to png).
             */
            format?: ('jpeg' | 'png');

            /**
             * Compression quality from range [0..100] (jpeg only).
             */
            quality?: integer;
        }

        export interface BeginFrameRequest {
            /**
             * Timestamp of this BeginFrame in Renderer TimeTicks (milliseconds of uptime). If not set,
             * the current time will be used.
             */
            frameTimeTicks?: number;

            /**
             * The interval between BeginFrames that is reported to the compositor, in milliseconds.
             * Defaults to a 60 frames/second interval, i.e. about 16.666 milliseconds.
             */
            interval?: number;

            /**
             * Whether updates should not be committed and drawn onto the display. False by default. If
             * true, only side effects of the BeginFrame will be run, such as layout and animations, but
             * any visual updates may not be visible on the display or in screenshots.
             */
            noDisplayUpdates?: boolean;

            /**
             * If set, a screenshot of the frame will be captured and returned in the response. Otherwise,
             * no screenshot will be captured. Note that capturing a screenshot can fail, for example,
             * during renderer initialization. In such a case, no screenshot data will be returned.
             */
            screenshot?: ScreenshotParams;
        }

        export interface BeginFrameResponse {
            /**
             * Whether the BeginFrame resulted in damage and, thus, a new frame was committed to the
             * display. Reported for diagnostic uses, may be removed in the future.
             */
            hasDamage: boolean;

            /**
             * Base64-encoded image data of the screenshot, if one was requested and successfully taken.
             */
            screenshotData?: string;
        }

        export interface NeedsBeginFramesChangedEvent {
            /**
             * True if BeginFrames are needed, false otherwise.
             */
            needsBeginFrames: boolean;
        }
    }

    export interface HeadlessExperimentalApi {
        /**
         * Sends a BeginFrame to the target and returns when the frame was completed. Optionally captures a
         * screenshot from the resulting frame. Requires that the target was created with enabled
         * BeginFrameControl. Designed for use with --run-all-compositor-stages-before-draw, see also
         * https://goo.gl/3zHXhB for more background.
         */
        beginFrame(params: HeadlessExperimental.BeginFrameRequest): Promise<HeadlessExperimental.BeginFrameResponse>;

        /**
         * Disables headless events for the target.
         */
        disable(): Promise<void>;

        /**
         * Enables headless events for the target.
         */
        enable(): Promise<void>;

        /**
         * Issued when the target starts or stops needing BeginFrames.
         */
        on(event: 'needsBeginFramesChanged', listener: (params: HeadlessExperimental.NeedsBeginFramesChangedEvent) => void): void;
    }

    /**
     * Input/Output operations for streams produced by DevTools.
     */
    export namespace IO {

        /**
         * This is either obtained from another method or specifed as `blob:&lt;uuid&gt;` where
         * `&lt;uuid&gt` is an UUID of a Blob.
         */
        export type StreamHandle = string;

        export interface CloseRequest {
            /**
             * Handle of the stream to close.
             */
            handle: StreamHandle;
        }

        export interface ReadRequest {
            /**
             * Handle of the stream to read.
             */
            handle: StreamHandle;

            /**
             * Seek to the specified offset before reading (if not specificed, proceed with offset
             * following the last read). Some types of streams may only support sequential reads.
             */
            offset?: integer;

            /**
             * Maximum number of bytes to read (left upon the agent discretion if not specified).
             */
            size?: integer;
        }

        export interface ReadResponse {
            /**
             * Set if the data is base64-encoded
             */
            base64Encoded?: boolean;

            /**
             * Data that were read.
             */
            data: string;

            /**
             * Set if the end-of-file condition occured while reading.
             */
            eof: boolean;
        }

        export interface ResolveBlobRequest {
            /**
             * Object id of a Blob object wrapper.
             */
            objectId: Runtime.RemoteObjectId;
        }

        export interface ResolveBlobResponse {
            /**
             * UUID of the specified Blob.
             */
            uuid: string;
        }
    }

    export interface IOApi {
        /**
         * Close the stream, discard any temporary backing storage.
         */
        close(params: IO.CloseRequest): Promise<void>;

        /**
         * Read a chunk of the stream
         */
        read(params: IO.ReadRequest): Promise<IO.ReadResponse>;

        /**
         * Return UUID of Blob object specified by a remote object id.
         */
        resolveBlob(params: IO.ResolveBlobRequest): Promise<IO.ResolveBlobResponse>;
    }

    export namespace IndexedDB {

        /**
         * Database with an array of object stores.
         */
        export interface DatabaseWithObjectStores {
            /**
             * Database name.
             */
            name: string;

            /**
             * Database version.
             */
            version: integer;

            /**
             * Object stores in this database.
             */
            objectStores: ObjectStore[];
        }

        /**
         * Object store.
         */
        export interface ObjectStore {
            /**
             * Object store name.
             */
            name: string;

            /**
             * Object store key path.
             */
            keyPath: KeyPath;

            /**
             * If true, object store has auto increment flag set.
             */
            autoIncrement: boolean;

            /**
             * Indexes in this object store.
             */
            indexes: ObjectStoreIndex[];
        }

        /**
         * Object store index.
         */
        export interface ObjectStoreIndex {
            /**
             * Index name.
             */
            name: string;

            /**
             * Index key path.
             */
            keyPath: KeyPath;

            /**
             * If true, index is unique.
             */
            unique: boolean;

            /**
             * If true, index allows multiple entries for a key.
             */
            multiEntry: boolean;
        }

        /**
         * Key.
         */
        export interface Key {
            /**
             * Key type.
             */
            type: ('number' | 'string' | 'date' | 'array');

            /**
             * Number value.
             */
            number?: number;

            /**
             * String value.
             */
            string?: string;

            /**
             * Date value.
             */
            date?: number;

            /**
             * Array value.
             */
            array?: Key[];
        }

        /**
         * Key range.
         */
        export interface KeyRange {
            /**
             * Lower bound.
             */
            lower?: Key;

            /**
             * Upper bound.
             */
            upper?: Key;

            /**
             * If true lower bound is open.
             */
            lowerOpen: boolean;

            /**
             * If true upper bound is open.
             */
            upperOpen: boolean;
        }

        /**
         * Data entry.
         */
        export interface DataEntry {
            /**
             * Key object.
             */
            key: Runtime.RemoteObject;

            /**
             * Primary key object.
             */
            primaryKey: Runtime.RemoteObject;

            /**
             * Value object.
             */
            value: Runtime.RemoteObject;
        }

        /**
         * Key path.
         */
        export interface KeyPath {
            /**
             * Key path type.
             */
            type: ('null' | 'string' | 'array');

            /**
             * String value.
             */
            string?: string;

            /**
             * Array value.
             */
            array?: string[];
        }

        export interface ClearObjectStoreRequest {
            /**
             * Security origin.
             */
            securityOrigin: string;

            /**
             * Database name.
             */
            databaseName: string;

            /**
             * Object store name.
             */
            objectStoreName: string;
        }

        export interface DeleteDatabaseRequest {
            /**
             * Security origin.
             */
            securityOrigin: string;

            /**
             * Database name.
             */
            databaseName: string;
        }

        export interface DeleteObjectStoreEntriesRequest {
            securityOrigin: string;

            databaseName: string;

            objectStoreName: string;

            /**
             * Range of entry keys to delete
             */
            keyRange: KeyRange;
        }

        export interface RequestDataRequest {
            /**
             * Security origin.
             */
            securityOrigin: string;

            /**
             * Database name.
             */
            databaseName: string;

            /**
             * Object store name.
             */
            objectStoreName: string;

            /**
             * Index name, empty string for object store data requests.
             */
            indexName: string;

            /**
             * Number of records to skip.
             */
            skipCount: integer;

            /**
             * Number of records to fetch.
             */
            pageSize: integer;

            /**
             * Key range.
             */
            keyRange?: KeyRange;
        }

        export interface RequestDataResponse {
            /**
             * Array of object store data entries.
             */
            objectStoreDataEntries: DataEntry[];

            /**
             * If true, there are more entries to fetch in the given range.
             */
            hasMore: boolean;
        }

        export interface RequestDatabaseRequest {
            /**
             * Security origin.
             */
            securityOrigin: string;

            /**
             * Database name.
             */
            databaseName: string;
        }

        export interface RequestDatabaseResponse {
            /**
             * Database with an array of object stores.
             */
            databaseWithObjectStores: DatabaseWithObjectStores;
        }

        export interface RequestDatabaseNamesRequest {
            /**
             * Security origin.
             */
            securityOrigin: string;
        }

        export interface RequestDatabaseNamesResponse {
            /**
             * Database names for origin.
             */
            databaseNames: string[];
        }
    }

    export interface IndexedDBApi {
        /**
         * Clears all entries from an object store.
         */
        clearObjectStore(params: IndexedDB.ClearObjectStoreRequest): Promise<void>;

        /**
         * Deletes a database.
         */
        deleteDatabase(params: IndexedDB.DeleteDatabaseRequest): Promise<void>;

        /**
         * Delete a range of entries from an object store
         */
        deleteObjectStoreEntries(params: IndexedDB.DeleteObjectStoreEntriesRequest): Promise<void>;

        /**
         * Disables events from backend.
         */
        disable(): Promise<void>;

        /**
         * Enables events from backend.
         */
        enable(): Promise<void>;

        /**
         * Requests data from object store or index.
         */
        requestData(params: IndexedDB.RequestDataRequest): Promise<IndexedDB.RequestDataResponse>;

        /**
         * Requests database with given name in given frame.
         */
        requestDatabase(params: IndexedDB.RequestDatabaseRequest): Promise<IndexedDB.RequestDatabaseResponse>;

        /**
         * Requests database names for given security origin.
         */
        requestDatabaseNames(params: IndexedDB.RequestDatabaseNamesRequest): Promise<IndexedDB.RequestDatabaseNamesResponse>;
    }

    export namespace Input {

        export interface TouchPoint {
            /**
             * X coordinate of the event relative to the main frame's viewport in CSS pixels.
             */
            x: number;

            /**
             * Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
             * the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
             */
            y: number;

            /**
             * X radius of the touch area (default: 1.0).
             */
            radiusX?: number;

            /**
             * Y radius of the touch area (default: 1.0).
             */
            radiusY?: number;

            /**
             * Rotation angle (default: 0.0).
             */
            rotationAngle?: number;

            /**
             * Force (default: 1.0).
             */
            force?: number;

            /**
             * Identifier used to track touch sources between events, must be unique within an event.
             */
            id?: number;
        }

        export type GestureSourceType = ('default' | 'touch' | 'mouse');

        /**
         * UTC time in seconds, counted from January 1, 1970.
         */
        export type TimeSinceEpoch = number;

        export interface DispatchKeyEventRequest {
            /**
             * Type of the key event.
             */
            type: ('keyDown' | 'keyUp' | 'rawKeyDown' | 'char');

            /**
             * Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
             * (default: 0).
             */
            modifiers?: integer;

            /**
             * Time at which the event occurred.
             */
            timestamp?: TimeSinceEpoch;

            /**
             * Text as generated by processing a virtual key code with a keyboard layout. Not needed for
             * for `keyUp` and `rawKeyDown` events (default: "")
             */
            text?: string;

            /**
             * Text that would have been generated by the keyboard if no modifiers were pressed (except for
             * shift). Useful for shortcut (accelerator) key handling (default: "").
             */
            unmodifiedText?: string;

            /**
             * Unique key identifier (e.g., 'U+0041') (default: "").
             */
            keyIdentifier?: string;

            /**
             * Unique DOM defined string value for each physical key (e.g., 'KeyA') (default: "").
             */
            code?: string;

            /**
             * Unique DOM defined string value describing the meaning of the key in the context of active
             * modifiers, keyboard layout, etc (e.g., 'AltGr') (default: "").
             */
            key?: string;

            /**
             * Windows virtual key code (default: 0).
             */
            windowsVirtualKeyCode?: integer;

            /**
             * Native virtual key code (default: 0).
             */
            nativeVirtualKeyCode?: integer;

            /**
             * Whether the event was generated from auto repeat (default: false).
             */
            autoRepeat?: boolean;

            /**
             * Whether the event was generated from the keypad (default: false).
             */
            isKeypad?: boolean;

            /**
             * Whether the event was a system key event (default: false).
             */
            isSystemKey?: boolean;

            /**
             * Whether the event was from the left or right side of the keyboard. 1=Left, 2=Right (default:
             * 0).
             */
            location?: integer;
        }

        export interface InsertTextRequest {
            /**
             * The text to insert.
             */
            text: string;
        }

        export interface DispatchMouseEventRequest {
            /**
             * Type of the mouse event.
             */
            type: ('mousePressed' | 'mouseReleased' | 'mouseMoved' | 'mouseWheel');

            /**
             * X coordinate of the event relative to the main frame's viewport in CSS pixels.
             */
            x: number;

            /**
             * Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to
             * the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
             */
            y: number;

            /**
             * Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
             * (default: 0).
             */
            modifiers?: integer;

            /**
             * Time at which the event occurred.
             */
            timestamp?: TimeSinceEpoch;

            /**
             * Mouse button (default: "none").
             */
            button?: ('none' | 'left' | 'middle' | 'right');

            /**
             * Number of times the mouse button was clicked (default: 0).
             */
            clickCount?: integer;

            /**
             * X delta in CSS pixels for mouse wheel event (default: 0).
             */
            deltaX?: number;

            /**
             * Y delta in CSS pixels for mouse wheel event (default: 0).
             */
            deltaY?: number;
        }

        export interface DispatchTouchEventRequest {
            /**
             * Type of the touch event. TouchEnd and TouchCancel must not contain any touch points, while
             * TouchStart and TouchMove must contains at least one.
             */
            type: ('touchStart' | 'touchEnd' | 'touchMove' | 'touchCancel');

            /**
             * Active touch points on the touch device. One event per any changed point (compared to
             * previous touch event in a sequence) is generated, emulating pressing/moving/releasing points
             * one by one.
             */
            touchPoints: TouchPoint[];

            /**
             * Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
             * (default: 0).
             */
            modifiers?: integer;

            /**
             * Time at which the event occurred.
             */
            timestamp?: TimeSinceEpoch;
        }

        export interface EmulateTouchFromMouseEventRequest {
            /**
             * Type of the mouse event.
             */
            type: ('mousePressed' | 'mouseReleased' | 'mouseMoved' | 'mouseWheel');

            /**
             * X coordinate of the mouse pointer in DIP.
             */
            x: integer;

            /**
             * Y coordinate of the mouse pointer in DIP.
             */
            y: integer;

            /**
             * Mouse button.
             */
            button: ('none' | 'left' | 'middle' | 'right');

            /**
             * Time at which the event occurred (default: current time).
             */
            timestamp?: TimeSinceEpoch;

            /**
             * X delta in DIP for mouse wheel event (default: 0).
             */
            deltaX?: number;

            /**
             * Y delta in DIP for mouse wheel event (default: 0).
             */
            deltaY?: number;

            /**
             * Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8
             * (default: 0).
             */
            modifiers?: integer;

            /**
             * Number of times the mouse button was clicked (default: 0).
             */
            clickCount?: integer;
        }

        export interface SetIgnoreInputEventsRequest {
            /**
             * Ignores input events processing when set to true.
             */
            ignore: boolean;
        }

        export interface SynthesizePinchGestureRequest {
            /**
             * X coordinate of the start of the gesture in CSS pixels.
             */
            x: number;

            /**
             * Y coordinate of the start of the gesture in CSS pixels.
             */
            y: number;

            /**
             * Relative scale factor after zooming (>1.0 zooms in, <1.0 zooms out).
             */
            scaleFactor: number;

            /**
             * Relative pointer speed in pixels per second (default: 800).
             */
            relativeSpeed?: integer;

            /**
             * Which type of input events to be generated (default: 'default', which queries the platform
             * for the preferred input type).
             */
            gestureSourceType?: GestureSourceType;
        }

        export interface SynthesizeScrollGestureRequest {
            /**
             * X coordinate of the start of the gesture in CSS pixels.
             */
            x: number;

            /**
             * Y coordinate of the start of the gesture in CSS pixels.
             */
            y: number;

            /**
             * The distance to scroll along the X axis (positive to scroll left).
             */
            xDistance?: number;

            /**
             * The distance to scroll along the Y axis (positive to scroll up).
             */
            yDistance?: number;

            /**
             * The number of additional pixels to scroll back along the X axis, in addition to the given
             * distance.
             */
            xOverscroll?: number;

            /**
             * The number of additional pixels to scroll back along the Y axis, in addition to the given
             * distance.
             */
            yOverscroll?: number;

            /**
             * Prevent fling (default: true).
             */
            preventFling?: boolean;

            /**
             * Swipe speed in pixels per second (default: 800).
             */
            speed?: integer;

            /**
             * Which type of input events to be generated (default: 'default', which queries the platform
             * for the preferred input type).
             */
            gestureSourceType?: GestureSourceType;

            /**
             * The number of times to repeat the gesture (default: 0).
             */
            repeatCount?: integer;

            /**
             * The number of milliseconds delay between each repeat. (default: 250).
             */
            repeatDelayMs?: integer;

            /**
             * The name of the interaction markers to generate, if not empty (default: "").
             */
            interactionMarkerName?: string;
        }

        export interface SynthesizeTapGestureRequest {
            /**
             * X coordinate of the start of the gesture in CSS pixels.
             */
            x: number;

            /**
             * Y coordinate of the start of the gesture in CSS pixels.
             */
            y: number;

            /**
             * Duration between touchdown and touchup events in ms (default: 50).
             */
            duration?: integer;

            /**
             * Number of times to perform the tap (e.g. 2 for double tap, default: 1).
             */
            tapCount?: integer;

            /**
             * Which type of input events to be generated (default: 'default', which queries the platform
             * for the preferred input type).
             */
            gestureSourceType?: GestureSourceType;
        }
    }

    export interface InputApi {
        /**
         * Dispatches a key event to the page.
         */
        dispatchKeyEvent(params: Input.DispatchKeyEventRequest): Promise<void>;

        /**
         * This method emulates inserting text that doesn't come from a key press,
         * for example an emoji keyboard or an IME.
         */
        insertText(params: Input.InsertTextRequest): Promise<void>;

        /**
         * Dispatches a mouse event to the page.
         */
        dispatchMouseEvent(params: Input.DispatchMouseEventRequest): Promise<void>;

        /**
         * Dispatches a touch event to the page.
         */
        dispatchTouchEvent(params: Input.DispatchTouchEventRequest): Promise<void>;

        /**
         * Emulates touch event from the mouse event parameters.
         */
        emulateTouchFromMouseEvent(params: Input.EmulateTouchFromMouseEventRequest): Promise<void>;

        /**
         * Ignores input events (useful while auditing page).
         */
        setIgnoreInputEvents(params: Input.SetIgnoreInputEventsRequest): Promise<void>;

        /**
         * Synthesizes a pinch gesture over a time period by issuing appropriate touch events.
         */
        synthesizePinchGesture(params: Input.SynthesizePinchGestureRequest): Promise<void>;

        /**
         * Synthesizes a scroll gesture over a time period by issuing appropriate touch events.
         */
        synthesizeScrollGesture(params: Input.SynthesizeScrollGestureRequest): Promise<void>;

        /**
         * Synthesizes a tap gesture over a time period by issuing appropriate touch events.
         */
        synthesizeTapGesture(params: Input.SynthesizeTapGestureRequest): Promise<void>;
    }

    export namespace Inspector {

        export interface DetachedEvent {
            /**
             * The reason why connection has been terminated.
             */
            reason: string;
        }
    }

    export interface InspectorApi {
        /**
         * Disables inspector domain notifications.
         */
        disable(): Promise<void>;

        /**
         * Enables inspector domain notifications.
         */
        enable(): Promise<void>;

        /**
         * Fired when remote debugging connection is about to be terminated. Contains detach reason.
         */
        on(event: 'detached', listener: (params: Inspector.DetachedEvent) => void): void;

        /**
         * Fired when debugging target has crashed
         */
        on(event: 'targetCrashed', listener: () => void): void;

        /**
         * Fired when debugging target has reloaded after crash
         */
        on(event: 'targetReloadedAfterCrash', listener: () => void): void;
    }

    export namespace LayerTree {

        /**
         * Unique Layer identifier.
         */
        export type LayerId = string;

        /**
         * Unique snapshot identifier.
         */
        export type SnapshotId = string;

        /**
         * Rectangle where scrolling happens on the main thread.
         */
        export interface ScrollRect {
            /**
             * Rectangle itself.
             */
            rect: DOM.Rect;

            /**
             * Reason for rectangle to force scrolling on the main thread
             */
            type: ('RepaintsOnScroll' | 'TouchEventHandler' | 'WheelEventHandler');
        }

        /**
         * Sticky position constraints.
         */
        export interface StickyPositionConstraint {
            /**
             * Layout rectangle of the sticky element before being shifted
             */
            stickyBoxRect: DOM.Rect;

            /**
             * Layout rectangle of the containing block of the sticky element
             */
            containingBlockRect: DOM.Rect;

            /**
             * The nearest sticky layer that shifts the sticky box
             */
            nearestLayerShiftingStickyBox?: LayerId;

            /**
             * The nearest sticky layer that shifts the containing block
             */
            nearestLayerShiftingContainingBlock?: LayerId;
        }

        /**
         * Serialized fragment of layer picture along with its offset within the layer.
         */
        export interface PictureTile {
            /**
             * Offset from owning layer left boundary
             */
            x: number;

            /**
             * Offset from owning layer top boundary
             */
            y: number;

            /**
             * Base64-encoded snapshot data.
             */
            picture: string;
        }

        /**
         * Information about a compositing layer.
         */
        export interface Layer {
            /**
             * The unique id for this layer.
             */
            layerId: LayerId;

            /**
             * The id of parent (not present for root).
             */
            parentLayerId?: LayerId;

            /**
             * The backend id for the node associated with this layer.
             */
            backendNodeId?: DOM.BackendNodeId;

            /**
             * Offset from parent layer, X coordinate.
             */
            offsetX: number;

            /**
             * Offset from parent layer, Y coordinate.
             */
            offsetY: number;

            /**
             * Layer width.
             */
            width: number;

            /**
             * Layer height.
             */
            height: number;

            /**
             * Transformation matrix for layer, default is identity matrix
             */
            transform?: number[];

            /**
             * Transform anchor point X, absent if no transform specified
             */
            anchorX?: number;

            /**
             * Transform anchor point Y, absent if no transform specified
             */
            anchorY?: number;

            /**
             * Transform anchor point Z, absent if no transform specified
             */
            anchorZ?: number;

            /**
             * Indicates how many time this layer has painted.
             */
            paintCount: integer;

            /**
             * Indicates whether this layer hosts any content, rather than being used for
             * transform/scrolling purposes only.
             */
            drawsContent: boolean;

            /**
             * Set if layer is not visible.
             */
            invisible?: boolean;

            /**
             * Rectangles scrolling on main thread only.
             */
            scrollRects?: ScrollRect[];

            /**
             * Sticky position constraint information
             */
            stickyPositionConstraint?: StickyPositionConstraint;
        }

        /**
         * Array of timings, one per paint step.
         */
        export type PaintProfile = number[];

        export interface CompositingReasonsRequest {
            /**
             * The id of the layer for which we want to get the reasons it was composited.
             */
            layerId: LayerId;
        }

        export interface CompositingReasonsResponse {
            /**
             * A list of strings specifying reasons for the given layer to become composited.
             */
            compositingReasons: string[];
        }

        export interface LoadSnapshotRequest {
            /**
             * An array of tiles composing the snapshot.
             */
            tiles: PictureTile[];
        }

        export interface LoadSnapshotResponse {
            /**
             * The id of the snapshot.
             */
            snapshotId: SnapshotId;
        }

        export interface MakeSnapshotRequest {
            /**
             * The id of the layer.
             */
            layerId: LayerId;
        }

        export interface MakeSnapshotResponse {
            /**
             * The id of the layer snapshot.
             */
            snapshotId: SnapshotId;
        }

        export interface ProfileSnapshotRequest {
            /**
             * The id of the layer snapshot.
             */
            snapshotId: SnapshotId;

            /**
             * The maximum number of times to replay the snapshot (1, if not specified).
             */
            minRepeatCount?: integer;

            /**
             * The minimum duration (in seconds) to replay the snapshot.
             */
            minDuration?: number;

            /**
             * The clip rectangle to apply when replaying the snapshot.
             */
            clipRect?: DOM.Rect;
        }

        export interface ProfileSnapshotResponse {
            /**
             * The array of paint profiles, one per run.
             */
            timings: PaintProfile[];
        }

        export interface ReleaseSnapshotRequest {
            /**
             * The id of the layer snapshot.
             */
            snapshotId: SnapshotId;
        }

        export interface ReplaySnapshotRequest {
            /**
             * The id of the layer snapshot.
             */
            snapshotId: SnapshotId;

            /**
             * The first step to replay from (replay from the very start if not specified).
             */
            fromStep?: integer;

            /**
             * The last step to replay to (replay till the end if not specified).
             */
            toStep?: integer;

            /**
             * The scale to apply while replaying (defaults to 1).
             */
            scale?: number;
        }

        export interface ReplaySnapshotResponse {
            /**
             * A data: URL for resulting image.
             */
            dataURL: string;
        }

        export interface SnapshotCommandLogRequest {
            /**
             * The id of the layer snapshot.
             */
            snapshotId: SnapshotId;
        }

        export interface SnapshotCommandLogResponse {
            /**
             * The array of canvas function calls.
             */
            commandLog: any[];
        }

        export interface LayerPaintedEvent {
            /**
             * The id of the painted layer.
             */
            layerId: LayerId;

            /**
             * Clip rectangle.
             */
            clip: DOM.Rect;
        }

        export interface LayerTreeDidChangeEvent {
            /**
             * Layer tree, absent if not in the comspositing mode.
             */
            layers?: Layer[];
        }
    }

    export interface LayerTreeApi {
        /**
         * Provides the reasons why the given layer was composited.
         */
        compositingReasons(params: LayerTree.CompositingReasonsRequest): Promise<LayerTree.CompositingReasonsResponse>;

        /**
         * Disables compositing tree inspection.
         */
        disable(): Promise<void>;

        /**
         * Enables compositing tree inspection.
         */
        enable(): Promise<void>;

        /**
         * Returns the snapshot identifier.
         */
        loadSnapshot(params: LayerTree.LoadSnapshotRequest): Promise<LayerTree.LoadSnapshotResponse>;

        /**
         * Returns the layer snapshot identifier.
         */
        makeSnapshot(params: LayerTree.MakeSnapshotRequest): Promise<LayerTree.MakeSnapshotResponse>;

        profileSnapshot(params: LayerTree.ProfileSnapshotRequest): Promise<LayerTree.ProfileSnapshotResponse>;

        /**
         * Releases layer snapshot captured by the back-end.
         */
        releaseSnapshot(params: LayerTree.ReleaseSnapshotRequest): Promise<void>;

        /**
         * Replays the layer snapshot and returns the resulting bitmap.
         */
        replaySnapshot(params: LayerTree.ReplaySnapshotRequest): Promise<LayerTree.ReplaySnapshotResponse>;

        /**
         * Replays the layer snapshot and returns canvas log.
         */
        snapshotCommandLog(params: LayerTree.SnapshotCommandLogRequest): Promise<LayerTree.SnapshotCommandLogResponse>;

        on(event: 'layerPainted', listener: (params: LayerTree.LayerPaintedEvent) => void): void;

        on(event: 'layerTreeDidChange', listener: (params: LayerTree.LayerTreeDidChangeEvent) => void): void;
    }

    /**
     * Provides access to log entries.
     */
    export namespace Log {

        /**
         * Log entry.
         */
        export interface LogEntry {
            /**
             * Log entry source.
             */
            source: ('xml' | 'javascript' | 'network' | 'storage' | 'appcache' | 'rendering' | 'security' | 'deprecation' | 'worker' | 'violation' | 'intervention' | 'recommendation' | 'other');

            /**
             * Log entry severity.
             */
            level: ('verbose' | 'info' | 'warning' | 'error');

            /**
             * Logged text.
             */
            text: string;

            /**
             * Timestamp when this entry was added.
             */
            timestamp: Runtime.Timestamp;

            /**
             * URL of the resource if known.
             */
            url?: string;

            /**
             * Line number in the resource.
             */
            lineNumber?: integer;

            /**
             * JavaScript stack trace.
             */
            stackTrace?: Runtime.StackTrace;

            /**
             * Identifier of the network request associated with this entry.
             */
            networkRequestId?: Network.RequestId;

            /**
             * Identifier of the worker associated with this entry.
             */
            workerId?: string;

            /**
             * Call arguments.
             */
            args?: Runtime.RemoteObject[];
        }

        /**
         * Violation configuration setting.
         */
        export interface ViolationSetting {
            /**
             * Violation type.
             */
            name: ('longTask' | 'longLayout' | 'blockedEvent' | 'blockedParser' | 'discouragedAPIUse' | 'handler' | 'recurringHandler');

            /**
             * Time threshold to trigger upon.
             */
            threshold: number;
        }

        export interface StartViolationsReportRequest {
            /**
             * Configuration for violations.
             */
            config: ViolationSetting[];
        }

        export interface EntryAddedEvent {
            /**
             * The entry.
             */
            entry: LogEntry;
        }
    }

    export interface LogApi {
        /**
         * Clears the log.
         */
        clear(): Promise<void>;

        /**
         * Disables log domain, prevents further log entries from being reported to the client.
         */
        disable(): Promise<void>;

        /**
         * Enables log domain, sends the entries collected so far to the client by means of the
         * `entryAdded` notification.
         */
        enable(): Promise<void>;

        /**
         * start violation reporting.
         */
        startViolationsReport(params: Log.StartViolationsReportRequest): Promise<void>;

        /**
         * Stop violation reporting.
         */
        stopViolationsReport(): Promise<void>;

        /**
         * Issued when new message was logged.
         */
        on(event: 'entryAdded', listener: (params: Log.EntryAddedEvent) => void): void;
    }

    export namespace Memory {

        /**
         * Memory pressure level.
         */
        export type PressureLevel = ('moderate' | 'critical');

        /**
         * Heap profile sample.
         */
        export interface SamplingProfileNode {
            /**
             * Size of the sampled allocation.
             */
            size: number;

            /**
             * Total bytes attributed to this sample.
             */
            total: number;

            /**
             * Execution stack at the point of allocation.
             */
            stack: string[];
        }

        /**
         * Array of heap profile samples.
         */
        export interface SamplingProfile {
            samples: SamplingProfileNode[];

            modules: Module[];
        }

        /**
         * Executable module information
         */
        export interface Module {
            /**
             * Name of the module.
             */
            name: string;

            /**
             * UUID of the module.
             */
            uuid: string;

            /**
             * Base address where the module is loaded into memory. Encoded as a decimal
             * or hexadecimal (0x prefixed) string.
             */
            baseAddress: string;

            /**
             * Size of the module in bytes.
             */
            size: number;
        }

        export interface GetDOMCountersResponse {
            documents: integer;

            nodes: integer;

            jsEventListeners: integer;
        }

        export interface SetPressureNotificationsSuppressedRequest {
            /**
             * If true, memory pressure notifications will be suppressed.
             */
            suppressed: boolean;
        }

        export interface SimulatePressureNotificationRequest {
            /**
             * Memory pressure level of the notification.
             */
            level: PressureLevel;
        }

        export interface StartSamplingRequest {
            /**
             * Average number of bytes between samples.
             */
            samplingInterval?: integer;

            /**
             * Do not randomize intervals between samples.
             */
            suppressRandomness?: boolean;
        }

        export interface GetAllTimeSamplingProfileResponse {
            profile: SamplingProfile;
        }

        export interface GetBrowserSamplingProfileResponse {
            profile: SamplingProfile;
        }

        export interface GetSamplingProfileResponse {
            profile: SamplingProfile;
        }
    }

    export interface MemoryApi {
        getDOMCounters(): Promise<Memory.GetDOMCountersResponse>;

        prepareForLeakDetection(): Promise<void>;

        /**
         * Enable/disable suppressing memory pressure notifications in all processes.
         */
        setPressureNotificationsSuppressed(params: Memory.SetPressureNotificationsSuppressedRequest): Promise<void>;

        /**
         * Simulate a memory pressure notification in all processes.
         */
        simulatePressureNotification(params: Memory.SimulatePressureNotificationRequest): Promise<void>;

        /**
         * Start collecting native memory profile.
         */
        startSampling(params: Memory.StartSamplingRequest): Promise<void>;

        /**
         * Stop collecting native memory profile.
         */
        stopSampling(): Promise<void>;

        /**
         * Retrieve native memory allocations profile
         * collected since renderer process startup.
         */
        getAllTimeSamplingProfile(): Promise<Memory.GetAllTimeSamplingProfileResponse>;

        /**
         * Retrieve native memory allocations profile
         * collected since browser process startup.
         */
        getBrowserSamplingProfile(): Promise<Memory.GetBrowserSamplingProfileResponse>;

        /**
         * Retrieve native memory allocations profile collected since last
         * `startSampling` call.
         */
        getSamplingProfile(): Promise<Memory.GetSamplingProfileResponse>;
    }

    /**
     * Network domain allows tracking network activities of the page. It exposes information about http,
     * file, data and other requests and responses, their headers, bodies, timing, etc.
     */
    export namespace Network {

        /**
         * Unique loader identifier.
         */
        export type LoaderId = string;

        /**
         * Unique request identifier.
         */
        export type RequestId = string;

        /**
         * Unique intercepted request identifier.
         */
        export type InterceptionId = string;

        /**
         * Network level fetch failure reason.
         */
        export type ErrorReason = ('Failed' | 'Aborted' | 'TimedOut' | 'AccessDenied' | 'ConnectionClosed' | 'ConnectionReset' | 'ConnectionRefused' | 'ConnectionAborted' | 'ConnectionFailed' | 'NameNotResolved' | 'InternetDisconnected' | 'AddressUnreachable' | 'BlockedByClient' | 'BlockedByResponse');

        /**
         * UTC time in seconds, counted from January 1, 1970.
         */
        export type TimeSinceEpoch = number;

        /**
         * Monotonically increasing time in seconds since an arbitrary point in the past.
         */
        export type MonotonicTime = number;

        /**
         * Request / response headers as keys / values of JSON object.
         */
        export interface Headers {
            [key: string]: string;
        }

        /**
         * The underlying connection technology that the browser is supposedly using.
         */
        export type ConnectionType = ('none' | 'cellular2g' | 'cellular3g' | 'cellular4g' | 'bluetooth' | 'ethernet' | 'wifi' | 'wimax' | 'other');

        /**
         * Represents the cookie's 'SameSite' status:
         * https://tools.ietf.org/html/draft-west-first-party-cookies
         */
        export type CookieSameSite = ('Strict' | 'Lax');

        /**
         * Timing information for the request.
         */
        export interface ResourceTiming {
            /**
             * Timing's requestTime is a baseline in seconds, while the other numbers are ticks in
             * milliseconds relatively to this requestTime.
             */
            requestTime: number;

            /**
             * Started resolving proxy.
             */
            proxyStart: number;

            /**
             * Finished resolving proxy.
             */
            proxyEnd: number;

            /**
             * Started DNS address resolve.
             */
            dnsStart: number;

            /**
             * Finished DNS address resolve.
             */
            dnsEnd: number;

            /**
             * Started connecting to the remote host.
             */
            connectStart: number;

            /**
             * Connected to the remote host.
             */
            connectEnd: number;

            /**
             * Started SSL handshake.
             */
            sslStart: number;

            /**
             * Finished SSL handshake.
             */
            sslEnd: number;

            /**
             * Started running ServiceWorker.
             */
            workerStart: number;

            /**
             * Finished Starting ServiceWorker.
             */
            workerReady: number;

            /**
             * Started sending request.
             */
            sendStart: number;

            /**
             * Finished sending request.
             */
            sendEnd: number;

            /**
             * Time the server started pushing request.
             */
            pushStart: number;

            /**
             * Time the server finished pushing request.
             */
            pushEnd: number;

            /**
             * Finished receiving response headers.
             */
            receiveHeadersEnd: number;
        }

        /**
         * Loading priority of a resource request.
         */
        export type ResourcePriority = ('VeryLow' | 'Low' | 'Medium' | 'High' | 'VeryHigh');

        /**
         * HTTP request data.
         */
        export interface Request {
            /**
             * Request URL (without fragment).
             */
            url: string;

            /**
             * Fragment of the requested URL starting with hash, if present.
             */
            urlFragment?: string;

            /**
             * HTTP request method.
             */
            method: string;

            /**
             * HTTP request headers.
             */
            headers: Headers;

            /**
             * HTTP POST request data.
             */
            postData?: string;

            /**
             * True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.
             */
            hasPostData?: boolean;

            /**
             * The mixed content type of the request.
             */
            mixedContentType?: Security.MixedContentType;

            /**
             * Priority of the resource request at the time request is sent.
             */
            initialPriority: ResourcePriority;

            /**
             * The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
             */
            referrerPolicy: ('unsafe-url' | 'no-referrer-when-downgrade' | 'no-referrer' | 'origin' | 'origin-when-cross-origin' | 'same-origin' | 'strict-origin' | 'strict-origin-when-cross-origin');

            /**
             * Whether is loaded via link preload.
             */
            isLinkPreload?: boolean;
        }

        /**
         * Details of a signed certificate timestamp (SCT).
         */
        export interface SignedCertificateTimestamp {
            /**
             * Validation status.
             */
            status: string;

            /**
             * Origin.
             */
            origin: string;

            /**
             * Log name / description.
             */
            logDescription: string;

            /**
             * Log ID.
             */
            logId: string;

            /**
             * Issuance date.
             */
            timestamp: TimeSinceEpoch;

            /**
             * Hash algorithm.
             */
            hashAlgorithm: string;

            /**
             * Signature algorithm.
             */
            signatureAlgorithm: string;

            /**
             * Signature data.
             */
            signatureData: string;
        }

        /**
         * Security details about a request.
         */
        export interface SecurityDetails {
            /**
             * Protocol name (e.g. "TLS 1.2" or "QUIC").
             */
            protocol: string;

            /**
             * Key Exchange used by the connection, or the empty string if not applicable.
             */
            keyExchange: string;

            /**
             * (EC)DH group used by the connection, if applicable.
             */
            keyExchangeGroup?: string;

            /**
             * Cipher name.
             */
            cipher: string;

            /**
             * TLS MAC. Note that AEAD ciphers do not have separate MACs.
             */
            mac?: string;

            /**
             * Certificate ID value.
             */
            certificateId: Security.CertificateId;

            /**
             * Certificate subject name.
             */
            subjectName: string;

            /**
             * Subject Alternative Name (SAN) DNS names and IP addresses.
             */
            sanList: string[];

            /**
             * Name of the issuing CA.
             */
            issuer: string;

            /**
             * Certificate valid from date.
             */
            validFrom: TimeSinceEpoch;

            /**
             * Certificate valid to (expiration) date
             */
            validTo: TimeSinceEpoch;

            /**
             * List of signed certificate timestamps (SCTs).
             */
            signedCertificateTimestampList: SignedCertificateTimestamp[];

            /**
             * Whether the request complied with Certificate Transparency policy
             */
            certificateTransparencyCompliance: CertificateTransparencyCompliance;
        }

        /**
         * Whether the request complied with Certificate Transparency policy.
         */
        export type CertificateTransparencyCompliance = ('unknown' | 'not-compliant' | 'compliant');

        /**
         * The reason why request was blocked.
         */
        export type BlockedReason = ('other' | 'csp' | 'mixed-content' | 'origin' | 'inspector' | 'subresource-filter' | 'content-type' | 'collapsed-by-client');

        /**
         * HTTP response data.
         */
        export interface Response {
            /**
             * Response URL. This URL can be different from CachedResource.url in case of redirect.
             */
            url: string;

            /**
             * HTTP response status code.
             */
            status: integer;

            /**
             * HTTP response status text.
             */
            statusText: string;

            /**
             * HTTP response headers.
             */
            headers: Headers;

            /**
             * HTTP response headers text.
             */
            headersText?: string;

            /**
             * Resource mimeType as determined by the browser.
             */
            mimeType: string;

            /**
             * Refined HTTP request headers that were actually transmitted over the network.
             */
            requestHeaders?: Headers;

            /**
             * HTTP request headers text.
             */
            requestHeadersText?: string;

            /**
             * Specifies whether physical connection was actually reused for this request.
             */
            connectionReused: boolean;

            /**
             * Physical connection id that was actually used for this request.
             */
            connectionId: number;

            /**
             * Remote IP address.
             */
            remoteIPAddress?: string;

            /**
             * Remote port.
             */
            remotePort?: integer;

            /**
             * Specifies that the request was served from the disk cache.
             */
            fromDiskCache?: boolean;

            /**
             * Specifies that the request was served from the ServiceWorker.
             */
            fromServiceWorker?: boolean;

            /**
             * Total number of bytes received for this request so far.
             */
            encodedDataLength: number;

            /**
             * Timing information for the given request.
             */
            timing?: ResourceTiming;

            /**
             * Protocol used to fetch this request.
             */
            protocol?: string;

            /**
             * Security state of the request resource.
             */
            securityState: Security.SecurityState;

            /**
             * Security details for the request.
             */
            securityDetails?: SecurityDetails;
        }

        /**
         * WebSocket request data.
         */
        export interface WebSocketRequest {
            /**
             * HTTP request headers.
             */
            headers: Headers;
        }

        /**
         * WebSocket response data.
         */
        export interface WebSocketResponse {
            /**
             * HTTP response status code.
             */
            status: integer;

            /**
             * HTTP response status text.
             */
            statusText: string;

            /**
             * HTTP response headers.
             */
            headers: Headers;

            /**
             * HTTP response headers text.
             */
            headersText?: string;

            /**
             * HTTP request headers.
             */
            requestHeaders?: Headers;

            /**
             * HTTP request headers text.
             */
            requestHeadersText?: string;
        }

        /**
         * WebSocket frame data.
         */
        export interface WebSocketFrame {
            /**
             * WebSocket frame opcode.
             */
            opcode: number;

            /**
             * WebSocke frame mask.
             */
            mask: boolean;

            /**
             * WebSocke frame payload data.
             */
            payloadData: string;
        }

        /**
         * Information about the cached resource.
         */
        export interface CachedResource {
            /**
             * Resource URL. This is the url of the original network request.
             */
            url: string;

            /**
             * Type of this resource.
             */
            type: Page.ResourceType;

            /**
             * Cached response data.
             */
            response?: Response;

            /**
             * Cached response body size.
             */
            bodySize: number;
        }

        /**
         * Information about the request initiator.
         */
        export interface Initiator {
            /**
             * Type of this initiator.
             */
            type: ('parser' | 'script' | 'preload' | 'SignedExchange' | 'other');

            /**
             * Initiator JavaScript stack trace, set for Script only.
             */
            stack?: Runtime.StackTrace;

            /**
             * Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.
             */
            url?: string;

            /**
             * Initiator line number, set for Parser type or for Script type (when script is importing
             * module) (0-based).
             */
            lineNumber?: number;
        }

        /**
         * Cookie object
         */
        export interface Cookie {
            /**
             * Cookie name.
             */
            name: string;

            /**
             * Cookie value.
             */
            value: string;

            /**
             * Cookie domain.
             */
            domain: string;

            /**
             * Cookie path.
             */
            path: string;

            /**
             * Cookie expiration date as the number of seconds since the UNIX epoch.
             */
            expires: number;

            /**
             * Cookie size.
             */
            size: integer;

            /**
             * True if cookie is http-only.
             */
            httpOnly: boolean;

            /**
             * True if cookie is secure.
             */
            secure: boolean;

            /**
             * True in case of session cookie.
             */
            session: boolean;

            /**
             * Cookie SameSite type.
             */
            sameSite?: CookieSameSite;
        }

        /**
         * Cookie parameter object
         */
        export interface CookieParam {
            /**
             * Cookie name.
             */
            name: string;

            /**
             * Cookie value.
             */
            value: string;

            /**
             * The request-URI to associate with the setting of the cookie. This value can affect the
             * default domain and path values of the created cookie.
             */
            url?: string;

            /**
             * Cookie domain.
             */
            domain?: string;

            /**
             * Cookie path.
             */
            path?: string;

            /**
             * True if cookie is secure.
             */
            secure?: boolean;

            /**
             * True if cookie is http-only.
             */
            httpOnly?: boolean;

            /**
             * Cookie SameSite type.
             */
            sameSite?: CookieSameSite;

            /**
             * Cookie expiration date, session cookie if not set
             */
            expires?: TimeSinceEpoch;
        }

        /**
         * Authorization challenge for HTTP status code 401 or 407.
         */
        export interface AuthChallenge {
            /**
             * Source of the authentication challenge.
             */
            source?: ('Server' | 'Proxy');

            /**
             * Origin of the challenger.
             */
            origin: string;

            /**
             * The authentication scheme used, such as basic or digest
             */
            scheme: string;

            /**
             * The realm of the challenge. May be empty.
             */
            realm: string;
        }

        /**
         * Response to an AuthChallenge.
         */
        export interface AuthChallengeResponse {
            /**
             * The decision on what to do in response to the authorization challenge.  Default means
             * deferring to the default behavior of the net stack, which will likely either the Cancel
             * authentication or display a popup dialog box.
             */
            response: ('Default' | 'CancelAuth' | 'ProvideCredentials');

            /**
             * The username to provide, possibly empty. Should only be set if response is
             * ProvideCredentials.
             */
            username?: string;

            /**
             * The password to provide, possibly empty. Should only be set if response is
             * ProvideCredentials.
             */
            password?: string;
        }

        /**
         * Stages of the interception to begin intercepting. Request will intercept before the request is
         * sent. Response will intercept after the response is received.
         */
        export type InterceptionStage = ('Request' | 'HeadersReceived');

        /**
         * Request pattern for interception.
         */
        export interface RequestPattern {
            /**
             * Wildcards ('*' -> zero or more, '?' -> exactly one) are allowed. Escape character is
             * backslash. Omitting is equivalent to "*".
             */
            urlPattern?: string;

            /**
             * If set, only requests for matching resource types will be intercepted.
             */
            resourceType?: Page.ResourceType;

            /**
             * Stage at wich to begin intercepting requests. Default is Request.
             */
            interceptionStage?: InterceptionStage;
        }

        /**
         * Information about a signed exchange signature.
         * https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#rfc.section.3.1
         */
        export interface SignedExchangeSignature {
            /**
             * Signed exchange signature label.
             */
            label: string;

            /**
             * The hex string of signed exchange signature.
             */
            signature: string;

            /**
             * Signed exchange signature integrity.
             */
            integrity: string;

            /**
             * Signed exchange signature cert Url.
             */
            certUrl?: string;

            /**
             * The hex string of signed exchange signature cert sha256.
             */
            certSha256?: string;

            /**
             * Signed exchange signature validity Url.
             */
            validityUrl: string;

            /**
             * Signed exchange signature date.
             */
            date: integer;

            /**
             * Signed exchange signature expires.
             */
            expires: integer;

            /**
             * The encoded certificates.
             */
            certificates?: string[];
        }

        /**
         * Information about a signed exchange header.
         * https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#cbor-representation
         */
        export interface SignedExchangeHeader {
            /**
             * Signed exchange request URL.
             */
            requestUrl: string;

            /**
             * Signed exchange request method.
             */
            requestMethod: string;

            /**
             * Signed exchange response code.
             */
            responseCode: integer;

            /**
             * Signed exchange response headers.
             */
            responseHeaders: Headers;

            /**
             * Signed exchange response signature.
             */
            signatures: SignedExchangeSignature[];
        }

        /**
         * Field type for a signed exchange related error.
         */
        export type SignedExchangeErrorField = ('signatureSig' | 'signatureIntegrity' | 'signatureCertUrl' | 'signatureCertSha256' | 'signatureValidityUrl' | 'signatureTimestamps');

        /**
         * Information about a signed exchange response.
         */
        export interface SignedExchangeError {
            /**
             * Error message.
             */
            message: string;

            /**
             * The index of the signature which caused the error.
             */
            signatureIndex?: integer;

            /**
             * The field which caused the error.
             */
            errorField?: SignedExchangeErrorField;
        }

        /**
         * Information about a signed exchange response.
         */
        export interface SignedExchangeInfo {
            /**
             * The outer response of signed HTTP exchange which was received from network.
             */
            outerResponse: Response;

            /**
             * Information about the signed exchange header.
             */
            header?: SignedExchangeHeader;

            /**
             * Security details for the signed exchange header.
             */
            securityDetails?: SecurityDetails;

            /**
             * Errors occurred while handling the signed exchagne.
             */
            errors?: SignedExchangeError[];
        }

        export interface CanClearBrowserCacheResponse {
            /**
             * True if browser cache can be cleared.
             */
            result: boolean;
        }

        export interface CanClearBrowserCookiesResponse {
            /**
             * True if browser cookies can be cleared.
             */
            result: boolean;
        }

        export interface CanEmulateNetworkConditionsResponse {
            /**
             * True if emulation of network conditions is supported.
             */
            result: boolean;
        }

        export interface ContinueInterceptedRequestRequest {
            interceptionId: InterceptionId;

            /**
             * If set this causes the request to fail with the given reason. Passing `Aborted` for requests
             * marked with `isNavigationRequest` also cancels the navigation. Must not be set in response
             * to an authChallenge.
             */
            errorReason?: ErrorReason;

            /**
             * If set the requests completes using with the provided base64 encoded raw response, including
             * HTTP status line and headers etc... Must not be set in response to an authChallenge.
             */
            rawResponse?: string;

            /**
             * If set the request url will be modified in a way that's not observable by page. Must not be
             * set in response to an authChallenge.
             */
            url?: string;

            /**
             * If set this allows the request method to be overridden. Must not be set in response to an
             * authChallenge.
             */
            method?: string;

            /**
             * If set this allows postData to be set. Must not be set in response to an authChallenge.
             */
            postData?: string;

            /**
             * If set this allows the request headers to be changed. Must not be set in response to an
             * authChallenge.
             */
            headers?: Headers;

            /**
             * Response to a requestIntercepted with an authChallenge. Must not be set otherwise.
             */
            authChallengeResponse?: AuthChallengeResponse;
        }

        export interface DeleteCookiesRequest {
            /**
             * Name of the cookies to remove.
             */
            name: string;

            /**
             * If specified, deletes all the cookies with the given name where domain and path match
             * provided URL.
             */
            url?: string;

            /**
             * If specified, deletes only cookies with the exact domain.
             */
            domain?: string;

            /**
             * If specified, deletes only cookies with the exact path.
             */
            path?: string;
        }

        export interface EmulateNetworkConditionsRequest {
            /**
             * True to emulate internet disconnection.
             */
            offline: boolean;

            /**
             * Minimum latency from request sent to response headers received (ms).
             */
            latency: number;

            /**
             * Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.
             */
            downloadThroughput: number;

            /**
             * Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.
             */
            uploadThroughput: number;

            /**
             * Connection type if known.
             */
            connectionType?: ConnectionType;
        }

        export interface EnableRequest {
            /**
             * Buffer size in bytes to use when preserving network payloads (XHRs, etc).
             */
            maxTotalBufferSize?: integer;

            /**
             * Per-resource buffer size in bytes to use when preserving network payloads (XHRs, etc).
             */
            maxResourceBufferSize?: integer;

            /**
             * Longest post body size (in bytes) that would be included in requestWillBeSent notification
             */
            maxPostDataSize?: integer;
        }

        export interface GetAllCookiesResponse {
            /**
             * Array of cookie objects.
             */
            cookies: Cookie[];
        }

        export interface GetCertificateRequest {
            /**
             * Origin to get certificate for.
             */
            origin: string;
        }

        export interface GetCertificateResponse {
            tableNames: string[];
        }

        export interface GetCookiesRequest {
            /**
             * The list of URLs for which applicable cookies will be fetched
             */
            urls?: string[];
        }

        export interface GetCookiesResponse {
            /**
             * Array of cookie objects.
             */
            cookies: Cookie[];
        }

        export interface GetResponseBodyRequest {
            /**
             * Identifier of the network request to get content for.
             */
            requestId: RequestId;
        }

        export interface GetResponseBodyResponse {
            /**
             * Response body.
             */
            body: string;

            /**
             * True, if content was sent as base64.
             */
            base64Encoded: boolean;
        }

        export interface GetRequestPostDataRequest {
            /**
             * Identifier of the network request to get content for.
             */
            requestId: RequestId;
        }

        export interface GetRequestPostDataResponse {
            /**
             * Base64-encoded request body.
             */
            postData: string;
        }

        export interface GetResponseBodyForInterceptionRequest {
            /**
             * Identifier for the intercepted request to get body for.
             */
            interceptionId: InterceptionId;
        }

        export interface GetResponseBodyForInterceptionResponse {
            /**
             * Response body.
             */
            body: string;

            /**
             * True, if content was sent as base64.
             */
            base64Encoded: boolean;
        }

        export interface TakeResponseBodyForInterceptionAsStreamRequest {
            interceptionId: InterceptionId;
        }

        export interface TakeResponseBodyForInterceptionAsStreamResponse {
            stream: IO.StreamHandle;
        }

        export interface ReplayXHRRequest {
            /**
             * Identifier of XHR to replay.
             */
            requestId: RequestId;
        }

        export interface SearchInResponseBodyRequest {
            /**
             * Identifier of the network response to search.
             */
            requestId: RequestId;

            /**
             * String to search for.
             */
            query: string;

            /**
             * If true, search is case sensitive.
             */
            caseSensitive?: boolean;

            /**
             * If true, treats string parameter as regex.
             */
            isRegex?: boolean;
        }

        export interface SearchInResponseBodyResponse {
            /**
             * List of search matches.
             */
            result: Debugger.SearchMatch[];
        }

        export interface SetBlockedURLsRequest {
            /**
             * URL patterns to block. Wildcards ('*') are allowed.
             */
            urls: string[];
        }

        export interface SetBypassServiceWorkerRequest {
            /**
             * Bypass service worker and load from network.
             */
            bypass: boolean;
        }

        export interface SetCacheDisabledRequest {
            /**
             * Cache disabled state.
             */
            cacheDisabled: boolean;
        }

        export interface SetCookieRequest {
            /**
             * Cookie name.
             */
            name: string;

            /**
             * Cookie value.
             */
            value: string;

            /**
             * The request-URI to associate with the setting of the cookie. This value can affect the
             * default domain and path values of the created cookie.
             */
            url?: string;

            /**
             * Cookie domain.
             */
            domain?: string;

            /**
             * Cookie path.
             */
            path?: string;

            /**
             * True if cookie is secure.
             */
            secure?: boolean;

            /**
             * True if cookie is http-only.
             */
            httpOnly?: boolean;

            /**
             * Cookie SameSite type.
             */
            sameSite?: CookieSameSite;

            /**
             * Cookie expiration date, session cookie if not set
             */
            expires?: TimeSinceEpoch;
        }

        export interface SetCookieResponse {
            /**
             * True if successfully set cookie.
             */
            success: boolean;
        }

        export interface SetCookiesRequest {
            /**
             * Cookies to be set.
             */
            cookies: CookieParam[];
        }

        export interface SetDataSizeLimitsForTestRequest {
            /**
             * Maximum total buffer size.
             */
            maxTotalSize: integer;

            /**
             * Maximum per-resource size.
             */
            maxResourceSize: integer;
        }

        export interface SetExtraHTTPHeadersRequest {
            /**
             * Map with extra HTTP headers.
             */
            headers: Headers;
        }

        export interface SetRequestInterceptionRequest {
            /**
             * Requests matching any of these patterns will be forwarded and wait for the corresponding
             * continueInterceptedRequest call.
             */
            patterns: RequestPattern[];
        }

        export interface SetUserAgentOverrideRequest {
            /**
             * User agent to use.
             */
            userAgent: string;

            /**
             * Browser langugage to emulate.
             */
            acceptLanguage?: string;

            /**
             * The platform navigator.platform should return.
             */
            platform?: string;
        }

        export interface DataReceivedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * Data chunk length.
             */
            dataLength: integer;

            /**
             * Actual bytes received (might be less than dataLength for compressed encodings).
             */
            encodedDataLength: integer;
        }

        export interface EventSourceMessageReceivedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * Message type.
             */
            eventName: string;

            /**
             * Message identifier.
             */
            eventId: string;

            /**
             * Message content.
             */
            data: string;
        }

        export interface LoadingFailedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * Resource type.
             */
            type: Page.ResourceType;

            /**
             * User friendly error message.
             */
            errorText: string;

            /**
             * True if loading was canceled.
             */
            canceled?: boolean;

            /**
             * The reason why loading was blocked, if any.
             */
            blockedReason?: BlockedReason;
        }

        export interface LoadingFinishedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * Total number of bytes received for this request.
             */
            encodedDataLength: number;

            /**
             * Set when 1) response was blocked by Cross-Origin Read Blocking and also
             * 2) this needs to be reported to the DevTools console.
             */
            shouldReportCorbBlocking?: boolean;
        }

        export interface RequestInterceptedEvent {
            /**
             * Each request the page makes will have a unique id, however if any redirects are encountered
             * while processing that fetch, they will be reported with the same id as the original fetch.
             * Likewise if HTTP authentication is needed then the same fetch id will be used.
             */
            interceptionId: InterceptionId;

            request: Request;

            /**
             * The id of the frame that initiated the request.
             */
            frameId: Page.FrameId;

            /**
             * How the requested resource will be used.
             */
            resourceType: Page.ResourceType;

            /**
             * Whether this is a navigation request, which can abort the navigation completely.
             */
            isNavigationRequest: boolean;

            /**
             * Set if the request is a navigation that will result in a download.
             * Only present after response is received from the server (i.e. HeadersReceived stage).
             */
            isDownload?: boolean;

            /**
             * Redirect location, only sent if a redirect was intercepted.
             */
            redirectUrl?: string;

            /**
             * Details of the Authorization Challenge encountered. If this is set then
             * continueInterceptedRequest must contain an authChallengeResponse.
             */
            authChallenge?: AuthChallenge;

            /**
             * Response error if intercepted at response stage or if redirect occurred while intercepting
             * request.
             */
            responseErrorReason?: ErrorReason;

            /**
             * Response code if intercepted at response stage or if redirect occurred while intercepting
             * request or auth retry occurred.
             */
            responseStatusCode?: integer;

            /**
             * Response headers if intercepted at the response stage or if redirect occurred while
             * intercepting request or auth retry occurred.
             */
            responseHeaders?: Headers;
        }

        export interface RequestServedFromCacheEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;
        }

        export interface RequestWillBeSentEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Loader identifier. Empty string if the request is fetched from worker.
             */
            loaderId: LoaderId;

            /**
             * URL of the document this request is loaded for.
             */
            documentURL: string;

            /**
             * Request data.
             */
            request: Request;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * Timestamp.
             */
            wallTime: TimeSinceEpoch;

            /**
             * Request initiator.
             */
            initiator: Initiator;

            /**
             * Redirect response data.
             */
            redirectResponse?: Response;

            /**
             * Type of this resource.
             */
            type?: Page.ResourceType;

            /**
             * Frame identifier.
             */
            frameId?: Page.FrameId;

            /**
             * Whether the request is initiated by a user gesture. Defaults to false.
             */
            hasUserGesture?: boolean;
        }

        export interface ResourceChangedPriorityEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * New priority
             */
            newPriority: ResourcePriority;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;
        }

        export interface SignedExchangeReceivedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Information about the signed exchange response.
             */
            info: SignedExchangeInfo;
        }

        export interface ResponseReceivedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Loader identifier. Empty string if the request is fetched from worker.
             */
            loaderId: LoaderId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * Resource type.
             */
            type: Page.ResourceType;

            /**
             * Response data.
             */
            response: Response;

            /**
             * Frame identifier.
             */
            frameId?: Page.FrameId;
        }

        export interface WebSocketClosedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;
        }

        export interface WebSocketCreatedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * WebSocket request URL.
             */
            url: string;

            /**
             * Request initiator.
             */
            initiator?: Initiator;
        }

        export interface WebSocketFrameErrorEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * WebSocket frame error message.
             */
            errorMessage: string;
        }

        export interface WebSocketFrameReceivedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * WebSocket response data.
             */
            response: WebSocketFrame;
        }

        export interface WebSocketFrameSentEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * WebSocket response data.
             */
            response: WebSocketFrame;
        }

        export interface WebSocketHandshakeResponseReceivedEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * WebSocket response data.
             */
            response: WebSocketResponse;
        }

        export interface WebSocketWillSendHandshakeRequestEvent {
            /**
             * Request identifier.
             */
            requestId: RequestId;

            /**
             * Timestamp.
             */
            timestamp: MonotonicTime;

            /**
             * UTC Timestamp.
             */
            wallTime: TimeSinceEpoch;

            /**
             * WebSocket request data.
             */
            request: WebSocketRequest;
        }
    }

    export interface NetworkApi {
        /**
         * Tells whether clearing browser cache is supported.
         */
        canClearBrowserCache(): Promise<Network.CanClearBrowserCacheResponse>;

        /**
         * Tells whether clearing browser cookies is supported.
         */
        canClearBrowserCookies(): Promise<Network.CanClearBrowserCookiesResponse>;

        /**
         * Tells whether emulation of network conditions is supported.
         */
        canEmulateNetworkConditions(): Promise<Network.CanEmulateNetworkConditionsResponse>;

        /**
         * Clears browser cache.
         */
        clearBrowserCache(): Promise<void>;

        /**
         * Clears browser cookies.
         */
        clearBrowserCookies(): Promise<void>;

        /**
         * Response to Network.requestIntercepted which either modifies the request to continue with any
         * modifications, or blocks it, or completes it with the provided response bytes. If a network
         * fetch occurs as a result which encounters a redirect an additional Network.requestIntercepted
         * event will be sent with the same InterceptionId.
         */
        continueInterceptedRequest(params: Network.ContinueInterceptedRequestRequest): Promise<void>;

        /**
         * Deletes browser cookies with matching name and url or domain/path pair.
         */
        deleteCookies(params: Network.DeleteCookiesRequest): Promise<void>;

        /**
         * Disables network tracking, prevents network events from being sent to the client.
         */
        disable(): Promise<void>;

        /**
         * Activates emulation of network conditions.
         */
        emulateNetworkConditions(params: Network.EmulateNetworkConditionsRequest): Promise<void>;

        /**
         * Enables network tracking, network events will now be delivered to the client.
         */
        enable(params: Network.EnableRequest): Promise<void>;

        /**
         * Returns all browser cookies. Depending on the backend support, will return detailed cookie
         * information in the `cookies` field.
         */
        getAllCookies(): Promise<Network.GetAllCookiesResponse>;

        /**
         * Returns the DER-encoded certificate.
         */
        getCertificate(params: Network.GetCertificateRequest): Promise<Network.GetCertificateResponse>;

        /**
         * Returns all browser cookies for the current URL. Depending on the backend support, will return
         * detailed cookie information in the `cookies` field.
         */
        getCookies(params: Network.GetCookiesRequest): Promise<Network.GetCookiesResponse>;

        /**
         * Returns content served for the given request.
         */
        getResponseBody(params: Network.GetResponseBodyRequest): Promise<Network.GetResponseBodyResponse>;

        /**
         * Returns post data sent with the request. Returns an error when no data was sent with the request.
         */
        getRequestPostData(params: Network.GetRequestPostDataRequest): Promise<Network.GetRequestPostDataResponse>;

        /**
         * Returns content served for the given currently intercepted request.
         */
        getResponseBodyForInterception(params: Network.GetResponseBodyForInterceptionRequest): Promise<Network.GetResponseBodyForInterceptionResponse>;

        /**
         * Returns a handle to the stream representing the response body. Note that after this command,
         * the intercepted request can't be continued as is -- you either need to cancel it or to provide
         * the response body. The stream only supports sequential read, IO.read will fail if the position
         * is specified.
         */
        takeResponseBodyForInterceptionAsStream(params: Network.TakeResponseBodyForInterceptionAsStreamRequest): Promise<Network.TakeResponseBodyForInterceptionAsStreamResponse>;

        /**
         * This method sends a new XMLHttpRequest which is identical to the original one. The following
         * parameters should be identical: method, url, async, request body, extra headers, withCredentials
         * attribute, user, password.
         */
        replayXHR(params: Network.ReplayXHRRequest): Promise<void>;

        /**
         * Searches for given string in response content.
         */
        searchInResponseBody(params: Network.SearchInResponseBodyRequest): Promise<Network.SearchInResponseBodyResponse>;

        /**
         * Blocks URLs from loading.
         */
        setBlockedURLs(params: Network.SetBlockedURLsRequest): Promise<void>;

        /**
         * Toggles ignoring of service worker for each request.
         */
        setBypassServiceWorker(params: Network.SetBypassServiceWorkerRequest): Promise<void>;

        /**
         * Toggles ignoring cache for each request. If `true`, cache will not be used.
         */
        setCacheDisabled(params: Network.SetCacheDisabledRequest): Promise<void>;

        /**
         * Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist.
         */
        setCookie(params: Network.SetCookieRequest): Promise<Network.SetCookieResponse>;

        /**
         * Sets given cookies.
         */
        setCookies(params: Network.SetCookiesRequest): Promise<void>;

        /**
         * For testing.
         */
        setDataSizeLimitsForTest(params: Network.SetDataSizeLimitsForTestRequest): Promise<void>;

        /**
         * Specifies whether to always send extra HTTP headers with the requests from this page.
         */
        setExtraHTTPHeaders(params: Network.SetExtraHTTPHeadersRequest): Promise<void>;

        /**
         * Sets the requests to intercept that match a the provided patterns and optionally resource types.
         */
        setRequestInterception(params: Network.SetRequestInterceptionRequest): Promise<void>;

        /**
         * Allows overriding user agent with the given string.
         */
        setUserAgentOverride(params: Network.SetUserAgentOverrideRequest): Promise<void>;

        /**
         * Fired when data chunk was received over the network.
         */
        on(event: 'dataReceived', listener: (params: Network.DataReceivedEvent) => void): void;

        /**
         * Fired when EventSource message is received.
         */
        on(event: 'eventSourceMessageReceived', listener: (params: Network.EventSourceMessageReceivedEvent) => void): void;

        /**
         * Fired when HTTP request has failed to load.
         */
        on(event: 'loadingFailed', listener: (params: Network.LoadingFailedEvent) => void): void;

        /**
         * Fired when HTTP request has finished loading.
         */
        on(event: 'loadingFinished', listener: (params: Network.LoadingFinishedEvent) => void): void;

        /**
         * Details of an intercepted HTTP request, which must be either allowed, blocked, modified or
         * mocked.
         */
        on(event: 'requestIntercepted', listener: (params: Network.RequestInterceptedEvent) => void): void;

        /**
         * Fired if request ended up loading from cache.
         */
        on(event: 'requestServedFromCache', listener: (params: Network.RequestServedFromCacheEvent) => void): void;

        /**
         * Fired when page is about to send HTTP request.
         */
        on(event: 'requestWillBeSent', listener: (params: Network.RequestWillBeSentEvent) => void): void;

        /**
         * Fired when resource loading priority is changed
         */
        on(event: 'resourceChangedPriority', listener: (params: Network.ResourceChangedPriorityEvent) => void): void;

        /**
         * Fired when a signed exchange was received over the network
         */
        on(event: 'signedExchangeReceived', listener: (params: Network.SignedExchangeReceivedEvent) => void): void;

        /**
         * Fired when HTTP response is available.
         */
        on(event: 'responseReceived', listener: (params: Network.ResponseReceivedEvent) => void): void;

        /**
         * Fired when WebSocket is closed.
         */
        on(event: 'webSocketClosed', listener: (params: Network.WebSocketClosedEvent) => void): void;

        /**
         * Fired upon WebSocket creation.
         */
        on(event: 'webSocketCreated', listener: (params: Network.WebSocketCreatedEvent) => void): void;

        /**
         * Fired when WebSocket frame error occurs.
         */
        on(event: 'webSocketFrameError', listener: (params: Network.WebSocketFrameErrorEvent) => void): void;

        /**
         * Fired when WebSocket frame is received.
         */
        on(event: 'webSocketFrameReceived', listener: (params: Network.WebSocketFrameReceivedEvent) => void): void;

        /**
         * Fired when WebSocket frame is sent.
         */
        on(event: 'webSocketFrameSent', listener: (params: Network.WebSocketFrameSentEvent) => void): void;

        /**
         * Fired when WebSocket handshake response becomes available.
         */
        on(event: 'webSocketHandshakeResponseReceived', listener: (params: Network.WebSocketHandshakeResponseReceivedEvent) => void): void;

        /**
         * Fired when WebSocket is about to initiate handshake.
         */
        on(event: 'webSocketWillSendHandshakeRequest', listener: (params: Network.WebSocketWillSendHandshakeRequestEvent) => void): void;
    }

    /**
     * This domain provides various functionality related to drawing atop the inspected page.
     */
    export namespace Overlay {

        /**
         * Configuration data for the highlighting of page elements.
         */
        export interface HighlightConfig {
            /**
             * Whether the node info tooltip should be shown (default: false).
             */
            showInfo?: boolean;

            /**
             * Whether the rulers should be shown (default: false).
             */
            showRulers?: boolean;

            /**
             * Whether the extension lines from node to the rulers should be shown (default: false).
             */
            showExtensionLines?: boolean;

            displayAsMaterial?: boolean;

            /**
             * The content box highlight fill color (default: transparent).
             */
            contentColor?: DOM.RGBA;

            /**
             * The padding highlight fill color (default: transparent).
             */
            paddingColor?: DOM.RGBA;

            /**
             * The border highlight fill color (default: transparent).
             */
            borderColor?: DOM.RGBA;

            /**
             * The margin highlight fill color (default: transparent).
             */
            marginColor?: DOM.RGBA;

            /**
             * The event target element highlight fill color (default: transparent).
             */
            eventTargetColor?: DOM.RGBA;

            /**
             * The shape outside fill color (default: transparent).
             */
            shapeColor?: DOM.RGBA;

            /**
             * The shape margin fill color (default: transparent).
             */
            shapeMarginColor?: DOM.RGBA;

            /**
             * Selectors to highlight relevant nodes.
             */
            selectorList?: string;

            /**
             * The grid layout color (default: transparent).
             */
            cssGridColor?: DOM.RGBA;
        }

        export type InspectMode = ('searchForNode' | 'searchForUAShadowDOM' | 'none');

        export interface GetHighlightObjectForTestRequest {
            /**
             * Id of the node to get highlight object for.
             */
            nodeId: DOM.NodeId;
        }

        export interface GetHighlightObjectForTestResponse {
            /**
             * Highlight data for the node.
             */
            highlight: any;
        }

        export interface HighlightFrameRequest {
            /**
             * Identifier of the frame to highlight.
             */
            frameId: Page.FrameId;

            /**
             * The content box highlight fill color (default: transparent).
             */
            contentColor?: DOM.RGBA;

            /**
             * The content box highlight outline color (default: transparent).
             */
            contentOutlineColor?: DOM.RGBA;
        }

        export interface HighlightNodeRequest {
            /**
             * A descriptor for the highlight appearance.
             */
            highlightConfig: HighlightConfig;

            /**
             * Identifier of the node to highlight.
             */
            nodeId?: DOM.NodeId;

            /**
             * Identifier of the backend node to highlight.
             */
            backendNodeId?: DOM.BackendNodeId;

            /**
             * JavaScript object id of the node to be highlighted.
             */
            objectId?: Runtime.RemoteObjectId;
        }

        export interface HighlightQuadRequest {
            /**
             * Quad to highlight
             */
            quad: DOM.Quad;

            /**
             * The highlight fill color (default: transparent).
             */
            color?: DOM.RGBA;

            /**
             * The highlight outline color (default: transparent).
             */
            outlineColor?: DOM.RGBA;
        }

        export interface HighlightRectRequest {
            /**
             * X coordinate
             */
            x: integer;

            /**
             * Y coordinate
             */
            y: integer;

            /**
             * Rectangle width
             */
            width: integer;

            /**
             * Rectangle height
             */
            height: integer;

            /**
             * The highlight fill color (default: transparent).
             */
            color?: DOM.RGBA;

            /**
             * The highlight outline color (default: transparent).
             */
            outlineColor?: DOM.RGBA;
        }

        export interface SetInspectModeRequest {
            /**
             * Set an inspection mode.
             */
            mode: InspectMode;

            /**
             * A descriptor for the highlight appearance of hovered-over nodes. May be omitted if `enabled
             * == false`.
             */
            highlightConfig?: HighlightConfig;
        }

        export interface SetPausedInDebuggerMessageRequest {
            /**
             * The message to display, also triggers resume and step over controls.
             */
            message?: string;
        }

        export interface SetShowDebugBordersRequest {
            /**
             * True for showing debug borders
             */
            show: boolean;
        }

        export interface SetShowFPSCounterRequest {
            /**
             * True for showing the FPS counter
             */
            show: boolean;
        }

        export interface SetShowPaintRectsRequest {
            /**
             * True for showing paint rectangles
             */
            result: boolean;
        }

        export interface SetShowScrollBottleneckRectsRequest {
            /**
             * True for showing scroll bottleneck rects
             */
            show: boolean;
        }

        export interface SetShowViewportSizeOnResizeRequest {
            /**
             * Whether to paint size or not.
             */
            show: boolean;
        }

        export interface SetSuspendedRequest {
            /**
             * Whether overlay should be suspended and not consume any resources until resumed.
             */
            suspended: boolean;
        }

        export interface InspectNodeRequestedEvent {
            /**
             * Id of the node to inspect.
             */
            backendNodeId: DOM.BackendNodeId;
        }

        export interface NodeHighlightRequestedEvent {
            nodeId: DOM.NodeId;
        }

        export interface ScreenshotRequestedEvent {
            /**
             * Viewport to capture, in CSS.
             */
            viewport: Page.Viewport;
        }
    }

    export interface OverlayApi {
        /**
         * Disables domain notifications.
         */
        disable(): Promise<void>;

        /**
         * Enables domain notifications.
         */
        enable(): Promise<void>;

        /**
         * For testing.
         */
        getHighlightObjectForTest(params: Overlay.GetHighlightObjectForTestRequest): Promise<Overlay.GetHighlightObjectForTestResponse>;

        /**
         * Hides any highlight.
         */
        hideHighlight(): Promise<void>;

        /**
         * Highlights owner element of the frame with given id.
         */
        highlightFrame(params: Overlay.HighlightFrameRequest): Promise<void>;

        /**
         * Highlights DOM node with given id or with the given JavaScript object wrapper. Either nodeId or
         * objectId must be specified.
         */
        highlightNode(params: Overlay.HighlightNodeRequest): Promise<void>;

        /**
         * Highlights given quad. Coordinates are absolute with respect to the main frame viewport.
         */
        highlightQuad(params: Overlay.HighlightQuadRequest): Promise<void>;

        /**
         * Highlights given rectangle. Coordinates are absolute with respect to the main frame viewport.
         */
        highlightRect(params: Overlay.HighlightRectRequest): Promise<void>;

        /**
         * Enters the 'inspect' mode. In this mode, elements that user is hovering over are highlighted.
         * Backend then generates 'inspectNodeRequested' event upon element selection.
         */
        setInspectMode(params: Overlay.SetInspectModeRequest): Promise<void>;

        setPausedInDebuggerMessage(params: Overlay.SetPausedInDebuggerMessageRequest): Promise<void>;

        /**
         * Requests that backend shows debug borders on layers
         */
        setShowDebugBorders(params: Overlay.SetShowDebugBordersRequest): Promise<void>;

        /**
         * Requests that backend shows the FPS counter
         */
        setShowFPSCounter(params: Overlay.SetShowFPSCounterRequest): Promise<void>;

        /**
         * Requests that backend shows paint rectangles
         */
        setShowPaintRects(params: Overlay.SetShowPaintRectsRequest): Promise<void>;

        /**
         * Requests that backend shows scroll bottleneck rects
         */
        setShowScrollBottleneckRects(params: Overlay.SetShowScrollBottleneckRectsRequest): Promise<void>;

        /**
         * Paints viewport size upon main frame resize.
         */
        setShowViewportSizeOnResize(params: Overlay.SetShowViewportSizeOnResizeRequest): Promise<void>;

        setSuspended(params: Overlay.SetSuspendedRequest): Promise<void>;

        /**
         * Fired when the node should be inspected. This happens after call to `setInspectMode` or when
         * user manually inspects an element.
         */
        on(event: 'inspectNodeRequested', listener: (params: Overlay.InspectNodeRequestedEvent) => void): void;

        /**
         * Fired when the node should be highlighted. This happens after call to `setInspectMode`.
         */
        on(event: 'nodeHighlightRequested', listener: (params: Overlay.NodeHighlightRequestedEvent) => void): void;

        /**
         * Fired when user asks to capture screenshot of some area on the page.
         */
        on(event: 'screenshotRequested', listener: (params: Overlay.ScreenshotRequestedEvent) => void): void;
    }

    /**
     * Actions and events related to the inspected page belong to the page domain.
     */
    export namespace Page {

        /**
         * Resource type as it was perceived by the rendering engine.
         */
        export type ResourceType = ('Document' | 'Stylesheet' | 'Image' | 'Media' | 'Font' | 'Script' | 'TextTrack' | 'XHR' | 'Fetch' | 'EventSource' | 'WebSocket' | 'Manifest' | 'SignedExchange' | 'Ping' | 'CSPViolationReport' | 'Other');

        /**
         * Unique frame identifier.
         */
        export type FrameId = string;

        /**
         * Information about the Frame on the page.
         */
        export interface Frame {
            /**
             * Frame unique identifier.
             */
            id: string;

            /**
             * Parent frame identifier.
             */
            parentId?: string;

            /**
             * Identifier of the loader associated with this frame.
             */
            loaderId: Network.LoaderId;

            /**
             * Frame's name as specified in the tag.
             */
            name?: string;

            /**
             * Frame document's URL.
             */
            url: string;

            /**
             * Frame document's security origin.
             */
            securityOrigin: string;

            /**
             * Frame document's mimeType as determined by the browser.
             */
            mimeType: string;

            /**
             * If the frame failed to load, this contains the URL that could not be loaded.
             */
            unreachableUrl?: string;
        }

        /**
         * Information about the Resource on the page.
         */
        export interface FrameResource {
            /**
             * Resource URL.
             */
            url: string;

            /**
             * Type of this resource.
             */
            type: ResourceType;

            /**
             * Resource mimeType as determined by the browser.
             */
            mimeType: string;

            /**
             * last-modified timestamp as reported by server.
             */
            lastModified?: Network.TimeSinceEpoch;

            /**
             * Resource content size.
             */
            contentSize?: number;

            /**
             * True if the resource failed to load.
             */
            failed?: boolean;

            /**
             * True if the resource was canceled during loading.
             */
            canceled?: boolean;
        }

        /**
         * Information about the Frame hierarchy along with their cached resources.
         */
        export interface FrameResourceTree {
            /**
             * Frame information for this tree item.
             */
            frame: Frame;

            /**
             * Child frames.
             */
            childFrames?: FrameResourceTree[];

            /**
             * Information about frame resources.
             */
            resources: FrameResource[];
        }

        /**
         * Information about the Frame hierarchy.
         */
        export interface FrameTree {
            /**
             * Frame information for this tree item.
             */
            frame: Frame;

            /**
             * Child frames.
             */
            childFrames?: FrameTree[];
        }

        /**
         * Unique script identifier.
         */
        export type ScriptIdentifier = string;

        /**
         * Transition type.
         */
        export type TransitionType = ('link' | 'typed' | 'auto_bookmark' | 'auto_subframe' | 'manual_subframe' | 'generated' | 'auto_toplevel' | 'form_submit' | 'reload' | 'keyword' | 'keyword_generated' | 'other');

        /**
         * Navigation history entry.
         */
        export interface NavigationEntry {
            /**
             * Unique id of the navigation history entry.
             */
            id: integer;

            /**
             * URL of the navigation history entry.
             */
            url: string;

            /**
             * URL that the user typed in the url bar.
             */
            userTypedURL: string;

            /**
             * Title of the navigation history entry.
             */
            title: string;

            /**
             * Transition type.
             */
            transitionType: TransitionType;
        }

        /**
         * Screencast frame metadata.
         */
        export interface ScreencastFrameMetadata {
            /**
             * Top offset in DIP.
             */
            offsetTop: number;

            /**
             * Page scale factor.
             */
            pageScaleFactor: number;

            /**
             * Device screen width in DIP.
             */
            deviceWidth: number;

            /**
             * Device screen height in DIP.
             */
            deviceHeight: number;

            /**
             * Position of horizontal scroll in CSS pixels.
             */
            scrollOffsetX: number;

            /**
             * Position of vertical scroll in CSS pixels.
             */
            scrollOffsetY: number;

            /**
             * Frame swap timestamp.
             */
            timestamp?: Network.TimeSinceEpoch;
        }

        /**
         * Javascript dialog type.
         */
        export type DialogType = ('alert' | 'confirm' | 'prompt' | 'beforeunload');

        /**
         * Error while paring app manifest.
         */
        export interface AppManifestError {
            /**
             * Error message.
             */
            message: string;

            /**
             * If criticial, this is a non-recoverable parse error.
             */
            critical: integer;

            /**
             * Error line.
             */
            line: integer;

            /**
             * Error column.
             */
            column: integer;
        }

        /**
         * Layout viewport position and dimensions.
         */
        export interface LayoutViewport {
            /**
             * Horizontal offset relative to the document (CSS pixels).
             */
            pageX: integer;

            /**
             * Vertical offset relative to the document (CSS pixels).
             */
            pageY: integer;

            /**
             * Width (CSS pixels), excludes scrollbar if present.
             */
            clientWidth: integer;

            /**
             * Height (CSS pixels), excludes scrollbar if present.
             */
            clientHeight: integer;
        }

        /**
         * Visual viewport position, dimensions, and scale.
         */
        export interface VisualViewport {
            /**
             * Horizontal offset relative to the layout viewport (CSS pixels).
             */
            offsetX: number;

            /**
             * Vertical offset relative to the layout viewport (CSS pixels).
             */
            offsetY: number;

            /**
             * Horizontal offset relative to the document (CSS pixels).
             */
            pageX: number;

            /**
             * Vertical offset relative to the document (CSS pixels).
             */
            pageY: number;

            /**
             * Width (CSS pixels), excludes scrollbar if present.
             */
            clientWidth: number;

            /**
             * Height (CSS pixels), excludes scrollbar if present.
             */
            clientHeight: number;

            /**
             * Scale relative to the ideal viewport (size at width=device-width).
             */
            scale: number;
        }

        /**
         * Viewport for capturing screenshot.
         */
        export interface Viewport {
            /**
             * X offset in CSS pixels.
             */
            x: number;

            /**
             * Y offset in CSS pixels
             */
            y: number;

            /**
             * Rectangle width in CSS pixels
             */
            width: number;

            /**
             * Rectangle height in CSS pixels
             */
            height: number;

            /**
             * Page scale factor.
             */
            scale: number;
        }

        /**
         * Generic font families collection.
         */
        export interface FontFamilies {
            /**
             * The standard font-family.
             */
            standard?: string;

            /**
             * The fixed font-family.
             */
            fixed?: string;

            /**
             * The serif font-family.
             */
            serif?: string;

            /**
             * The sansSerif font-family.
             */
            sansSerif?: string;

            /**
             * The cursive font-family.
             */
            cursive?: string;

            /**
             * The fantasy font-family.
             */
            fantasy?: string;

            /**
             * The pictograph font-family.
             */
            pictograph?: string;
        }

        /**
         * Default font sizes.
         */
        export interface FontSizes {
            /**
             * Default standard font size.
             */
            standard?: integer;

            /**
             * Default fixed font size.
             */
            fixed?: integer;
        }

        export interface AddScriptToEvaluateOnLoadRequest {
            scriptSource: string;
        }

        export interface AddScriptToEvaluateOnLoadResponse {
            /**
             * Identifier of the added script.
             */
            identifier: ScriptIdentifier;
        }

        export interface AddScriptToEvaluateOnNewDocumentRequest {
            source: string;
        }

        export interface AddScriptToEvaluateOnNewDocumentResponse {
            /**
             * Identifier of the added script.
             */
            identifier: ScriptIdentifier;
        }

        export interface CaptureScreenshotRequest {
            /**
             * Image compression format (defaults to png).
             */
            format?: ('jpeg' | 'png');

            /**
             * Compression quality from range [0..100] (jpeg only).
             */
            quality?: integer;

            /**
             * Capture the screenshot of a given region only.
             */
            clip?: Viewport;

            /**
             * Capture the screenshot from the surface, rather than the view. Defaults to true.
             */
            fromSurface?: boolean;
        }

        export interface CaptureScreenshotResponse {
            /**
             * Base64-encoded image data.
             */
            data: string;
        }

        export interface CreateIsolatedWorldRequest {
            /**
             * Id of the frame in which the isolated world should be created.
             */
            frameId: FrameId;

            /**
             * An optional name which is reported in the Execution Context.
             */
            worldName?: string;

            /**
             * Whether or not universal access should be granted to the isolated world. This is a powerful
             * option, use with caution.
             */
            grantUniveralAccess?: boolean;
        }

        export interface CreateIsolatedWorldResponse {
            /**
             * Execution context of the isolated world.
             */
            executionContextId: Runtime.ExecutionContextId;
        }

        export interface DeleteCookieRequest {
            /**
             * Name of the cookie to remove.
             */
            cookieName: string;

            /**
             * URL to match cooke domain and path.
             */
            url: string;
        }

        export interface GetAppManifestResponse {
            /**
             * Manifest location.
             */
            url: string;

            errors: AppManifestError[];

            /**
             * Manifest content.
             */
            data?: string;
        }

        export interface GetCookiesResponse {
            /**
             * Array of cookie objects.
             */
            cookies: Network.Cookie[];
        }

        export interface GetFrameTreeResponse {
            /**
             * Present frame tree structure.
             */
            frameTree: FrameTree;
        }

        export interface GetLayoutMetricsResponse {
            /**
             * Metrics relating to the layout viewport.
             */
            layoutViewport: LayoutViewport;

            /**
             * Metrics relating to the visual viewport.
             */
            visualViewport: VisualViewport;

            /**
             * Size of scrollable area.
             */
            contentSize: DOM.Rect;
        }

        export interface GetNavigationHistoryResponse {
            /**
             * Index of the current navigation history entry.
             */
            currentIndex: integer;

            /**
             * Array of navigation history entries.
             */
            entries: NavigationEntry[];
        }

        export interface GetResourceContentRequest {
            /**
             * Frame id to get resource for.
             */
            frameId: FrameId;

            /**
             * URL of the resource to get content for.
             */
            url: string;
        }

        export interface GetResourceContentResponse {
            /**
             * Resource content.
             */
            content: string;

            /**
             * True, if content was served as base64.
             */
            base64Encoded: boolean;
        }

        export interface GetResourceTreeResponse {
            /**
             * Present frame / resource tree structure.
             */
            frameTree: FrameResourceTree;
        }

        export interface HandleJavaScriptDialogRequest {
            /**
             * Whether to accept or dismiss the dialog.
             */
            accept: boolean;

            /**
             * The text to enter into the dialog prompt before accepting. Used only if this is a prompt
             * dialog.
             */
            promptText?: string;
        }

        export interface NavigateRequest {
            /**
             * URL to navigate the page to.
             */
            url: string;

            /**
             * Referrer URL.
             */
            referrer?: string;

            /**
             * Intended transition type.
             */
            transitionType?: TransitionType;

            /**
             * Frame id to navigate, if not specified navigates the top frame.
             */
            frameId?: FrameId;
        }

        export interface NavigateResponse {
            /**
             * Frame id that has navigated (or failed to navigate)
             */
            frameId: FrameId;

            /**
             * Loader identifier.
             */
            loaderId?: Network.LoaderId;

            /**
             * User friendly error message, present if and only if navigation has failed.
             */
            errorText?: string;
        }

        export interface NavigateToHistoryEntryRequest {
            /**
             * Unique id of the entry to navigate to.
             */
            entryId: integer;
        }

        export interface PrintToPDFRequest {
            /**
             * Paper orientation. Defaults to false.
             */
            landscape?: boolean;

            /**
             * Display header and footer. Defaults to false.
             */
            displayHeaderFooter?: boolean;

            /**
             * Print background graphics. Defaults to false.
             */
            printBackground?: boolean;

            /**
             * Scale of the webpage rendering. Defaults to 1.
             */
            scale?: number;

            /**
             * Paper width in inches. Defaults to 8.5 inches.
             */
            paperWidth?: number;

            /**
             * Paper height in inches. Defaults to 11 inches.
             */
            paperHeight?: number;

            /**
             * Top margin in inches. Defaults to 1cm (~0.4 inches).
             */
            marginTop?: number;

            /**
             * Bottom margin in inches. Defaults to 1cm (~0.4 inches).
             */
            marginBottom?: number;

            /**
             * Left margin in inches. Defaults to 1cm (~0.4 inches).
             */
            marginLeft?: number;

            /**
             * Right margin in inches. Defaults to 1cm (~0.4 inches).
             */
            marginRight?: number;

            /**
             * Paper ranges to print, e.g., '1-5, 8, 11-13'. Defaults to the empty string, which means
             * print all pages.
             */
            pageRanges?: string;

            /**
             * Whether to silently ignore invalid but successfully parsed page ranges, such as '3-2'.
             * Defaults to false.
             */
            ignoreInvalidPageRanges?: boolean;

            /**
             * HTML template for the print header. Should be valid HTML markup with following
             * classes used to inject printing values into them:
             * - `date`: formatted print date
             * - `title`: document title
             * - `url`: document location
             * - `pageNumber`: current page number
             * - `totalPages`: total pages in the document
             * 
             * For example, `<span class=title></span>` would generate span containing the title.
             */
            headerTemplate?: string;

            /**
             * HTML template for the print footer. Should use the same format as the `headerTemplate`.
             */
            footerTemplate?: string;

            /**
             * Whether or not to prefer page size as defined by css. Defaults to false,
             * in which case the content will be scaled to fit the paper size.
             */
            preferCSSPageSize?: boolean;
        }

        export interface PrintToPDFResponse {
            /**
             * Base64-encoded pdf data.
             */
            data: string;
        }

        export interface ReloadRequest {
            /**
             * If true, browser cache is ignored (as if the user pressed Shift+refresh).
             */
            ignoreCache?: boolean;

            /**
             * If set, the script will be injected into all frames of the inspected page after reload.
             * Argument will be ignored if reloading dataURL origin.
             */
            scriptToEvaluateOnLoad?: string;
        }

        export interface RemoveScriptToEvaluateOnLoadRequest {
            identifier: ScriptIdentifier;
        }

        export interface RemoveScriptToEvaluateOnNewDocumentRequest {
            identifier: ScriptIdentifier;
        }

        export interface ScreencastFrameAckRequest {
            /**
             * Frame number.
             */
            sessionId: integer;
        }

        export interface SearchInResourceRequest {
            /**
             * Frame id for resource to search in.
             */
            frameId: FrameId;

            /**
             * URL of the resource to search in.
             */
            url: string;

            /**
             * String to search for.
             */
            query: string;

            /**
             * If true, search is case sensitive.
             */
            caseSensitive?: boolean;

            /**
             * If true, treats string parameter as regex.
             */
            isRegex?: boolean;
        }

        export interface SearchInResourceResponse {
            /**
             * List of search matches.
             */
            result: Debugger.SearchMatch[];
        }

        export interface SetAdBlockingEnabledRequest {
            /**
             * Whether to block ads.
             */
            enabled: boolean;
        }

        export interface SetBypassCSPRequest {
            /**
             * Whether to bypass page CSP.
             */
            enabled: boolean;
        }

        export interface SetDeviceMetricsOverrideRequest {
            /**
             * Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.
             */
            width: integer;

            /**
             * Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.
             */
            height: integer;

            /**
             * Overriding device scale factor value. 0 disables the override.
             */
            deviceScaleFactor: number;

            /**
             * Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text
             * autosizing and more.
             */
            mobile: boolean;

            /**
             * Scale to apply to resulting view image.
             */
            scale?: number;

            /**
             * Overriding screen width value in pixels (minimum 0, maximum 10000000).
             */
            screenWidth?: integer;

            /**
             * Overriding screen height value in pixels (minimum 0, maximum 10000000).
             */
            screenHeight?: integer;

            /**
             * Overriding view X position on screen in pixels (minimum 0, maximum 10000000).
             */
            positionX?: integer;

            /**
             * Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).
             */
            positionY?: integer;

            /**
             * Do not set visible view size, rely upon explicit setVisibleSize call.
             */
            dontSetVisibleSize?: boolean;

            /**
             * Screen orientation override.
             */
            screenOrientation?: Emulation.ScreenOrientation;

            /**
             * The viewport dimensions and scale. If not set, the override is cleared.
             */
            viewport?: Viewport;
        }

        export interface SetDeviceOrientationOverrideRequest {
            /**
             * Mock alpha
             */
            alpha: number;

            /**
             * Mock beta
             */
            beta: number;

            /**
             * Mock gamma
             */
            gamma: number;
        }

        export interface SetFontFamiliesRequest {
            /**
             * Specifies font families to set. If a font family is not specified, it won't be changed.
             */
            fontFamilies: FontFamilies;
        }

        export interface SetFontSizesRequest {
            /**
             * Specifies font sizes to set. If a font size is not specified, it won't be changed.
             */
            fontSizes: FontSizes;
        }

        export interface SetDocumentContentRequest {
            /**
             * Frame id to set HTML for.
             */
            frameId: FrameId;

            /**
             * HTML content to set.
             */
            html: string;
        }

        export interface SetDownloadBehaviorRequest {
            /**
             * Whether to allow all or deny all download requests, or use default Chrome behavior if
             * available (otherwise deny).
             */
            behavior: ('deny' | 'allow' | 'default');

            /**
             * The default path to save downloaded files to. This is requred if behavior is set to 'allow'
             */
            downloadPath?: string;
        }

        export interface SetGeolocationOverrideRequest {
            /**
             * Mock latitude
             */
            latitude?: number;

            /**
             * Mock longitude
             */
            longitude?: number;

            /**
             * Mock accuracy
             */
            accuracy?: number;
        }

        export interface SetLifecycleEventsEnabledRequest {
            /**
             * If true, starts emitting lifecycle events.
             */
            enabled: boolean;
        }

        export interface SetTouchEmulationEnabledRequest {
            /**
             * Whether the touch event emulation should be enabled.
             */
            enabled: boolean;

            /**
             * Touch/gesture events configuration. Default: current platform.
             */
            configuration?: ('mobile' | 'desktop');
        }

        export interface StartScreencastRequest {
            /**
             * Image compression format.
             */
            format?: ('jpeg' | 'png');

            /**
             * Compression quality from range [0..100].
             */
            quality?: integer;

            /**
             * Maximum screenshot width.
             */
            maxWidth?: integer;

            /**
             * Maximum screenshot height.
             */
            maxHeight?: integer;

            /**
             * Send every n-th frame.
             */
            everyNthFrame?: integer;
        }

        export interface SetWebLifecycleStateRequest {
            /**
             * Target lifecycle state
             */
            state: ('frozen' | 'active');
        }

        export interface SetProduceCompilationCacheRequest {
            enabled: boolean;
        }

        export interface AddCompilationCacheRequest {
            url: string;

            /**
             * Base64-encoded data
             */
            data: string;
        }

        export interface GenerateTestReportRequest {
            /**
             * Message to be displayed in the report.
             */
            message: string;

            /**
             * Specifies the endpoint group to deliver the report to.
             */
            group?: string;
        }

        export interface DomContentEventFiredEvent {
            timestamp: Network.MonotonicTime;
        }

        export interface FrameAttachedEvent {
            /**
             * Id of the frame that has been attached.
             */
            frameId: FrameId;

            /**
             * Parent frame identifier.
             */
            parentFrameId: FrameId;

            /**
             * JavaScript stack trace of when frame was attached, only set if frame initiated from script.
             */
            stack?: Runtime.StackTrace;
        }

        export interface FrameClearedScheduledNavigationEvent {
            /**
             * Id of the frame that has cleared its scheduled navigation.
             */
            frameId: FrameId;
        }

        export interface FrameDetachedEvent {
            /**
             * Id of the frame that has been detached.
             */
            frameId: FrameId;
        }

        export interface FrameNavigatedEvent {
            /**
             * Frame object.
             */
            frame: Frame;
        }

        export interface FrameScheduledNavigationEvent {
            /**
             * Id of the frame that has scheduled a navigation.
             */
            frameId: FrameId;

            /**
             * Delay (in seconds) until the navigation is scheduled to begin. The navigation is not
             * guaranteed to start.
             */
            delay: number;

            /**
             * The reason for the navigation.
             */
            reason: ('formSubmissionGet' | 'formSubmissionPost' | 'httpHeaderRefresh' | 'scriptInitiated' | 'metaTagRefresh' | 'pageBlockInterstitial' | 'reload');

            /**
             * The destination URL for the scheduled navigation.
             */
            url: string;
        }

        export interface FrameStartedLoadingEvent {
            /**
             * Id of the frame that has started loading.
             */
            frameId: FrameId;
        }

        export interface FrameStoppedLoadingEvent {
            /**
             * Id of the frame that has stopped loading.
             */
            frameId: FrameId;
        }

        export interface JavascriptDialogClosedEvent {
            /**
             * Whether dialog was confirmed.
             */
            result: boolean;

            /**
             * User input in case of prompt.
             */
            userInput: string;
        }

        export interface JavascriptDialogOpeningEvent {
            /**
             * Frame url.
             */
            url: string;

            /**
             * Message that will be displayed by the dialog.
             */
            message: string;

            /**
             * Dialog type.
             */
            type: DialogType;

            /**
             * True iff browser is capable showing or acting on the given dialog. When browser has no
             * dialog handler for given target, calling alert while Page domain is engaged will stall
             * the page execution. Execution can be resumed via calling Page.handleJavaScriptDialog.
             */
            hasBrowserHandler: boolean;

            /**
             * Default dialog prompt.
             */
            defaultPrompt?: string;
        }

        export interface LifecycleEventEvent {
            /**
             * Id of the frame.
             */
            frameId: FrameId;

            /**
             * Loader identifier. Empty string if the request is fetched from worker.
             */
            loaderId: Network.LoaderId;

            name: string;

            timestamp: Network.MonotonicTime;
        }

        export interface LoadEventFiredEvent {
            timestamp: Network.MonotonicTime;
        }

        export interface NavigatedWithinDocumentEvent {
            /**
             * Id of the frame.
             */
            frameId: FrameId;

            /**
             * Frame's new url.
             */
            url: string;
        }

        export interface ScreencastFrameEvent {
            /**
             * Base64-encoded compressed image.
             */
            data: string;

            /**
             * Screencast frame metadata.
             */
            metadata: ScreencastFrameMetadata;

            /**
             * Frame number.
             */
            sessionId: integer;
        }

        export interface ScreencastVisibilityChangedEvent {
            /**
             * True if the page is visible.
             */
            visible: boolean;
        }

        export interface WindowOpenEvent {
            /**
             * The URL for the new window.
             */
            url: string;

            /**
             * Window name.
             */
            windowName: string;

            /**
             * An array of enabled window features.
             */
            windowFeatures: string[];

            /**
             * Whether or not it was triggered by user gesture.
             */
            userGesture: boolean;
        }

        export interface CompilationCacheProducedEvent {
            url: string;

            /**
             * Base64-encoded data
             */
            data: string;
        }
    }

    export interface PageApi {
        /**
         * Deprecated, please use addScriptToEvaluateOnNewDocument instead.
         */
        addScriptToEvaluateOnLoad(params: Page.AddScriptToEvaluateOnLoadRequest): Promise<Page.AddScriptToEvaluateOnLoadResponse>;

        /**
         * Evaluates given script in every frame upon creation (before loading frame's scripts).
         */
        addScriptToEvaluateOnNewDocument(params: Page.AddScriptToEvaluateOnNewDocumentRequest): Promise<Page.AddScriptToEvaluateOnNewDocumentResponse>;

        /**
         * Brings page to front (activates tab).
         */
        bringToFront(): Promise<void>;

        /**
         * Capture page screenshot.
         */
        captureScreenshot(params: Page.CaptureScreenshotRequest): Promise<Page.CaptureScreenshotResponse>;

        /**
         * Clears the overriden device metrics.
         */
        clearDeviceMetricsOverride(): Promise<void>;

        /**
         * Clears the overridden Device Orientation.
         */
        clearDeviceOrientationOverride(): Promise<void>;

        /**
         * Clears the overriden Geolocation Position and Error.
         */
        clearGeolocationOverride(): Promise<void>;

        /**
         * Creates an isolated world for the given frame.
         */
        createIsolatedWorld(params: Page.CreateIsolatedWorldRequest): Promise<Page.CreateIsolatedWorldResponse>;

        /**
         * Deletes browser cookie with given name, domain and path.
         */
        deleteCookie(params: Page.DeleteCookieRequest): Promise<void>;

        /**
         * Disables page domain notifications.
         */
        disable(): Promise<void>;

        /**
         * Enables page domain notifications.
         */
        enable(): Promise<void>;

        getAppManifest(): Promise<Page.GetAppManifestResponse>;

        /**
         * Returns all browser cookies. Depending on the backend support, will return detailed cookie
         * information in the `cookies` field.
         */
        getCookies(): Promise<Page.GetCookiesResponse>;

        /**
         * Returns present frame tree structure.
         */
        getFrameTree(): Promise<Page.GetFrameTreeResponse>;

        /**
         * Returns metrics relating to the layouting of the page, such as viewport bounds/scale.
         */
        getLayoutMetrics(): Promise<Page.GetLayoutMetricsResponse>;

        /**
         * Returns navigation history for the current page.
         */
        getNavigationHistory(): Promise<Page.GetNavigationHistoryResponse>;

        /**
         * Returns content of the given resource.
         */
        getResourceContent(params: Page.GetResourceContentRequest): Promise<Page.GetResourceContentResponse>;

        /**
         * Returns present frame / resource tree structure.
         */
        getResourceTree(): Promise<Page.GetResourceTreeResponse>;

        /**
         * Accepts or dismisses a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload).
         */
        handleJavaScriptDialog(params: Page.HandleJavaScriptDialogRequest): Promise<void>;

        /**
         * Navigates current page to the given URL.
         */
        navigate(params: Page.NavigateRequest): Promise<Page.NavigateResponse>;

        /**
         * Navigates current page to the given history entry.
         */
        navigateToHistoryEntry(params: Page.NavigateToHistoryEntryRequest): Promise<void>;

        /**
         * Print page as PDF.
         */
        printToPDF(params: Page.PrintToPDFRequest): Promise<Page.PrintToPDFResponse>;

        /**
         * Reloads given page optionally ignoring the cache.
         */
        reload(params: Page.ReloadRequest): Promise<void>;

        /**
         * Deprecated, please use removeScriptToEvaluateOnNewDocument instead.
         */
        removeScriptToEvaluateOnLoad(params: Page.RemoveScriptToEvaluateOnLoadRequest): Promise<void>;

        /**
         * Removes given script from the list.
         */
        removeScriptToEvaluateOnNewDocument(params: Page.RemoveScriptToEvaluateOnNewDocumentRequest): Promise<void>;

        requestAppBanner(): Promise<void>;

        /**
         * Acknowledges that a screencast frame has been received by the frontend.
         */
        screencastFrameAck(params: Page.ScreencastFrameAckRequest): Promise<void>;

        /**
         * Searches for given string in resource content.
         */
        searchInResource(params: Page.SearchInResourceRequest): Promise<Page.SearchInResourceResponse>;

        /**
         * Enable Chrome's experimental ad filter on all sites.
         */
        setAdBlockingEnabled(params: Page.SetAdBlockingEnabledRequest): Promise<void>;

        /**
         * Enable page Content Security Policy by-passing.
         */
        setBypassCSP(params: Page.SetBypassCSPRequest): Promise<void>;

        /**
         * Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
         * window.innerWidth, window.innerHeight, and "device-width"/"device-height"-related CSS media
         * query results).
         */
        setDeviceMetricsOverride(params: Page.SetDeviceMetricsOverrideRequest): Promise<void>;

        /**
         * Overrides the Device Orientation.
         */
        setDeviceOrientationOverride(params: Page.SetDeviceOrientationOverrideRequest): Promise<void>;

        /**
         * Set generic font families.
         */
        setFontFamilies(params: Page.SetFontFamiliesRequest): Promise<void>;

        /**
         * Set default font sizes.
         */
        setFontSizes(params: Page.SetFontSizesRequest): Promise<void>;

        /**
         * Sets given markup as the document's HTML.
         */
        setDocumentContent(params: Page.SetDocumentContentRequest): Promise<void>;

        /**
         * Set the behavior when downloading a file.
         */
        setDownloadBehavior(params: Page.SetDownloadBehaviorRequest): Promise<void>;

        /**
         * Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position
         * unavailable.
         */
        setGeolocationOverride(params: Page.SetGeolocationOverrideRequest): Promise<void>;

        /**
         * Controls whether page will emit lifecycle events.
         */
        setLifecycleEventsEnabled(params: Page.SetLifecycleEventsEnabledRequest): Promise<void>;

        /**
         * Toggles mouse event-based touch event emulation.
         */
        setTouchEmulationEnabled(params: Page.SetTouchEmulationEnabledRequest): Promise<void>;

        /**
         * Starts sending each frame using the `screencastFrame` event.
         */
        startScreencast(params: Page.StartScreencastRequest): Promise<void>;

        /**
         * Force the page stop all navigations and pending resource fetches.
         */
        stopLoading(): Promise<void>;

        /**
         * Crashes renderer on the IO thread, generates minidumps.
         */
        crash(): Promise<void>;

        /**
         * Tries to close page, running its beforeunload hooks, if any.
         */
        close(): Promise<void>;

        /**
         * Tries to update the web lifecycle state of the page.
         * It will transition the page to the given state according to:
         * https://github.com/WICG/web-lifecycle/
         */
        setWebLifecycleState(params: Page.SetWebLifecycleStateRequest): Promise<void>;

        /**
         * Stops sending each frame in the `screencastFrame`.
         */
        stopScreencast(): Promise<void>;

        /**
         * Forces compilation cache to be generated for every subresource script.
         */
        setProduceCompilationCache(params: Page.SetProduceCompilationCacheRequest): Promise<void>;

        /**
         * Seeds compilation cache for given url. Compilation cache does not survive
         * cross-process navigation.
         */
        addCompilationCache(params: Page.AddCompilationCacheRequest): Promise<void>;

        /**
         * Clears seeded compilation cache.
         */
        clearCompilationCache(): Promise<void>;

        /**
         * Generates a report for testing.
         */
        generateTestReport(params: Page.GenerateTestReportRequest): Promise<void>;

        on(event: 'domContentEventFired', listener: (params: Page.DomContentEventFiredEvent) => void): void;

        /**
         * Fired when frame has been attached to its parent.
         */
        on(event: 'frameAttached', listener: (params: Page.FrameAttachedEvent) => void): void;

        /**
         * Fired when frame no longer has a scheduled navigation.
         */
        on(event: 'frameClearedScheduledNavigation', listener: (params: Page.FrameClearedScheduledNavigationEvent) => void): void;

        /**
         * Fired when frame has been detached from its parent.
         */
        on(event: 'frameDetached', listener: (params: Page.FrameDetachedEvent) => void): void;

        /**
         * Fired once navigation of the frame has completed. Frame is now associated with the new loader.
         */
        on(event: 'frameNavigated', listener: (params: Page.FrameNavigatedEvent) => void): void;

        on(event: 'frameResized', listener: () => void): void;

        /**
         * Fired when frame schedules a potential navigation.
         */
        on(event: 'frameScheduledNavigation', listener: (params: Page.FrameScheduledNavigationEvent) => void): void;

        /**
         * Fired when frame has started loading.
         */
        on(event: 'frameStartedLoading', listener: (params: Page.FrameStartedLoadingEvent) => void): void;

        /**
         * Fired when frame has stopped loading.
         */
        on(event: 'frameStoppedLoading', listener: (params: Page.FrameStoppedLoadingEvent) => void): void;

        /**
         * Fired when interstitial page was hidden
         */
        on(event: 'interstitialHidden', listener: () => void): void;

        /**
         * Fired when interstitial page was shown
         */
        on(event: 'interstitialShown', listener: () => void): void;

        /**
         * Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) has been
         * closed.
         */
        on(event: 'javascriptDialogClosed', listener: (params: Page.JavascriptDialogClosedEvent) => void): void;

        /**
         * Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) is about to
         * open.
         */
        on(event: 'javascriptDialogOpening', listener: (params: Page.JavascriptDialogOpeningEvent) => void): void;

        /**
         * Fired for top level page lifecycle events such as navigation, load, paint, etc.
         */
        on(event: 'lifecycleEvent', listener: (params: Page.LifecycleEventEvent) => void): void;

        on(event: 'loadEventFired', listener: (params: Page.LoadEventFiredEvent) => void): void;

        /**
         * Fired when same-document navigation happens, e.g. due to history API usage or anchor navigation.
         */
        on(event: 'navigatedWithinDocument', listener: (params: Page.NavigatedWithinDocumentEvent) => void): void;

        /**
         * Compressed image data requested by the `startScreencast`.
         */
        on(event: 'screencastFrame', listener: (params: Page.ScreencastFrameEvent) => void): void;

        /**
         * Fired when the page with currently enabled screencast was shown or hidden `.
         */
        on(event: 'screencastVisibilityChanged', listener: (params: Page.ScreencastVisibilityChangedEvent) => void): void;

        /**
         * Fired when a new window is going to be opened, via window.open(), link click, form submission,
         * etc.
         */
        on(event: 'windowOpen', listener: (params: Page.WindowOpenEvent) => void): void;

        /**
         * Issued for every compilation cache generated. Is only available
         * if Page.setGenerateCompilationCache is enabled.
         */
        on(event: 'compilationCacheProduced', listener: (params: Page.CompilationCacheProducedEvent) => void): void;
    }

    export namespace Performance {

        /**
         * Run-time execution metric.
         */
        export interface Metric {
            /**
             * Metric name.
             */
            name: string;

            /**
             * Metric value.
             */
            value: number;
        }

        export interface GetMetricsResponse {
            /**
             * Current values for run-time metrics.
             */
            metrics: Metric[];
        }

        export interface MetricsEvent {
            /**
             * Current values of the metrics.
             */
            metrics: Metric[];

            /**
             * Timestamp title.
             */
            title: string;
        }
    }

    export interface PerformanceApi {
        /**
         * Disable collecting and reporting metrics.
         */
        disable(): Promise<void>;

        /**
         * Enable collecting and reporting metrics.
         */
        enable(): Promise<void>;

        /**
         * Retrieve current values of run-time metrics.
         */
        getMetrics(): Promise<Performance.GetMetricsResponse>;

        /**
         * Current values of the metrics.
         */
        on(event: 'metrics', listener: (params: Performance.MetricsEvent) => void): void;
    }

    /**
     * Security
     */
    export namespace Security {

        /**
         * An internal certificate ID value.
         */
        export type CertificateId = integer;

        /**
         * A description of mixed content (HTTP resources on HTTPS pages), as defined by
         * https://www.w3.org/TR/mixed-content/#categories
         */
        export type MixedContentType = ('blockable' | 'optionally-blockable' | 'none');

        /**
         * The security level of a page or resource.
         */
        export type SecurityState = ('unknown' | 'neutral' | 'insecure' | 'secure' | 'info');

        /**
         * An explanation of an factor contributing to the security state.
         */
        export interface SecurityStateExplanation {
            /**
             * Security state representing the severity of the factor being explained.
             */
            securityState: SecurityState;

            /**
             * Title describing the type of factor.
             */
            title: string;

            /**
             * Short phrase describing the type of factor.
             */
            summary: string;

            /**
             * Full text explanation of the factor.
             */
            description: string;

            /**
             * The type of mixed content described by the explanation.
             */
            mixedContentType: MixedContentType;

            /**
             * Page certificate.
             */
            certificate: string[];
        }

        /**
         * Information about insecure content on the page.
         */
        export interface InsecureContentStatus {
            /**
             * True if the page was loaded over HTTPS and ran mixed (HTTP) content such as scripts.
             */
            ranMixedContent: boolean;

            /**
             * True if the page was loaded over HTTPS and displayed mixed (HTTP) content such as images.
             */
            displayedMixedContent: boolean;

            /**
             * True if the page was loaded over HTTPS and contained a form targeting an insecure url.
             */
            containedMixedForm: boolean;

            /**
             * True if the page was loaded over HTTPS without certificate errors, and ran content such as
             * scripts that were loaded with certificate errors.
             */
            ranContentWithCertErrors: boolean;

            /**
             * True if the page was loaded over HTTPS without certificate errors, and displayed content
             * such as images that were loaded with certificate errors.
             */
            displayedContentWithCertErrors: boolean;

            /**
             * Security state representing a page that ran insecure content.
             */
            ranInsecureContentStyle: SecurityState;

            /**
             * Security state representing a page that displayed insecure content.
             */
            displayedInsecureContentStyle: SecurityState;
        }

        /**
         * The action to take when a certificate error occurs. continue will continue processing the
         * request and cancel will cancel the request.
         */
        export type CertificateErrorAction = ('continue' | 'cancel');

        export interface SetIgnoreCertificateErrorsRequest {
            /**
             * If true, all certificate errors will be ignored.
             */
            ignore: boolean;
        }

        export interface HandleCertificateErrorRequest {
            /**
             * The ID of the event.
             */
            eventId: integer;

            /**
             * The action to take on the certificate error.
             */
            action: CertificateErrorAction;
        }

        export interface SetOverrideCertificateErrorsRequest {
            /**
             * If true, certificate errors will be overridden.
             */
            override: boolean;
        }

        export interface CertificateErrorEvent {
            /**
             * The ID of the event.
             */
            eventId: integer;

            /**
             * The type of the error.
             */
            errorType: string;

            /**
             * The url that was requested.
             */
            requestURL: string;
        }

        export interface SecurityStateChangedEvent {
            /**
             * Security state.
             */
            securityState: SecurityState;

            /**
             * True if the page was loaded over cryptographic transport such as HTTPS.
             */
            schemeIsCryptographic: boolean;

            /**
             * List of explanations for the security state. If the overall security state is `insecure` or
             * `warning`, at least one corresponding explanation should be included.
             */
            explanations: SecurityStateExplanation[];

            /**
             * Information about insecure content on the page.
             */
            insecureContentStatus: InsecureContentStatus;

            /**
             * Overrides user-visible description of the state.
             */
            summary?: string;
        }
    }

    export interface SecurityApi {
        /**
         * Disables tracking security state changes.
         */
        disable(): Promise<void>;

        /**
         * Enables tracking security state changes.
         */
        enable(): Promise<void>;

        /**
         * Enable/disable whether all certificate errors should be ignored.
         */
        setIgnoreCertificateErrors(params: Security.SetIgnoreCertificateErrorsRequest): Promise<void>;

        /**
         * Handles a certificate error that fired a certificateError event.
         */
        handleCertificateError(params: Security.HandleCertificateErrorRequest): Promise<void>;

        /**
         * Enable/disable overriding certificate errors. If enabled, all certificate error events need to
         * be handled by the DevTools client and should be answered with `handleCertificateError` commands.
         */
        setOverrideCertificateErrors(params: Security.SetOverrideCertificateErrorsRequest): Promise<void>;

        /**
         * There is a certificate error. If overriding certificate errors is enabled, then it should be
         * handled with the `handleCertificateError` command. Note: this event does not fire if the
         * certificate error has been allowed internally. Only one client per target should override
         * certificate errors at the same time.
         */
        on(event: 'certificateError', listener: (params: Security.CertificateErrorEvent) => void): void;

        /**
         * The security state of the page changed.
         */
        on(event: 'securityStateChanged', listener: (params: Security.SecurityStateChangedEvent) => void): void;
    }

    export namespace ServiceWorker {

        /**
         * ServiceWorker registration.
         */
        export interface ServiceWorkerRegistration {
            registrationId: string;

            scopeURL: string;

            isDeleted: boolean;
        }

        export type ServiceWorkerVersionRunningStatus = ('stopped' | 'starting' | 'running' | 'stopping');

        export type ServiceWorkerVersionStatus = ('new' | 'installing' | 'installed' | 'activating' | 'activated' | 'redundant');

        /**
         * ServiceWorker version.
         */
        export interface ServiceWorkerVersion {
            versionId: string;

            registrationId: string;

            scriptURL: string;

            runningStatus: ServiceWorkerVersionRunningStatus;

            status: ServiceWorkerVersionStatus;

            /**
             * The Last-Modified header value of the main script.
             */
            scriptLastModified?: number;

            /**
             * The time at which the response headers of the main script were received from the server.
             * For cached script it is the last time the cache entry was validated.
             */
            scriptResponseTime?: number;

            controlledClients?: Target.TargetID[];

            targetId?: Target.TargetID;
        }

        /**
         * ServiceWorker error message.
         */
        export interface ServiceWorkerErrorMessage {
            errorMessage: string;

            registrationId: string;

            versionId: string;

            sourceURL: string;

            lineNumber: integer;

            columnNumber: integer;
        }

        export interface DeliverPushMessageRequest {
            origin: string;

            registrationId: string;

            data: string;
        }

        export interface DispatchSyncEventRequest {
            origin: string;

            registrationId: string;

            tag: string;

            lastChance: boolean;
        }

        export interface InspectWorkerRequest {
            versionId: string;
        }

        export interface SetForceUpdateOnPageLoadRequest {
            forceUpdateOnPageLoad: boolean;
        }

        export interface SkipWaitingRequest {
            scopeURL: string;
        }

        export interface StartWorkerRequest {
            scopeURL: string;
        }

        export interface StopWorkerRequest {
            versionId: string;
        }

        export interface UnregisterRequest {
            scopeURL: string;
        }

        export interface UpdateRegistrationRequest {
            scopeURL: string;
        }

        export interface WorkerErrorReportedEvent {
            errorMessage: ServiceWorkerErrorMessage;
        }

        export interface WorkerRegistrationUpdatedEvent {
            registrations: ServiceWorkerRegistration[];
        }

        export interface WorkerVersionUpdatedEvent {
            versions: ServiceWorkerVersion[];
        }
    }

    export interface ServiceWorkerApi {
        deliverPushMessage(params: ServiceWorker.DeliverPushMessageRequest): Promise<void>;

        disable(): Promise<void>;

        dispatchSyncEvent(params: ServiceWorker.DispatchSyncEventRequest): Promise<void>;

        enable(): Promise<void>;

        inspectWorker(params: ServiceWorker.InspectWorkerRequest): Promise<void>;

        setForceUpdateOnPageLoad(params: ServiceWorker.SetForceUpdateOnPageLoadRequest): Promise<void>;

        skipWaiting(params: ServiceWorker.SkipWaitingRequest): Promise<void>;

        startWorker(params: ServiceWorker.StartWorkerRequest): Promise<void>;

        stopAllWorkers(): Promise<void>;

        stopWorker(params: ServiceWorker.StopWorkerRequest): Promise<void>;

        unregister(params: ServiceWorker.UnregisterRequest): Promise<void>;

        updateRegistration(params: ServiceWorker.UpdateRegistrationRequest): Promise<void>;

        on(event: 'workerErrorReported', listener: (params: ServiceWorker.WorkerErrorReportedEvent) => void): void;

        on(event: 'workerRegistrationUpdated', listener: (params: ServiceWorker.WorkerRegistrationUpdatedEvent) => void): void;

        on(event: 'workerVersionUpdated', listener: (params: ServiceWorker.WorkerVersionUpdatedEvent) => void): void;
    }

    export namespace Storage {

        /**
         * Enum of possible storage types.
         */
        export type StorageType = ('appcache' | 'cookies' | 'file_systems' | 'indexeddb' | 'local_storage' | 'shader_cache' | 'websql' | 'service_workers' | 'cache_storage' | 'all' | 'other');

        /**
         * Usage for a storage type.
         */
        export interface UsageForType {
            /**
             * Name of storage type.
             */
            storageType: StorageType;

            /**
             * Storage usage (bytes).
             */
            usage: number;
        }

        export interface ClearDataForOriginRequest {
            /**
             * Security origin.
             */
            origin: string;

            /**
             * Comma separated origin names.
             */
            storageTypes: string;
        }

        export interface GetUsageAndQuotaRequest {
            /**
             * Security origin.
             */
            origin: string;
        }

        export interface GetUsageAndQuotaResponse {
            /**
             * Storage usage (bytes).
             */
            usage: number;

            /**
             * Storage quota (bytes).
             */
            quota: number;

            /**
             * Storage usage per type (bytes).
             */
            usageBreakdown: UsageForType[];
        }

        export interface TrackCacheStorageForOriginRequest {
            /**
             * Security origin.
             */
            origin: string;
        }

        export interface TrackIndexedDBForOriginRequest {
            /**
             * Security origin.
             */
            origin: string;
        }

        export interface UntrackCacheStorageForOriginRequest {
            /**
             * Security origin.
             */
            origin: string;
        }

        export interface UntrackIndexedDBForOriginRequest {
            /**
             * Security origin.
             */
            origin: string;
        }

        export interface CacheStorageContentUpdatedEvent {
            /**
             * Origin to update.
             */
            origin: string;

            /**
             * Name of cache in origin.
             */
            cacheName: string;
        }

        export interface CacheStorageListUpdatedEvent {
            /**
             * Origin to update.
             */
            origin: string;
        }

        export interface IndexedDBContentUpdatedEvent {
            /**
             * Origin to update.
             */
            origin: string;

            /**
             * Database to update.
             */
            databaseName: string;

            /**
             * ObjectStore to update.
             */
            objectStoreName: string;
        }

        export interface IndexedDBListUpdatedEvent {
            /**
             * Origin to update.
             */
            origin: string;
        }
    }

    export interface StorageApi {
        /**
         * Clears storage for origin.
         */
        clearDataForOrigin(params: Storage.ClearDataForOriginRequest): Promise<void>;

        /**
         * Returns usage and quota in bytes.
         */
        getUsageAndQuota(params: Storage.GetUsageAndQuotaRequest): Promise<Storage.GetUsageAndQuotaResponse>;

        /**
         * Registers origin to be notified when an update occurs to its cache storage list.
         */
        trackCacheStorageForOrigin(params: Storage.TrackCacheStorageForOriginRequest): Promise<void>;

        /**
         * Registers origin to be notified when an update occurs to its IndexedDB.
         */
        trackIndexedDBForOrigin(params: Storage.TrackIndexedDBForOriginRequest): Promise<void>;

        /**
         * Unregisters origin from receiving notifications for cache storage.
         */
        untrackCacheStorageForOrigin(params: Storage.UntrackCacheStorageForOriginRequest): Promise<void>;

        /**
         * Unregisters origin from receiving notifications for IndexedDB.
         */
        untrackIndexedDBForOrigin(params: Storage.UntrackIndexedDBForOriginRequest): Promise<void>;

        /**
         * A cache's contents have been modified.
         */
        on(event: 'cacheStorageContentUpdated', listener: (params: Storage.CacheStorageContentUpdatedEvent) => void): void;

        /**
         * A cache has been added/deleted.
         */
        on(event: 'cacheStorageListUpdated', listener: (params: Storage.CacheStorageListUpdatedEvent) => void): void;

        /**
         * The origin's IndexedDB object store has been modified.
         */
        on(event: 'indexedDBContentUpdated', listener: (params: Storage.IndexedDBContentUpdatedEvent) => void): void;

        /**
         * The origin's IndexedDB database list has been modified.
         */
        on(event: 'indexedDBListUpdated', listener: (params: Storage.IndexedDBListUpdatedEvent) => void): void;
    }

    /**
     * The SystemInfo domain defines methods and events for querying low-level system information.
     */
    export namespace SystemInfo {

        /**
         * Describes a single graphics processor (GPU).
         */
        export interface GPUDevice {
            /**
             * PCI ID of the GPU vendor, if available; 0 otherwise.
             */
            vendorId: number;

            /**
             * PCI ID of the GPU device, if available; 0 otherwise.
             */
            deviceId: number;

            /**
             * String description of the GPU vendor, if the PCI ID is not available.
             */
            vendorString: string;

            /**
             * String description of the GPU device, if the PCI ID is not available.
             */
            deviceString: string;
        }

        /**
         * Provides information about the GPU(s) on the system.
         */
        export interface GPUInfo {
            /**
             * The graphics devices on the system. Element 0 is the primary GPU.
             */
            devices: GPUDevice[];

            /**
             * An optional dictionary of additional GPU related attributes.
             */
            auxAttributes?: any;

            /**
             * An optional dictionary of graphics features and their status.
             */
            featureStatus?: any;

            /**
             * An optional array of GPU driver bug workarounds.
             */
            driverBugWorkarounds: string[];
        }

        export interface GetInfoResponse {
            /**
             * Information about the GPUs on the system.
             */
            gpu: GPUInfo;

            /**
             * A platform-dependent description of the model of the machine. On Mac OS, this is, for
             * example, 'MacBookPro'. Will be the empty string if not supported.
             */
            modelName: string;

            /**
             * A platform-dependent description of the version of the machine. On Mac OS, this is, for
             * example, '10.1'. Will be the empty string if not supported.
             */
            modelVersion: string;

            /**
             * The command line string used to launch the browser. Will be the empty string if not
             * supported.
             */
            commandLine: string;
        }
    }

    export interface SystemInfoApi {
        /**
         * Returns information about the system.
         */
        getInfo(): Promise<SystemInfo.GetInfoResponse>;
    }

    /**
     * Supports additional targets discovery and allows to attach to them.
     */
    export namespace Target {

        export type TargetID = string;

        /**
         * Unique identifier of attached debugging session.
         */
        export type SessionID = string;

        export type BrowserContextID = string;

        export interface TargetInfo {
            targetId: TargetID;

            type: string;

            title: string;

            url: string;

            /**
             * Whether the target has an attached client.
             */
            attached: boolean;

            /**
             * Opener target Id
             */
            openerId?: TargetID;

            browserContextId?: BrowserContextID;
        }

        export interface RemoteLocation {
            host: string;

            port: integer;
        }

        export interface ActivateTargetRequest {
            targetId: TargetID;
        }

        export interface AttachToTargetRequest {
            targetId: TargetID;

            /**
             * Enables "flat" access to the session via specifying sessionId attribute in the commands.
             */
            flatten?: boolean;
        }

        export interface AttachToTargetResponse {
            /**
             * Id assigned to the session.
             */
            sessionId: SessionID;
        }

        export interface AttachToBrowserTargetResponse {
            /**
             * Id assigned to the session.
             */
            sessionId: SessionID;
        }

        export interface CloseTargetRequest {
            targetId: TargetID;
        }

        export interface CloseTargetResponse {
            success: boolean;
        }

        export interface ExposeDevToolsProtocolRequest {
            targetId: TargetID;

            /**
             * Binding name, 'cdp' if not specified.
             */
            bindingName?: string;
        }

        export interface CreateBrowserContextResponse {
            /**
             * The id of the context created.
             */
            browserContextId: BrowserContextID;
        }

        export interface GetBrowserContextsResponse {
            /**
             * An array of browser context ids.
             */
            browserContextIds: BrowserContextID[];
        }

        export interface CreateTargetRequest {
            /**
             * The initial URL the page will be navigated to.
             */
            url: string;

            /**
             * Frame width in DIP (headless chrome only).
             */
            width?: integer;

            /**
             * Frame height in DIP (headless chrome only).
             */
            height?: integer;

            /**
             * The browser context to create the page in.
             */
            browserContextId?: BrowserContextID;

            /**
             * Whether BeginFrames for this target will be controlled via DevTools (headless chrome only,
             * not supported on MacOS yet, false by default).
             */
            enableBeginFrameControl?: boolean;
        }

        export interface CreateTargetResponse {
            /**
             * The id of the page opened.
             */
            targetId: TargetID;
        }

        export interface DetachFromTargetRequest {
            /**
             * Session to detach.
             */
            sessionId?: SessionID;

            /**
             * Deprecated.
             */
            targetId?: TargetID;
        }

        export interface DisposeBrowserContextRequest {
            browserContextId: BrowserContextID;
        }

        export interface GetTargetInfoRequest {
            targetId?: TargetID;
        }

        export interface GetTargetInfoResponse {
            targetInfo: TargetInfo;
        }

        export interface GetTargetsResponse {
            /**
             * The list of targets.
             */
            targetInfos: TargetInfo[];
        }

        export interface SendMessageToTargetRequest {
            message: string;

            /**
             * Identifier of the session.
             */
            sessionId?: SessionID;

            /**
             * Deprecated.
             */
            targetId?: TargetID;
        }

        export interface SetAutoAttachRequest {
            /**
             * Whether to auto-attach to related targets.
             */
            autoAttach: boolean;

            /**
             * Whether to pause new targets when attaching to them. Use `Runtime.runIfWaitingForDebugger`
             * to run paused targets.
             */
            waitForDebuggerOnStart: boolean;

            /**
             * Enables "flat" access to the session via specifying sessionId attribute in the commands.
             */
            flatten?: boolean;
        }

        export interface SetDiscoverTargetsRequest {
            /**
             * Whether to discover available targets.
             */
            discover: boolean;
        }

        export interface SetRemoteLocationsRequest {
            /**
             * List of remote locations.
             */
            locations: RemoteLocation[];
        }

        export interface AttachedToTargetEvent {
            /**
             * Identifier assigned to the session used to send/receive messages.
             */
            sessionId: SessionID;

            targetInfo: TargetInfo;

            waitingForDebugger: boolean;
        }

        export interface DetachedFromTargetEvent {
            /**
             * Detached session identifier.
             */
            sessionId: SessionID;

            /**
             * Deprecated.
             */
            targetId?: TargetID;
        }

        export interface ReceivedMessageFromTargetEvent {
            /**
             * Identifier of a session which sends a message.
             */
            sessionId: SessionID;

            message: string;

            /**
             * Deprecated.
             */
            targetId?: TargetID;
        }

        export interface TargetCreatedEvent {
            targetInfo: TargetInfo;
        }

        export interface TargetDestroyedEvent {
            targetId: TargetID;
        }

        export interface TargetCrashedEvent {
            targetId: TargetID;

            /**
             * Termination status type.
             */
            status: string;

            /**
             * Termination error code.
             */
            errorCode: integer;
        }

        export interface TargetInfoChangedEvent {
            targetInfo: TargetInfo;
        }
    }

    export interface TargetApi {
        /**
         * Activates (focuses) the target.
         */
        activateTarget(params: Target.ActivateTargetRequest): Promise<void>;

        /**
         * Attaches to the target with given id.
         */
        attachToTarget(params: Target.AttachToTargetRequest): Promise<Target.AttachToTargetResponse>;

        /**
         * Attaches to the browser target, only uses flat sessionId mode.
         */
        attachToBrowserTarget(): Promise<Target.AttachToBrowserTargetResponse>;

        /**
         * Closes the target. If the target is a page that gets closed too.
         */
        closeTarget(params: Target.CloseTargetRequest): Promise<Target.CloseTargetResponse>;

        /**
         * Inject object to the target's main frame that provides a communication
         * channel with browser target.
         * 
         * Injected object will be available as `window[bindingName]`.
         * 
         * The object has the follwing API:
         * - `binding.send(json)` - a method to send messages over the remote debugging protocol
         * - `binding.onmessage = json => handleMessage(json)` - a callback that will be called for the protocol notifications and command responses.
         */
        exposeDevToolsProtocol(params: Target.ExposeDevToolsProtocolRequest): Promise<void>;

        /**
         * Creates a new empty BrowserContext. Similar to an incognito profile but you can have more than
         * one.
         */
        createBrowserContext(): Promise<Target.CreateBrowserContextResponse>;

        /**
         * Returns all browser contexts created with `Target.createBrowserContext` method.
         */
        getBrowserContexts(): Promise<Target.GetBrowserContextsResponse>;

        /**
         * Creates a new page.
         */
        createTarget(params: Target.CreateTargetRequest): Promise<Target.CreateTargetResponse>;

        /**
         * Detaches session with given id.
         */
        detachFromTarget(params: Target.DetachFromTargetRequest): Promise<void>;

        /**
         * Deletes a BrowserContext. All the belonging pages will be closed without calling their
         * beforeunload hooks.
         */
        disposeBrowserContext(params: Target.DisposeBrowserContextRequest): Promise<void>;

        /**
         * Returns information about a target.
         */
        getTargetInfo(params: Target.GetTargetInfoRequest): Promise<Target.GetTargetInfoResponse>;

        /**
         * Retrieves a list of available targets.
         */
        getTargets(): Promise<Target.GetTargetsResponse>;

        /**
         * Sends protocol message over session with given id.
         */
        sendMessageToTarget(params: Target.SendMessageToTargetRequest): Promise<void>;

        /**
         * Controls whether to automatically attach to new targets which are considered to be related to
         * this one. When turned on, attaches to all existing related targets as well. When turned off,
         * automatically detaches from all currently attached targets.
         */
        setAutoAttach(params: Target.SetAutoAttachRequest): Promise<void>;

        /**
         * Controls whether to discover available targets and notify via
         * `targetCreated/targetInfoChanged/targetDestroyed` events.
         */
        setDiscoverTargets(params: Target.SetDiscoverTargetsRequest): Promise<void>;

        /**
         * Enables target discovery for the specified locations, when `setDiscoverTargets` was set to
         * `true`.
         */
        setRemoteLocations(params: Target.SetRemoteLocationsRequest): Promise<void>;

        /**
         * Issued when attached to target because of auto-attach or `attachToTarget` command.
         */
        on(event: 'attachedToTarget', listener: (params: Target.AttachedToTargetEvent) => void): void;

        /**
         * Issued when detached from target for any reason (including `detachFromTarget` command). Can be
         * issued multiple times per target if multiple sessions have been attached to it.
         */
        on(event: 'detachedFromTarget', listener: (params: Target.DetachedFromTargetEvent) => void): void;

        /**
         * Notifies about a new protocol message received from the session (as reported in
         * `attachedToTarget` event).
         */
        on(event: 'receivedMessageFromTarget', listener: (params: Target.ReceivedMessageFromTargetEvent) => void): void;

        /**
         * Issued when a possible inspection target is created.
         */
        on(event: 'targetCreated', listener: (params: Target.TargetCreatedEvent) => void): void;

        /**
         * Issued when a target is destroyed.
         */
        on(event: 'targetDestroyed', listener: (params: Target.TargetDestroyedEvent) => void): void;

        /**
         * Issued when a target has crashed.
         */
        on(event: 'targetCrashed', listener: (params: Target.TargetCrashedEvent) => void): void;

        /**
         * Issued when some information about a target has changed. This only happens between
         * `targetCreated` and `targetDestroyed`.
         */
        on(event: 'targetInfoChanged', listener: (params: Target.TargetInfoChangedEvent) => void): void;
    }

    /**
     * The Tethering domain defines methods and events for browser port binding.
     */
    export namespace Tethering {

        export interface BindRequest {
            /**
             * Port number to bind.
             */
            port: integer;
        }

        export interface UnbindRequest {
            /**
             * Port number to unbind.
             */
            port: integer;
        }

        export interface AcceptedEvent {
            /**
             * Port number that was successfully bound.
             */
            port: integer;

            /**
             * Connection id to be used.
             */
            connectionId: string;
        }
    }

    export interface TetheringApi {
        /**
         * Request browser port binding.
         */
        bind(params: Tethering.BindRequest): Promise<void>;

        /**
         * Request browser port unbinding.
         */
        unbind(params: Tethering.UnbindRequest): Promise<void>;

        /**
         * Informs that port was successfully bound and got a specified connection id.
         */
        on(event: 'accepted', listener: (params: Tethering.AcceptedEvent) => void): void;
    }

    export namespace Tracing {

        /**
         * Configuration for memory dump. Used only when "memory-infra" category is enabled.
         */
        export interface MemoryDumpConfig {
            [key: string]: string;
        }

        export interface TraceConfig {
            /**
             * Controls how the trace buffer stores data.
             */
            recordMode?: ('recordUntilFull' | 'recordContinuously' | 'recordAsMuchAsPossible' | 'echoToConsole');

            /**
             * Turns on JavaScript stack sampling.
             */
            enableSampling?: boolean;

            /**
             * Turns on system tracing.
             */
            enableSystrace?: boolean;

            /**
             * Turns on argument filter.
             */
            enableArgumentFilter?: boolean;

            /**
             * Included category filters.
             */
            includedCategories?: string[];

            /**
             * Excluded category filters.
             */
            excludedCategories?: string[];

            /**
             * Configuration to synthesize the delays in tracing.
             */
            syntheticDelays?: string[];

            /**
             * Configuration for memory dump triggers. Used only when "memory-infra" category is enabled.
             */
            memoryDumpConfig?: MemoryDumpConfig;
        }

        /**
         * Compression type to use for traces returned via streams.
         */
        export type StreamCompression = ('none' | 'gzip');

        export interface GetCategoriesResponse {
            /**
             * A list of supported tracing categories.
             */
            categories: string[];
        }

        export interface RecordClockSyncMarkerRequest {
            /**
             * The ID of this clock sync marker
             */
            syncId: string;
        }

        export interface RequestMemoryDumpResponse {
            /**
             * GUID of the resulting global memory dump.
             */
            dumpGuid: string;

            /**
             * True iff the global memory dump succeeded.
             */
            success: boolean;
        }

        export interface StartRequest {
            /**
             * Category/tag filter
             */
            categories?: string;

            /**
             * Tracing options
             */
            options?: string;

            /**
             * If set, the agent will issue bufferUsage events at this interval, specified in milliseconds
             */
            bufferUsageReportingInterval?: number;

            /**
             * Whether to report trace events as series of dataCollected events or to save trace to a
             * stream (defaults to `ReportEvents`).
             */
            transferMode?: ('ReportEvents' | 'ReturnAsStream');

            /**
             * Compression format to use. This only applies when using `ReturnAsStream`
             * transfer mode (defaults to `none`)
             */
            streamCompression?: StreamCompression;

            traceConfig?: TraceConfig;
        }

        export interface BufferUsageEvent {
            /**
             * A number in range [0..1] that indicates the used size of event buffer as a fraction of its
             * total size.
             */
            percentFull?: number;

            /**
             * An approximate number of events in the trace log.
             */
            eventCount?: number;

            /**
             * A number in range [0..1] that indicates the used size of event buffer as a fraction of its
             * total size.
             */
            value?: number;
        }

        export interface DataCollectedEvent {
            value: any[];
        }

        export interface TracingCompleteEvent {
            /**
             * A handle of the stream that holds resulting trace data.
             */
            stream?: IO.StreamHandle;

            /**
             * Compression format of returned stream.
             */
            streamCompression?: StreamCompression;
        }
    }

    export interface TracingApi {
        /**
         * Stop trace events collection.
         */
        end(): Promise<void>;

        /**
         * Gets supported tracing categories.
         */
        getCategories(): Promise<Tracing.GetCategoriesResponse>;

        /**
         * Record a clock sync marker in the trace.
         */
        recordClockSyncMarker(params: Tracing.RecordClockSyncMarkerRequest): Promise<void>;

        /**
         * Request a global memory dump.
         */
        requestMemoryDump(): Promise<Tracing.RequestMemoryDumpResponse>;

        /**
         * Start trace events collection.
         */
        start(params: Tracing.StartRequest): Promise<void>;

        on(event: 'bufferUsage', listener: (params: Tracing.BufferUsageEvent) => void): void;

        /**
         * Contains an bucket of collected trace events. When tracing is stopped collected events will be
         * send as a sequence of dataCollected events followed by tracingComplete event.
         */
        on(event: 'dataCollected', listener: (params: Tracing.DataCollectedEvent) => void): void;

        /**
         * Signals that tracing is stopped and there is no trace buffers pending flush, all data were
         * delivered via dataCollected events.
         */
        on(event: 'tracingComplete', listener: (params: Tracing.TracingCompleteEvent) => void): void;
    }

    /**
     * Testing domain is a dumping ground for the capabilities requires for browser or app testing that do not fit other
     * domains.
     */
    export namespace Testing {

        export interface GenerateTestReportRequest {
            /**
             * Message to be displayed in the report.
             */
            message: string;

            /**
             * Specifies the endpoint group to deliver the report to.
             */
            group?: string;
        }
    }

    export interface TestingApi {
        /**
         * Generates a report for testing.
         */
        generateTestReport(params: Testing.GenerateTestReportRequest): Promise<void>;
    }
}

export default Protocol;
