/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls.flyout;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.controls.flyout.IFlyoutPreferences;

public final class PluginFlyoutPreferences
implements IFlyoutPreferences {
    private final IPreferenceStore m_store;
    private final String m_dockLocationKey;
    private final String m_stateKey;
    private final String m_widthKey;

    public PluginFlyoutPreferences(IPreferenceStore store, String prefix) {
        this.m_store = store;
        this.m_dockLocationKey = String.valueOf(prefix) + ".flyout.dockLocation";
        this.m_stateKey = String.valueOf(prefix) + ".flyout.state";
        this.m_widthKey = String.valueOf(prefix) + ".flyout.width";
    }

    public void initializeDefaults(int location, int state, int width) {
        this.m_store.setDefault(this.m_dockLocationKey, location);
        this.m_store.setDefault(this.m_stateKey, state);
        this.m_store.setDefault(this.m_widthKey, width);
    }

    @Override
    public int getDockLocation() {
        return this.m_store.getInt(this.m_dockLocationKey);
    }

    @Override
    public int getState() {
        return this.m_store.getInt(this.m_stateKey);
    }

    @Override
    public int getWidth() {
        return this.m_store.getInt(this.m_widthKey);
    }

    @Override
    public void setDockLocation(int location) {
        this.m_store.setValue(this.m_dockLocationKey, location);
    }

    @Override
    public void setState(int state) {
        this.m_store.setValue(this.m_stateKey, state);
    }

    @Override
    public void setWidth(int width) {
        this.m_store.setValue(this.m_widthKey, width);
    }
}

