/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyleRange;

public class PHPContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    private IContextInformation fInformation;
    private ITextViewer fViewer;
    private int fPosition;
    private int fCurrentParameter;

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        this.fInformation = info;
        this.fViewer = viewer;
        this.fPosition = info instanceof IContextInformationExtension ? ((IContextInformationExtension)info).getContextInformationPosition() : offset - 1;
        ++this.fPosition;
        this.fCurrentParameter = -1;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    private int getCharCount(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        int nestingLevel = 0;
        int charCount = 0;
        block5: while (start < end) {
            char curr = document.getChar(start++);
            switch (curr) {
                case '/': {
                    if (start >= end) continue block5;
                    char next = document.getChar(start);
                    if (next == '*') {
                        start = this.getCommentEnd(document, start + 1, end);
                        break;
                    }
                    if (next != '/') continue block5;
                    IRegion line = document.getLineInformationOfOffset(start);
                    start = line.getOffset() + line.getLength();
                    break;
                }
                case '*': {
                    char next;
                    if (start >= end || (next = document.getChar(start)) != '/') continue block5;
                    charCount = 0;
                    ++start;
                    break;
                }
                case '\"': 
                case '\'': {
                    start = this.getStringEnd(document, start, end, curr);
                    break;
                }
                default: {
                    if (considerNesting) {
                        if ('(' == curr) {
                            ++nestingLevel;
                        } else if (')' == curr) {
                            --nestingLevel;
                        }
                        if (nestingLevel != 0) continue block5;
                    }
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block5;
                    --charCount;
                }
            }
        }
        return charCount;
    }

    public boolean isContextInformationValid(int offset) {
        IDocument document;
        block5: {
            block4: {
                try {
                    if (offset >= this.fPosition) break block4;
                    return false;
                }
                catch (BadLocationException x) {
                    return false;
                }
            }
            document = this.fViewer.getDocument();
            IRegion line = document.getLineInformationOfOffset(this.fPosition);
            if (offset >= line.getOffset() && offset <= document.getLength()) break block5;
            return false;
        }
        return this.getCharCount(document, this.fPosition, offset, "(", ")", false) >= 0;
    }

    public boolean updatePresentation(int offset, TextPresentation presentation) {
        int end;
        int currentParameter = -1;
        IDocument document = this.fViewer.getDocument();
        int parameterStartPosition = this.fPosition;
        try {
            int i = parameterStartPosition;
            while (i < offset) {
                if (document.getChar(parameterStartPosition) == '(') {
                    ++parameterStartPosition;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException i) {
            // empty catch block
        }
        try {
            currentParameter = this.getCharCount(document, parameterStartPosition, offset, ",", "", true);
        }
        catch (BadLocationException x) {
            return false;
        }
        if (this.fCurrentParameter != -1 && currentParameter == this.fCurrentParameter) {
            return false;
        }
        presentation.clear();
        this.fCurrentParameter = currentParameter;
        if (this.fInformation == null) {
            return false;
        }
        String s = this.fInformation.getInformationDisplayString();
        int start = 0;
        int occurrences = 0;
        while (occurrences < this.fCurrentParameter) {
            int found = s.indexOf(44, start);
            if (found == -1) break;
            start = found + 1;
            ++occurrences;
        }
        if (occurrences < this.fCurrentParameter) {
            presentation.addStyleRange(new StyleRange(0, s.length(), null, null, 0));
            return true;
        }
        if (start == -1) {
            start = 0;
        }
        if ((end = s.indexOf(44, start)) == -1) {
            end = s.length();
        }
        if (start > 0) {
            presentation.addStyleRange(new StyleRange(0, start, null, null, 0));
        }
        if (end > start) {
            presentation.addStyleRange(new StyleRange(start, end - start, null, null, 1));
        }
        if (end < s.length()) {
            presentation.addStyleRange(new StyleRange(end, s.length() - end, null, null, 0));
        }
        return true;
    }
}

