/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.extract.function;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.ast.nodes.EmptyStatement;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InLineHtml;
import org.eclipse.php.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.core.ast.nodes.MethodInvocation;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.ReturnStatement;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewrite;
import org.eclipse.php.internal.core.ast.rewrite.ASTRewriteFlattener;
import org.eclipse.php.internal.core.ast.rewrite.ListRewrite;
import org.eclipse.php.internal.core.ast.util.Util;
import org.eclipse.php.internal.core.corext.dom.Selection;
import org.eclipse.php.internal.ui.corext.util.Resources;
import org.eclipse.php.refactoring.core.LinkedNodeFinder;
import org.eclipse.php.refactoring.core.PHPRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.changes.ProgramDocumentChange;
import org.eclipse.php.refactoring.core.extract.function.ExtractFunctionAnalyzer;
import org.eclipse.php.refactoring.core.extract.function.ParameterInfo;
import org.eclipse.php.refactoring.core.extract.function.SnippetFinder;
import org.eclipse.php.refactoring.core.utils.ASTUtils;
import org.eclipse.php.refactoring.core.utils.RefactoringUtility;
import org.eclipse.php.ui.CodeGeneration;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ExtractFunctionRefactoring
extends Refactoring {
    private ISourceModule sourceModule = null;
    private IDocument document = null;
    private int selectionStartOffset;
    private int selectionLength;
    private Program astRoot;
    private boolean fReplaceAllOccurrences;
    private String fNewFunctionName = null;
    private DocumentChange textFileChange = null;
    private RefactoringStatus matchingFragmentsStatus;
    protected CompositeChange rootChange;
    private ASTRewrite fRewriter;
    private AST fAST;
    private ExtractFunctionAnalyzer fAnalyzer;
    private ArrayList<ParameterInfo> fParameterInfos;
    private int fVisibility;
    private SnippetFinder.Match[] fDuplicates;
    private boolean fReplaceDuplicates;
    private boolean fGeneratePHPDoc;

    public ExtractFunctionRefactoring(ISourceModule sourceModule, IDocument document, int offset, int length) {
        this.sourceModule = sourceModule;
        this.document = document;
        this.selectionStartOffset = offset;
        this.selectionLength = length;
        this.fReplaceAllOccurrences = true;
        this.fVisibility = -1;
        this.fNewFunctionName = "extracted";
    }

    public void setNewFunctionName(String newVariableName) {
        this.fNewFunctionName = newVariableName;
    }

    public void setReplaceDuplicates(boolean replaceAllOccurrences) {
        this.fReplaceAllOccurrences = replaceAllOccurrences;
    }

    public boolean getReplaceDuplicates() {
        return this.fReplaceAllOccurrences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("", 8);
            RefactoringStatus status = ExtractFunctionRefactoring.validateModifiesFiles(new IResource[]{this.sourceModule.getResource()}, this.getValidationContext());
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            try {
                this.astRoot = ASTUtils.createProgramFromSource(this.sourceModule);
                this.fAST = this.astRoot.getAST();
                StringReader reader = new StringReader(this.document.get());
                this.astRoot.initCommentMapper(this.document, (Reader)reader, this.fAST.lexer());
                this.astRoot.accept((Visitor)this.createVisitor());
            }
            catch (Exception e) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring.10"));
                pm.done();
                return refactoringStatus;
            }
            status.merge(this.fAnalyzer.checkInitialConditions());
            status.merge(this.fAnalyzer.checkSelection(status, (IProgressMonitor)new SubProgressMonitor(pm, 3)));
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.fVisibility == -1) {
                this.setVisibility(16);
            }
            this.initializeParameterInfos();
            this.initializeDuplicates();
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public boolean isClassMethod() {
        return this.fAnalyzer.getEnclosingBodyDeclaration() instanceof MethodDeclaration;
    }

    public boolean isStaticMethod() {
        if (this.fAnalyzer.getEnclosingBodyDeclaration() instanceof MethodDeclaration) {
            return Flags.isStatic((int)((MethodDeclaration)this.fAnalyzer.getEnclosingBodyDeclaration()).getModifier());
        }
        return false;
    }

    private void initializeDuplicates() {
        ASTNode start = this.fAnalyzer.getEnclosingBodyDeclaration();
        while (this.isClassMethod() && !(start instanceof ClassDeclaration)) {
            start = start.getParent();
        }
        this.fDuplicates = SnippetFinder.perform(start, this.fAnalyzer.getSelectedNodes());
        this.fReplaceDuplicates = this.fDuplicates.length > 0;
    }

    private void initializeParameterInfos() {
        IVariableBinding[] arguments = this.fAnalyzer.getArguments();
        if (arguments != null) {
            this.fParameterInfos = new ArrayList(arguments.length);
            int i = 0;
            while (i < arguments.length) {
                IVariableBinding argument = arguments[i];
                if (argument != null) {
                    ParameterInfo info = new ParameterInfo(argument, argument.getName(), i);
                    this.fParameterInfos.add(info);
                }
                ++i;
            }
        }
    }

    private AbstractVisitor createVisitor() throws CoreException, IOException {
        this.fAnalyzer = new ExtractFunctionAnalyzer(this.astRoot, this.sourceModule, this.document, Selection.createFromStartLength((int)this.selectionStartOffset, (int)this.selectionLength));
        return this.fAnalyzer;
    }

    public ASTNode[] getSelectedNodes() {
        return this.fAnalyzer.getSelectedNodes();
    }

    public static RefactoringStatus validateModifiesFiles(IResource[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, (Object)context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring.11"));
            }
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.matchingFragmentsStatus);
        status.merge(this.doesNameAlreadyExist(this.fNewFunctionName));
        return status;
    }

    private RefactoringStatus doesNameAlreadyExist(String name) {
        RefactoringStatus status = new RefactoringStatus();
        if ((this.fAnalyzer.getEnclosingBodyDeclaration().getType() == 29 || this.fAnalyzer.getEnclosingBodyDeclaration().getType() == 42) && PHPElementConciliator.functionAlreadyExists((Program)this.astRoot, (String)name)) {
            status.addWarning(PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring.3"));
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring"), 1);
            ASTNode declaration = this.fAnalyzer.getEnclosingBodyDeclaration();
            this.fRewriter = ASTRewrite.create((AST)declaration.getAST());
            this.rootChange = new CompositeChange(PHPRefactoringCoreMessages.format("ExtractFunctionRefactoring.2", new String[]{this.fNewFunctionName}));
            this.rootChange.markAsSynthetic();
            MultiTextEdit root = new MultiTextEdit();
            this.textFileChange = new ProgramDocumentChange(PHPRefactoringCoreMessages.format("ExtractFunctionRefactoring.2", new String[]{this.fNewFunctionName}), this.document, this.astRoot);
            this.textFileChange.setEdit((TextEdit)root);
            this.textFileChange.setTextType("php");
            this.rootChange.add((Change)this.textFileChange);
            ASTNode[] selectedNodes = this.fAnalyzer.getSelectedNodes();
            TextEditGroup substituteDesc = new TextEditGroup(PHPRefactoringCoreMessages.format("ExtractFunctionRefactoring.2", new String[]{this.fNewFunctionName}));
            this.textFileChange.addTextEditGroup(substituteDesc);
            String lineDelimiter = Util.getLineSeparator((String)this.astRoot.getSourceModule().getSource(), (IScriptProject)this.astRoot.getSourceModule().getScriptProject());
            FunctionDeclaration function = this.createNewFunction(selectedNodes, lineDelimiter, substituteDesc);
            MethodDeclaration method = null;
            Comment funcComment = null;
            if (this.isClassMethod()) {
                method = this.fAST.newMethodDeclaration();
                method.setFunction(function);
                int flags = this.fVisibility;
                if (this.isStaticMethod()) {
                    flags |= 0x80;
                }
                method.setModifier(flags);
                if (this.fGeneratePHPDoc) {
                    IScriptProject sp = this.fAnalyzer.getEnclosingBodyDeclaration().getProgramRoot().getSourceModule().getScriptProject();
                    ITypeBinding classDecl = ((MethodDeclaration)this.fAnalyzer.getEnclosingBodyDeclaration()).resolveMethodBinding().getDeclaringClass();
                    List parameters = method.getFunction().formalParameters();
                    String[] paramNames = new String[parameters.size()];
                    int i = 0;
                    while (i < parameters.size()) {
                        Expression name = ((FormalParameter)parameters.get(i)).getParameterName();
                        if (name instanceof Scalar) {
                            paramNames[i] = this.removeDollar(((Scalar)name).getStringValue());
                        }
                        if (name instanceof Identifier) {
                            paramNames[i] = ((Identifier)name).getName();
                        }
                        ++i;
                    }
                    String comments = CodeGeneration.getMethodComment((IScriptProject)sp, (String)classDecl.getName(), (String)method.getFunction().getFunctionName().getName(), (String[])paramNames, null, null, null, (String)lineDelimiter, null);
                    Comment commentNode = (Comment)this.fRewriter.createStringPlaceholder(comments, 16);
                    commentNode.setCommentType(2);
                    method.setComment(commentNode);
                }
            } else if (this.fGeneratePHPDoc) {
                IScriptProject sp = this.fAnalyzer.getEnclosingBodyDeclaration().getProgramRoot().getSourceModule().getScriptProject();
                List parameters = function.formalParameters();
                String[] paramNames = new String[parameters.size()];
                int i = 0;
                while (i < parameters.size()) {
                    Expression name = ((FormalParameter)parameters.get(i)).getParameterName();
                    if (name instanceof Scalar) {
                        paramNames[i] = this.removeDollar(((Scalar)name).getStringValue());
                    }
                    if (name instanceof Identifier) {
                        paramNames[i] = ((Identifier)name).getName();
                    }
                    ++i;
                }
                String comments = CodeGeneration.getMethodComment((IScriptProject)sp, (String)"", (String)function.getFunctionName().getName(), (String[])paramNames, null, null, null, (String)lineDelimiter, null);
                comments = String.valueOf(lineDelimiter) + comments + lineDelimiter;
                funcComment = (Comment)this.fRewriter.createStringPlaceholder(comments, 16);
                funcComment.setCommentType(2);
            }
            TextEditGroup insertDesc = new TextEditGroup(PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring.4"));
            this.textFileChange.addTextEditGroup(insertDesc);
            ChildListPropertyDescriptor desc = (ChildListPropertyDescriptor)declaration.getLocationInParent();
            ListRewrite container = null;
            container = declaration instanceof Program ? this.fRewriter.getListRewrite(declaration, Program.STATEMENTS_PROPERTY) : this.fRewriter.getListRewrite(declaration.getParent(), desc);
            if (method != null) {
                container.insertAfter((ASTNode)method, declaration, insertDesc);
            } else if (declaration instanceof Program) {
                List statements = ((Program)declaration).statements();
                int length = statements.size();
                Statement node = (Statement)statements.get(length - 1);
                if (length >= 2 && node instanceof InLineHtml) {
                    container.insertBefore((ASTNode)function, (ASTNode)statements.get(length - 2), insertDesc);
                    if (funcComment != null) {
                        container.insertBefore((ASTNode)funcComment, (ASTNode)function, insertDesc);
                    }
                } else if (length > 1 && node instanceof EmptyStatement) {
                    container.insertBefore((ASTNode)function, (ASTNode)statements.get(length - 1), insertDesc);
                    if (funcComment != null) {
                        container.insertBefore((ASTNode)funcComment, (ASTNode)function, insertDesc);
                    }
                } else {
                    container.insertLast((ASTNode)function, insertDesc);
                    if (funcComment != null) {
                        container.insertBefore((ASTNode)funcComment, (ASTNode)function, insertDesc);
                    }
                }
            } else {
                container.insertAfter((ASTNode)function, declaration, insertDesc);
                if (funcComment != null) {
                    container.insertBefore(funcComment, (ASTNode)function, insertDesc);
                }
            }
            if (this.getReplaceDuplicates()) {
                this.replaceDuplicates(this.textFileChange);
            }
            TextEdit edit = this.fRewriter.rewriteAST(this.document, null);
            root.addChild(edit);
            CompositeChange compositeChange = this.rootChange;
            return compositeChange;
        }
        finally {
            pm.done();
        }
    }

    private void replaceDuplicates(DocumentChange textFileChange2) {
        int numberOf = this.getNumberOfDuplicates();
        if (numberOf == 0 || !this.fReplaceDuplicates) {
            return;
        }
        String label = null;
        label = numberOf == 1 ? PHPRefactoringCoreMessages.format("ExtractFunctionRefactoring.5", new String[]{this.fNewFunctionName}) : PHPRefactoringCoreMessages.format("ExtractFunctionRefactoring.6", new String[]{this.fNewFunctionName});
        TextEditGroup description = new TextEditGroup(label);
        textFileChange2.addTextEditGroup(description);
        int d = 0;
        while (d < this.fDuplicates.length) {
            SnippetFinder.Match duplicate = this.fDuplicates[d];
            if (!duplicate.isMethodBody()) {
                ASTNode[] nodes;
                ASTNode[] callNodes = this.createCallNodes(duplicate);
                ASTNode[] aSTNodeArray = nodes = duplicate.getNodes();
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    ASTNode node = aSTNodeArray[n2];
                    this.fRewriter.replace(node, callNodes[0], description);
                    ++n2;
                }
            }
            ++d;
        }
    }

    private FunctionDeclaration createNewFunction(ASTNode[] selectedNodes, String lineSeparator, TextEditGroup substitute) {
        FunctionDeclaration result = this.createNewFunctionDeclaration();
        result.setBody(this.createFunctionBody(selectedNodes, substitute));
        return result;
    }

    private Block createFunctionBody(ASTNode[] selectedNodes, TextEditGroup substitute) {
        Block result = this.fAST.newBlock();
        ListRewrite statements = this.fRewriter.getListRewrite((ASTNode)result, Block.STATEMENTS_PROPERTY);
        for (ParameterInfo parameter : this.fParameterInfos) {
            if (!parameter.isRenamed()) continue;
            int n = 0;
            while (n < selectedNodes.length) {
                Identifier[] oldNames = LinkedNodeFinder.findByBinding(selectedNodes[n], parameter.getOldBinding());
                int i = 0;
                while (i < oldNames.length) {
                    this.fRewriter.replace((ASTNode)oldNames[i], (ASTNode)this.fAST.newIdentifier(this.removeDollar(parameter.getNewName())), substitute);
                    ++i;
                }
                ++n;
            }
        }
        boolean extractsExpression = this.fAnalyzer.isExpressionSelected();
        ASTNode[] callNodes = this.createCallNodes(null);
        ASTNode replacementNode = callNodes.length == 1 ? callNodes[0] : this.fRewriter.createGroupNode(callNodes);
        if (extractsExpression) {
            ReturnStatement rs = this.fAST.newReturnStatement();
            rs.setExpression((Expression)this.fRewriter.createMoveTarget(selectedNodes[0]));
            statements.insertLast((ASTNode)rs, null);
            this.fRewriter.replace(selectedNodes[0], replacementNode, substitute);
        } else {
            if (selectedNodes.length == 1) {
                statements.insertLast(this.fRewriter.createMoveTarget(selectedNodes[0]), substitute);
                this.fRewriter.replace(selectedNodes[0], replacementNode, substitute);
            } else {
                ListRewrite source = this.fRewriter.getListRewrite(selectedNodes[0].getParent(), (ChildListPropertyDescriptor)selectedNodes[0].getLocationInParent());
                ASTNode[] nodes = this.filterComments(selectedNodes);
                if (nodes.length > 0) {
                    ASTNode toMove = source.createMoveTarget(nodes[0], selectedNodes[nodes.length - 1], replacementNode, substitute);
                    statements.insertLast(toMove, substitute);
                }
            }
            IVariableBinding returnValue = this.fAnalyzer.getReturnValue();
            if (returnValue != null) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fAST.newIdentifier(this.getName(returnValue)));
                statements.insertLast((ASTNode)rs, null);
            }
        }
        return result;
    }

    private ASTNode[] filterComments(ASTNode[] selectedNodes) {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>(selectedNodes.length);
        ASTNode[] aSTNodeArray = selectedNodes;
        int n = selectedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode node = aSTNodeArray[n2];
            if (!(node instanceof Comment)) {
                nodes.add(node);
            }
            ++n2;
        }
        return nodes.toArray(new ASTNode[nodes.size()]);
    }

    private String getName(IVariableBinding binding) {
        for (ParameterInfo info : this.fParameterInfos) {
            if (!binding.equals((Object)info.getOldBinding())) continue;
            return info.getNewName();
        }
        return binding.getName();
    }

    private ASTNode[] createCallNodes(Object duplicate) {
        FunctionInvocation call;
        ArrayList<FunctionInvocation> result = new ArrayList<FunctionInvocation>(2);
        FunctionInvocation invocation = null;
        List arguments = null;
        if (this.isClassMethod()) {
            FunctionInvocation funcInv;
            if (this.isStaticMethod()) {
                invocation = this.fAST.newStaticMethodInvocation();
                funcInv = this.fAST.newFunctionInvocation();
                funcInv.setFunctionName(this.fAST.newFunctionName((Expression)this.fAST.newIdentifier(this.fNewFunctionName)));
                ((StaticMethodInvocation)invocation).setMethod(funcInv);
                ((StaticMethodInvocation)invocation).setClassName((Expression)this.fAST.newIdentifier("self"));
                arguments = ((StaticMethodInvocation)invocation).getMethod().parameters();
            } else {
                invocation = this.fAST.newMethodInvocation();
                funcInv = this.fAST.newFunctionInvocation();
                funcInv.setFunctionName(this.fAST.newFunctionName((Expression)this.fAST.newIdentifier(this.fNewFunctionName)));
                ((MethodInvocation)invocation).setMethod(funcInv);
                ((MethodInvocation)invocation).setDispatcher((VariableBase)this.fAST.newVariable("this"));
                arguments = ((MethodInvocation)invocation).getMethod().parameters();
            }
        } else {
            invocation = this.fAST.newFunctionInvocation();
            invocation.setFunctionName(this.fAST.newFunctionName((Expression)this.fAST.newIdentifier(this.fNewFunctionName)));
            arguments = invocation.parameters();
        }
        int i = 0;
        while (i < this.fParameterInfos.size()) {
            ParameterInfo parameter = this.fParameterInfos.get(i);
            arguments.add(this.fAST.newScalar(parameter.getOldName()));
            ++i;
        }
        int returnKind = this.fAnalyzer.getReturnKind();
        switch (returnKind) {
            case 2: {
                Assignment assignment = this.fAST.newAssignment();
                assignment.setLeftHandSide((VariableBase)this.fAST.newVariable(this.removeDollar(this.fAnalyzer.getReturnValue().getName())));
                assignment.setRightHandSide((Expression)invocation);
                call = assignment;
                break;
            }
            case 4: {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)invocation);
                call = rs;
                break;
            }
            default: {
                call = invocation;
            }
        }
        if (call instanceof Expression && !this.fAnalyzer.isExpressionSelected()) {
            call = this.fAST.newExpressionStatement((Expression)call);
        }
        result.add(call);
        return result.toArray(new ASTNode[result.size()]);
    }

    private String removeDollar(String name) {
        String value = name;
        if (name != null && name.length() > 0 && name.startsWith("$")) {
            value = name.substring(1);
        }
        return value;
    }

    private FunctionDeclaration createNewFunctionDeclaration() {
        FunctionDeclaration result = this.fAST.newFunctionDeclaration();
        result.setFunctionName(this.fAST.newIdentifier(this.fNewFunctionName));
        List parameters = result.formalParameters();
        int i = 0;
        while (i < this.fParameterInfos.size()) {
            ParameterInfo info = this.fParameterInfos.get(i);
            FormalParameter parameter = this.fAST.newFormalParameter();
            parameter.setParameterName((Expression)this.fAST.newScalar(info.getNewName()));
            parameters.add(parameter);
            ++i;
        }
        return result;
    }

    public String getName() {
        return PHPRefactoringCoreMessages.getString("ExtractFunctionRefactoring.8");
    }

    public RefactoringStatus checkNewVariableName(String text) {
        return this.doesNameAlreadyExist(text);
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fParameterInfos;
    }

    public int getNumberOfDuplicates() {
        return this.fDuplicates.length;
    }

    public void setVisibility(int intValue) {
        this.fVisibility = intValue;
    }

    public boolean getGeneratePHPdoc() {
        return this.fGeneratePHPDoc;
    }

    public void setGeneratePHPdoc(boolean value) {
        this.fGeneratePHPDoc = value;
    }

    public String getSignature() {
        return this.getSignature(this.fNewFunctionName);
    }

    public String getSignature(String methodName) {
        FunctionDeclaration methodDecl = this.createNewFunctionDeclaration();
        methodDecl.setBody(this.fAST.newBlock());
        methodDecl.getFunctionName();
        String str = ASTRewriteFlattener.asString((ASTNode)methodDecl, null);
        return str.substring(0, str.indexOf(123));
    }

    public void setMethodName(String text) {
        this.fNewFunctionName = text;
    }

    public RefactoringStatus checkFunctionName() {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(RefactoringUtility.checkNewElementName(this.fNewFunctionName));
        status.merge(this.doesNameAlreadyExist(this.fNewFunctionName));
        return status;
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(RefactoringUtility.checkNewElementName(this.fNewFunctionName));
        status.merge(this.doesNameAlreadyExist(this.fNewFunctionName));
        return status;
    }
}

