/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.ui.internal;

import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SourceLookupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text vmArguments;
    private Text launchFileVMArguments;
    private Text launchFileAttribute;

    public SourceLookupPreferencePage() {
        this.setMessage("Manual configuration of dynamic source lookup");
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.disableScrollingFor(composite);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        Label lblVMArguments = new Label(composite, 0);
        lblVMArguments.setText("VM arguments:");
        GridDataFactory textGridDataFactory = GridDataFactory.createFrom((GridData)new GridData(4, 4, true, false, 1, 1)).hint(parent.getSize().x, -1);
        this.vmArguments = new Text(composite, 2122);
        textGridDataFactory.applyTo((Control)this.vmArguments);
        String javaagentString = AdvancedSourceLookupSupport.getJavaagentString();
        this.vmArguments.setText(javaagentString);
        Label lblLaunchVMArguments = new Label(composite, 0);
        lblLaunchVMArguments.setText(".launch file VM arguments:");
        this.launchFileVMArguments = new Text(composite, 2122);
        textGridDataFactory.applyTo((Control)this.launchFileVMArguments);
        this.launchFileVMArguments.setText("-javaagent:${sourcelookup_agent_path}");
        Label lblLaunchFileAttribute = new Label(composite, 0);
        lblLaunchFileAttribute.setText(".launch file attribute:");
        this.launchFileAttribute = new Text(composite, 2122);
        this.launchFileAttribute.setText("<stringAttribute key=\"org.eclipse.debug.core.source_locator_id\" value=\"org.eclipse.m2e.sourcelookupDirector\"/>\n");
        textGridDataFactory.applyTo((Control)this.launchFileAttribute);
        return composite;
    }

    private void disableScrollingFor(final Composite composite) {
        Composite temp = composite;
        while (temp != null && !(temp instanceof ScrolledComposite)) {
            temp = temp.getParent();
        }
        final ScrolledComposite scrolledComposite = (ScrolledComposite)temp;
        if (scrolledComposite != null) {
            ControlAdapter resizeAndWrapRatherThanScroll = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (composite.isVisible()) {
                        scrolledComposite.setMinWidth(scrolledComposite.getSize().x);
                    }
                }
            };
            scrolledComposite.addControlListener((ControlListener)resizeAndWrapRatherThanScroll);
            composite.addDisposeListener(e -> scrolledComposite.removeControlListener((ControlListener)resizeAndWrapRatherThanScroll));
        }
    }
}

