/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.internal.model.component;

import java.util.List;
import java.util.Map;
import org.eclipse.jst.jsf.common.runtime.internal.model.behavioural.IEditableValueHolderInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentFactory;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.UIOutputInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorDecorator;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValueChangeListenerDecorator;

public class UIInputInfo
extends UIOutputInfo
implements IEditableValueHolderInfo {
    private static final long serialVersionUID = -6055473902554910848L;
    private final boolean _isValid;
    private final boolean _isImmediate;
    private final boolean _isRequired;
    private final Object _submittedValue;
    private final String _validator;
    private final String _valueChangeListener;
    private final boolean _localSetValue;

    protected UIInputInfo(String id, ComponentInfo parent, ComponentTypeInfo typeInfo, IEditableValueHolderInfo editableValueHolderInfo, boolean isRendered) {
        super(id, parent, typeInfo, editableValueHolderInfo, isRendered);
        if (editableValueHolderInfo == null) {
            this._isValid = true;
            this._isImmediate = false;
            this._isRequired = false;
            this._localSetValue = false;
            this._submittedValue = null;
            this._validator = null;
            this._valueChangeListener = null;
        } else {
            this._isValid = editableValueHolderInfo.isValid();
            this._isImmediate = editableValueHolderInfo.isImmediate();
            this._isRequired = editableValueHolderInfo.isRequired();
            this._localSetValue = editableValueHolderInfo.isLocalSetValue();
            this._submittedValue = editableValueHolderInfo.getSubmittedValue();
            this._validator = editableValueHolderInfo.getValidator();
            this._valueChangeListener = editableValueHolderInfo.getValueChangeListener();
            for (ValidatorDecorator validator : editableValueHolderInfo.getValidators()) {
                this.addValidator(validator);
            }
            for (ValueChangeListenerDecorator valueChangeListener : editableValueHolderInfo.getValueChangeListeners()) {
                this.addValueChangeListener(valueChangeListener);
            }
        }
    }

    protected UIInputInfo(ComponentInfo parent, ComponentTypeInfo typeInfo, Map attributes) {
        this(UIInputInfo.getStringProperty("id", attributes, true), parent, typeInfo, UIInputInfo.getEditableValueHolderInfo("$editableValueHolderInfo", attributes), UIInputInfo.getBooleanProperty("rendered", attributes, false));
    }

    private static IEditableValueHolderInfo getEditableValueHolderInfo(String key, Map attributes) {
        return (IEditableValueHolderInfo)attributes.get(key);
    }

    protected String getMostSpecificComponentName() {
        return "UIInput";
    }

    public final boolean isValid() {
        return this._isValid;
    }

    public final boolean isImmediate() {
        return this._isImmediate;
    }

    public final boolean isRequired() {
        return this._isRequired;
    }

    public final Object getSubmittedValue() {
        return this._submittedValue;
    }

    public final String getValidator() {
        return this._validator;
    }

    public final String getValueChangeListener() {
        return this._valueChangeListener;
    }

    public final boolean isLocalSetValue() {
        return this._localSetValue;
    }

    public final void addValidator(ValidatorDecorator validator) {
        this.addDecorator(validator, ComponentFactory.VALIDATOR);
    }

    public final void addValueChangeListener(ValueChangeListenerDecorator valueChangeListenerInfo) {
        this.addDecorator(valueChangeListenerInfo, ComponentFactory.VALUE_CHANGE_LISTENER);
    }

    public final List getValidators() {
        return this.getDecorators(ComponentFactory.VALIDATOR);
    }

    public final List getValueChangeListeners() {
        return this.getDecorators(ComponentFactory.VALUE_CHANGE_LISTENER);
    }
}

