/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.FillBehavior;
import org.eclipse.xwt.animation.Timeline;
import org.eclipse.xwt.animation.internal.ITimeline;
import org.eclipse.xwt.animation.internal.PathPropertyAccessor;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;

public abstract class AnimationTimeline
extends Timeline {
    private boolean isDestinationDefault;
    private String targetName;
    private String targetProperty;
    private Object initValue;
    private Object cacheValue;

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(String targetProperty) {
        this.targetProperty = targetProperty;
    }

    public boolean getIsDestinationDefault() {
        return this.isDestinationDefault;
    }

    public void setIsDestinationDefault(boolean isDestinationDefault) {
        this.isDestinationDefault = isDestinationDefault;
    }

    protected void setCacheValue(Object cacheValue) {
        this.cacheValue = cacheValue;
    }

    protected Object getCacheValue() {
        return this.cacheValue;
    }

    protected Object getInitValue() {
        return this.initValue;
    }

    @Override
    protected void initialize(Object target) {
        this.cacheValue = this.initValue = this.getCurrentValue(target);
    }

    @Override
    protected void endFinalize(Object target) {
        if (this.getFillBehavior() == FillBehavior.Stop) {
            Object element = this.findTarget(target);
            IMetaclass metaclass = XWT.getMetaclass(element);
            IProperty property = metaclass.findProperty(this.getTargetProperty());
            if (property == null) {
                throw new XWTException("Property \"" + this.getTargetProperty() + "\" is not found in " + metaclass.getType().getName());
            }
            try {
                property.setValue(element, this.initValue);
            }
            catch (Exception e) {
                throw new XWTException(e);
            }
        }
    }

    protected Object getCurrentValue(Object target) {
        Object element = this.findTarget(target);
        IMetaclass metaclass = XWT.getMetaclass(element);
        String targetProperty = this.getTargetProperty();
        int index = targetProperty.lastIndexOf(46);
        if (index != -1) {
            String lastNodePath = targetProperty.substring(0, index);
            String lastNodeName = targetProperty.substring(index + 1);
            PathPropertyAccessor accessor = new PathPropertyAccessor(lastNodePath);
            return accessor.get(element, lastNodeName);
        }
        IProperty property = metaclass.findProperty(this.getTargetProperty());
        if (property == null) {
            throw new XWTException("Property \"" + this.getTargetProperty() + "\" is not found in " + metaclass.getType().getName());
        }
        try {
            return property.getValue(element);
        }
        catch (Exception e) {
            throw new XWTException(e);
        }
    }

    @Override
    protected Object findTarget(Object target) {
        String targetName = this.getTargetName();
        if (targetName == null) {
            return target;
        }
        Object newTarget = UserData.findElementByName(target, targetName);
        if (newTarget == null) {
            throw new XWTException("Name element " + targetName + " is not found in animation.");
        }
        return super.findTarget(newTarget);
    }

    protected void update(ITimeline timeline) {
    }
}

