/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.layout;

import java.util.List;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.AbstractHeaderLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.GefMessages;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.GridLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.grid.header.selection.ColumnSelectionEditPolicy;
import org.eclipse.wb.internal.swt.model.layout.grid.GridColumnInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.IGridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class ColumnsLayoutEditPolicy<C extends IControlInfo>
extends AbstractHeaderLayoutEditPolicy {
    private final GridLayoutEditPolicy<C> m_mainPolicy;
    private final IGridLayoutInfo<C> m_layout;
    private final Figure m_insertFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private TextFeedback m_feedback;
    private Command m_moveCommand;

    public ColumnsLayoutEditPolicy(GridLayoutEditPolicy<C> mainPolicy, IGridLayoutInfo<C> layout) {
        super(mainPolicy);
        this.m_mainPolicy = mainPolicy;
        this.m_layout = layout;
    }

    protected void decorateChild(EditPart child) {
        child.installEditPolicy((Object)"Selection Feedback", new ColumnSelectionEditPolicy((LayoutEditPolicy)this.m_mainPolicy));
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (!this.m_layout.canChangeDimensions()) {
            return null;
        }
        return this.m_moveCommand;
    }

    protected void showLayoutTargetFeedback(Request request) {
        int size;
        int x;
        int index;
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        ColumnHeaderEditPart headerEditPart = (ColumnHeaderEditPart)((Object)changeBoundsRequest.getEditParts().get(0));
        IDropRequest dropRequest = (IDropRequest)request;
        Point location = dropRequest.getLocation().getCopy();
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int y1 = rowIntervals[0].begin - 5;
        int y2 = rowIntervals[rowIntervals.length - 1].end() + 5;
        DimensionHeaderEditPart target = null;
        List children = this.getHost().getChildren();
        for (EditPart child : children) {
            DimensionHeaderEditPart columnEditPart = (DimensionHeaderEditPart)child;
            Rectangle bounds = columnEditPart.getFigure().getBounds();
            if (gridInfo.isRTL()) {
                if (location.x <= bounds.getCenter().x) continue;
                target = columnEditPart;
                break;
            }
            if (location.x >= bounds.getCenter().x) continue;
            target = columnEditPart;
            break;
        }
        if (target != null) {
            index = target.getDimension().getIndex();
            Interval prevInterval = index == 0 ? new Interval(0, 0) : columnIntervals[index - 1];
            int[] parameters = GridLayoutEditPolicy.getInsertFeedbackParameters(prevInterval, columnIntervals[index], 7);
            x = parameters[1];
            size = parameters[2] - parameters[1];
        } else {
            index = this.m_layout.getColumns().size();
            this.m_mainPolicy.showInsertFeedbacks(null, null);
            x = columnIntervals[columnIntervals.length - 1].end() + 1;
            size = 7;
        }
        this.m_mainPolicy.showInsertFeedbacks(new Rectangle(x, y1, size, y2 - y1), null);
        if (this.m_insertFeedback.getParent() == null) {
            this.addFeedback(this.m_insertFeedback);
        }
        Rectangle bounds = new Rectangle(x, 0, size, this.getHostFigure().getSize().height);
        headerEditPart.translateModelToFeedback(bounds);
        this.m_insertFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new TextFeedback(feedbackLayer);
            this.m_feedback.add();
        }
        Point feedbackLocation = new Point(location.x + 30, 10);
        FigureUtils.translateAbsoluteToFigure((Figure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_feedback.setText(String.valueOf(GefMessages.ColumnsLayoutEditPolicy_feedbackTextPrefix) + index);
        GridColumnInfo column = (GridColumnInfo)headerEditPart.getDimension();
        final int sourceIndex = column.getIndex();
        this.m_moveCommand = index == sourceIndex || index == sourceIndex + 1 ? Command.EMPTY : new EditCommand(this.m_layout){

            protected void executeEdit() throws Exception {
                ColumnsLayoutEditPolicy.this.m_layout.command_MOVE_COLUMN(sourceIndex, index);
            }
        };
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.m_mainPolicy.eraseInsertFeedbacks();
        FigureUtils.removeFigure((Figure)this.m_insertFeedback);
        if (this.m_feedback != null) {
            this.m_feedback.remove();
            this.m_feedback = null;
        }
    }
}

