/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgent;
import org.eclipse.viatra.transformation.debug.communication.IDebuggerHostAgentListener;
import org.eclipse.viatra.transformation.debug.model.TransformationStackFrame;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelElement;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationState;
import org.eclipse.viatra.transformation.debug.ui.activator.TransformationDebugUIActivator;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.TransformationModelElementContentProvider;
import org.eclipse.viatra.transformation.debug.ui.views.modelinstancebrowser.TransformationModelElementLabelProvider;

public class ModelInstanceViewer
extends ViewPart
implements IDebuggerHostAgentListener {
    private static final String DEBUG_VIEW = "org.eclipse.debug.ui.DebugView";
    public static final String ID = "org.eclipse.viatra.transformation.ui.debug.TransformationViewer";
    private CTabFolder tabFolder;
    private TransformationThread currentThread;
    private Map<CTabItem, TreeViewer> tabMap = Maps.newHashMap();
    private ITreeContentProvider contentProvider;
    private TabbedSelectionProviderWrapper selectionProviderWrapper;

    public void createPartControl(Composite parent) {
        ISelectionService sService = this.getSite().getWorkbenchWindow().getSelectionService();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout(256));
        this.tabFolder = new CTabFolder(composite, 2048);
        this.tabFolder.setBorderVisible(true);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(35));
        this.selectionProviderWrapper = new TabbedSelectionProviderWrapper();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProviderWrapper);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof CTabItem) {
                    ModelInstanceViewer.this.selectionProviderWrapper.setActiveProvider((ISelectionProvider)ModelInstanceViewer.this.tabMap.get(ModelInstanceViewer.this.tabFolder.getSelection()));
                }
            }
        });
        ISelectionListener listener = (part, selection) -> {
            if (!selection.isEmpty() && selection instanceof StructuredSelection) {
                Object firstElement = ((StructuredSelection)selection).getFirstElement();
                try {
                    if (firstElement instanceof TransformationThread) {
                        this.currentThread = (TransformationThread)firstElement;
                        if (!this.currentThread.isTerminated()) {
                            this.maintainTabs();
                            this.currentThread.getHostAgent().registerDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
                        }
                    } else if (firstElement instanceof TransformationStackFrame) {
                        TransformationThread thread;
                        this.currentThread = thread = (TransformationThread)((TransformationStackFrame)firstElement).getThread();
                        if (!this.currentThread.isTerminated()) {
                            this.maintainTabs();
                            this.currentThread.getHostAgent().registerDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
                        }
                    }
                }
                catch (Exception e) {
                    TransformationDebugUIActivator.getDefault().logException(e.getMessage(), e);
                }
            }
        };
        sService.addSelectionListener(DEBUG_VIEW, listener);
    }

    private void maintainTabs() {
        List rootElements = this.currentThread.getModelProvider().getRootElements();
        this.tabMap.clear();
        this.disposeTabs();
        for (TransformationModelElement element : rootElements) {
            CTabItem ritem = new CTabItem(this.tabFolder, 0);
            String nameAttribute = element.getNameAttribute();
            ritem.setText(String.valueOf(element.getTypeAttribute()) + (nameAttribute.isEmpty() ? " " : " \"" + nameAttribute + "\" "));
            TreeViewer treeViewer = new TreeViewer((Composite)this.tabFolder, 268438018);
            ritem.setControl((Control)treeViewer.getTree());
            this.tabMap.put(ritem, treeViewer);
            this.contentProvider = new TransformationModelElementContentProvider(this.currentThread.getModelProvider());
            treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            treeViewer.setLabelProvider((IBaseLabelProvider)new TransformationModelElementLabelProvider());
            treeViewer.setInput((Object)new TransformationModelElement[]{element});
            ritem.setControl(treeViewer.getControl());
        }
        if (this.tabFolder.getItems().length > 0) {
            this.tabFolder.setSelection(this.tabFolder.getItems()[0]);
            this.selectionProviderWrapper.setActiveProvider((ISelectionProvider)this.tabMap.get(this.tabFolder.getSelection()));
        }
    }

    private void disposeTabs() {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
    }

    public void transformationStateChanged(TransformationState state) {
        if (this.currentThread.getTransformationState().equals(state)) {
            this.tabFolder.getDisplay().asyncExec(this::maintainTabs);
        }
    }

    public void terminated(IDebuggerHostAgent agent) {
        if (this.currentThread.getHostAgent().equals(agent)) {
            this.tabFolder.getDisplay().asyncExec(() -> {
                this.disposeTabs();
                this.currentThread = null;
            });
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void dispose() {
        this.selectionProviderWrapper.dispose();
        if (this.currentThread != null) {
            this.currentThread.getHostAgent().unRegisterDebuggerHostAgentListener((IDebuggerHostAgentListener)this);
        }
        super.dispose();
    }

    private static class TabbedSelectionProviderWrapper
    implements ISelectionProvider {
        private final ListenerList fListenerList = new ListenerList(1);
        private final ISelectionChangedListener fListener = this::fireSelectionChanged;
        private ISelectionProvider fActiveProvider;

        private TabbedSelectionProviderWrapper() {
        }

        public void setActiveProvider(ISelectionProvider provider) {
            if (this.fActiveProvider != null && (this.fActiveProvider.equals(provider) || this.equals(provider))) {
                return;
            }
            if (this.fActiveProvider != null) {
                this.fActiveProvider.removeSelectionChangedListener(this.fListener);
            }
            if (provider != null) {
                provider.addSelectionChangedListener(this.fListener);
            }
            this.fActiveProvider = provider;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            Object[] listeners = this.fListenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }

        private void dispose() {
            this.fListenerList.clear();
            this.setActiveProvider(null);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListenerList.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fActiveProvider != null) {
                return this.fActiveProvider.getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListenerList.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (this.fActiveProvider != null) {
                this.fActiveProvider.setSelection(selection);
            }
        }
    }
}

