/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public class MemoryViewBackedMapView<T>
implements Map<T, Integer> {
    private static final String READ_ONLY = "Read only";
    private final IMemoryView<T> wrapped;

    protected MemoryViewBackedMapView(IMemoryView<T> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsNonZeroUnsafe(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            for (Map.Entry<T, Integer> entry : this.wrapped.entriesWithMultiplicities()) {
                if (!entry.getValue().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer put(T key, Integer value) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Integer get(Object key) {
        int count2 = this.wrapped.getCountUnsafe(key);
        if (count2 == 0) {
            return null;
        }
        return count2;
    }

    @Override
    public Integer remove(Object key) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public void putAll(Map<? extends T, ? extends Integer> m) {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public Set<T> keySet() {
        return this.wrapped.distinctValues();
    }

    @Override
    public Collection<Integer> values() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.wrapped.forEachEntryWithMultiplicities((value, count2) -> {
            boolean bl = result.add((Integer)count2);
        });
        return result;
    }

    @Override
    public Set<Map.Entry<T, Integer>> entrySet() {
        HashSet<Map.Entry<T, Integer>> result = new HashSet<Map.Entry<T, Integer>>();
        for (Map.Entry<T, Integer> entry : this.wrapped.entriesWithMultiplicities()) {
            result.add(entry);
        }
        return result;
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

