/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.bracket;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketRelativeBendpoint;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.Direction;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.DirectionUtil;

public class BracketConnectionQuery {
    public static final Direction DEFAULT_SOURCE_SIDE = Direction.RIGHT;
    public static final Direction DEFAULT_DIRECTION = Direction.RIGHT;
    public static final int DEFAULT_OFFSET = 100;
    public static final int ORIGIN_POINT_INDEX = 2;
    public static final int TARGET_POINT_INDEX = 3;
    public static final int DECO_OFFSET = 8;
    private BendpointRequest bendpointRequest;
    private Connection connection;
    private PointList currentPointList;
    private boolean mustAddOriginAndTargetPoint;
    private Point updatedFirstPoint;
    private Point updatedLastPoint;
    private Direction generalDirection;
    private Direction newDirectionToSourceFigure;
    private Direction newDirectionToTargetFigure;
    private Rectangle sourceBounds;
    private Rectangle targetBounds;

    public BracketConnectionQuery(BendpointRequest bendpointRequest, Connection connection) {
        this.bendpointRequest = bendpointRequest;
        this.connection = connection;
        this.currentPointList = connection.getPoints();
    }

    public BracketConnectionQuery(Connection connection) {
        this(null, connection);
    }

    public PointList getNewPointList() {
        Direction newDirection;
        PointList pointListFromConstraint;
        this.currentPointList = pointListFromConstraint = this.getPointListFromConstraint();
        Point firstPoint = this.currentPointList.getFirstPoint().getCopy();
        Point lastPoint = this.currentPointList.getLastPoint().getCopy();
        Rectangle rectangle = new Rectangle(this.sourceBounds.getCenter(), this.targetBounds.getCenter());
        Point center = rectangle.getCenter().getCopy();
        Point location = this.bendpointRequest != null ? this.bendpointRequest.getLocation().getCopy() : this.currentPointList.getMidpoint().getCopy();
        this.connection.translateToRelative((Translatable)location);
        this.generalDirection = newDirection = DirectionUtil.getDirection(location, center);
        this.computeConnectionAnchorsLocation(location, newDirection);
        firstPoint = this.updatedFirstPoint;
        lastPoint = this.updatedLastPoint;
        PointList newPointList = new PointList();
        newPointList.addPoint(firstPoint);
        if (this.mustAddOriginAndTargetPoint) {
            this.addOriginAndTargetPoint(newPointList, newDirection, location, firstPoint, lastPoint);
        }
        newPointList.addPoint(lastPoint);
        this.currentPointList = newPointList;
        return newPointList;
    }

    private void addOriginAndTargetPoint(PointList newPointList, Direction newDirection, Point location, Point firstPoint, Point lastPoint) {
        Point originPoint = new Point();
        Point targetPoint = new Point();
        switch (newDirection) {
            case LEFT: 
            case RIGHT: {
                originPoint.setX(location.x);
                originPoint.setY(firstPoint.y);
                targetPoint.setX(location.x);
                targetPoint.setY(lastPoint.y);
                break;
            }
            case TOP: 
            case BOTTOM: {
                originPoint.setX(firstPoint.x);
                originPoint.setY(location.y);
                targetPoint.setX(lastPoint.x);
                targetPoint.setY(location.y);
            }
        }
        Point originDecoPoint = this.getOriginDecoPoint(originPoint);
        newPointList.addPoint(originDecoPoint);
        newPointList.addPoint(originPoint);
        newPointList.addPoint(targetPoint);
        Point targetDecoPoint = this.getTargetDecoPoint(targetPoint);
        newPointList.addPoint(targetDecoPoint);
    }

    public boolean isDefaultPointListAtCreation() {
        boolean isDefaultPointListAtCreation;
        if (this.currentPointList == null) {
            return false;
        }
        boolean bl = isDefaultPointListAtCreation = this.currentPointList.size() == 0;
        if (!isDefaultPointListAtCreation && this.connection != null) {
            Point firstPoint = this.currentPointList.getFirstPoint().getCopy();
            Point lastPoint = this.currentPointList.getLastPoint().getCopy();
            boolean defaultFirstPoint = firstPoint.x == 0 && firstPoint.y == 0;
            boolean defaultLastPoint = lastPoint.x == 100 && lastPoint.y == 100;
            isDefaultPointListAtCreation = this.currentPointList.size() == 2 && defaultFirstPoint && defaultLastPoint;
        }
        return isDefaultPointListAtCreation;
    }

    public boolean hasDefaultContraint() {
        boolean hasDefaultContraint = false;
        List bendpoints = (List)this.connection.getRoutingConstraint();
        hasDefaultContraint = bendpoints == null ? true : bendpoints.size() == 2;
        return hasDefaultContraint;
    }

    private boolean mustAddOriginAndTargetPoint(Point location, Point firstPoint, Point lastPoint, Direction newDirection) {
        switch (newDirection) {
            case LEFT: 
            case RIGHT: {
                this.mustAddOriginAndTargetPoint = firstPoint.y != lastPoint.y;
                break;
            }
            case TOP: 
            case BOTTOM: {
                this.mustAddOriginAndTargetPoint = firstPoint.x != lastPoint.x;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.mustAddOriginAndTargetPoint;
    }

    private Point getAnchorLocation(ConnectionAnchor connectionAnchor, Direction direction) {
        Point anchorLocation;
        block7: {
            block8: {
                block6: {
                    anchorLocation = null;
                    if (!(connectionAnchor.getOwner() instanceof Connection)) break block6;
                    Connection ownerConnection = (Connection)connectionAnchor.getOwner();
                    anchorLocation = ownerConnection.getPoints().getMidpoint().getCopy();
                    ownerConnection.translateToAbsolute((Translatable)anchorLocation);
                    break block7;
                }
                Rectangle connectionAnchorOwnerBounds = this.getConnectionAnchorOwnerBounds(connectionAnchor.getOwner());
                if (connectionAnchorOwnerBounds == null) break block8;
                switch (direction) {
                    case LEFT: {
                        anchorLocation = connectionAnchorOwnerBounds.getLeft().getCopy();
                        break block7;
                    }
                    case RIGHT: {
                        anchorLocation = connectionAnchorOwnerBounds.getRight().getCopy();
                        break block7;
                    }
                    case TOP: {
                        anchorLocation = connectionAnchorOwnerBounds.getTop().getCopy();
                        break block7;
                    }
                    case BOTTOM: {
                        anchorLocation = connectionAnchorOwnerBounds.getBottom().getCopy();
                        break block7;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            anchorLocation = connectionAnchor == this.connection.getSourceAnchor() ? this.connection.getPoints().getFirstPoint().getCopy() : this.connection.getPoints().getLastPoint().getCopy();
        }
        this.connection.translateToRelative((Translatable)anchorLocation);
        return anchorLocation;
    }

    private Rectangle getConnectionAnchorOwnerBounds(IFigure connectionAnchorOwner) {
        if (connectionAnchorOwner == null) {
            return null;
        }
        Rectangle connectionAnchorOwnerBounds = connectionAnchorOwner.getBounds().getCopy();
        if (connectionAnchorOwner instanceof Connection) {
            Connection connectionOwner = (Connection)connectionAnchorOwner;
            connectionAnchorOwnerBounds = new Rectangle(connectionOwner.getPoints().getMidpoint(), Dimension.SINGLETON);
        }
        if (this.bendpointRequest != null) {
            Point location = connectionAnchorOwnerBounds.getLocation();
            connectionAnchorOwner.translateToAbsolute((Translatable)location);
            connectionAnchorOwnerBounds.setLocation(location);
        } else {
            connectionAnchorOwner.translateToAbsolute((Translatable)connectionAnchorOwnerBounds);
        }
        return connectionAnchorOwnerBounds;
    }

    public Direction getDirection(Point location, IFigure connectionAnchorOwner, Direction direction) {
        Direction result;
        Rectangle connectionAnchorOwnerBounds = this.getConnectionAnchorOwnerBounds(connectionAnchorOwner);
        Point center = connectionAnchorOwnerBounds.getCenter();
        int diffX = location.x - center.x;
        int diffY = location.y - center.y;
        switch (direction) {
            case LEFT: 
            case RIGHT: {
                if (diffX < 0) {
                    result = Direction.LEFT;
                    break;
                }
                result = Direction.RIGHT;
                break;
            }
            case TOP: 
            case BOTTOM: {
                if (diffY > 0) {
                    result = Direction.BOTTOM;
                    break;
                }
                result = Direction.TOP;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public void computeConnectionAnchorsLocation(Point location, Direction newDirection) {
        Point firstPoint = this.currentPointList.getFirstPoint().getCopy();
        Point lastPoint = this.currentPointList.getLastPoint().getCopy();
        this.newDirectionToSourceFigure = this.getDirection(location, this.connection.getSourceAnchor().getOwner(), newDirection);
        this.newDirectionToTargetFigure = this.getDirection(location, this.connection.getTargetAnchor().getOwner(), newDirection);
        this.mustAddOriginAndTargetPoint = this.mustAddOriginAndTargetPoint(location, firstPoint, lastPoint, newDirection);
        this.updatedFirstPoint = this.getAnchorLocation(this.connection.getSourceAnchor(), this.newDirectionToSourceFigure);
        this.updatedLastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), this.newDirectionToTargetFigure);
        if (!this.mustAddOriginAndTargetPoint) {
            switch (newDirection) {
                case LEFT: 
                case RIGHT: {
                    this.updatedFirstPoint = this.getAnchorLocation(this.connection.getSourceAnchor(), Direction.LEFT);
                    this.updatedLastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), Direction.RIGHT);
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    this.updatedFirstPoint = this.getAnchorLocation(this.connection.getSourceAnchor(), Direction.BOTTOM);
                    this.updatedLastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), Direction.TOP);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private Point getOriginDecoPoint(Point originPoint) {
        Point originDecoPoint = this.getDecoPoint(this.newDirectionToSourceFigure, this.sourceBounds, originPoint);
        return originDecoPoint;
    }

    private Point getTargetDecoPoint(Point targetPoint) {
        Point targetDecoPoint = this.getDecoPoint(this.newDirectionToTargetFigure, this.targetBounds, targetPoint);
        return targetDecoPoint;
    }

    private Point getDecoPoint(Direction specificDirection, Rectangle ownerBounds, Point point) {
        Point decoPoint = new Point();
        switch (specificDirection) {
            case RIGHT: {
                decoPoint.setY(point.y);
                if (point.x > ownerBounds.x && point.x < ownerBounds.x + ownerBounds.width) {
                    decoPoint.setX(point.x - 8);
                    break;
                }
                decoPoint.setX(point.x + 8);
                break;
            }
            case LEFT: {
                decoPoint.setY(point.y);
                if (point.x > ownerBounds.x && point.x < ownerBounds.x + ownerBounds.width) {
                    decoPoint.setX(point.x + 8);
                    break;
                }
                decoPoint.setX(point.x - 8);
                break;
            }
            case TOP: {
                decoPoint.setX(point.x);
                if (point.y > ownerBounds.y && point.y < ownerBounds.y + ownerBounds.height) {
                    decoPoint.setY(point.y + 8);
                    break;
                }
                decoPoint.setY(point.y - 8);
                break;
            }
            case BOTTOM: {
                decoPoint.setX(point.x);
                if (point.y > ownerBounds.y && point.y < ownerBounds.y + ownerBounds.height) {
                    decoPoint.setY(point.y - 8);
                    break;
                }
                decoPoint.setY(point.y + 8);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return decoPoint;
    }

    public PointList getPointListFromConstraint() {
        return this.getPointListFromConstraintAndMove(new Point(0, 0), true);
    }

    public PointList getPointListFromConstraintAndMove(Point moveDelta, boolean sourceMove) {
        List bracketRelativeBendpoints = (List)this.connection.getRoutingConstraint();
        PointList points = new PointList();
        Point firstPoint = null;
        Point originPoint = null;
        Point originDecoPoint = null;
        Point targetDecoPoint = null;
        Point targetPoint = null;
        Point lastPoint = null;
        if (bracketRelativeBendpoints != null && bracketRelativeBendpoints.size() == 1) {
            BracketRelativeBendpoint firstDimensionRelativeBendpoint = (BracketRelativeBendpoint)((Object)bracketRelativeBendpoints.get(0));
            Direction sourceDirection = Direction.values()[firstDimensionRelativeBendpoint.getSourceDirection()];
            Direction firstDirection = Direction.values()[firstDimensionRelativeBendpoint.getDirection()];
            int firstOffset = firstDimensionRelativeBendpoint.getOffset();
            this.generalDirection = firstDirection;
            firstPoint = this.getAnchorLocation(this.connection.getSourceAnchor(), sourceDirection);
            Point targetReferencePoint = this.connection.getTargetAnchor().getReferencePoint();
            if (this.connection.getTargetAnchor().getOwner() instanceof Connection) {
                Connection targetConnection = (Connection)this.connection.getTargetAnchor().getOwner();
                targetReferencePoint = targetConnection.getPoints().getMidpoint().getCopy();
            }
            if (this.connection.getTargetAnchor() == null || this.connection.getSourceAnchor() == null || this.connection.getTargetAnchor().getOwner() == null || this.connection.getSourceAnchor().getOwner() == null) {
                return this.connection.getPoints();
            }
            this.sourceBounds = this.getConnectionAnchorOwnerBounds(this.connection.getSourceAnchor().getOwner());
            this.connection.translateToRelative((Translatable)this.sourceBounds);
            this.targetBounds = this.getConnectionAnchorOwnerBounds(this.connection.getTargetAnchor().getOwner());
            this.connection.translateToRelative((Translatable)this.targetBounds);
            if (sourceMove) {
                firstPoint.translate(moveDelta);
                this.sourceBounds.translate(moveDelta);
            } else {
                this.targetBounds.translate(moveDelta);
                targetReferencePoint.translate(moveDelta);
            }
            Enum lastDirection = null;
            int lastOffset = 0;
            switch (firstDirection) {
                case RIGHT: {
                    originDecoPoint = firstPoint.getTranslated(firstOffset + 8, 0);
                    originPoint = originDecoPoint.getTranslated(-8, 0);
                    lastDirection = targetReferencePoint.x > originPoint.x ? Direction.LEFT : Direction.RIGHT;
                    lastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), (Direction)lastDirection);
                    if (!sourceMove) {
                        lastPoint.translate(moveDelta);
                    }
                    lastOffset = originPoint.x - lastPoint.x;
                    break;
                }
                case LEFT: {
                    originDecoPoint = firstPoint.getTranslated(-firstOffset - 8, 0);
                    originPoint = originDecoPoint.getTranslated(8, 0);
                    lastDirection = targetReferencePoint.x < originPoint.x ? Direction.RIGHT : Direction.LEFT;
                    lastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), (Direction)lastDirection);
                    if (!sourceMove) {
                        lastPoint.translate(moveDelta);
                    }
                    lastOffset = originPoint.x - lastPoint.x;
                    break;
                }
                case TOP: {
                    originDecoPoint = firstPoint.getTranslated(0, -firstOffset - 8);
                    originPoint = originDecoPoint.getTranslated(0, 8);
                    lastDirection = targetReferencePoint.y > originPoint.y ? Direction.TOP : Direction.BOTTOM;
                    lastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), (Direction)lastDirection);
                    if (!sourceMove) {
                        lastPoint.translate(moveDelta);
                    }
                    lastOffset = originPoint.y - lastPoint.y;
                    break;
                }
                case BOTTOM: {
                    originDecoPoint = firstPoint.getTranslated(0, firstOffset + 8);
                    originPoint = originDecoPoint.getTranslated(0, -8);
                    lastDirection = targetReferencePoint.y > originPoint.y ? Direction.TOP : Direction.BOTTOM;
                    lastPoint = this.getAnchorLocation(this.connection.getTargetAnchor(), (Direction)lastDirection);
                    if (!sourceMove) {
                        lastPoint.translate(moveDelta);
                    }
                    lastOffset = originPoint.y - lastPoint.y;
                }
            }
            switch (BracketConnectionQuery.$SWITCH_TABLE$org$eclipse$sirius$diagram$ui$business$internal$bracket$Direction()[lastDirection.ordinal()]) {
                case 2: {
                    if (originPoint.x > this.targetBounds.x && originPoint.x < this.targetBounds.x + this.targetBounds.width) {
                        targetDecoPoint = lastPoint.getTranslated(lastOffset - 8, 0);
                        targetPoint = targetDecoPoint.getTranslated(8, 0);
                        break;
                    }
                    targetDecoPoint = lastPoint.getTranslated(lastOffset + 8, 0);
                    targetPoint = targetDecoPoint.getTranslated(-8, 0);
                    break;
                }
                case 1: {
                    if (originPoint.x > this.targetBounds.x && originPoint.x < this.targetBounds.x + this.targetBounds.width) {
                        targetDecoPoint = lastPoint.getTranslated(lastOffset + 8, 0);
                        targetPoint = targetDecoPoint.getTranslated(-8, 0);
                        break;
                    }
                    targetDecoPoint = lastPoint.getTranslated(lastOffset - 8, 0);
                    targetPoint = targetDecoPoint.getTranslated(8, 0);
                    break;
                }
                case 3: {
                    if (originPoint.y > this.targetBounds.y && originPoint.y < this.targetBounds.y + this.targetBounds.height) {
                        targetDecoPoint = lastPoint.getTranslated(0, lastOffset + 8);
                        targetPoint = targetDecoPoint.getTranslated(0, -8);
                        break;
                    }
                    targetDecoPoint = lastPoint.getTranslated(0, lastOffset - 8);
                    targetPoint = targetDecoPoint.getTranslated(0, 8);
                    break;
                }
                case 4: {
                    if (originPoint.y > this.targetBounds.y && originPoint.y < this.targetBounds.y + this.targetBounds.height) {
                        targetDecoPoint = lastPoint.getTranslated(0, lastOffset - 8);
                        targetPoint = targetDecoPoint.getTranslated(0, 8);
                        break;
                    }
                    targetDecoPoint = lastPoint.getTranslated(0, lastOffset + 8);
                    targetPoint = targetDecoPoint.getTranslated(0, -8);
                }
            }
            points.addPoint(firstPoint);
            if (!this.isVerticalBracket(firstDirection, (Direction)lastDirection) && !this.isHorizontalBracket(firstDirection, (Direction)lastDirection)) {
                points.addPoint(originDecoPoint);
                points.addPoint(originPoint);
                points.addPoint(targetPoint);
                points.addPoint(targetDecoPoint);
            }
            points.addPoint(lastPoint);
        }
        return points;
    }

    public boolean isVerticalBracket(Direction firstDirection, Direction lastDirection) {
        boolean isVerticalDimensionOnDirection;
        boolean bl = isVerticalDimensionOnDirection = firstDirection == Direction.TOP && lastDirection == Direction.BOTTOM || firstDirection == Direction.BOTTOM && lastDirection == Direction.TOP;
        return isVerticalDimensionOnDirection && this.connection.getSourceAnchor().getOwner().getBounds().getCenter().x == this.connection.getTargetAnchor().getOwner().getBounds().getCenter().x;
    }

    public boolean isHorizontalBracket(Direction firstDirection, Direction lastDirection) {
        boolean isHorizontalDimension;
        boolean bl = isHorizontalDimension = firstDirection == Direction.LEFT && lastDirection == Direction.RIGHT || firstDirection == Direction.RIGHT && lastDirection == Direction.LEFT;
        return isHorizontalDimension && this.connection.getSourceAnchor().getOwner().getBounds().getCenter().y == this.connection.getTargetAnchor().getOwner().getBounds().getCenter().y;
    }

    public List<RelativeBendpoint> getGMFRelativeBendpoints(PointList newPointList) {
        List<RelativeBendpoint> relativeBendpointsFromPointList = null;
        if (newPointList.size() >= 2) {
            Point firstPoint = newPointList.getFirstPoint();
            Point lastPoint = newPointList.getLastPoint();
            Direction firstDirection = DirectionUtil.getDirection(newPointList.getPoint(1), firstPoint);
            Direction sourceDirection = DirectionUtil.getDirection(firstPoint, this.sourceBounds.getCenter());
            int firstOffset = 0;
            switch (firstDirection) {
                case LEFT: 
                case RIGHT: {
                    firstOffset = Math.abs(firstPoint.x - lastPoint.x);
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    firstOffset = Math.abs(firstPoint.y - lastPoint.y);
                    break;
                }
            }
            if (newPointList.size() == 6) {
                Point originPoint = newPointList.getPoint(2);
                switch (firstDirection) {
                    case LEFT: 
                    case RIGHT: {
                        firstOffset = Math.abs(originPoint.x - firstPoint.x);
                        break;
                    }
                    case TOP: 
                    case BOTTOM: {
                        firstOffset = Math.abs(originPoint.y - firstPoint.y);
                        break;
                    }
                }
            }
            relativeBendpointsFromPointList = this.getGMFRelativeBendpoints(sourceDirection, firstDirection, firstOffset);
        }
        return relativeBendpointsFromPointList;
    }

    public List<RelativeBendpoint> getGMFRelativeBendpoints(Direction sourceDirection, Direction firstDirection, int firstOffset) {
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        newBendpoints.add(new RelativeBendpoint(sourceDirection.ordinal(), firstDirection.ordinal(), firstOffset, -1));
        return newBendpoints;
    }

    public List<BracketRelativeBendpoint> getBracketRelativeBendointFromGMFRelativeBendpoints(List<RelativeBendpoint> gmfRelativeBendpoints) {
        ArrayList<BracketRelativeBendpoint> figureConstraint = new ArrayList<BracketRelativeBendpoint>();
        if (gmfRelativeBendpoints.size() == 1) {
            RelativeBendpoint firstGMFRelativeBendpoint = gmfRelativeBendpoints.get(0);
            int firstSourceDirection = firstGMFRelativeBendpoint.getSourceX();
            int firstDirection = firstGMFRelativeBendpoint.getSourceY();
            int firstOffset = firstGMFRelativeBendpoint.getTargetX();
            figureConstraint.add(new BracketRelativeBendpoint(this.connection, firstSourceDirection, firstDirection, firstOffset));
        }
        return figureConstraint;
    }

    public Direction getGeneralDirection() {
        return this.generalDirection;
    }

    public Rectangle getBracketSegmentBounds() {
        Rectangle bracketSegmentRectangle = new Rectangle();
        PointList points = this.connection.getPoints();
        if (points.size() == 2) {
            Point firstPoint = points.getFirstPoint();
            Point lastPoint = points.getLastPoint();
            bracketSegmentRectangle = new Rectangle(firstPoint, lastPoint);
        } else if (points.size() == 6) {
            Point point1 = points.getPoint(2);
            Point point2 = points.getPoint(3);
            bracketSegmentRectangle = new Rectangle(point1, point2);
        }
        return bracketSegmentRectangle;
    }
}

