/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.RequirementsBuilder;
import org.eclipse.reddeer.junit.internal.runner.IgnoredClassRunner;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRunner;
import org.eclipse.reddeer.junit.internal.runner.RequirementsRunner;
import org.eclipse.reddeer.junit.internal.runner.TestsExecutionManager;
import org.junit.Ignore;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.RunnerBuilder;

public class RequirementsRunnerBuilder
extends RunnerBuilder {
    public TestsExecutionManager testsManager;
    private Logger log = Logger.getLogger(RequirementsRunnerBuilder.class);
    private RequirementsBuilder requirementsBuilder = new RequirementsBuilder();
    private List<IBeforeTest> beforeTestExtensions;
    private List<IAfterTest> afterTestExtensions;
    private RunListener[] runListeners;
    private RequirementConfigurationSet configurationSet;

    public RequirementsRunnerBuilder(RequirementConfigurationSet configurationSet) {
        this(configurationSet, null, null, null, null);
    }

    public RequirementsRunnerBuilder(RequirementConfigurationSet configurationSet, RunListener[] runListeners, List<IBeforeTest> beforeTestExtensions) {
        this(configurationSet, runListeners, beforeTestExtensions, null, null);
    }

    public RequirementsRunnerBuilder(RequirementConfigurationSet configurationSet, RunListener[] runListeners, List<IBeforeTest> beforeTestExtensions, List<IAfterTest> afterTestExtensions, TestsExecutionManager testsManager) {
        this.configurationSet = configurationSet;
        this.runListeners = runListeners;
        this.beforeTestExtensions = beforeTestExtensions;
        this.afterTestExtensions = afterTestExtensions;
        this.testsManager = testsManager;
    }

    public Runner runnerForClass(Class<?> clazz) throws Throwable {
        if (clazz.getAnnotation(Ignore.class) != null) {
            return new IgnoredClassRunner(clazz);
        }
        if (clazz.getAnnotation(Suite.SuiteClasses.class) != null) {
            return new Suite(clazz, (RunnerBuilder)this);
        }
        this.log.info("Found test " + clazz);
        if (this.testsManager != null) {
            this.testsManager.addTest(clazz);
        }
        Requirements requirements = this.requirementsBuilder.build(this.configurationSet, clazz);
        if (this.testsManager != null) {
            this.testsManager.addExecutedTest(clazz);
        }
        if (this.isParameterized(clazz)) {
            return new ParameterizedRunner(clazz, requirements, this.configurationSet.getId(), this.runListeners, this.beforeTestExtensions, this.afterTestExtensions);
        }
        return new RequirementsRunner(clazz, requirements, this.configurationSet.getId(), this.runListeners, this.beforeTestExtensions, this.afterTestExtensions);
    }

    private boolean isParameterized(Class<?> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(Parameterized.Parameters.class) != null && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

