/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Comparator;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class SortedCollectionContainerPolicy
extends CollectionContainerPolicy {
    protected Comparator m_comparator = null;
    protected Class comparatorClass = null;
    protected String comparatorClassName = null;

    public SortedCollectionContainerPolicy() {
    }

    public SortedCollectionContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public SortedCollectionContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public void setComparatorClass(Class comparatorClass) {
        if (!Helper.classImplementsInterface(comparatorClass, Comparator.class)) {
            throw ValidationException.invalidComparatorClass(comparatorClass.getName());
        }
        this.m_comparator = (Comparator)Helper.getInstanceFromClass(comparatorClass);
        this.comparatorClass = comparatorClass;
    }

    public void setComparatorClassName(String comparatorClassName) {
        this.comparatorClassName = comparatorClassName;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public Class getComparatorClass() {
        return this.comparatorClass;
    }

    public String getComparatorClassName() {
        if (this.m_comparator != null) {
            return this.m_comparator.getClass().getName();
        }
        if (this.comparatorClass != null) {
            return this.comparatorClass.getName();
        }
        if (this.comparatorClassName != null) {
            return this.comparatorClassName;
        }
        return null;
    }

    @Override
    public Object containerInstance() {
        try {
            if (this.m_comparator == null && this.comparatorClass != null) {
                if (Helper.classImplementsInterface(this.comparatorClass, Comparator.class)) {
                    this.m_comparator = (Comparator)Helper.getInstanceFromClass(this.comparatorClass);
                } else {
                    throw ValidationException.invalidComparatorClass(this.comparatorClass.getName());
                }
            }
            if (this.m_comparator != null) {
                Object[] arguments = new Object[]{this.m_comparator};
                Class[] constructClass = new Class[]{Comparator.class};
                Constructor constructor = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        constructor = AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), constructClass, false));
                        return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, arguments));
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                    }
                }
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), constructClass, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, arguments);
            }
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.getContainerClass()));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.m_comparator != null) return;
        if (this.comparatorClass == null) {
            if (this.comparatorClassName == null) return;
            Class comparatorClass = Helper.getClassFromClasseName(this.comparatorClassName, classLoader);
            if (!Helper.classImplementsInterface(comparatorClass, Comparator.class)) throw ValidationException.invalidComparatorClass(this.comparatorClassName);
            this.m_comparator = (Comparator)Helper.getInstanceFromClass(comparatorClass);
            return;
        } else {
            if (!Helper.classImplementsInterface(this.comparatorClass, Comparator.class)) throw ValidationException.invalidComparatorClass(this.comparatorClass.getName());
            this.m_comparator = (Comparator)Helper.getInstanceFromClass(this.comparatorClass);
        }
    }
}

