/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.FilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.PatternViewerFilter;
import org.eclipse.papyrus.infra.widgets.providers.SemanticWorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.strategy.StrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.WorkspaceRevealStrategy;
import org.eclipse.swt.widgets.Composite;

public class WorkspaceContentProvider
extends EncapsulatedContentProvider {
    private Map<String, String> extensionFilters = new LinkedHashMap<String, String>();
    private PatternViewerFilter extensionViewerFilter = new PatternViewerFilter();
    private ISelectionChangedListener extensionFiltersListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            String patternString = "*";
            if (!event.getSelection().isEmpty()) {
                patternString = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
            }
            WorkspaceContentProvider.this.extensionViewerFilter.setPattern(patternString);
            WorkspaceContentProvider.this.viewer.refresh();
        }
    };
    protected StructuredViewer viewer;

    public WorkspaceContentProvider() {
        this.encapsulated = this.encapsulateProvider(WorkspaceContentProvider.getSemanticProvider());
        this.extensionFilters.put("*", "All (*)");
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (viewer instanceof StructuredViewer) {
            this.viewer = (StructuredViewer)viewer;
            this.addViewerFilter(this.viewer, this.extensionViewerFilter);
        }
    }

    protected static IHierarchicContentProvider getSemanticProvider() {
        return new SemanticWorkspaceContentProvider();
    }

    public void setExtensionFilters(Map<String, String> extensionFilters) {
        this.extensionFilters = extensionFilters;
    }

    public void addExtensionFilter(String pattern, String label) {
        this.extensionFilters.put(pattern, label);
    }

    protected IStructuredContentProvider encapsulateProvider(IHierarchicContentProvider provider) {
        ProviderBasedBrowseStrategy browseStrategy = new ProviderBasedBrowseStrategy(provider);
        WorkspaceRevealStrategy revealStrategy = new WorkspaceRevealStrategy(provider);
        StrategyBasedContentProvider strategyProvider = new StrategyBasedContentProvider(browseStrategy, revealStrategy);
        ExtensionFilteredContentProvider graphicalProvider = new ExtensionFilteredContentProvider(strategyProvider);
        return graphicalProvider;
    }

    @Override
    public void setFlat(boolean isFlat) {
        super.setFlat(isFlat);
        if (this.viewer != null) {
            ViewerFilter[] filters = this.viewer.getFilters();
            int i = 0;
            while (i < filters.length) {
                if (filters[i] instanceof PatternViewerFilter) {
                    ((PatternViewerFilter)filters[i]).clearCache();
                }
                ++i;
            }
            this.viewer.refresh();
        }
    }

    private class ExtensionFilteredContentProvider
    extends FilteredContentProvider {
        public ExtensionFilteredContentProvider(IHierarchicContentProvider semanticProvider) {
            super((IStructuredContentProvider)semanticProvider);
        }

        @Override
        public void createAfter(Composite parent) {
            super.createAfter(parent);
            ComboViewer extensionFiltersViewer = new ComboViewer(parent);
            extensionFiltersViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
            extensionFiltersViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (((ExtensionFilteredContentProvider)ExtensionFilteredContentProvider.this).WorkspaceContentProvider.this.extensionFilters.containsKey(element)) {
                        return ((ExtensionFilteredContentProvider)ExtensionFilteredContentProvider.this).WorkspaceContentProvider.this.extensionFilters.get(element);
                    }
                    return super.getText(element);
                }
            });
            extensionFiltersViewer.addSelectionChangedListener(WorkspaceContentProvider.this.extensionFiltersListener);
            extensionFiltersViewer.setInput(WorkspaceContentProvider.this.extensionFilters.keySet());
            if (!WorkspaceContentProvider.this.extensionFilters.isEmpty()) {
                extensionFiltersViewer.setSelection((ISelection)new StructuredSelection((Object)WorkspaceContentProvider.this.extensionFilters.keySet().iterator().next()));
            }
        }
    }
}

