/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.lang.reflect.Array;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CompositeServiceTracker<S>
extends ServiceTracker<S, S> {
    private final AtomicReference<S> delegate = new AtomicReference();
    private final Class<S> serviceType;
    private final S identity;
    private final BinaryOperator<S> composer;

    public CompositeServiceTracker(BundleContext context, Class<S> serviceType, S identity, BinaryOperator<S> composer) {
        super(context, serviceType, null);
        this.serviceType = serviceType;
        this.identity = identity;
        this.composer = composer;
    }

    public final S getService() {
        Object result = this.delegate.get();
        if (result == null) {
            Object[] services = (Object[])Array.newInstance(this.serviceType, this.getTrackingCount());
            result = Stream.of(this.getServices(services)).filter(Objects::nonNull).reduce(this.identity, this.composer);
            this.delegate.set(result);
        }
        return result;
    }

    public S addingService(ServiceReference<S> reference) {
        Object result = super.addingService(reference);
        this.delegate.set(null);
        return (S)result;
    }

    public void removedService(ServiceReference<S> reference, S service) {
        super.removedService(reference, service);
        this.delegate.set(null);
    }
}

