/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.maven.model.RepositoryBase;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.m2e.pde.MavenTargetRepository;
import org.eclipse.m2e.pde.ui.editor.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MavenTargetRepositoryEditor
extends Dialog {
    private List<MavenTargetRepository> repositoryList;
    private List<MavenTargetRepository> editList;
    private TableViewer tableViewer;

    public MavenTargetRepositoryEditor(Shell shell, List<MavenTargetRepository> repositoryList) {
        super(shell);
        this.repositoryList = repositoryList;
        this.editList = repositoryList.stream().map(MavenTargetRepository::copy).collect(Collectors.toCollection(ArrayList::new));
    }

    public int open() {
        int open = super.open();
        if (open == 0) {
            this.repositoryList.clear();
            this.repositoryList.addAll(this.editList);
        }
        return open;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1025, Messages.MavenTargetRepositoryEditor_1, false);
        button.addSelectionListener(new SelectionListener(){
            int counter = 1;

            public void widgetSelected(SelectionEvent e) {
                MavenTargetRepositoryEditor.this.editList.add(new MavenTargetRepository("Id" + this.counter++, "https://"));
                MavenTargetRepositoryEditor.this.tableViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.tableViewer = new TableViewer(container, 68356);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object selected = MavenTargetRepositoryEditor.this.tableViewer.getStructuredSelection().getFirstElement();
                if (selected instanceof MavenTargetRepository) {
                    final MavenTargetRepository repository = (MavenTargetRepository)selected;
                    manager.add((IAction)new Action("Delete"){

                        public void run() {
                            (this).MavenTargetRepositoryEditor.this.editList.remove(repository);
                            (this).MavenTargetRepositoryEditor.this.tableViewer.refresh();
                        }
                    });
                }
            }
        });
        this.tableViewer.getControl().setMenu(contextMenu.createContextMenu(this.tableViewer.getControl()));
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText("Id");
        column.getColumn().setWidth(150);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((MavenTargetRepository)element).getId();
            }
        });
        column.setEditingSupport((EditingSupport)new TextEditingSupport((ColumnViewer)this.tableViewer, RepositoryBase::getId, RepositoryBase::setId));
        column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setText("URL");
        column.getColumn().setWidth(300);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((MavenTargetRepository)element).getUrl();
            }
        });
        column.setEditingSupport((EditingSupport)new TextEditingSupport((ColumnViewer)this.tableViewer, RepositoryBase::getUrl, RepositoryBase::setUrl));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setInput(this.editList);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit repositories");
    }

    protected Point getInitialSize() {
        return new Point(600, 300);
    }

    private static final class TextEditingSupport
    extends EditingSupport {
        private Function<MavenTargetRepository, String> getter;
        private BiConsumer<MavenTargetRepository, String> setter;

        public TextEditingSupport(ColumnViewer viewer, Function<MavenTargetRepository, String> getter, BiConsumer<MavenTargetRepository, String> setter) {
            super(viewer);
            this.getter = getter;
            this.setter = setter;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected boolean canEdit(Object element) {
            return element instanceof MavenTargetRepository;
        }

        protected Object getValue(Object element) {
            return this.getter.apply((MavenTargetRepository)element);
        }

        protected void setValue(Object element, Object value) {
            this.setter.accept((MavenTargetRepository)element, (String)value);
            this.getViewer().update(element, null);
        }
    }
}

