/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IComputation;

public class ResourceComputationScheduler<T> {
    private final Set<T> currentlyComputing;
    private volatile Set<T> computedKeys;
    private ListeningExecutorService computingPool;
    private ListeningExecutorService unloadingPool;
    private ListeningExecutorService terminator;
    private final AtomicBoolean shutdownInProgress;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Condition endOfTasks = this.lock.writeLock().newCondition();
    private final int shutdownWaitDuration;
    private final TimeUnit shutdownWaitUnit;
    private final EventBus eventBus;

    public ResourceComputationScheduler() {
        this(5, TimeUnit.SECONDS);
    }

    public ResourceComputationScheduler(int shutdownWaitDuration, TimeUnit shutdownWaitUnit) {
        this(shutdownWaitDuration, shutdownWaitUnit, null);
    }

    public ResourceComputationScheduler(int shutdownWaitDuration, TimeUnit shutdownWaitUnit, EventBus eventBus) {
        this.currentlyComputing = new HashSet<T>();
        this.shutdownInProgress = new AtomicBoolean(false);
        this.shutdownWaitDuration = shutdownWaitDuration;
        this.shutdownWaitUnit = shutdownWaitUnit;
        this.eventBus = eventBus;
    }

    private void setUpComputation() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        ThreadFactory computingThreadFactory = new ThreadFactoryBuilder().setNameFormat("EMFCompare-ResolvingThread-%d").build();
        this.computingPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(availableProcessors, computingThreadFactory));
        ThreadFactory unloadingThreadFactory = new ThreadFactoryBuilder().setNameFormat("EMFCompare-UnloadingThread-%d").build();
        this.unloadingPool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(availableProcessors, unloadingThreadFactory));
        this.computedKeys = new LinkedHashSet<T>();
    }

    private void tearDownComputation() {
        if (!this.shutdownInProgress.get()) {
            this.shutdownPools();
        }
        this.computedKeys = null;
    }

    public void demandShutdown() {
        if (!Thread.currentThread().isInterrupted() && this.shutdownInProgress.compareAndSet(false, true)) {
            if (this.eventBus != null) {
                this.eventBus.post((Object)ShutdownStatus.STARTED);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ResourceComputationScheduler.this.shutdownPools();
                }
            };
            ListenableFuture listenableFuture = this.terminator.submit(runnable);
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    ResourceComputationScheduler.this.shutdownInProgress.set(false);
                    if (ResourceComputationScheduler.this.eventBus != null) {
                        ResourceComputationScheduler.this.eventBus.post((Object)ShutdownStatus.SUCCESS);
                    }
                }

                public void onFailure(Throwable t) {
                    ResourceComputationScheduler.this.shutdownInProgress.set(false);
                    if (ResourceComputationScheduler.this.eventBus != null) {
                        ResourceComputationScheduler.this.eventBus.post((Object)new ShutdownStatus(t));
                    }
                    EMFCompareIDEUIPlugin.getDefault().log(t);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private synchronized void shutdownPools() {
        try {
            if (this.computingPool != null) {
                this.shutdownAndAwaitTermination((ExecutorService)this.computingPool);
            }
            if (this.unloadingPool != null) {
                this.shutdownAndAwaitTermination((ExecutorService)this.unloadingPool);
            }
        }
        finally {
            this.computingPool = null;
            this.unloadingPool = null;
        }
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            this.terminator = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("EMFCompare-ThreadPoolShutdowner-%d").setPriority(10).build()));
        }
    }

    public boolean isInitialized() {
        return this.terminator != null;
    }

    public synchronized void dispose() {
        if (this.isInitialized()) {
            this.terminator.shutdown();
            this.terminator = null;
        }
    }

    public synchronized <U> U call(Callable<U> callable, Runnable postTreatment) {
        Preconditions.checkNotNull(callable);
        try {
            if (this.eventBus != null) {
                this.eventBus.post((Object)CallStatus.SETTING_UP);
            }
            this.setUpComputation();
            if (this.eventBus != null) {
                this.eventBus.post((Object)CallStatus.SCHEDULED);
            }
            U u = callable.call();
            return u;
        }
        catch (Exception e) {
            if (this.eventBus != null) {
                this.eventBus.post((Object)new CallStatus(e));
            }
            if (e instanceof InterruptedException) {
                throw new OperationCanceledException();
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (this.eventBus != null) {
                this.eventBus.post((Object)CallStatus.FINISHING);
            }
            try {
                this.tearDownComputation();
                if (postTreatment != null) {
                    postTreatment.run();
                }
            }
            finally {
                if (this.eventBus != null) {
                    this.eventBus.post((Object)CallStatus.FINISHED);
                }
            }
        }
    }

    public void computeAll(Iterable<? extends IComputation<T>> computations) {
        Preconditions.checkNotNull(computations);
        try {
            for (IComputation<T> comp : computations) {
                if (comp == null) continue;
                this.scheduleComputation(comp);
            }
        }
        finally {
            this.waitForEndOfTasks();
        }
    }

    public boolean scheduleComputation(final IComputation<T> computation) {
        Preconditions.checkNotNull(computation);
        this.lock.writeLock().lock();
        try {
            if (this.computedKeys.add(computation.getKey()) && this.currentlyComputing.add(computation.getKey())) {
                ListenableFuture future = this.computingPool.submit(new Runnable(){

                    @Override
                    public void run() {
                        computation.run();
                    }
                });
                Futures.addCallback((ListenableFuture)future, new ComputingFutureCallback(this, computation.getKey(), computation.getPostTreatment()), (Executor)MoreExecutors.directExecutor());
                return true;
            }
            return false;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void runAll(Iterable<? extends Runnable> runnables) {
        Preconditions.checkNotNull(runnables);
        try {
            for (Runnable runnable : runnables) {
                if (runnable == null) continue;
                runnable.run();
            }
        }
        finally {
            this.waitForEndOfTasks();
        }
    }

    public void scheduleUnload(Runnable runnable, FutureCallback<Object> callback) {
        ListenableFuture future = this.unloadingPool.submit(runnable);
        if (callback != null) {
            Futures.addCallback((ListenableFuture)future, callback, (Executor)MoreExecutors.directExecutor());
        }
    }

    public ImmutableSet<T> getComputedElements() {
        this.lock.readLock().lock();
        try {
            if (this.computedKeys == null) {
                ImmutableSet immutableSet = ImmutableSet.of();
                return immutableSet;
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.computedKeys);
            return immutableSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isScheduled(T key) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.computedKeys != null && this.computedKeys.contains(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearComputedElements() {
        this.lock.writeLock().lock();
        try {
            this.computedKeys.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setComputedElements(Iterable<T> elements) {
        this.lock.writeLock().lock();
        try {
            this.computedKeys = Sets.newLinkedHashSet(elements);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean shutdownAndAwaitTermination(ExecutorService pool) {
        boolean ret = true;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(this.shutdownWaitDuration, this.shutdownWaitUnit)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(this.shutdownWaitDuration, this.shutdownWaitUnit)) {
                    ret = false;
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            ret = false;
        }
        return ret;
    }

    private void waitForEndOfTasks() {
        this.lock.readLock().lock();
        try {
            if (this.currentlyComputing.isEmpty()) {
                return;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            try {
                while (!this.currentlyComputing.isEmpty()) {
                    this.endOfTasks.await();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new OperationCanceledException();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void finalizeTask(T key) {
        this.lock.writeLock().lock();
        try {
            this.currentlyComputing.remove(key);
            if (this.currentlyComputing.isEmpty()) {
                this.endOfTasks.signalAll();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static class CallStatus {
        public static final CallStatus SETTING_UP = new CallStatus(ComputationState.SETTING_UP);
        public static final CallStatus SCHEDULED = new CallStatus(ComputationState.SCHEDULED);
        public static final CallStatus FINISHING = new CallStatus(ComputationState.FINISHING);
        public static final CallStatus FINISHED = new CallStatus(ComputationState.FINISHED);
        private final Throwable cause;
        private final ComputationState state;

        private CallStatus(ComputationState state) {
            this.state = state;
            this.cause = null;
        }

        private CallStatus(Throwable cause) {
            this.state = ComputationState.FAILED;
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public ComputationState getState() {
            return this.state;
        }
    }

    public static enum ComputationState {
        SETTING_UP,
        SCHEDULED,
        FINISHING,
        FAILED,
        FINISHED;

    }

    private static final class ComputingFutureCallback<T>
    implements FutureCallback<Object> {
        private final ResourceComputationScheduler<T> scheduler;
        private final T key;
        private final FutureCallback<Object> wrappedCallback;

        private ComputingFutureCallback(ResourceComputationScheduler<T> scheduler, T key, FutureCallback<Object> callback) {
            this.scheduler = (ResourceComputationScheduler)Preconditions.checkNotNull(scheduler);
            this.key = Preconditions.checkNotNull(key);
            this.wrappedCallback = callback;
        }

        public void onSuccess(Object result) {
            try {
                if (this.wrappedCallback != null) {
                    this.wrappedCallback.onSuccess(result);
                }
            }
            finally {
                ((ResourceComputationScheduler)this.scheduler).finalizeTask(this.key);
            }
        }

        public void onFailure(Throwable t) {
            try {
                if (this.wrappedCallback != null) {
                    this.wrappedCallback.onFailure(t);
                }
            }
            finally {
                ((ResourceComputationScheduler)this.scheduler).finalizeTask(this.key);
            }
        }
    }

    public static enum ShutdownState {
        STARTED,
        FINISH_FAILED,
        FINISH_SUCCESS;

    }

    public static class ShutdownStatus {
        public static final ShutdownStatus STARTED = new ShutdownStatus(ShutdownState.STARTED);
        public static final ShutdownStatus SUCCESS = new ShutdownStatus(ShutdownState.FINISH_SUCCESS);
        private final Throwable cause;
        private final ShutdownState state;

        private ShutdownStatus(ShutdownState state) {
            this.state = state;
            this.cause = null;
        }

        private ShutdownStatus(Throwable cause) {
            this.state = ShutdownState.FINISH_FAILED;
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public ShutdownState getState() {
            return this.state;
        }
    }
}

