/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.internal.ui.actions.AbstractViewAction;
import org.eclipse.emf.cdo.internal.ui.actions.NewTopLevelResourceNodeAction;
import org.eclipse.emf.cdo.internal.ui.actions.ResourceNodeNameInputValidator;
import org.eclipse.emf.cdo.internal.ui.actions.TransactionalBackgroundAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IWorkbenchPage;

public abstract class NewResourceNodeAction
extends TransactionalBackgroundAction {
    private final NewTopLevelResourceNodeAction.Type type;
    private String name;

    public NewResourceNodeAction(IWorkbenchPage page, NewTopLevelResourceNodeAction.Type type, CDOObject object) {
        super(page, type.getTitle(), type.getTooltip(), type.getImageDescriptor(), object);
        this.type = type;
    }

    public final NewTopLevelResourceNodeAction.Type getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    protected void preRun() {
        CDOResourceNode object = (CDOResourceNode)this.getObject();
        String initialValue = String.valueOf(this.type == NewTopLevelResourceNodeAction.Type.FOLDER ? "folder" : "resource") + (AbstractViewAction.lastResourceNumber + 1);
        InputDialog dialog = new InputDialog(this.getShell(), this.getText(), Messages.getString("NewResourceNodeAction.8"), initialValue, (IInputValidator)new ResourceNodeNameInputValidator(object));
        if (dialog.open() == 0) {
            ++AbstractViewAction.lastResourceNumber;
            this.name = dialog.getValue();
        } else {
            this.cancel();
        }
    }

    @Override
    protected final void doRun(CDOTransaction transaction, CDOObject object, IProgressMonitor progressMonitor) throws Exception {
        CDOResourceNode newResourceNode = this.createNewResourceNode();
        newResourceNode.setName(this.name);
        if (object instanceof CDOResourceFolder) {
            ((CDOResourceFolder)object).getNodes().add((Object)newResourceNode);
        } else {
            transaction.getRootResource().getContents().add((Object)newResourceNode);
        }
    }

    protected abstract CDOResourceNode createNewResourceNode();

    public static class Binary
    extends NewResourceNodeAction {
        public Binary(IWorkbenchPage page, CDOObject object) {
            super(page, NewTopLevelResourceNodeAction.Type.BINARY, object);
        }

        @Override
        protected CDOResourceNode createNewResourceNode() {
            return EresourceFactory.eINSTANCE.createCDOBinaryResource();
        }
    }

    public static class Folder
    extends NewResourceNodeAction {
        public Folder(IWorkbenchPage page, CDOObject object) {
            super(page, NewTopLevelResourceNodeAction.Type.FOLDER, object);
        }

        @Override
        protected CDOResourceNode createNewResourceNode() {
            return EresourceFactory.eINSTANCE.createCDOResourceFolder();
        }
    }

    public static class Model
    extends NewResourceNodeAction {
        public Model(IWorkbenchPage page, CDOObject object) {
            super(page, NewTopLevelResourceNodeAction.Type.MODEL, object);
        }

        @Override
        protected CDOResourceNode createNewResourceNode() {
            return EresourceFactory.eINSTANCE.createCDOResource();
        }

        @Override
        protected void postRun(CDOView view, CDOObject object) {
            String resourcePath = String.valueOf(((CDOResourceNode)object).getPath()) + "/" + this.getName();
            CDOEditorUtil.openEditor(this.getPage(), view, resourcePath);
        }
    }

    public static class Text
    extends NewResourceNodeAction {
        public Text(IWorkbenchPage page, CDOObject object) {
            super(page, NewTopLevelResourceNodeAction.Type.TEXT, object);
        }

        @Override
        protected CDOResourceNode createNewResourceNode() {
            return EresourceFactory.eINSTANCE.createCDOTextResource();
        }
    }
}

