/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.junitXmlReport;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.internal.model.TestCaseElement;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.model.TestSuiteElement;
import org.eclipse.unittest.model.ITestElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TestRunSessionSerializer
implements XMLReader {
    private static final String EMPTY = "";
    private static final String CDATA = "CDATA";
    private static final Attributes NO_ATTS = new AttributesImpl();
    private final TestRunSession fTestRunSession;
    private ContentHandler fHandler;
    private ErrorHandler fErrorHandler;

    public TestRunSessionSerializer(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        this.fTestRunSession = testRunSession;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.fHandler == null) {
            throw new SAXException("ContentHandler missing");
        }
        this.fHandler.startDocument();
        this.handleTestRun();
        this.fHandler.endDocument();
    }

    private void handleTestRun() throws SAXException {
        Duration duration;
        Integer total;
        ILaunchConfiguration launchConfig;
        AttributesImpl atts = new AttributesImpl();
        TestRunSessionSerializer.addCDATA(atts, "name", this.fTestRunSession.getTestRunName());
        ILaunchConfiguration iLaunchConfiguration = launchConfig = this.fTestRunSession.getLaunch() != null ? this.fTestRunSession.getLaunch().getLaunchConfiguration() : null;
        if (launchConfig != null) {
            TestRunSessionSerializer.addCDATA(atts, "launch_config_name", launchConfig.getName());
        }
        if ((total = this.fTestRunSession.getFinalTestCaseCount()) != null) {
            TestRunSessionSerializer.addCDATA(atts, "tests", total);
        }
        TestRunSessionSerializer.addCDATA(atts, "started", this.fTestRunSession.countStartedTestCases());
        TestRunSessionSerializer.addCDATA(atts, "failures", this.fTestRunSession.getCurrentFailureCount());
        TestRunSessionSerializer.addCDATA(atts, "errors", this.fTestRunSession.getCurrentErrorCount());
        TestRunSessionSerializer.addCDATA(atts, "ignored", this.fTestRunSession.getCurrentIgnoredCount());
        Instant startTime = this.fTestRunSession.getStartTime();
        if (startTime != null) {
            TestRunSessionSerializer.addCDATA(atts, "startTime", startTime.toString());
        }
        if ((duration = this.fTestRunSession.getDuration()) != null) {
            TestRunSessionSerializer.addCDATA(atts, "time", duration.toString());
        }
        this.startElement("testrun", atts);
        for (ITestElement iTestElement : this.fTestRunSession.getChildren()) {
            this.handleTestElement(iTestElement);
        }
        this.endElement("testrun");
    }

    private void handleTestElement(ITestElement testElement) throws SAXException {
        if (testElement instanceof TestSuiteElement) {
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            TestRunSessionSerializer.addCDATA(atts, "name", testSuiteElement.getTestName());
            if (testSuiteElement.getDuration() != null) {
                TestRunSessionSerializer.addCDATA(atts, "time", Double.toString((double)testSuiteElement.getDuration().toMillis() / 1000.0));
            }
            if (testSuiteElement.getProgressState() != ProgressState.COMPLETED || testSuiteElement.getTestResult(false) != ITestElement.Result.UNDEFINED) {
                TestRunSessionSerializer.addCDATA(atts, "incomplete", Boolean.TRUE.toString());
            }
            if (testSuiteElement.getDisplayName() != null) {
                TestRunSessionSerializer.addCDATA(atts, "displayname", testSuiteElement.getDisplayName());
            }
            if (testSuiteElement.getData() != null) {
                TestRunSessionSerializer.addCDATA(atts, "data", testSuiteElement.getData());
            }
            this.startElement("testsuite", atts);
            this.addFailure(testSuiteElement);
            for (ITestElement iTestElement : testSuiteElement.getChildren()) {
                this.handleTestElement(iTestElement);
            }
            this.endElement("testsuite");
        } else if (testElement instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            if (testCaseElement.getDuration() != null) {
                TestRunSessionSerializer.addCDATA(atts, "time", testCaseElement.getDuration().toString());
            }
            if (testCaseElement.getProgressState() != ProgressState.COMPLETED) {
                TestRunSessionSerializer.addCDATA(atts, "incomplete", Boolean.TRUE.toString());
            }
            if (testCaseElement.isIgnored()) {
                TestRunSessionSerializer.addCDATA(atts, "ignored", Boolean.TRUE.toString());
            }
            if (testCaseElement.isDynamicTest()) {
                TestRunSessionSerializer.addCDATA(atts, "dynamicTest", Boolean.TRUE.toString());
            }
            if (testCaseElement.getDisplayName() != null) {
                TestRunSessionSerializer.addCDATA(atts, "displayname", testCaseElement.getDisplayName());
            }
            if (testCaseElement.getData() != null) {
                TestRunSessionSerializer.addCDATA(atts, "data", testCaseElement.getData());
            }
            this.startElement("testcase", atts);
            this.addFailure(testCaseElement);
            this.endElement("testcase");
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
    }

    private void addFailure(TestElement testElement) throws SAXException {
        ITestElement.FailureTrace failureTrace = testElement.getFailureTrace();
        if (testElement.isAssumptionFailure()) {
            this.startElement("skipped", NO_ATTS);
            if (failureTrace != null) {
                this.addCharacters(failureTrace.getTrace());
            }
            this.endElement("skipped");
        } else if (failureTrace != null) {
            AttributesImpl failureAtts = new AttributesImpl();
            String failureKind = testElement.getTestResult(false) == ITestElement.Result.ERROR ? "error" : "failure";
            this.startElement(failureKind, failureAtts);
            String expected = failureTrace.getExpected();
            String actual = failureTrace.getActual();
            if (expected != null) {
                this.startElement("expected", NO_ATTS);
                this.addCharacters(expected);
                this.endElement("expected");
            }
            if (actual != null) {
                this.startElement("actual", NO_ATTS);
                this.addCharacters(actual);
                this.endElement("actual");
            }
            String trace = failureTrace.getTrace();
            this.addCharacters(trace);
            this.endElement(failureKind);
        }
    }

    private void startElement(String name, Attributes atts) throws SAXException {
        this.fHandler.startElement(EMPTY, name, name, atts);
    }

    private void endElement(String name) throws SAXException {
        this.fHandler.endElement(EMPTY, name, name);
    }

    private static void addCDATA(AttributesImpl atts, String name, int value) {
        TestRunSessionSerializer.addCDATA(atts, name, Integer.toString(value));
    }

    private static void addCDATA(AttributesImpl atts, String name, String value) {
        atts.addAttribute(EMPTY, EMPTY, name, CDATA, value);
    }

    private void addCharacters(String string) throws SAXException {
        string = TestRunSessionSerializer.escapeNonUnicodeChars(string);
        this.fHandler.characters(string.toCharArray(), 0, string.length());
    }

    private static String escapeNonUnicodeChars(String string) {
        StringBuilder buf = null;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch < ' ') {
                if (buf == null) {
                    buf = new StringBuilder(string.substring(0, i));
                }
                buf.append("\\u");
                String hex = Integer.toHexString(ch);
                int j = hex.length();
                while (j < 4) {
                    buf.append('0');
                    ++j;
                }
                buf.append(hex);
            } else if (buf != null) {
                buf.append(ch);
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return string;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.fHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.fHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setFeature(String name, boolean value) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }
}

