/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.util.TasksCoreUtil;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskReviewsMappingsStore
implements ITaskListChangeListener {
    static final String ATTR_ASSOCIATED_TASK = "org.eclipse.mylyn.associated.task";
    private final SetMultimap<String, String> taskReviewsMap;
    private final TaskRepositoryManager repositoryManager;
    private final TaskList taskList;
    private static TaskReviewsMappingsStore instance;

    public TaskReviewsMappingsStore(TaskList taskList, TaskRepositoryManager repositoryManager) {
        this.taskList = taskList;
        this.repositoryManager = repositoryManager;
        this.taskReviewsMap = Multimaps.synchronizedSetMultimap((SetMultimap)LinkedHashMultimap.create());
    }

    public void readFromTaskList() {
        for (AbstractTask review : this.taskList.getAllTasks()) {
            String task = this.getTaskUrl((ITask)review);
            if (task == null) continue;
            this.taskReviewsMap.put((Object)task, (Object)review.getUrl());
        }
    }

    private void updateMapping(ITask review, String newTaskUrl) {
        String reviewUrl = review.getUrl();
        String oldTaskUrl = this.getTaskUrl(review);
        if (oldTaskUrl != null && !oldTaskUrl.equals(newTaskUrl)) {
            this.taskReviewsMap.remove((Object)oldTaskUrl, (Object)reviewUrl);
        }
        this.taskReviewsMap.put((Object)newTaskUrl, (Object)reviewUrl);
        review.setAttribute(ATTR_ASSOCIATED_TASK, newTaskUrl);
    }

    public void addTaskAssocation(ITask review, TaskData taskData) {
        TaskAttribute attr = taskData.getRoot().getMappedAttribute("task.common.description");
        if (attr == null) {
            return;
        }
        String oldTaskUrl = this.getTaskUrl(review);
        String description = attr.getValue();
        String[] stringArray = description.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.equals(oldTaskUrl)) {
                return;
            }
            if (token.contains("://")) {
                try {
                    AbstractRepositoryConnector connector;
                    new URL(token);
                    ITask task = this.getTaskByUrl(token);
                    if (task != null && !((connector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind())) instanceof ReviewsConnector)) {
                        this.updateMapping(review, task.getUrl() != null ? task.getUrl() : token);
                        return;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.deleteMappingsTo(review);
    }

    public String getTaskUrl(ITask review) {
        return review.getAttribute(ATTR_ASSOCIATED_TASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getReviewUrls(String taskUrl) {
        SetMultimap<String, String> setMultimap = this.taskReviewsMap;
        synchronized (setMultimap) {
            return ImmutableSet.copyOf((Collection)this.taskReviewsMap.get((Object)taskUrl));
        }
    }

    ITask getTaskByUrl(String url) {
        return TasksCoreUtil.getTaskByUrl((TaskList)this.taskList, (IRepositoryManager)this.repositoryManager, (String)url);
    }

    public void containersChanged(Set<TaskContainerDelta> containers) {
        for (TaskContainerDelta delta : containers) {
            ITask review;
            AbstractRepositoryConnector connector;
            IRepositoryElement reviewRepoElement;
            if (delta.getKind() != TaskContainerDelta.Kind.DELETED || !((reviewRepoElement = delta.getElement()) instanceof ITask) || !((connector = this.repositoryManager.getRepositoryConnector((review = (ITask)reviewRepoElement).getConnectorKind())) instanceof ReviewsConnector)) continue;
            this.deleteMappingsTo(review);
        }
    }

    private void deleteMappingsTo(ITask review) {
        String taskUrl = this.getTaskUrl(review);
        if (taskUrl != null) {
            this.taskReviewsMap.remove((Object)taskUrl, (Object)review.getUrl());
            review.setAttribute(ATTR_ASSOCIATED_TASK, null);
        }
    }

    public static void setInstance(TaskReviewsMappingsStore instance) {
        TaskReviewsMappingsStore.instance = instance;
    }

    public static TaskReviewsMappingsStore getInstance() {
        return instance;
    }
}

