/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ValidateAction
extends Action
implements ISelectionChangedListener {
    private static final long serialVersionUID = 1L;
    protected ISelectionProvider selectionProvider;
    protected List<EObject> selectedObjects;
    protected EditingDomain domain;

    public ValidateAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Validate_menu_item"));
        this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Validate_simple_description"));
    }

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    final Diagnostic diagnostic = ValidateAction.this.validate(progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                ValidateAction.this.handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                ValidateAction.this.handleDiagnostic(diagnostic);
                            }
                        }
                    });
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log(exception);
        }
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor) {
        int selectionSize;
        int count = selectionSize = this.selectedObjects.size();
        for (EObject eObject : this.selectedObjects) {
            TreeIterator i = eObject.eAllContents();
            while (i.hasNext()) {
                ++count;
                i.next();
            }
        }
        progressMonitor.beginTask("", count);
        AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        Diagnostician diagnostician = this.createDiagnostician(adapterFactory, progressMonitor);
        BasicDiagnostic diagnostic = selectionSize == 1 ? diagnostician.createDefaultDiagnostic(this.selectedObjects.get(0)) : new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", new String[]{Integer.toString(selectionSize)}), this.selectedObjects.toArray());
        Map context = diagnostician.createDefaultContext();
        for (EObject eObject : this.selectedObjects) {
            progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
            diagnostician.validate(eObject, (DiagnosticChain)diagnostic, context);
        }
        return diagnostic;
    }

    protected Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        List data;
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        int result = 0;
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
            result = 1;
        } else {
            result = DiagnosticDialog.open((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        if (result == 0 && !diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
            Viewer viewer;
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
            } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionProvider = event.getSelectionProvider();
        if (event.getSelection() instanceof IStructuredSelection) {
            this.setEnabled(this.updateSelection((IStructuredSelection)event.getSelection()));
        } else {
            this.setEnabled(false);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList<EObject>();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            Object object = AdapterFactoryEditingDomain.unwrap(objects.next());
            if (object instanceof EObject) {
                this.selectedObjects.add((EObject)object);
                continue;
            }
            if (object instanceof Resource) {
                this.selectedObjects.addAll((Collection<EObject>)((Resource)object).getContents());
                continue;
            }
            return false;
        }
        this.selectedObjects = EcoreUtil.filterDescendants(this.selectedObjects);
        return !this.selectedObjects.isEmpty();
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }
}

