/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.swt.selection;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecp.view.spi.swt.selection.IMasterDetailSelectionProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class MasterDetailSelectionProvider
implements IMasterDetailSelectionProvider,
IPostSelectionProvider {
    private final ListenerList<ISelectionChangedListener> listeners = new ListenerList();
    private final ListenerList<ISelectionChangedListener> postListeners = new ListenerList();
    private final ISelectionChangedListener forwarder = event -> this.forward(this.listeners, event.getSelection());
    private final ISelectionChangedListener postForwarder = event -> this.forward(this.postListeners, event.getSelection());
    private final ISelectionProvider master;
    private ISelectionProvider detail;

    public MasterDetailSelectionProvider(ISelectionProvider master) {
        this.master = master;
        this.hookListeners(master);
    }

    protected final ISelectionProvider getActiveSelectionProvider() {
        return this.detail != null ? this.detail : this.master;
    }

    public ISelection getSelection() {
        return this.getActiveSelectionProvider().getSelection();
    }

    public void setSelection(ISelection selection) {
        this.getActiveSelectionProvider().setSelection(selection);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove((Object)listener);
    }

    @Override
    public void setDetailSelectionProvider(ISelectionProvider selectionProvider) {
        if (selectionProvider != this.detail) {
            this.unhookListeners(this.getActiveSelectionProvider());
            this.detail = selectionProvider;
            this.hookListeners(this.getActiveSelectionProvider());
            this.pumpSelection();
        }
    }

    private void hookListeners(ISelectionProvider delegate) {
        delegate.addSelectionChangedListener(this.forwarder);
        if (delegate instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)delegate).addPostSelectionChangedListener(this.postForwarder);
        }
    }

    private void unhookListeners(ISelectionProvider delegate) {
        if (delegate instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)delegate).removePostSelectionChangedListener(this.postForwarder);
        }
        delegate.removeSelectionChangedListener(this.forwarder);
    }

    protected final void pumpSelection() {
        ISelection selection = this.getSelection();
        this.forward(this.listeners, selection);
        this.forward(this.postListeners, selection);
    }

    private void forward(ListenerList<? extends ISelectionChangedListener> listeners, ISelection selection) {
        if (!listeners.isEmpty()) {
            SelectionChangedEvent forward = new SelectionChangedEvent((ISelectionProvider)this, selection);
            listeners.forEach(l -> l.selectionChanged(forward));
        }
    }
}

