/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.impl.EmfResourceChangeUtil;

public class EmfResourceReferenceUpdater
extends AbstractReferenceUpdater {
    private static final Logger LOG = Logger.getLogger(EmfResourceReferenceUpdater.class);
    @Inject
    private EmfResourceChangeUtil changeUtil;

    @Override
    protected void createReferenceUpdates(ElementRenameArguments elementRenameArguments, Multimap<URI, IReferenceDescription> resource2references, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor, IProgressMonitor monitor) {
        for (URI referringResourceURI : resource2references.keySet()) {
            try {
                EObject refactoredElement;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Resource referringResource = resourceSet.getResource(referringResourceURI, false);
                if (referringResource == (refactoredElement = resourceSet.getEObject(elementRenameArguments.getNewElementURI(elementRenameArguments.getTargetElementURI()), true)).eResource()) continue;
                if (refactoredElement instanceof EClassifier) {
                    for (IReferenceDescription reference : resource2references.get((Object)referringResourceURI)) {
                        EObject source = referringResource.getEObject(reference.getSourceEObjectUri().fragment());
                        if (source == null) {
                            LOG.error((Object)("Couldn't find source element " + reference.getSourceEObjectUri() + " in " + referringResource.getURI()));
                            continue;
                        }
                        EObject referringEReference = source.eContainer();
                        if (referringEReference == null || !(referringEReference instanceof EReference)) continue;
                        ((EReference)referringEReference).setEType((EClassifier)refactoredElement);
                    }
                }
                this.changeUtil.addSaveAsUpdate(referringResource, updateAcceptor);
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (Exception exc) {
                throw new WrappedException(exc);
            }
        }
    }
}

