/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFG;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFGNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPDFS;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPPragmaNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.PhaseConcurrencyAnalysis;

public class PhaseAnalysisFactory {
    protected OMPCFG cfg_ = null;
    protected OMPCFGNode termNode_ = null;
    protected Stack barrierStack_ = new Stack();
    protected HashSet finishedBarriers_ = new HashSet();
    protected LinkedList phases_ = new LinkedList();
    protected Hashtable nodeToPhases_ = new Hashtable();

    public PhaseAnalysisFactory(OMPCFG cfg) {
        this.cfg_ = cfg;
        this.termNode_ = this.cfg_.getTermNode();
    }

    public void buildPhases() {
        OMPCFGNode node = this.cfg_.getRoot();
        if (!(node instanceof OMPPragmaNode)) {
            return;
        }
        DFSWalk pc = new DFSWalk((OMPPragmaNode)node);
        this.barrierStack_.push(pc);
        pc.trigger();
    }

    protected PhaseConcurrencyAnalysis findPhase(OMPPragmaNode bNode, OMPPragmaNode eNode, boolean addNew) {
        for (PhaseConcurrencyAnalysis phase : this.phases_) {
            if (phase.getBeginNode() != bNode || phase.getEndNode() != eNode) continue;
            return phase;
        }
        if (!addNew) {
            return null;
        }
        PhaseConcurrencyAnalysis phase = new PhaseConcurrencyAnalysis(bNode, eNode);
        this.phases_.add(phase);
        return phase;
    }

    protected void addNodesToPhase(PhaseConcurrencyAnalysis phase, OMPCFGNode[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            phase.add(nodes[i]);
            this.mapNodeToPhase(nodes[i], phase);
            ++i;
        }
    }

    protected boolean isFinished(OMPPragmaNode pNode) {
        return this.finishedBarriers_.contains(pNode);
    }

    protected boolean isOnBarrierStack(OMPPragmaNode pNode) {
        for (DFSWalk dw : this.barrierStack_) {
            if (dw.getPragmaNode() != pNode) continue;
            return true;
        }
        return false;
    }

    protected LinkedList memberPhases(OMPCFGNode node) {
        return (LinkedList)this.nodeToPhases_.get(node);
    }

    protected void mapNodeToPhase(OMPCFGNode node, PhaseConcurrencyAnalysis phase) {
        LinkedList<PhaseConcurrencyAnalysis> l = (LinkedList<PhaseConcurrencyAnalysis>)this.nodeToPhases_.get(node);
        if (l == null) {
            l = new LinkedList<PhaseConcurrencyAnalysis>();
            this.nodeToPhases_.put(node, l);
        }
        if (!l.contains(phase)) {
            l.add(phase);
        }
    }

    public PhaseConcurrencyAnalysis[] getPhases() {
        PhaseConcurrencyAnalysis[] l = new PhaseConcurrencyAnalysis[this.phases_.size()];
        int count = 0;
        Iterator i = this.phases_.iterator();
        while (i.hasNext()) {
            l[count++] = (PhaseConcurrencyAnalysis)i.next();
        }
        return l;
    }

    protected class DFSWalk
    extends OMPDFS {
        protected OMPPragmaNode phaseBeginNode_;

        public DFSWalk(OMPPragmaNode phaseBeginNode) {
            super(phaseBeginNode);
            this.phaseBeginNode_ = null;
            this.phaseBeginNode_ = phaseBeginNode;
        }

        public OMPPragmaNode getPragmaNode() {
            return this.phaseBeginNode_;
        }

        public void trigger() {
            this.startWalking();
        }

        @Override
        public int visit(OMPCFGNode node) {
            if (node instanceof OMPPragmaNode) {
                OMPPragmaNode pragmaNode = (OMPPragmaNode)node;
                if (pragmaNode.getPragma() != null && pragmaNode.getPragma().getOMPType() != 9) {
                    return 0;
                }
                if (this.getNodeStackSize() == 1) {
                    return 0;
                }
                PhaseConcurrencyAnalysis phase = PhaseAnalysisFactory.this.findPhase(this.phaseBeginNode_, pragmaNode, true);
                PhaseAnalysisFactory.this.addNodesToPhase(phase, this.getNodeStack());
                if (PhaseAnalysisFactory.this.isFinished(pragmaNode) || PhaseAnalysisFactory.this.isOnBarrierStack(pragmaNode)) {
                    return 1;
                }
                DFSWalk pc = new DFSWalk(pragmaNode);
                PhaseAnalysisFactory.this.barrierStack_.push(pc);
                pc.trigger();
                PhaseAnalysisFactory.this.barrierStack_.pop();
                return 1;
            }
            if (node == PhaseAnalysisFactory.this.termNode_) {
                if (this.getNodeStackSize() == 1) {
                    return 0;
                }
                return 0;
            }
            OMPCFGNode[] nodes = node.getOutNodes();
            int i = 0;
            while (i < nodes.length) {
                if (this.isVisited(nodes[i])) {
                    LinkedList l = PhaseAnalysisFactory.this.memberPhases(nodes[i]);
                    OMPCFGNode[] nodeStack = this.getNodeStack();
                    Object[] listArray = l.toArray();
                    int j = 0;
                    while (j < listArray.length) {
                        PhaseConcurrencyAnalysis phase = (PhaseConcurrencyAnalysis)listArray[j];
                        if (phase.getBeginNode() == this.phaseBeginNode_) {
                            PhaseAnalysisFactory.this.addNodesToPhase(phase, nodeStack);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return 0;
        }

        protected boolean atStartNode(OMPCFGNode node) {
            return node == this.phaseBeginNode_ && this.getNodeStackSize() == 1;
        }
    }
}

