/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.config;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.uml.nattable.config.utils.CellEditorConfigurationUtils;
import org.eclipse.papyrus.uml.nattable.editor.MultiEnumCellEditor;
import org.eclipse.papyrus.uml.nattable.utils.UMLTableUtils;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLStereotypeMultiUMLEnumerationCellEditorConfiguration
implements ICellAxisConfiguration {
    public static final String ID = "org.eclipse.papyrus.uml.nattable.celleditor.configuration.UMLStereotypeMultiUMLEnumerationCellEditorConfiguration.MultiEditor";

    public String getConfigurationId() {
        return ID;
    }

    public String getConfigurationDescription() {
        return "This configuration provides a multi editor for a multi UML Enumeration type";
    }

    public boolean handles(Table table, Object axisElement) {
        Property prop;
        boolean result = false;
        String id = AxisUtils.getPropertyId((Object)axisElement);
        if (id != null && id.startsWith("property_of_stereotype:/") && (prop = UMLTableUtils.getRealStereotypeProperty(table.getContext(), id)) != null && prop.isMultivalued()) {
            Type type = prop.getType();
            result = type instanceof Enumeration;
        }
        return result;
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        Object axisElement = AxisUtils.getRepresentedElement((Object)axis);
        CellEditorConfigurationUtils.configureCellPainter(configRegistry, axis, configLabel);
        INattableModelManager modelManager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new MultiEnumCellEditor(axisElement, modelManager.getTableAxisElementProvider()), "EDIT", configLabel);
    }
}

