/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.ui.delegate;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.OCLSettingDelegate;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class OCLDebugSettingDelegate
extends OCLSettingDelegate {
    public OCLDebugSettingDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EStructuralFeature structuralFeature) {
        super(delegateDomain, structuralFeature);
    }

    protected @Nullable Object evaluateEcore(@NonNull ExpressionInOCL query, @Nullable Object contextObject) {
        @NonNull Display display = Display.getCurrent();
        DebugStarter runnable = new DebugStarter(display, contextObject, query);
        runnable.run((IProgressMonitor)new NullProgressMonitor());
        ILaunch launch = runnable.getLaunch();
        if (launch != null) {
            try {
                this.waitForLaunchToTerminate(launch);
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (launch != null) {
            return true;
        }
        return false;
    }

    public static void flushEvents() {
        int i = 0;
        while (i < 10) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            while (workbench.getDisplay().readAndDispatch()) {
            }
            ++i;
        }
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        try {
            ExpressionInOCL query2 = this.getQuery();
            @NonNull Display display = Display.getCurrent();
            DebugStarter runnable = new DebugStarter(display, owner, query2);
            runnable.run((IProgressMonitor)new NullProgressMonitor());
            ILaunch launch = runnable.getLaunch();
            if (launch != null) {
                try {
                    this.waitForLaunchToTerminate(launch);
                }
                catch (DebugException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (launch != null) {
                return true;
            }
            return false;
        }
        catch (EvaluationException e) {
            throw new OCLDelegateException((Exception)((Object)new EvaluationException((Throwable)e, PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, new Object[]{this.basicGetProperty()})));
        }
    }

    protected void waitForLaunchToTerminate(@NonNull ILaunch launch) throws InterruptedException, DebugException {
        boolean allDead;
        do {
            int i = 0;
            while (i < 10) {
                OCLDebugSettingDelegate.flushEvents();
                Thread.sleep(100L);
                ++i;
            }
            allDead = true;
            IDebugTarget[] iDebugTargetArray = launch.getDebugTargets();
            int n = iDebugTargetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDebugTarget debugTarget = iDebugTargetArray[n2];
                IProcess process = debugTarget.getProcess();
                if (!process.isTerminated()) {
                    allDead = false;
                }
                IThread[] iThreadArray = debugTarget.getThreads();
                int n3 = iThreadArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IThread debugThread = iThreadArray[n4];
                    if (!debugThread.isTerminated()) {
                        allDead = false;
                    }
                    ++n4;
                }
                ++n2;
            }
        } while (!allDead);
    }

    protected static class DebugStarter
    implements IRunnableWithProgress {
        protected final @NonNull Display display;
        protected final @Nullable Object contextObject;
        protected final @NonNull ExpressionInOCL constraint;
        private @Nullable ILaunch launch = null;

        public DebugStarter(@NonNull Display display, @Nullable Object contextObject, @NonNull ExpressionInOCL constraint) {
            this.display = display;
            this.contextObject = contextObject;
            this.constraint = constraint;
        }

        public ILaunch getLaunch() {
            return this.launch;
        }

        protected ILaunch launchDebugger(IProgressMonitor monitor, @Nullable Object contextObject, @NonNull ExpressionInOCL expressionInOCL) throws CoreException {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.ocl.examples.debug.launching.OCLLaunchConfigurationDelegate");
            ILaunchConfigurationWorkingCopy launchConfiguration = launchConfigurationType.newInstance(null, "test");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("expressionObject", expressionInOCL);
            attributes.put("contextObject", contextObject);
            launchConfiguration.setAttributes(attributes);
            return launchConfiguration.launch("debug", monitor);
        }

        protected void openError(final String message, final @NonNull Exception e) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Status status = new Status(4, "org.eclipse.ocl.examples.debug.ui", e.getLocalizedMessage(), (Throwable)e);
                    ErrorDialog.openError((Shell)display.getActiveShell(), (String)"ConsoleMessages.Debug_Starter", (String)message, (IStatus)status);
                }
            });
        }

        public void run(IProgressMonitor monitor) {
            String expression = this.constraint.toString();
            monitor.beginTask(NLS.bind((String)"ConsoleMessages.Debug_Starter", (Object)expression), 1);
            try {
                monitor.subTask("ConsoleMessages.Debug_ProgressLoad");
                try {
                    this.launch = this.launchDebugger(monitor, this.contextObject, this.constraint);
                }
                catch (CoreException e) {
                    this.openError("ConsoleMessages.Debug_FailLaunch", (Exception)((Object)e));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
    }
}

