/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.egit.github.core.FieldError;
import org.eclipse.egit.github.core.RequestError;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.mylyn.internal.github.core.Messages;

public class GitHubException
extends IOException {
    private static final long serialVersionUID = -1456910662911777231L;

    public static IOException wrap(IOException exception) {
        return exception instanceof RequestException ? new GitHubException((RequestException)exception) : exception;
    }

    public GitHubException(RequestException cause) {
        this.initCause((Throwable)cause);
    }

    @Override
    public String getMessage() {
        RequestError error = ((RequestException)this.getCause()).getError();
        String errorMessage = error.getMessage();
        if (errorMessage == null) {
            errorMessage = "";
        }
        StringBuilder message = new StringBuilder(errorMessage);
        List errors = error.getErrors();
        if (errors != null && errors.size() > 0) {
            message.append(':');
            for (FieldError fieldError : errors) {
                message.append(' ').append(this.format(fieldError)).append(',');
            }
            message.deleteCharAt(message.length() - 1);
        }
        return message.toString();
    }

    private String format(FieldError error) {
        String code = error.getCode();
        String value = error.getValue();
        String field = error.getField();
        String resource = error.getResource();
        if ("invalid".equals(code)) {
            if (value != null) {
                return MessageFormat.format(Messages.FieldError_InvalidFieldWithValue, value, field);
            }
            return MessageFormat.format(Messages.FieldError_InvalidField, field);
        }
        if ("missing_field".equals(code)) {
            return MessageFormat.format(Messages.FieldError_MissingField, field);
        }
        if ("already_exists".equals(code)) {
            return MessageFormat.format(Messages.FieldError_AlreadyExists, resource, field);
        }
        return MessageFormat.format(Messages.FieldError_ResourceError, field, resource);
    }
}

